$ save_verify = 'f$verify(0)'
$!
$! Command procedure for building shareable image MST (Dynamically loaded
$! services.  The build checks the environment and makes correct
$! links for AXP/DECC, VAX/DECC, VAX/VAXC.
$!
$! Input parameters:
$!	P1	Comma-delimited list of universal symbols for image, if
$!		only one supplied, 'P1'_init will added.
$!	P2	Comma-delimited list of object files to link
$!		is implied.  Files may include qualifiers (e.g. /opt).
$!	P3,P4	Additional qualifiers for link, P3 placed before P2 in
$!		actual link command and P4 placed after.
$!
$! The following modules are included in the link automatically:
$!	MST_SHARE.OBJ, TUTIL.OBJ
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Extract input.
$ ucnt = 0			! count of universals
$ next_p1:
$    universal_'ucnt' = F$ELEMENT(ucnt,",",P1)
$    if universal_'ucnt' .eqs. "," then goto check_ucnt
$    ucnt = ucnt + 1
$    goto next_p1
$!
$ check_ucnt:
$ if ucnt .gt. 0 .and. universal_0 .nes. "" then goto check_ucnt_1
$    write sys$Output "Missing P1, specify universals"
$    save_verify = f$verify(save_verify)
$    exit
$ check_ucnt_1:
$ if ucnt .gt. 1 then goto get_image
$    universal_'ucnt' = universal_0 + "_INIT"
$    ucnt = 2
$!
$ get_image:
$ shr_name = f$parse(f$element(0,"/",f$element(0,",",P2)),,,"NAME")
$ if shr_name .nes. "" then goto create_opt
$    write sys$Output "Missing P2, specify object files"
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Construct options file.
$ create_opt:
$ create link_mst_tmp.opt
$ open/append opt link_mst_tmp.opt
$ on error then goto abort
$ on control_y then goto abort
$!
$! Determine our configuration.
$!
$ is_axp = (f$getsyi("CPU") .ge. 128)
$ is_vaxc = (.not.is_axp .and. (f$trnlnm("DECC$CC_DEFAULT") .nes. "/DECC"))
$ is_vmsv5 = ("V5." .eqs. f$extract(0,3,f$getsyi("VERSION")))
$ write opt "!This file generated by LINK_MST.COM, AXP flag: ", is_axp, -
	", VAXC flag: ", is_vaxc, ", image: ", shr_name
$!
$! Add standard support routines and pthreads libraries
$  write opt "sys$disk:[]tutil.obj,http_base_mst.exe/share
$ if f$search("sys$share:pthread$rtl.exe") .eqs. ""
$ then
$ write opt "sys$share:cma$lib_shr/share,cma$rtl/share
$ if is_axp then write opt "sys$share:cma$open_lib_shr/share,cma$open_rtl/share
$ endif
$!
$! Add stuff for vaxc
$ if is_vaxc 
$ then 
$    write opt "sys$share:vaxcrtl/share"
$    write opt "PSECT_ATTR=$CHAR_STRING_CONSTANTS,NOWRT"
$    write opt "PSECT_ATTR=HTTP_LOG_LEVEL_P,LCL,NOSHR
$    write opt "PSECT_ATTR=HTTP_REENTRANT_C_RTL,LCL,NOSHR
$    write opt "PSECT_ATTR=HTTP_REENTRANT_C_RTL_P,LCL,NOSHR
$    write opt "PSECT_ATTR=HTTP_REENTRANT_VMS_RTL,LCL,NOSHR
$    write opt "PSECT_ATTR=HTTP_REENTRANT_VMS_RTL_P,LCL,NOSHR
$    write opt "PSECT_ATTR=HTTP_INDEX_FILENAME,LCL,NOSHR"
$    write opt "PSECT_ATTR=MST_CLOSE_CB,LCL,NOSHR
$    write opt "PSECT_ATTR=MST_CONNECT_CB,LCL,NOSHR
$    write opt "PSECT_ATTR=MST_CREATE_SERVICE_POOL_CB,LCL,NOSHR
$    write opt "PSECT_ATTR=MST_EXIT_CB,LCL,NOSHR
$    write opt "PSECT_ATTR=MST_FORMAT_ERROR_CB,LCL,NOSHR
$    write opt "PSECT_ATTR=MST_READ_CB,LCL,NOSHR
$    write opt "PSECT_ATTR=MST_REGISTER_SERVICE_CB,LCL,NOSHR
$    write opt "PSECT_ATTR=MST_WRITE_CB,LCL,NOSHR
$    write opt "PSECT_ATTR=TLOG_PUTLOG_CB,LCL,NOSHR
$ endif
$!
$! Build universal list or symbol vector.
$!
$ if is_axp
$ then
$!   AXP, make symbol vector, we know we have at least 2.
$    write opt "SYMBOL_VECTOR=(",universal_0,"=PROCEDURE,-"
$    i = 0
$    next_sym:
$       i = i + 1
$       if i+1 .ge. ucnt then goto last_sym
$	write opt "   ",universal_'i',"=PROCEDURE,-"
$	goto next_sym
$    last_sym:
$    write opt "   ",universal_'i',"=PROCEDURE)"
$ else
$!	Vax list.
$    next_universal:
$        ucnt = ucnt - 1
$	if ucnt .lt. 0 then goto do_link
$	write opt "universal=", universal_'ucnt'
$	goto next_universal
$ endif
$ do_link:
$ close opt
$ on error then exit
$!
$! Link the image.
$ link/map/share='shr_name'.exe 'P3' 'P2',sys$disk:[]link_mst_tmp/opt 'P4'
$ save_verify = f$verify(save_verify)
$ exit
$!
$ abort:
$ close opt
$ write sys$Output "LINK_MST aborted operation"
$ save_verify = f$verify(save_verify)
$ exit
