/*
 * This include file abstracts the the toupper and tolower functions
 * to macros that behave consistently  across variants in different
 * compilers ctype.h.  The macro cannot be used with arguments that have
 * side effects.
 */
#include <ctype.h>
#if defined(VAXC) || defined(__DECC)
/*
 * the _tolower and _toupper macros return value identicall to non-macro form.
 */
#define UPPER_CASE _toupper
#define LOWER_CASE _tolower
#else
/*
 * Use function call.
 */
#define UPPER_CASE toupper
#define LOWER_CASE tolower
#endif
