/*
** AUTHACL.H  
**
**  Contains prototypes for AUTHACL routines.
**
**  Also contains macros which may be modified to control behavior of
**  routines at compile-time.
**
*/

#define ACLREQUIREUSER 0  /* For protect files that have ACL's, should
			      a user in SYSUAF be required?   If set to 0
			      then if the username does not exist in SYSUAF,
			      access is granted.  If set to 1, and username
			      is missing, then access is denied. See
			      doc for details and reasoning */

#define ACLMAXBIN    512    /* Maximum size (in bytes) of binary ACL.
				Typical ACE is 12 bytes each    */
#define ACLMAXRIGHTS 256    /* Max number of identifiers in rightslists */

#define OWNERUIC     "SYSTEM"  /* Owner UIC for all protected objects.  
				  Could be set to UIC of HTTP server acct */

/* Uncomment this to enable interactive debugging of ACL routines, or
   compile with /DEFINE=DEBUGACL
#define DEBUGACL     YES
*/

/* Don't change these unless you add/remove items from the respective
   item lists.
*/
#define ACLCHPSIZE   10 /* Entries in $CHKPRO item list */
#define ACLUAISIZE   4  /* Entries in $GETUAI item list */

int authacl_parse_acl ( char *, char *, int *, char *);
int authacl_check_acl ( char *, char *, char *, int );


