/*
*   AUTHACL contains a routines to test whether a specified VMS username
*           has access to a given ACL (specified as a string) on behalf
*	    of ACL_AUTHENTICATOR.
*
*    Modified: 27-NOV-1996	DLJ- Set access check based upon method,
*				make ctxptr conditional upon OS version.
*    Modified:  3-DEC-1996	Incorporate changes from D. Smith.
*/

#include <descrip.h>
#include <string.h>
#include <starlet.h>
#include <lib$routines.h>
#include <chpdef.h>
#include <prvdef.h>
#include <armdef.h>
#include <uaidef.h>
#include <stdio.h>
#include "authacl.h"
#include "authlib.h"

#ifdef DEBUGACL
/*	 
**  Test routine, for testing ACL routine interactively.
*/	 
int main ()
{
    int allowed, parsed;
    char acl[ACLMAXBIN];		/* binary ACL */
    char username[13];
    char method[8];
    char log_message[200];
    int  acllen = 0;			/* ACL length */

    while (1) {
	printf ("Enter username: ");
	gets (username);
	printf ("Method (GET, POST, etc): ");
	gets (method);

	acllen = 0;

/*	 
**  to test the routine, hardcode an ACL by calling authacl_parse_acl as
**  below, then compile with /DEFINE=DEBUGACL
*/	 
	parsed = authacl_parse_acl ( "(IDENT=SMITH_NP,ACCESS=WRITE+READ)", acl, &acllen, log_message );
	if (!parsed) printf ("%s\n", log_message);
	parsed = authacl_parse_acl ( "(IDENT=FCJVS_T,ACCESS=NONE)", acl, &acllen, log_message  );
	if (!parsed) printf ("%s\n", log_message);
	parsed = authacl_parse_acl ( "(IDENT=[30,*],ACCESS=READ)", acl, &acllen, log_message  );
	if (!parsed) printf ("%s\n", log_message);

	allowed = authacl_check_acl( username, method, acl, acllen);

	if (allowed) {
	    printf ("User %s has access\n", username);
	} else {
	    printf ("User %s does not have access\n", username);
	}
    }
}

#endif

int authacl_parse_acl ( char *aclstr, char *acl, int *acllen, char *log_message)
{
    int	 sts;
    char *ace;
    short msglen, errpos;
    struct dsc$descriptor_s aclstr_dx = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};
    struct dsc$descriptor_s ace_dx = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};
    struct dsc$descriptor_s msg_dx = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};

    aclstr_dx.dsc$w_length = strlen(aclstr);
    aclstr_dx.dsc$a_pointer = aclstr;

    ace = acl + *acllen;
    ace_dx.dsc$w_length = ACLMAXBIN - *acllen;
    ace_dx.dsc$a_pointer = ace;

    sts = sys$parse_acl ( &aclstr_dx, &ace_dx, &errpos, 0, 0);
    if (!(sts & 1)) {
        msg_dx.dsc$w_length = 200;
	msg_dx.dsc$a_pointer = log_message;
	lib$sys_getmsg ( &sts, &msglen, &msg_dx, 0, 0);
	msg_dx.dsc$a_pointer += msglen + 1;
	sprintf (msg_dx.dsc$a_pointer, 
		"\r\nACE: %s\r\n error at pos %hi ", aclstr, errpos);
	return 0;
    } else {
	*acllen += *ace;
	return 1;
    }
}

/* 
** Macros for inserting items into item lists 
*/
#define set_chplst(size,itemcode,buffadr)	    \
    chpcnt++;				    \
    chplst[chpcnt].len     =  size;	    \
    chplst[chpcnt].code    =  itemcode;	    \
    chplst[chpcnt].bufadr  =  buffadr;	    \
    chplst[chpcnt].retadr  =  0;	    

#define set_uailst(size,itemcode,buffadr, retlenadr)	    \
    uaicnt++;				    \
    uailst[uaicnt].len     =  size;	    \
    uailst[uaicnt].code    =  itemcode;	    \
    uailst[uaicnt].bufadr  =  buffadr;	    \
    uailst[uaicnt].retadr  =  retlenadr;	    

int authacl_check_acl ( char *username, char *method, char *acl, int acllen )
/*
** This routine builds up a security object and user profile given the
** username and ACL and then calls $CHKPRO to see if the user has 
** access to the object.  
*/
{
    static int contxt = -1;
    static int contxt_id = 0;
    int sts;
    int chpcnt = -1, uaicnt = -1;
    int rightscnt = 0;
    long priv_mask[2];

    int chp_access;

    int privused = 0;

    struct {
	int uic;
	int zero;
    }	holder = { 0, 0 };

    int uai_flags;
    char privs[8];
    struct {
	int id, attrib;
    } rights[256];
    int owner;

    short prot = 0xFF00;  /* (S:RWED, O:RWED, G:none, W:none) */

    struct {                   
		 short len, code;
		 void *bufadr;
		 int retadr;
    } chplst[ACLCHPSIZE];   

    struct {                   
		 short len, code;
		 void *bufadr;
		 int retadr;
    } uailst[ACLUAISIZE];   

    $DESCRIPTOR (owner_dx,OWNERUIC);  /* Owner UIC of the object we're buiding */

    struct dsc$descriptor_s acl_dx = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};

    struct dsc$descriptor_s username_dx = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};
    username_dx.dsc$w_length = strlen(username);
    username_dx.dsc$a_pointer = username;

    /* Convert owner id to binary UIC */

    sts = sys$asctoid (&owner_dx, &owner, 0);
    if (!(sts & 1)) lib$signal(sts);


    /*
     * Enable SYSPRV temporarily, get UAF items and rights and disable again.
     */
    priv_mask[0] = PRV$M_SYSPRV; 
    priv_mask[1] = 0;
    sts = sys$setprv ( 1, priv_mask, 0, 0 );
    if (!(sts & 1)) return 0;

    set_uailst( 4, UAI$_UIC, &holder.uic, 0);
    set_uailst( 8, UAI$_PRIV, privs, 0);
    set_uailst( 4, UAI$_FLAGS, &uai_flags, 0);

    set_uailst( 0, 0, 0, 0);

    sts = sys$getuai (0, auth_getuai_context(), &username_dx, uailst, 0, 0, 0);
#if  ACLREQUIREUSER
/* Valid username required, return failed access. */
    if (!(sts & 1))	{
        (void) sys$setprv ( 0, priv_mask, 0, 0 );
	return 0;
    }
#else
/* Valid username not required, return succesful access.  Assumes that a
   hardcoded username/password combination in protect file should allow
   access.
 */
    if (!(sts & 1)) {
	(void) sys$setprv ( 0, priv_mask, 0, 0 );
	return 1;
    }
#endif

    rights[rightscnt].id = holder.uic;
    rights[rightscnt].attrib = 0;
    rightscnt++;

    /* Get first held identifier */
    sts = sys$find_held ( &holder,  &rights[rightscnt].id, 
				    &rights[rightscnt].attrib, 
				    &contxt_id);
    while ( (sts & 1) ) {
	rightscnt++;
	/* Get rest of held identifiers */
	sts = sys$find_held ( &holder,  &rights[rightscnt].id, 
					&rights[rightscnt].attrib, 
					&contxt_id);
    }

    /* Disable SYSPRV */
    (void) sys$setprv ( 0, priv_mask, 0, 0 );

    if ( ( uai_flags & UAI$M_DISACNT ) )  return 0;	    /* Disuser'd? */

    /*
     * Check method and change access to READ for GET and HEAD operations.
     */
    chp_access = CHP$M_WRITE;
    if ( *method == 'G' ) {
	if ( strcmp(method,"GET") == 0 ) chp_access = CHP$M_READ;
    } else if ( *method = 'H' ) {
	if ( strcmp(method,"HEAD") == 0 ) chp_access = CHP$M_READ;
#ifdef CHP$M_DELETE
    } else if ( *method == 'D' ) {
	/* (If delete bit unknown, we will use default WRITE access) */
	if ( strcmp(method,"DELETE") == 0 ) chp_access = CHP$M_DELETE;
#endif
    }

    set_chplst ( 4, CHP$_ACCESS, &chp_access );
    set_chplst ( (rightscnt * 8), CHP$_RIGHTS, rights);
    set_chplst ( 8, CHP$_PRIV, privs);
    set_chplst ( 4, CHP$_OWNER, &owner );
    set_chplst ( 2, CHP$_PROT, &prot );
    set_chplst ( acllen, CHP$_ACL, acl );
    set_chplst ( 4, CHP$_PRIVUSED, &privused );
    
    set_chplst ( 0, CHP$_END, 0 )

    sts = sys$chkpro ( chplst );

    if (sts & 1) {
	return 1;
    } else {
	return 0;
    }

}
