 /* **++ **  FACILITY:  CMEM  V1.0  ** ** **  MODULE DESCRIPTION:  **? **	This module contains all the routines required to convert an @ **	address within a program to a human understandable reference. **@ **	The following (internal) routines are defined in this module: ** **	    cmem___send_dbg_command" **	    cmem___receive_dbg_response **	    cmem___debugger_exit_ast  **	    cmem___start_debugger **	    cmem___symbolize  ** ** **  AUTHORS: **2 **      Brett Hunsaker (hunsaker@eisner.decus.org) ** ** **  CREATION DATE:  4 May 1995 ** ** **  DESIGN ISSUES: **H **	The format is the debugger symbol table is undocumented.  So, we will@ **	use the debugger itself to translate addresses into something2 **	useful.  The debugger will run as a subprocess. ** ** **  MODIFICATION HISTORY:  **5 **      4-May-1995	B. Hunsaker	Initial implementation  **. **	Necessity is truly the mother of invention. ** ** **-- */   /* ** **  ENVIRONMENT SETTINGS ** */   /*C 	For VAX C compatibility, we use the 'globalref' modifier to access D 	message codes.  This will generate a warning message with DEC C, soE 	disable that here.  If this module was only compiled with DEC C, you D 	could get away with using 'extern int <condition_name>' rather than" 	'globalref int <condition_name>'. */  
 #ifdef __DECC $ #pragma message disable( GLOBALEXT ) #endif     /* ** **  GLOBAL CONSTANTS ** */     /* ** **  INCLUDE FILES  ** */   #include lib$routines  #include starlet #include descrip #include clidef  #include iodef #include jpidef  #include ssdef   #include <stdio.h> #include <string.h>      /* ** **  GLOBAL STRUCTURES  ** */  ! struct mbx_io_status_block_struct  {    unsigned short int		status; !   unsigned short int		byte_count;     unsigned long int		sender_pid; };     /* ** **  GLOBAL VARIABLES ** */  ) static struct cmem___trace_globals_struct  { '   unsigned short int		dbg_command_chan; (   unsigned short int		dbg_response_chan;%   unsigned long int		dbg_exit_status;  } cmem___trace_globals;          /* **++ **  FUNCTIONAL DESCRIPTION:  **  **      cmem___send_dbg_command: **H **	This function will send the specified command to the debugger runningD **	in the subprocess created by the 'cmem___start_debugger' routine. ** ** **  FORMAL PARAMETERS: ** **	command_string:' **	    Type:	    Null terminated string  **	    Access:	    Input" **	    Mechanism:	    By reference **2 **	    This is the string written to the debugger. ** ** **  RETURN VALUE:  ** **	None. ** ** **  SIDE EFFECTS:  **
 **      None.  ** ** **  DESIGN:  **C **	Wht the debugger subprocess we created, we pointed SYS$INPUT and E **	SYS$OUTPUT for the process to mailboxes.  We will simply write the % **	string to the appropriate mailbox.  **@ **	Unfortunately, we don't know how many lines of output will beB **	generated by a single command.  Indeed, there may be no output.B **	So, to allow the read routine to know that the command has been@ **	completed, we will send a second command that has exactly one **	line of output. ** ** **  PRECONDITIONS: **    G **	The subroutine 'cmem___start_debugger' must already have created the  **	subprocess. ** ** **  CALLING SEQUENCE:  **) **  	Here is an example calling sequence:  **4 **	    cmem___send_dbg_command( "EXAMINE/HEX %SP" ); ** ** **  EXCEPTIONS:  **     **  	CMEM__UNEXPERR: **    D **	    The $QIOW system service returned an error trying to write to **	    the mailbox.  ** ** **-- */  5 void cmem___send_dbg_command( char * command_string )  {    /* ** **  INCLUDE FILES  ** */     /* **
 **  CONSTANTS  ** */   #define SECONDS_TO_WAIT		5.0  >   static char			echo_command[] = "EVALUATE/HEX %HEX 5A5A5A5A";     /* ** **  STRUCTURES AND UNIONS  ** */     /* ** **  EXTERNAL ROUTINES  ** */     /* ** **  EXTERNAL CONSTANTS ** */      globalref int CMEM__UNDBGEXIT;   globalref int CMEM__UNEXPERR;      /* ** **  LOCAL VARIABLES  ** */     int					status;    float					timer;-   struct mbx_io_status_block_struct	mbx_iosb;      /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */   /*2 	Send the command to the debugger via the mailbox. */  >   status = sys$qiow( 0, cmem___trace_globals.dbg_command_chan,? 	    IO$_WRITEVBLK | IO$M_NOW, &mbx_iosb, 0, 0, command_string, , 	    strlen( command_string ), 0, 0, 0, 0 );   if ( ( status & 1 ) != 1 )   {      timer = SECONDS_TO_WAIT;     lib$wait( &timer ); 4     if ( cmem___trace_globals.dbg_exit_status == 0 )J       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$QIOW to debugger", status );     else@       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$QIOW to debugger",- 		    status, 0, ( int ) &CMEM__UNDBGEXIT, 0, > 		    ( cmem___trace_globals.dbg_exit_status & 0x0FFFFFFF ) );   }   %   if ( ( mbx_iosb.status & 1 ) != 1 )    {      timer = SECONDS_TO_WAIT;     lib$wait( &timer ); 4     if ( cmem___trace_globals.dbg_exit_status == 0 )+       lib$stop( ( int ) &CMEM__UNEXPERR, 1, 4 		    "$QIOW (IOSB) to debugger", mbx_iosb.status );     elseG       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$QIOW (IOSB) to debugger", 6 		    mbx_iosb.status, 0, ( int ) &CMEM__UNDBGEXIT, 0,> 		    ( cmem___trace_globals.dbg_exit_status & 0x0FFFFFFF ) );   }      /*A 	The debugger fails to prompt unless it is accepting input from a C 	terminal.  We would normally use the prompt to indicate completion ? 	of the command.  But since we can't do that, we will force the @ 	debugger to send back a one line which will indicate completion 	of the user's command.  */  >   status = sys$qiow( 0, cmem___trace_globals.dbg_command_chan,= 	    IO$_WRITEVBLK | IO$M_NOW, &mbx_iosb, 0, 0, echo_command, * 	    strlen( echo_command ), 0, 0, 0, 0 );   if ( ( status & 1 ) != 1 )   {      timer = SECONDS_TO_WAIT;     lib$wait( &timer ); 4     if ( cmem___trace_globals.dbg_exit_status == 0 )O       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$QIOW echo to debugger", status );      elseE       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$QIOW echo to debugger", - 		    status, 0, ( int ) &CMEM__UNDBGEXIT, 0, > 		    ( cmem___trace_globals.dbg_exit_status & 0x0FFFFFFF ) );   }   %   if ( ( mbx_iosb.status & 1 ) != 1 )    {      timer = SECONDS_TO_WAIT;     lib$wait( &timer ); 4     if ( cmem___trace_globals.dbg_exit_status == 0 )+       lib$stop( ( int ) &CMEM__UNEXPERR, 1, 9 		    "$QIOW echo (IOSB) to debugger", mbx_iosb.status );      elseL       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$QIOW echo (IOSB) to debugger",6 		    mbx_iosb.status, 0, ( int ) &CMEM__UNDBGEXIT, 0,> 		    ( cmem___trace_globals.dbg_exit_status & 0x0FFFFFFF ) );   }   	   return;  }             /* **++ **  FUNCTIONAL DESCRIPTION:  **$ **      cmem___receive_dbg_response: **C **	We read any output from the debugger and return each line to the 
 **	caller. ** ** **  FORMAL PARAMETERS: ** **	array_elements: **	    Type:	    Signed integer  **	    Access:	    Input **	    Mechanism:	    By value **G **	    The number of elements in the array of 'response_strings'.  This A **	    is the maximum number of lines which we will read from the D **	    debugger.  You should always specify a number greater than or7 **	    equal to the number of lines you expect to read.  ** ** **	element_size: **	    Type:	    Signed integer  **	    Access:	    Input **	    Mechanism:	    By value **E **	    The number of bytes available in each array entry.  Be sure to E **	    have room for whatever the debugger may send.  Also allow room  **	    for the trailing null.  ** ** **	response_strings:= **	    Type:	    Array of pointers to null terminated strings  **	    Access:	    Input" **	    Mechanism:	    By reference **D **	    An array of pointers where each line of the debugger response **	    is to be written. ** ** **  RETURN VALUE:  **. **	The number of lines read from the debugger. ** ** **  SIDE EFFECTS:  **
 **      None.  ** ** **  DESIGN:  **B **	We simply read the mailbox and put each completed read into theF **	next element of the 'response_array'.  We will return to the callerF **	only when we receive a line containing the string "5A5A5A5A".  ThisA **	is the expected response from the extra command written by the @ **	'cmem___send_dbg_command' routine.  That response will not beD **	returned to the user (although the count of array elements should **	allow for it).  ** ** **  PRECONDITIONS: **    G **	The subroutine 'cmem___start_debugger' must already have created the E **	subprocess.  We expect that we are being called to read a response ? **	as a result of a previous call to 'cmem___send_dbg_command'.  ** ** **  CALLING SEQUENCE:  **) **  	Here is an example calling sequence:  **% **	    #define CHAR_ARRAY_ELEMENTS	10 $ **	    #define CHAR_ELEMENT_SIZE	128 ** **	    int				loop;  **	    int				count; **	    char			response **					[ CHAR_ARRAY_ELEMENTS ] **					[ CHAR_ELEMENT_SIZE ]; 4 **	    char *			response_ptr[ CHAR_ARRAY_ELEMENTS ]; ** **< **	    cmem___send_dbg_command( "SYMBOLIZE %HEX 000200B0" );: **	    for( loop = 0; loop < CHAR_ARRAY_ELEMENTS; loop++ )1 **	      response_ptr[ loop ] = response[ loop ]; + **	    count = cmem___receive_dbg_response( ? **		    CHAR_ARRAY_ELEMENTS, CHAR_ELEMENT_SIZE, response_ptr );  ** ** **  EXCEPTIONS:  **     **  	CMEM__UNEXPERR: **    C **	    The $QIOW system service returned an error trying to read to  **	    the mailbox.  ** **  	CMEM__ARRTOOSML:  **    F **	    The number of linse returned from the debugger was greater than+ **	    the number of elements in the array.  ** ** **-- */  4 int cmem___receive_dbg_response( int array_elements,0 			int element_size, char * response_strings[] ) {    /* ** **  INCLUDE FILES  ** */     /* **
 **  CONSTANTS  ** */   #define SECONDS_TO_WAIT		5.0  -   static char			echo_response[] = "5A5A5A5A";      /* ** **  STRUCTURES AND UNIONS  ** */     /* ** **  EXTERNAL ROUTINES  ** */     /* ** **  EXTERNAL CONSTANTS ** */      globalref int CMEM__ARRTOOSML;    globalref int CMEM__UNDBGEXIT;   globalref int CMEM__UNEXPERR;      /* ** **  LOCAL VARIABLES  ** */     int					status;    int					array_index;   float					timer;-   struct mbx_io_status_block_struct	mbx_iosb;      /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */  E   for( array_index = 0; array_index < array_elements; array_index++ )    {    /*B 	If we get an error reading from the debugger, check to see if the@ 	subprocess has exited.  We normally would get an AST, but it is> 	possible that we are running with ASTs currently disabled and 	have not yet been interrupted.  */  A     status = sys$qiow( 0, cmem___trace_globals.dbg_response_chan, D 	    IO$_READVBLK, &mbx_iosb, 0, 0, response_strings[ array_index ],  	    element_size, 0, 0, 0, 0 );     if ( ( status & 1 ) != 1 )     {        timer = SECONDS_TO_WAIT;       lib$wait( &timer ); 6       if ( cmem___trace_globals.dbg_exit_status == 0 )N         lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$QIOW from debugger", status );
       elseD         lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$QIOW from debugger",- 		    status, 0, ( int ) &CMEM__UNDBGEXIT, 0, > 		    ( cmem___trace_globals.dbg_exit_status & 0x0FFFFFFF ) );     }   '     if ( ( mbx_iosb.status & 1 ) != 1 )      {        timer = SECONDS_TO_WAIT;       lib$wait( &timer ); 6       if ( cmem___trace_globals.dbg_exit_status == 0 )-         lib$stop( ( int ) &CMEM__UNEXPERR, 1, 6 		    "$QIOW (IOSB) from debugger", mbx_iosb.status );
       elseK         lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$QIOW (IOSB) from debugger", 6 		    mbx_iosb.status, 0, ( int ) &CMEM__UNDBGEXIT, 0,> 		    ( cmem___trace_globals.dbg_exit_status & 0x0FFFFFFF ) );     }   B     response_strings[ array_index ][ mbx_iosb.byte_count ] = '\0';H     if ( strcmp( echo_response, response_strings[ array_index ] ) == 0 )       break;   }   &   if ( array_index >= array_elements ))     lib$stop( ( int ) &CMEM__ARRTOOSML );      return( array_index ); }          /* **++ **  FUNCTIONAL DESCRIPTION:  **! **      cmem___debugger_exit_ast:  **C **	This routine is activated whenever the debugger subprocess exits  **	unexpectedly.   ** ** **  FORMAL PARAMETERS: ** **	None. ** ** **  RETURN VALUE:  ** **	None. ** ** **  SIDE EFFECTS:  **/ **	Because the subprocess exited, we will also.  ** ** **  DESIGN:  **F **	The debugger should never exit.  But if it does, then we report the **	error and exit ourselves. ** ** **  PRECONDITIONS: **     **	None. ** ** **  CALLING SEQUENCE:  **E **  	This routine is called as an AST.  It should be specified in the  **	call to LIB$SPAWN:  **" **	    cmem___debugger_exit_ast(); ** ** **  EXCEPTIONS:  **     **  	CMEM__UNDBGEXIT:  **    ( **	    Hey, where did our subprocess go? ** ** ** **-- */  % void cmem___debugger_exit_ast( void )  {    /* ** **  INCLUDE FILES  ** */     /* **
 **  CONSTANTS  ** */     /* ** **  STRUCTURES AND UNIONS  ** */     /* ** **  EXTERNAL ROUTINES  ** */     /* ** **  EXTERNAL CONSTANTS ** */      globalref int CMEM__UNDBGEXIT;     /* ** **  LOCAL VARIABLES  ** */     /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */   /*- 	Yikes!  Just exit and let the user know why.  */  %   lib$stop( ( int ) &CMEM__UNDBGEXIT, - 			0, cmem___trace_globals.dbg_exit_status ); 	   return;  }          /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      cmem___start_debugger: **C **	Creates a subprocess running the debugger so that we can convert 8 **	program addresses to a meaningful source line number. ** ** **  FORMAL PARAMETERS: ** **	None. ** ** **  RETURN VALUE:  ** **	None. ** ** **  SIDE EFFECTS:  **
 **      None.  ** ** **  DESIGN:  **I **	We need someway of convertng an address to a line number.  Sounds like D **	a job for the debugger.  We'll create a subprocess to communicate **	with it.  ** ** **  PRECONDITIONS: **     **	None. ** ** **  CALLING SEQUENCE:  **) **  	Here is an example calling sequence:  ** **	    cmem___start_debugger();  ** ** **  EXCEPTIONS:  **     **  	CMEM__UNEXPERR: **    H **	    A system service has failed.  The error message contains the name? **	    of the service and the status returned is also signaled.  ** **  	CMEM__OLDSUBPRC:  **    @ **	    An old version of the subprocess exists and will not die. ** ** **-- */  " void cmem___start_debugger( void ) {    /* ** **  INCLUDE FILES  ** */     /* **
 **  CONSTANTS  ** */   #define DBG_MBX_MAXMSG			256 #define DBG_MBX_BUFQUO			32768   #define MAX_DELAY			5   # #define RESPONSE_ARRAY_ELEMENTS		10 " #define RESPONSE_ELEMENT_SIZE		100     /* ** **  STRUCTURES AND UNIONS  ** */     struct iosb_struct   { &     unsigned long int condition_value;     unsigned long int reserved;    };     struct item_list_struct    { )     unsigned short int	    buffer_length; %     unsigned short int	    item_code; &     unsigned char	    *buffer_address;2     unsigned short int	    *return_length_address;   };     /* ** **  EXTERNAL ROUTINES  ** */     /* ** **  EXTERNAL CONSTANTS ** */     globalref int CMEM__UNEXPERR;    globalref int CMEM__NORMAL;     globalref int CMEM__OLDSUBPRC;!   globalref int CMEM__SUBCREFAIL;      /* ** **  LOCAL VARIABLES  ** */     int					status;    int					delay_count;   int					spawn_flags;   int					loop; &   unsigned long int			delay_time[ 2 ];     struct iosb_struct			iosb;-   struct mbx_io_status_block_struct	mbx_iosb; *   struct item_list_struct		item_list[ 3 ];     char					input_buffer[ 256 ];     char					output_buffer[ 256 ];     char					filename[ 256 ]; '   unsigned short int			filename_length;    unsigned long int			pid;     char					prc_string[ 16 ];+   struct dsc$descriptor_s		prc_string_desc;       char					command_line[ 300 ]; -   struct dsc$descriptor_s		command_line_desc;      char					response   					[ RESPONSE_ARRAY_ELEMENTS ] 					[ RESPONSE_ELEMENT_SIZE ];    char *				response_ptr! 					[ RESPONSE_ARRAY_ELEMENTS ];      /* ** **  DECLARATIVE INITIALIZATION ** */  9   $DESCRIPTOR( dbg_command_lognam_desc, "CMEM_COMMAND" ); ;   $DESCRIPTOR( dbg_response_lognam_desc, "CMEM_RESPONSE" );U0   $DESCRIPTOR( lnm_table_desc, "LNM$FILE_DEV" );/   $DESCRIPTOR( delay_time_desc, "0 00:00:03" );w     /* ** **  CODE ** */   /*F 	Go get information about our job that we need to create a sub-processC 	running the debugger.  We need the name of this image file and thee 	process identification. */  8   item_list[ 0 ].buffer_length = sizeof( filename ) - 1;+   item_list[ 0 ].item_code = JPI$_IMAGNAME;*@   item_list[ 0 ].buffer_address = ( unsigned char * ) &filename;:   item_list[ 0 ].return_length_address = &filename_length;/   item_list[ 1 ].buffer_length = sizeof( pid );e&   item_list[ 1 ].item_code = JPI$_PID;;   item_list[ 1 ].buffer_address = ( unsigned char * ) &pid; +   item_list[ 1 ].return_length_address = 0;*#   item_list[ 2 ].buffer_length = 0;    item_list[ 2 ].item_code = 0;p  ;   status = sys$getjpiw( 0, 0, 0, &item_list, &iosb, 0, 0 );.   if ( ( status & 1 ) != 1 ))     lib$stop( ( int ) &CMEM__UNEXPERR, 1,r0 			"call to SYS$GETJPIW (image name)", status );*   if ( ( iosb.condition_value & 1 ) != 1 ))     lib$stop( ( int ) &CMEM__UNEXPERR, 1,d- 			"call to SYS$GETJPIW (IOSB) (image name)",i 			iosb.condition_value );     /*= 	Delete any sub-process that we may have created as part of alB 	previous invocation.  $FORCEX doesn't seem to do the trick so use 	the bigger hammer.e */  +   sprintf( prc_string, "CMEM__%08X", pid );   6   prc_string_desc.dsc$w_length = strlen( prc_string );.   prc_string_desc.dsc$b_dtype = DSC$K_DTYPE_T;.   prc_string_desc.dsc$b_class = DSC$K_CLASS_S;-   prc_string_desc.dsc$a_pointer = prc_string;i  $   sys$delprc( 0, &prc_string_desc );     /*D 	Although we have requested the old sub-process to exit, it may take@ 	a bit for the larger images or maybe the sub-process won't die.> 	In either case, wait for the old mailbox to be deleted before 	continuing. */  7   status = sys$bintim( &delay_time_desc, &delay_time );_   if ( ( status & 1 ) != 1 ))     lib$stop( ( int ) &CMEM__UNEXPERR, 1,g. 			"$BINTIM (subprocess existence)", status );  /   item_list[ 0 ].buffer_length = sizeof( pid ); &   item_list[ 0 ].item_code = JPI$_PID;;   item_list[ 0 ].buffer_address = ( unsigned char * ) &pid;n+   item_list[ 0 ].return_length_address = 0;e#   item_list[ 1 ].buffer_length = 0;    item_list[ 1 ].item_code = 0;m  @   for( delay_count = 0; delay_count < MAX_DELAY; delay_count++ )   {   L     status = sys$getjpiw( 0, 0, &prc_string_desc, &item_list, &iosb, 0, 0 );O     if ( ( status == SS$_NONEXPR ) || ( iosb.condition_value == SS$_NONEXPR ) )F       break;       if ( ( status & 1 ) != 1 )+       lib$stop( ( int ) &CMEM__UNEXPERR, 1,e/ 			"$GETJPIW (subprocess existence)", status );h,     if ( ( iosb.condition_value & 1 ) != 1 )+       lib$stop( ( int ) &CMEM__UNEXPERR, 1, , 			"$GETJPIW (IOSB) (subprocess existence)", 			iosb.condition_value );  0     status = sys$schdwk( 0, 0, &delay_time, 0 );     if ( ( status & 1 ) != 1 )+       lib$stop( ( int ) &CMEM__UNEXPERR, 1,n1 			"$SCHDWK checking sub-process exit", status );h       status = sys$hiber();t     if ( ( status & 1 ) != 1 )+       lib$stop( ( int ) &CMEM__UNEXPERR, 1,u0 			"$HIBER checking sub-process exit", status );   }*  !   if ( delay_count >= MAX_DELAY ) )     lib$stop( ( int ) &CMEM__OLDSUBPRC );      /*@ 	Create the mailboxes which will be used to send commands to the$ 	debugger and receive its responses. */  A   status = sys$crembx( 0, &cmem___trace_globals.dbg_command_chan,o' 		DBG_MBX_MAXMSG, DBG_MBX_BUFQUO, 0, 0,   		&dbg_command_lognam_desc, 0 );   if ( ( status & 1 ) != 1 )&     lib$stop( ( int ) &CMEM__UNEXPERR,0 				    1, "$CREMBX (debugger input)", status );  B   status = sys$crembx( 0, &cmem___trace_globals.dbg_response_chan,' 		DBG_MBX_MAXMSG, DBG_MBX_BUFQUO, 0, 0,U! 		&dbg_response_lognam_desc, 0 );E   if ( ( status & 1 ) != 1 )&     lib$stop( ( int ) &CMEM__UNEXPERR,1 				    1, "$CREMBX (debugger output)", status );M     /*/ 	Create the subprocess running in the debugger.  */  +   cmem___trace_globals.dbg_exit_status = 0;m  '   strcpy( command_line, "RUN/DEBUG " );*#   strcat( command_line, filename );   :   command_line_desc.dsc$w_length = strlen( command_line );0   command_line_desc.dsc$b_dtype = DSC$K_DTYPE_T;0   command_line_desc.dsc$b_class = DSC$K_CLASS_S;1   command_line_desc.dsc$a_pointer = command_line;   m-   spawn_flags = CLI$M_NOWAIT + CLI$M_NOCLISYM ' 					+ CLI$M_NOLOGNAM + CLI$M_NOKEYPAD; C   status = lib$spawn( &command_line_desc, &dbg_command_lognam_desc,(< 		&dbg_response_lognam_desc, &spawn_flags, &prc_string_desc,. 		0, &cmem___trace_globals.dbg_exit_status, 0,& 		cmem___debugger_exit_ast, 0, 0, 0 );   if ( ( status & 1 ) != 1 )5     lib$stop( ( int ) &CMEM__SUBCREFAIL, 0, status );E   /*C 	Do a SET MODULE/ALL so that we will get line numbers if available. B 	This could take some time on a program with a large symbol table. */  9   for( loop = 0; loop < RESPONSE_ARRAY_ELEMENTS; loop++ )b,     response_ptr[ loop ] = response[ loop ];  .   cmem___send_dbg_command( "SET MODULE/ALL" );7   cmem___receive_dbg_response( RESPONSE_ARRAY_ELEMENTS, . 				    RESPONSE_ELEMENT_SIZE, response_ptr );  	   return;  }b     s   /* **++ **  FUNCTIONAL DESCRIPTION:	 ** **      cmem___symbolize:e **C **	Accepts an address as input and converts it to a null terminated F **	string which is (hopefully) the source code line number represented **	by the address. ** ** **  FORMAL PARAMETERS: ** **	address:n" **	    Type:	    Unsigned longword **	    Access:	    Input **	    Mechanism:	    By value **( **	    The program address to interpret. ** ** **	output_string:g' **	    Type:	    Null terminated stringB **	    Access:	    Output," **	    Mechanism:	    By reference **F **	    The address in memory where the null terminated string is to be **	    placed. ** ** **	output_string_length:" **	    Type:	    Unsigned longword **	    Access:	    Input **	    Mechanism:	    By value **. **	    The size of the 'output_string' buffer. ** ** **  RETURN VALUE:E ** **	None. ** ** **  SIDE EFFECTS:  **
 **      None.) ** ** **  DESIGN:  **I **	Have the debugger process a "SYMBOLIZE" command on the passed address.( ** ** **  PRECONDITIONS: **    G **	The subroutine 'cmem___start_debugger' must already have created the_ **	subprocess. ** ** **  CALLING SEQUENCE:i **) **  	Here is an example calling sequence:I **" **	    unsigned long int		address;" **	    char			output_string[ 80 ]; **6 **	    cmem___symbolize( address, output_string, 80 ); ** ** **  EXCEPTIONS:0 **    & **	All exceptions are propagated from: ** **	    cmem___send_dbg_command" **	    cmem___receive_dbg_response ** ** **-- */   void cmem___symbolize( 	unsigned long int	address,r 	char *			output_string,) 	unsigned long int	output_string_length )  {u   /* ** **  INCLUDE FILESe ** */     /* **
 **  CONSTANTS  ** */   #define CHAR_ARRAY_ELEMENTS	10 #define CHAR_ELEMENT_SIZE	128      /* ** **  STRUCTURES AND UNIONSe ** */     /* ** **  EXTERNAL ROUTINESa ** */     /* ** **  EXTERNAL CONSTANTS ** */     /* ** **  LOCAL VARIABLESl ** */     int				loop;   int				count;u   char				debug_command[ 80 ];   char				response1 				[ CHAR_ARRAY_ELEMENTS ][ CHAR_ELEMENT_SIZE ];*   char *			tempstring;/   char *			response_ptr[ CHAR_ARRAY_ELEMENTS ];      /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */   /*, 	Tell the debugger to interpret the address. */  ;   sprintf( debug_command, "SYMBOLIZE %%HEX 0%X", address );t+   cmem___send_dbg_command( debug_command );g  5   for( loop = 0; loop < CHAR_ARRAY_ELEMENTS; loop++ ) ,     response_ptr[ loop ] = response[ loop ];&   count = cmem___receive_dbg_response(= 		    CHAR_ARRAY_ELEMENTS, CHAR_ELEMENT_SIZE, response_ptr );      /*B 	We've got multiple lines back from the debugger.  We need to look 	for the best one to display.* */     if ( count < 2 )     strncpy( output_string,EB 	"    --- debugger failed to respond ---", output_string_length );   else if ( count == 2 )B     strncpy( output_string, response[ 1 ], output_string_length );   else   {    /*> 	Look for a line with two backslashes.  This would represent a: 	translation that has both a routine name and line number.  B 	Yes, it is OK that we have two lines right after each other which 	are the same. */  )     for( loop = 0; loop < count; loop++ )i     {*$       tempstring = response[ loop ];@       if ( ( tempstring = strchr( tempstring, '\\' ) ) != NULL )D         if ( ( tempstring = strchr( ++tempstring, '\\' ) ) != NULL )	 	  break;      }t     if ( loop < count )mG       strncpy( output_string, response[ loop ], output_string_length );s     else     {n   /*F 	Since we couldn't find a line with two backslashes, search for a line 	with a plus sign. */  +       for( loop = 0; loop < count; loop++ )        {e:         if ( ( strchr( response[ loop ], '+' ) ) != NULL )	 	  break;        }a       if ( loop < count )RI         strncpy( output_string, response[ loop ], output_string_length );2
       else   /*2 	When all else fails, just return the second line. */  F         strncpy( output_string, response[ 1 ], output_string_length );     }_	   }         	   return;A }Y