$ dbg = "''f$verify( f$integer( f$trnlnm( "f$verify" ) ) )'"
$!++
$! IMGID.DCL - Image Header Information Display Facility
$! (c) Copyright 1996, Chris Olive
$! All rights reserved
$!
$! ENVIRONMENT
$!
$!    OpenVMS v5.5-2
$!    OpenVMS DCL
$!
$! ABSTRACT
$!
$!    Grabs image header information from the image header of an image
$!    and displays it.  Just a DCL implementation of a IMGID cousin
$!    written in C.  Does not include the Link Date/Time output since
$!    f$fao( "!%D" ) doesn't seem to support a parameter other than
$!    "0" to do $ASCTIM conversion.  Too bad, or else the entirety of
$!    this operation could have been done in DCL!  Cool!
$!
$!    As in the C version, no effort is made to verify that this is
$!    in fact a valid VMS image we are getting the IHI info from.
$!
$! AUTHOR, INSTALLATION and DATE
$!
$!    Chris Olive
$!    Senior Programmer Analyst
$!    Mellon Bank
$!    Pittsburgh, PA
$!    3/4/96
$!
$! MODIFICATION HISTORY
$!
$!    Revision    Date          Author/Comments
$!    ----------- ------------- ---------------------------------------------
$!    v1.01-000   3/7/96        Chris Olive
$!
$!    o Made somewhat Alpha-ready.  *Ideally* this program should be able to
$!      read *any* image header and display the proper ident area info (i.e.
$!      "This is an Alpha image; here's the info." or "This is a VAX image;
$!      here's the info."), but I don't have enough information available to
$!      me right now to determine the proper way to do this.  (I'd bet the
$!      image activator ($IMGACT) has the proper code...)
$!--
$
$!--- Setup section ---
$
$ echo := write sys$output
$ ALPHA = f$getsyi( "HW_MODEL" ) .ge. 1024
$
$ ! These values were grabbed from their respective $IHxDEF counter-parts
$ ! in SYS$LIBRARY:LIB.MLB.  They work for me under v5.5-2 of VMS, but are
$ ! subject to change with other and newer version of VMS.  Shoot, I don't
$ ! even have an Alpha to test these on!
$ !
$ ! The Alpha numerics were taken from a 6.x system, the $EIHxDEF macros
$ ! having been mailed to me!  All I can do is assume they work...  Don't
$ ! see why they wouldn't; that's what macros are for, eh?
$
$ if ALPHA
$    then
$    IHD_X_IMGIDOFF = 24   ! From EIHD$L_IMGIDOFF
$    IHI_T_IMGNAM   = 16   ! From EIHI$T_IMGNAM
$    IHI_T_IMGID    = 56   ! From EIHI$T_IMGID
$    IHI_T_LINKID   = 72   ! From EIHI$T_LINKIID
$    offset_bits    = 32
$    PLATFORM      := ALPHA 
$ else
$    IHD_X_IMGIDOFF = 6    ! From IHD$W_IMGIDOFF
$    IHI_T_IMGNAM   = 0    ! From IHI$T_IMGNAM
$    IHI_T_IMGID    = 40   ! From IHI$T_IMGID
$    IHI_T_LINKID   = 64   ! From IHI$T_LINKIID
$    offset_bits    = 16
$    PLATFORM      := VAX 
$ endif
$
$ QUOTE[0,8]   = 34
$ offset_bytes = offset_bits/8
$
$!--- Get filename and make sure it exists ---
$
$ filename = p1
$ if filename .eqs. "" then inquire filename "_Filename"
$ if filename .eqs. "" then exit
$
$ filename = f$parse( filename, "SYS$DISK:[]*.EXE" )
$ if f$search( filename ) .eqs. ""
$    then
$    echo f$fao( "Error opening image file !AS", filename )
$    exit 1+0*f$verify ( dbg )
$ endif
$
$!--- Open the image file, read the header, and close the file ---
$
$ open/read img% 'filename
$ read img% ihd_buffer
$ close img%
$
$!--- Calculate the IHI offset in the IHD buffer ---
$
$ ihi_offset = f$cvui( 0, offset_bits, f$extract( IHD_X_IMGIDOFF, offset_bytes, ihd_buffer ) )
$
$!--- Use the IHI offset to grab the values out of the IHD buffer ---
$
$ ! We wouldn't even have to *do* this if the !AC specifier in the DCL
$ ! implementation of f$fao() worked as we would like, but since it doesn't,
$ ! we have to byte-length extract these ourselves...
$
$ len      = f$cvui( 0, 8, f$extract( ihi_offset+IHI_T_IMGNAM, 1, ihd_buffer ) )
$ imgnam   = f$extract( ihi_offset+IHI_T_IMGNAM+1, len,           ihd_buffer )
$ len      = f$cvui( 0, 8, f$extract( ihi_offset+IHI_T_IMGID,  1, ihd_buffer ) )
$ imgid    = f$extract( ihi_offset+IHI_T_IMGID+1,  len,           ihd_buffer )
$ len      = f$cvui( 0, 8, f$extract( ihi_offset+IHI_T_IMGNAM, 1, ihd_buffer ) )
$ linkid   = f$extract( ihi_offset+IHI_T_LINKID+1, len,           ihd_buffer )
$
$!--- Display the Information Header Information minus link-time ---
$
$ echo f$fao( "Image Header Information for !AS image !AS!/", PLATFORM, filename )
$ echo f$fao( "!_Image Name: !3(AS)",            QUOTE, imgnam, QUOTE )
$ echo f$fao( "!_Image Identification: !3(AS)",  QUOTE, imgid,  QUOTE )
$ echo f$fao( "!_Linker Identification: !3(AS)", QUOTE, linkid, QUOTE )
$ echo ""
$
$!--- Bye! ---
$
$ exit 1+0*f$verify( dbg )
