/*++
** IMGID.C - Dump Image Header Information Area
** (c) Copyright 1996, Chris Olive
** All rights reserved
**
** ENVIRONMENT
**
**    OpenVMS v5.5-2
**    DEC/VAX C Language
**    GNU C v2.3.3
**
** ABSTRACT
**
**    Dumps the Image Header Information area as seen in the ANALYZE/IMAGE
**    output, allowing one to see the internal image file name, the version
**    number id (the main reason I wrote this), and linker date/time (who
**    cares?), and the linker identification (again, who cares?).
**
**    This program makes no effort whatsoever to verify that the file you
**    are attempting to get the information from is indeed a valid VMS
**    image file.  Which leads me to:
**
**    THE DORK OF THE MONTH AWARD
**    ---------------------------
**    After writing this, I was dimayed to find that I have a tool called
**    SCAN4 (that *I* wrote, of all things) that would have allowed me to get
**    to this information VERY EASILY by scanning for "ident" in the
**    output of ANALYZE/IMAGE.  That's why I wrote SCAN4 so I wouldn't have
**    to write hacks like this one...  Oh well, it's done now.  An example
**    (if not entirely accurate) of reading an image header and doing
**    something with it, I guess...
**
**    You can get SCAN4 from DECUS, ftp://ftp.wku.edu/vms.fileserv/scan4.zip,
**    or in the CompuServe VAXforum as SCAN4.ZIP.  It'll keep you from writing
**    hacks like this!
**
**    Not to mention how easily this could be done in DCL too in at least
**    HALF as many lines....
**
** AUTHOR, INSTALLATION and DATE
**
**    Chris Olive
**    Senior Programmer Analyst
**    Mellon Bank
**    Pittsburgh, PA
**    3/1/96
**
** CODE GENERATION
**
**    VAX ________________________________________________
**    Compile: $ CC   IMGID
**
**    AXP ________________________________________________
**    Compile: $ CC/DEBUG=__ALPHA__ IMGID
**
**    Both _______________________________________________
**       Link: $ LINK IMGID [,SYS$LIBRARY:VAXCRTL/LIBRARY]
**
** MODIFICATION HISTORY
**
**    Revision    Date          Author/Comments
**    ----------- ------------- ---------------------------------------------
**    v1.01-001   3/7/96        Chris Olive
**
**    o Made mostly Alpha-ready by adding Alpha-specific header includes
**      (generated by BUILD.COM) and platform-indepentant macros for
**      picking apart the IHD buffer.
**    o Broke out defs into seperate imgid.h header in lieu of many Alpha
**      adds.
**    o *Ideally* this one image should be able to read *any* image header
**      regardless of the image's intended architecture, and pick it apart
**      properly, returning the correct information per platform (i.e.
**      "This is an Alpha image" or "This is a VAX image"), but then I'd
**      have to do more image header verification, and I don't have enough
**      information about Alpha image headers to make it worth doing right
**      now.
*/

/*--- Includes ---*/

#include <stdio.h>                            /* Standard I/O defs      */
#include <stdlib.h>                           /* Standard library defs  */
#include <ssdef.h>                            /* Standard system defs   */
#include <descrip.h>                          /* Descriptor defs        */    
#include <fab.h>                              /* File Access Block defs */
#include <nam.h>                              /* file NAMe block defs   */
#include "imgid.h"                            /* IMGID defs             */

/*--- Code ---*/

int main( int argc, char **argv ) {

   byte_array ihd_buffer[IHD_S_IHDDEF];       /* Image header buffer        */
   offset_t  *ihi_offset;                     /* Offset in IHD to IHI       */
   int  stat;                                 /* Return status              */
   short int retlen;                          /* Return length from $ASCTIM */
   char  linktime_buf[STRING_LEN];            /* Link time buffer           */
   char  result_buf[STRING_LEN];              /* Resultant filename buffer  */
   $DESCRIPTOR( linktime_dsc, linktime_buf ); /* Link time descriptor       */
   SDESC filename_dsc;                        /* Filename descriptor        */
   $DESCRIPTOR( result_dsc, result_buf );     /* Resultant descriptor       */
   $DESCRIPTOR( default_dsc, "SYS$DISK:[].EXE" ); /* Default fname descriptor */

   FILE *f;                                   /* Image file pointer      */
   struct FAB *fabptr = NULL;                 /* Ptr to returned FAB     */
   struct NAM *namptr;                        /* Ptr to associated NAM   */
   int flags = LIB$_NOWILD;                   /* Flags for LIB$FIND_FILE */

   /* Open the image file for read access. */

   if (!--argc) {
      fprintf( stderr, "Syntax: IMGID <image-filename>\n" );
      return SS$_NORMAL;
   } else {

      /* Set up descriptor for filename from argv[1]. */

      filename_dsc.dsc$w_length  = strlen( argv[1] ); /* Set length           */
      filename_dsc.dsc$b_class   = DSC$K_CLASS_S;     /* Set class            */
      filename_dsc.dsc$b_dtype   = DSC$K_DTYPE_T;     /* Set dtype            */
      filename_dsc.dsc$a_pointer = argv[1];           /* Set buffer reference */

      /* See if file exists, and get full VMS path.  (For those not in the
       * know, LIB$FIND_FILE for some reason does NOT return the resultant
       * filename length to the descriptor.  So the actual filename length
       * is not known!  You have to go groveling around in the NAM which
       * you get to from the returned LIB$FIND_FILE context, which is
       * really a FAB reference!  Whew!  What a lot of work!  Thanks
       * Digital!  This "simple" program could be significantly shortened
       * without all this nonsense...
       */

      if (!(stat = lib$find_file( &filename_dsc, &result_dsc, &fabptr, &default_dsc, 0, 0, &flags )) & 1)
         return stat;
      namptr = fabptr->fab$l_nam;             /* Get NAM reference from FAB */
      result_buf[namptr->nam$b_rsl] = 0;      /* Set ASCIZ string up */
      if ((f = fopen( result_buf, "rb" )) == NULL) { /* Open sez me... */
         fprintf( stderr, "Error opening image file %s\n", result_buf );
         return SS$_NORMAL;
      }
   }

   /* Read the image header, then close the file. */

   if (fread( ihd_buffer, sizeof( ihd_buffer ), 1, f ) != 1) { /* Get header */
      fprintf( stderr, "Error reading image header information for %s\n", result_buf );
      return SS$_NORMAL;
   }
   fclose( f );                               /* Close 'er up... */

   /* Grab the offset of the Image Header Information area for use
    * in locating various IHI fields in the Image Header.
    */

   ihi_offset = (offset_t *) &ihd_buffer[IHD_X_IMGIDOFF];

   /* Convert the link date/time to an ASCII date/time string. */

   if (!(stat = sys$asctim( &retlen, &linktime_dsc, &ihd_buffer[*ihi_offset+IHI_Q_LINKTIME], 0 )) & 1)
      return stat;                            /* Convert to ASCII time str */

   /* Display Information Header Information */

   printf( "Image Header Information for %s image %s\n\n", PLATFORM, result_buf );
   printf( "\tImage Name: \"%.*s\"\n",
      ihd_buffer[*ihi_offset+IHI_T_IMGNAM],   /* Image name length           */
      &ihd_buffer[*ihi_offset+IHI_T_IMGNAM+1] /* Image name buffer reference */
   );
   printf( "\tImage Identification: \"%.*s\"\n",
      ihd_buffer[*ihi_offset+IHI_T_IMGID],    /* Image ID length           */
      &ihd_buffer[*ihi_offset+IHI_T_IMGID+1]  /* Image ID buffer reference */
   );
   printf( "\tLink Date/Time: %.*s\n", retlen, linktime_buf  ); /* ASC D/T */
   printf( "\tLinker Identification: \"%.*s\"\n\n",
      ihd_buffer[*ihi_offset+IHI_T_LINKID],   /* Linker ID length           */
      &ihd_buffer[*ihi_offset+IHI_T_LINKID+1] /* Linker ID buffer reference */
   );

   /* Return to caller. */

   return SS$_NORMAL;                         /* Good-bye... */

}
