 	SUBROUTINE TERMINAL_DATA    ** *	SUBROUTINE TERMINAL_DATA *  * D *	Returns information about this process' terminal.  The information *	returned is: * 4 *	  * The terminal name (and the length of the name) * ) *	  * The terminal type code (see $DCDEF)  * D *	  * The two longwords of device-dependent characteristics (see the= *	    I/O User's Guide, page 9-18 ff, and $TTDEF and $TT2DEF)  * A *	The data are returned in /TERMINAL_DATA_/, which is defined as:  *  *	CHARACTER*8 DEVNAME  * < *	COMMON /TERMINAL_DATA_/ DEVNAME, DEVTYPE, DEPEND, DEPEND2, *	1			DEVNAMELEN * . *	See also routine SMGL_GET_TERMINAL_SETTINGS. *  *	.INDEX TERMINAL I/O>>  *	.INDEX ENVIRONMENT>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 * *	24 Aug 1983	   Dahlgren, Virginia  22448 *    	IMPLICIT INTEGER (A-Z)   & 	PARAMETER ( DVI$_DEVDEPEND  =  'A'X )& 	PARAMETER ( DVI$_DEVDEPEND2 = '1C'X )& 	PARAMETER ( DVI$_DEVNAM     = '20'X )& 	PARAMETER ( DVI$_DEVTYPE    =  '6'X )   	INTEGER ITMLST(13)    	INTEGER*2 IOSB(4) 	CHARACTER*8 DEVNAME  ; 	COMMON /TERMINAL_DATA_/ DEVNAME, DEVTYPE, DEPEND, DEPEND2,  	1			DEVNAMELEN   - 	CALL ITEM_LIST(ITMLST,DVI$_DEVDEPEND,DEPEND, " 	1		      DVI$_DEVDEPEND2,DEPEND2,) 	2		      DVI$_DEVNAM,DEVNAME,DEVNAMELEN,  	3		      DVI$_DEVTYPE,DEVTYPE)   < 	STATUS = SYS$GETDVIW( %VAL(2) ,, 'TT:' , ITMLST , IOSB ,,,)  / 	IF (.NOT.STATUS) CALL LIB$STOP( %VAL(STATUS) )   1 	IF (.NOT.IOSB(1)) CALL LIB$STOP( %VAL(IOSB(1)) )    	END& 	SUBROUTINE CONTROL(CHARACTER,ROUTINE)   **+ *	SUBROUTINE CONTROL( character , routine )  *  * D *	Sets up linkage for subroutine ROUTINE to get control  when  ASCII+ *	character 'control-CHARACTER' is entered.  * D *	The argument CHARACTER must be a single alphabetic character,  not9 *	including 'C' OR 'Y'.  It must be an UPPER-CASE letter.  * D *	The argument ROUTINE must be declared EXTERNAL in the calling pro- *	gram.  *  *	For example: *			CALL CONTROL('B',X)  * 9 *	causes routine X to be called when a <ctrl-b> is typed.  * D *	CONTROL can be called multiple times, with different CHARACTER and2 *	ROUTINE arguments, to set up different linkages. * 4 *	  Reference:  VAX/VMS I/O User's Guide  (Volume 1)= *		      Terminal Driver Chapter  (Chapter 9 in 6/83 edition) = *		      Out-of-band AST Function Modifier  (9.4.3.5 in 6/83)  *  *	.INDEX TERMINAL I/O>>  *	.INDEX PROCESS CONTROL>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 ) *	4 Feb 1983	   Dahlgren, Virginia  22448  *    	IMPLICIT INTEGER (A-Z)   # 	PARAMETER ( IO$_SETMODE  = '23'X ) $ 	PARAMETER ( IO$M_OUTBAND = '400'X )   	CHARACTER*(*) CHARACTER 	CHARACTER*1 C 	INTEGER MASK(2) 	INTEGER*2 CHAN,IOSB(4)  	EXTERNAL ROUTINE    	DATA MASK / 2*0 /   	C = CHARACTER  4 	IF (LEN(CHARACTER).NE.1 .OR. C.EQ.'C' .OR. C.EQ.'Y'6 	1	.OR. C.LT.'A' .OR. C.GT.'Z') CALL EXIT('10000004'X)  ) 	MASK(2) = ISHFT(1,ICHAR(C)-ICHAR('A')+1)   ? 	STATUS = SYS$ASSIGN('TT',CHAN,,)	! Must assign new channel for  						! 	 each call to CONTROL- 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))   > 	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE+IO$M_OUTBAND), 	1					IOSB,,,ROUTINE,MASK,,,,)   - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))   / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))    	END 	SUBROUTINE CONTROL_Y(ROUTINE)   **! *	SUBROUTINE CONTROL_Y( routine )  *  * D *	Sets up linkage for subroutine ROUTINE to get control  when  ASCIID *	<control-Y>  or  <control-C>  is entered to abort this image.  TheD *	argument ROUTINE must be declared EXTERNAL in the calling program.D *	This routine disables CLI interpretation of <ctrl-Y> and <ctrl-C>,D *	and sets up an exit handler to re-enable them when the image exitsD *	(this is in case the caller does not do it in ROUTINE,  by callingD *	LIB$ENABLE_CTRL.  The exit handler is the separate  routine  named *	CONTROL_Y_EXIT.  * D *	If called with a null argument, the default action of  <control-Y> *	and <control-C> are restored.  * % *	22 Feb 85	Added restoration option.  *  *	.INDEX TERMINAL I/O>>  *	.INDEX PROCESS CONTROL>> * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 ) *	4 Feb 1983	   Dahlgren, Virginia  22448  *    	IMPLICIT INTEGER (A-Z)   # 	PARAMETER ( IO$_SETMODE  = '23'X ) $ 	PARAMETER ( IO$M_CTRLYAST = '80'X )% 	PARAMETER ( IO$M_CTRLCAST = '100'X )    	INTEGER*2 CHAN,IOSB(4)   	EXTERNAL ROUTINE,CONTROL_Y_EXIT   	COMMON /TT_CHAN_TT/ CHAN    	DATA CHAN / 0 /   	IF (CHAN.EQ.0) THEN  % 	    STATUS = SYS$ASSIGN('TT',CHAN,,)   1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	ENDIF  ? 	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE+IO$M_CTRLYAST),  	1						IOSB,,,ROUTINE,,,,,)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS)) / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))   ? 	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE+IO$M_CTRLCAST),  	1						IOSB,,,ROUTINE,,,,,)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS)) / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))    	IF (%LOC(ROUTINE).NE.0) THEN   . 	    CALL DECLARE_EXIT_HANDLER(CONTROL_Y_EXIT)  + 	    STATUS = LIB$DISABLE_CTRL('02000000'X)    	ELSE   - 	    CALL CANCEL_EXIT_HANDLER(CONTROL_Y_EXIT)   * 	    STATUS = LIB$ENABLE_CTRL('02000000'X)   	ENDIF  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	END 	SUBROUTINE CONTROL_Y_EXIT   ** *	SUBROUTINE CONTROL_Y_EXIT  *  * D *	This routine is not normally called by the user.   It  is  an exitD *	handler  set  up by routine CONTROL_Y to re-enable CLI interpreta-D *	tion of <ctrl-Y> and <ctrl-C>.  See routine CONTROL_Y for details. *  * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 ) *	4 Feb 1983	   Dahlgren, Virginia  22448  *    	IMPLICIT INTEGER (A-Z)   & 	STATUS = LIB$ENABLE_CTRL('02000000'X)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	END 	SUBROUTINE SET_INPUT_ALARM    ** *	SUBROUTINE SET_INPUT_ALARM *  * D *	Sets things up so that when a character is entered at the caller's7 *	VTxxx terminal keyboard, the following things happen:  * 3 *		* The LOGICAL variable INPUT_READY is set .TRUE.  * = *		* The  value of the character entered is put into variable  *		  INPUT_CHAR  * = *		* The variable INPUT_FLAG  is set to  ' '  (blank)  if the = *		  character is a printable character, '*' if it is a  con- = *		  trol character, or '.' if it indicates an escape sequen- = *		  ce (i.e. an arrow key or keypad key was hit).   In  this = *		  last case, INPUT_CHAR contains the last character of the = *		  sequence  (for example,  if the  'up arrow'  key is hit, . *		  INPUT_FLAG is '*' and INPUT_CHAR is 'A'). * = *		  An exception to the above occurs when the last character = *		  of the sequence is '~'.  This format is used by function = *		  keys on VT2xx terminals.  INPUT_FLAG is set to  '~'  and = *		  INPUT_CHAR  is set to the integer value of the preceding = *		  one- or two-digit integer.   For example,  if key F10 is 7 *		  hit, INPUT_FLAG is '~' and INPUT_CHAR is CHAR(21).  * = *		* If the program is hibernating (i.e.  it  called  routine $ *		  GO_HIBERNATE) it is wakened up. * ' *	The definition of these variables is:  *  *		LOGICAL*1 INPUT_READY$ *		CHARACTER*1 INPUT_CHAR,INPUT_FLAG * 3 *		COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY  * D *	The typed characters are not echoed on the screen; it is up to the( *	calling program to do this if desired. * D *	This routine enables a program to be doing useful work at the sameD *	time an input is expected, and, by testing INPUT_READY,  the input( *	can be processed as soon as it occurs. * D *	When using this routine and the DELETE key  is  hit, it  does  notD *	delete the last character; its ASCII value is placed in INPUT_CHAR *	just like any other key. *-D *	This is a one-time enable.  After you process the input character,8 *	you must call SET_INPUT_ALARM again to get more input. *  *	.INDEX TERMINAL I/O>>  * 4 *	 15 Jul 91	Allow input of all 256 character codes. * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 * *	30 Apr 1983	   Dahlgren, Virginia  22448 *    	IMPLICIT INTEGER (A-Z)    	EXTERNAL INPUT_ALARM    	INTEGER*2 CHAN,IOSB(4)  	BYTE BUFFER(16)  * 	INTEGER*4 MASK(10) / 32,0,8*'FFFFFFFF'X /   	LOGICAL*1 INPUT_READY" 	CHARACTER*1 INPUT_CHAR,INPUT_FLAG  1 	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY  	COMMON /TT_CHAN_TT/ CHAN $ 	COMMON /ALARM_IOSB/ IOSB,BUFFER,EFN  $ 	DATA CHAN,INPUT_READY / 0,.FALSE. /  # 	PARAMETER ( IO$_READVBLK = '31'X ) # 	PARAMETER ( IO$M_NOECHO  = '40'X ) $ 	PARAMETER ( IO$M_NOFILTR = '200'X )% 	PARAMETER ( IO$M_ESCAPE  = '4000'X ) 8 	PARAMETER ( FUNCTION     = IO$_READVBLK + IO$M_NOECHO +" 	1				IO$M_NOFILTR + IO$M_ESCAPE )   	INPUT_READY = .FALSE.   	IF (CHAN.EQ.0) THEN% 	    STATUS = SYS$ASSIGN('TT',CHAN,,) 1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	    STATUS = LIB$GET_EF(EFN) 1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	ENDIF   	MASK(2)=%LOC(MASK(3))  " *	NOTE FOLLOWING IS QIO, NOT QIOW!  9 	STATUS=SYS$QIO(%VAL(EFN),%VAL(CHAN),%VAL(FUNCTION),IOSB, - 	1			   INPUT_ALARM,,BUFFER,%VAL(16),,MASK,,)   - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	END' 	SUBROUTINE GET_TERMINAL_INPUT(TIMEOUT)    **, *	SUBROUTINE GET_TERMINAL_INPUT( [timeout] ) *  * D *	This is  identical to  subroutine  SET_INPUT_ALARM, except that it/ *	does not allow concurrent processing and I/O.  * D *	If the optional TIMEOUT argument is present, the read will timeoutD *	after that many seconds.  If nothing has been entered, the callingB *	program will get an indication that a NUL character was entered. *  *	.INDEX TERMINAL I/O>>  * 4 *	 15 Jul 91	Allow input of all 256 character codes.+ *	 23 Oct 92	Add optional TIMEOUT argument.  * 1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53 . *	30 Apr 1983        Dahlgren, Virginia  22448 *    	IMPLICIT INTEGER (A-Z)    	INCLUDE '($IODEF)'    	EXTERNAL INPUT_ALARM    	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR 	INTEGER*2 CHAN,IOSB(4)  	BYTE BUFFER(16)  * 	INTEGER*4 MASK(10) / 32,0,8*'FFFFFFFF'X /   	LOGICAL*1 INPUT_READY" 	CHARACTER*1 INPUT_CHAR,INPUT_FLAG1 	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READY    	COMMON /TT_CHAN_TT/ CHAN $ 	COMMON /ALARM_IOSB/ IOSB,BUFFER,EFN  $ 	DATA CHAN,INPUT_READY / 0,.FALSE. /  @ 	FUNCT = IO$_READVBLK + IO$M_NOECHO + IO$M_NOFILTR + IO$M_ESCAPE  ' 	IF (ARG_EXIST(%VAL(IARGPTR()),1)) THENd 	    FUNCT = FUNCT + IO$M_TIMED  	    TIME = MAX(TIMEOUT,2) 	ELSEF
 	    TIME = 0h 	ENDIF   	INPUT_READY = .FALSE.   	IF (CHAN.EQ.0) THEN% 	    STATUS = SYS$ASSIGN('TT',CHAN,,)f1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))r 	    STATUS = LIB$GET_EF(EFN)i1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))O 	ENDIF   	MASK(2) = %LOC(MASK(3))  7 	STATUS=SYS$QIOW(%VAL(EFN),%VAL(CHAN),%VAL(FUNCT),IOSB,i4 	1		 INPUT_ALARM,,BUFFER,%VAL(16),%VAL(TIME),MASK,,)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))k   	RETURNl       	ENTRY CANCEL_INPUT_ALARMC     ** *	SUBROUTINE CANCEL_INPUT_ALARMi *  *4D *	Cancels  any outstanding  I/O request  queued to the terminal by a+ *	previous call to routine SET_INPUT_ALARM.) *P *	.INDEX TERMINAL I/O>>  *'1 *	Alan L. Zirkle     Naval Surface Warfare CenterI *			   Code K55 . *	13 Feb 1990        Dahlgren, Virginia  22448 *M    	STATUS = SYS$CANCEL(%VAL(CHAN))  + 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(CHAN))    	END 	SUBROUTINE INPUT_ALARME   ** *	SUBROUTINE INPUT_ALARM *E *DD *	This routine is not called by the user.   Routine  SET_INPUT_ALARMD *	sets up this routine as the I/O completion AST routine for readingD *	from the terminal.  This routine checks  the status  of the  read,4 *	and parses the input (to set variable INPUT_FLAG). *T+ *	17 Jun 87	Update for VT220 character set.U *E) *	13 Feb 91	Don't abort if I/O Cancelled.	 *s *	.INDEX TERMINAL I/O>>e *U1 *	Alan L. Zirkle     Naval Surface Warfare Centerr *			   Code K53e* *	30 Apr 1983	   Dahlgren, Virginia  22448 *a   	IMPLICIT INTEGER (A-Z)r   	INTEGER*2 ESC / '1B'X / 	INTEGER*2 CSI / '9B'X / 	INTEGER*2 SS3 / '8F'X /  - 	EXTERNAL SS$_BADESCAPE,SS$_ABORT,SS$_TIMEOUTa   	INTEGER*2 IOSB(4) 	BYTE BUFFER(16)   	LOGICAL*1 INPUT_READY" 	CHARACTER*1 INPUT_CHAR,INPUT_FLAG  1 	COMMON /TTIN_/ INPUT_CHAR,INPUT_FLAG,INPUT_READYl$ 	COMMON /ALARM_IOSB/ IOSB,BUFFER,EFN 	COMMON /HIBER_/ HIBERNATING   	IF (.NOT.IOSB(1)) THENa  * 	  IF (IOSB(1).NE.%LOC(SS$_BADESCAPE).AND.& 	1     IOSB(1).NE.%LOC(SS$_ABORT).AND.A 	2     IOSB(1).NE.%LOC(SS$_TIMEOUT)) CALL LIB$STOP(%VAL(IOSB(1)))F   	ENDIF  # 	INPUT_CHAR = CHAR(BUFFER(IOSB(4)))X   	INPUT_READY = .TRUE.X  A 	IF (IOSB(3).EQ.ESC .OR. IOSB(3).EQ.CSI .OR. IOSB(3).EQ.SS3) THENn   	    INPUT_FLAG = '.'	  7 	    IF (INPUT_CHAR.EQ.'~') THEN		! VT2xx function keysN 		INPUT_FLAG = '~'* 		I = ZEXT(BUFFER(IOSB(4)-2)) - ICHAR('0') 		IF (I.GE.0 .AND. I.LE.9) THENA: 		    INPUT_CHAR = CHAR(I*10+BUFFER(IOSB(4)-1)-ICHAR('0')) 		ELSE5 		    INPUT_CHAR = CHAR(BUFFER(IOSB(4)-1)-ICHAR('0'))  		ENDIFA
 	    ENDIF   	ELSE IF (IOSB(3).LT.'20'X .OR.'4 	1		   (IOSB(3).GE.'7F'X.AND.IOSB(3).LE.'A0'X)) THEN   	    INPUT_FLAG = '*'(   	ELSET   	    INPUT_FLAG = ' '    	ENDIF  ! 	IF (HIBERNATING) CALL GO_WAKE_UPs   	END 	SUBROUTINE GO_HIBERNATE   **) *	Subroutines GO_HIBERNATE and GO_WAKE_UPO *V *SD *	Places the calling process into and out of  hibernation.   See theD *	VAX/VMS  System  Services Reference Manual,  Chapter 7 (pages 7-100 *	through 7-13) for a discussion of hibernation. *PD *	Note that after the process has been  placed  in hibernation,  the *	only ways it can wake up are:  * = *		* If the process receives an AST and the AST routine callsA= *		  GO_WAKE_UP (or calls the SYS$WAKE System Service,  whichi *		  is equivalent)t *U= *		* If this process called the SYS$SCHDWK System Service be-r4 *		  fore it hibernated, to schedule a wake-up call. *C= *		* If another process calls SYS$WAKE or SYS$SCHDWK  on  be-a *		  half of this processe *e *	.INDEX PROCESS CONTROL>> *N1 *	Alan L. Zirkle     Naval Surface Warfare Centerr *			   Code K53 ) *	2 Apr 1983	   Dahlgren, Virginia  22448f *l   	IMPLICIT INTEGER (A-Z)h   	LOGICAL HIBERNATING   	COMMON /HIBER_/ HIBERNATING   	DATA HIBERNATING / .FALSE. /    	HIBERNATING = .TRUE.    	STATUS = SYS$HIBER()   - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	HIBERNATING = .FALSE.   	RETURN	       	ENTRY GO_WAKE_UP3     	STATUS = SYS$WAKE(,)4  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))(   	END$ !	INTEGER FUNCTION SET_SCREEN(WIDTH) !A !**'' !*	INTEGER FUNCTION SET_SCREEN( width )' !* !*E !*	Sets the width of the terminal screen, in characters, to the valueTE !*	of the integer 'width' parameter,  which must be either 132 or 80.AE !*	If  the terminal  is already  at the desired width,  no setting isVE !*	done.   If the width  is changed,  then an exit handler  is set upDE !*	which resets  the terminal  back to  its original width  when thisAB !*	program exits.  If the width is changed, the screen is blanked. !*E !*	The function result is the previous value of the screen width.  If E !*	this value is not needed, SET_SCREEN may be CALLed as a subroutineS !*	rather than a function. !* !*	.INDEX TERMINAL I/O>> !*2 !*	Alan L. Zirkle     Naval Surface Warfare Center !*			   Code K53+ !*	14 Sep 1984	   Dahlgren, Virginia  22448' !* !0 !  !	IMPLICIT INTEGER (A-Z) !L% !	PARAMETER ( IO$_SENSEMODE = '27'X )S% !	PARAMETER ( IO$_SETMODE   = '23'X ) % !	PARAMETER ( IO$_WRITEVBLK = '30'X )O !V !	INTEGER*2 CHAN,IOSB(4)3 !	INTEGER*2 CHARACTERISTICS(4),WIDTH,ORIGINAL_WIDTHE !  !	EXTERNAL SET_SCREEN_EXIT !  !	LOGICAL FIRST_CALL / .TRUE. /  !  !	COMMON /TT_CHAN_TT/ CHAN !  !	DATA CHAN / 0 /o !- !	IF (CHAN.EQ.0) THEN . !	    STATUS = SYS$ASSIGN('SYS$OUTPUT',CHAN,,)2 !	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS)) !	ENDIFa !W !	IF (FIRST_CALL) THEN ! ? !	    STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SENSEMODE),IOSB,,,   !	1					   CHARACTERISTICS,,,,,) !E2 !	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS)) !V4 !	    IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1))) ! ) !	    ORIGINAL_WIDTH = CHARACTERISTICS(2)s !i !	ENDIF  !t! !	SET_SCREEN = CHARACTERISTICS(2)  !l) !	IF (CHARACTERISTICS(2).EQ.WIDTH) RETURNi !t !	CHARACTERISTICS(2) = WIDTH !C9 !	IF (WIDTH.EQ.132) CALL LIB$PUT_SCREEN(CHAR(27)//'[?3h') 9 !	IF (WIDTH.EQ. 80) CALL LIB$PUT_SCREEN(CHAR(27)//'[?3l')C ! 9 !	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE),IOSB,,,   !	1					   CHARACTERISTICS,,,,,) !l. !	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS)) !c0 !	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1))) !c !	IF (FIRST_CALL) THEN !p !	    FIRST_CALL = .FALSE. !	? !	    CALL DECLARE_EXIT_HANDLER(SET_SCREEN_EXIT,ORIGINAL_WIDTH)  !q !	ENDIFo !x !	END	8 !	SUBROUTINE SET_SCREEN_EXIT(EXIT_STATUS,ORIGINAL_WIDTH) !I !**C !*	SUBROUTINE SET_SCREEN_EXITt !* !*E !*	This routine is not called by the user.  Routine SET_SCREEN_132 or E !*	SET_SCREEN_80 may set up this routine as a VMS exit handler to setFE !*	the terminal screen back to its original width when the program iso
 !*	exited. !* !*2 !*	Alan L. Zirkle     Naval Surface Warfare Center !*			   Code K53+ !*	14 Sep 1984	   Dahlgren, Virginia  22448) !* !  !* !	IMPLICIT INTEGER (A-Z) !g& !	INTEGER*4 EXIT_STATUS,ORIGINAL_WIDTH !N! !	CALL SET_SCREEN(ORIGINAL_WIDTH)e !i !	END  	SUBROUTINE SET_KEYPAD_MODEL   **3 *	Subroutines SET_KEYPAD_MODE and RESET_KEYPAD_MODE  *  *CD *	Places the VT100 keypad keys  into or  out of  Keypad  ApplicationD *	Mode.   Normally, the keys are not in application mode; the keypadD *	'7' for instance, is the same as the keyboard '7', and the 'Enter'D *	key is the same as 'Return'.  When in application mode, the keypadD *	keys return unique escape sequences, described in the VT100 manual *	and reference card.  *t? *	The calling program should reset keypad mode before it exits.  *r *	.INDEX TERMINAL I/O>>  *c1 *	Alan L. Zirkle     Naval Surface Warfare Center	 *			   Code K53e) *	2 Apr 1983	   Dahlgren, Virginia  22448c *,   	IMPLICIT INTEGER (A-Z)_   	BYTE BUFFER(2) / 27,0 / 	INTEGER*2 CHAN,IOSB(4)    	COMMON /TT_CHAN_TT/ CHANw  $ 	PARAMETER ( IO$_WRITEVBLK = '30'X ), 	PARAMETER ( FUNCTION      = IO$_WRITEVBLK )   	BUFFER(2) = ICHAR('=')0   10	IF (CHAN.EQ.0) THEN# 	    STATUS=SYS$ASSIGN('TT',CHAN,,) 1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS)), 	ENDIF  3 	STATUS=SYS$QIOW(,%VAL(CHAN),%VAL(FUNCTION),IOSB,,,F 	1					BUFFER,%VAL(2),,,,)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))M  / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))M   	RETURNN       	ENTRY RESET_KEYPAD_MODE     	BUFFER(2)=ICHAR('>')H  	 	GO TO 10Y   	END 	SUBROUTINE RING_BELL(COUNT)   **$ *	SUBROUTINE RING_BELL [ ( count ) ] *4 * D *	Rings the terminal bell.   The argument COUNT tells how many timesD *	the bell is to be rung.  If  COUNT  is omitted,  the bell  is rung- *	once.  Count should not be greater than 16.A *= *	.INDEX TERMINAL I/O>>0 *H1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K53L) *	3 Nov 1983	   Dahlgren, Virginia  22448$ *_   	IMPLICIT INTEGER (A-Z)T   	BYTE BUFFER(16) / 16*7 /) 	INTEGER*2 CHAN,IOSB(4)O   	COMMON /TT_CHAN_TT/ CHANG  $ 	PARAMETER ( IO$_WRITEVBLK = '30'X ), 	PARAMETER ( FUNCTION      = IO$_WRITEVBLK )   	IF (CHAN.EQ.0) THEN# 	    STATUS=SYS$ASSIGN('TT',CHAN,,)S1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))  	ENDIF  2 	LEN = MIN( DEFAULT_ARG(%VAL(IARGPTR()),1,1) , 16)  3 	STATUS=SYS$QIOW(,%VAL(CHAN),%VAL(FUNCTION),IOSB,,,b 	1					BUFFER,%VAL(LEN),,,,)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))g  / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))i   	END 	SUBROUTINE PROMPT4 	1		(PROMPT_STRING,RESPONSE,RESPONSE_LENGTH,OPTIONS)   **. *	SUBROUTINE PROMPT ( prompt_string , response *a0 *+				       [, response_length ] [, options ] ) *  *>D *	Displays  a prompt message on the terminal,  then reads the user's *	response.o * D *	The prompt message is preceded by a blank line, and is accompaniedD *	by two rings of the bell.  A colon and one blank character are ap-# *	pended to the end of the message.I *UD *	The response is read from the file SYS$COMMAND, so from  within  aD *	command procedure, this will still obtain an interactive response. *SD *	The prompt message is specified as the character  string  argumentD *	PROMPT_STRING.   The response  is returned in the character stringD *	argument  RESPONSE.    If  the  optional  third  integer  argumentD *	RESPONSE_LENGTH is present, the length of the entered response  is *	returned there.F *RD *	The string RESPONSE must be longer than any expected response;  ifD *	the string fills up, then the operation completes before  the userD *	enters a Carriage Return.  The maximum response is 256 characters. *UD *	The optional third integer arguement OPTIONS  allows the caller toD *	change the presentation of the  prompt message and the entered re-D *	response.  Each bit in OPTIONS activates one function when set (by$ *	default, none are considered set): *T4 *		1 -- Do not output a blank line before the prompt% *		2 -- Do not ring the terminal bellS7 *		4 -- Do not put the colon and blank after the prompt_9 *		8 -- Output a blank line after the response is entered	> *	       16 -- Display the response in VT100 'bold' attributes% *	       32 -- Uppercase the responseT' *	       64 -- Do not echo the response' *	 *	IMPORTANT WARNING: *	------------------D *	If option 16 is used,  ALL attributes are turned off after the re-D *	sponse is entered.  Also, incoming broadcast messages will displayD *	as bold if they arrive while waiting for response,  and CTRL\Y andD *	AST events may leave the screen in BOLD;  the likelihood of screen *	damage must be considered. *  *	.INDEX TERMINAL I/O>>o *-? *	 13 Jan 87	Add OPTIONS parameter,  routine PROMPT_CANCEL, usec *			of LIB$GET_EF.? *	 12 May 87	If just CTRL\Z is entered,  return ASCII 26 as the. *			response# *	 20 Jun 88	Add options 32 and 64. . *	 18 Mar 91	Limit response to 256 characters. * 1 *	Alan L. Zirkle     Naval Surface Warfare CenterN *			   Code K53a* *	13 Dec 1983	   Dahlgren, Virginia  22448 *D   	IMPLICIT NONE   	INCLUDE '($IODEF)'   % 	CHARACTER*(*) PROMPT_STRING,RESPONSE/" 	INTEGER*4 RESPONSE_LENGTH,OPTIONS   	CHARACTER*1 CR,LF,BEL,ESC   	PARAMETER ( CR  = CHAR(13) )U 	PARAMETER ( LF  = CHAR(10) )  	PARAMETER ( BEL = CHAR( 7) )R 	PARAMETER ( ESC = CHAR(27) )N   	CHARACTER*5 PREFIXI 	CHARACTER*6 SUFFIXF 	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR 	INTEGER*2 CHAN,IOSB(4)H9 	INTEGER*4 FUNCTION,STATUS,SYS$ASSIGN,SYS$QIOW,SYS$CANCELS- 	INTEGER*4 OPTIONS_,P1,P2,S1,S2,STATUS2,L1,L2)   	EXTERNAL SS$_ABORT.   	DATA CHAN / 0 /  
 	OPTIONS_ = 0)  5 	IF (ARG_EXIST(%VAL(IARGPTR()),4)) OPTIONS_ = OPTIONS    	IF (CHAN.EQ.0) THEN  * 	    PREFIX = LF // LF // CR // BEL // BEL  . 	    STATUS = SYS$ASSIGN('SYS$COMMAND',CHAN,,)  1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))'   	ENDIF   	P1 = 1i 	P2 = 5    	FUNCTION = IO$_READPROMPT 	SUFFIX = ': ' 	S2 = 2A  # 	IF (IAND(OPTIONS_, 1).NE.0) P1 = 2A# 	IF (IAND(OPTIONS_, 2).NE.0) P2 = 3(# 	IF (IAND(OPTIONS_, 4).NE.0) S2 = 0 ! 	IF (IAND(OPTIONS_,16).NE.0) THEN-% 	    SUFFIX(S2+1:S2+4) = ESC // '[1m'E 	    S2 = S2 + 4 	ENDIF> 	IF (IAND(OPTIONS_,32).NE.0) FUNCTION = FUNCTION + IO$M_CVTLOW> 	IF (IAND(OPTIONS_,64).NE.0) FUNCTION = FUNCTION + IO$M_NOECHO    	L1 = MIN( 256 , LEN(RESPONSE) ). 	L2 = LEN(PROMPT_STRING) + (P2 - P1 + 1) + S2   5 	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(FUNCTION),IOSB,,,s 	1	%REF(RESPONSE),%VAL(L1),,,u9 	2	     %REF(PREFIX(P1:P2)//PROMPT_STRING//SUFFIX(1:S2)),e 	3						       %VAL(L2))  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))    	IF (.NOT.IOSB(1)) THENaA 	    IF (IOSB(1).NE.%LOC(SS$_ABORT)) CALL LIB$STOP(%VAL(IOSB(1)))w 	ENDIF  @ 	IF (IOSB(2).EQ.0 .AND.IOSB(3).EQ.26) THEN	! Return EOF (CTRL\Z)" 	    IOSB(2) = 1					!  indication 	    RESPONSE(1:1) = CHAR(26)v 	ENDIF  9 	IF (IOSB(2).LT.LEN(RESPONSE)) RESPONSE(IOSB(2)+1:) = ' 'h  < 	IF (ARG_EXIST(%VAL(IARGPTR()),3)) RESPONSE_LENGTH = IOSB(2)  % 	IF (IAND(OPTIONS_,8+16).EQ.0) RETURNe   	SUFFIX = LF // ESC // '[m'$ 	S1 = 1n 	S2 = 4	 	h# 	IF (IAND(OPTIONS_, 8).EQ.0) S1 = 2O# 	IF (IAND(OPTIONS_,16).EQ.0) S2 = 1   : 	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_WRITEVBLK),IOSB,,,- 	1			  %REF(SUFFIX(S1:S2)),%VAL(S2-S1+1),,,,)I  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))O  / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))E   	RETURNB       	ENTRY PROMPT_CANCEL   ** *	SUBROUTINE PROMPT_CANCEL *  *LD *	Causes a program which is waiting for user input because of a callD *	to routine PROMPT, PROMPT_YES, or PROMPT_INT to continue as if theD *	user had entered a carriage  return.   Any text (if any) which has3 *	already been typed in is considered the response.' **D *	PROMPT_CANCEL must be called from an AST routine.  Its use must beD *	carefully considered, since many programs (and definitely routinesD *	PROMPT_YES and PROMPT_INT) may loop when a null string is entered. *i *	.INDEX TERMINAL I/O>>  *t1 *	Alan L. Zirkle     Naval Surface Warfare Center* *			   Code K53e* *	13 Jan 1987	   Dahlgren, Virginia  22448 *i   	IF (CHAN.EQ.0) RETURN  ! 	STATUS2 = SYS$CANCEL(%VAL(CHAN))l  / 	IF (.NOT.STATUS2) CALL LIB$STOP(%VAL(STATUS2))v   	END3 	LOGICAL FUNCTION PROMPT_YES(PROMPT_STRING,DEFAULT)S   **= *	LOGICAL FUNCTION PROMPT_YES ( prompt_string [ , default ] )  *  *.D *	Displays a prompt message (the string PROMPT_STRING) on the  term-D *	inal,  then reads the user's response.   The message is assumed to3 *	be a question which can be answered by YES or NO.E * D *	If the response was positive,  a  .TRUE.  functional result is re-+ *	turned; otherwise the result is .FALSE. .E **D *	The first character of the response must be 'Y' or 'N' (either up-B *	per case or lower case); if it is not, the question is repeated. * D *	If the optional  DEFAULT  parameter is present,  it must be eitherD *	'Y' or 'N' (upper case only); if the user makes a  null  or  blank, *	entry, this value is used as his response. *aD *	The question is preceded by a blank line, and  is  accompanied  byD *	two rings of the bell. The question is followed, on the same line, *	by:( *T *	  *  A question mark *(9 *	  *  The string ' (Y/N)', showing the allowable entriesS *)D *	  *  (If DEFAULT is present,  one of the strings ' [Y]' or ' [N]',! *						      showing the default)  *	  *  A colon and one blank *ID *	The response is read from the file  SYS$COMMAND,  so from within aD *	command procedure, this will still obtain an interactive response. *T *	.INDEX TERMINAL I/O>>C * 1 *	Alan L. Zirkle     Naval Surface Warfare Center, *			   Code K53	* *	22 Dec 1983	   Dahlgren, Virginia  22448 *)   	IMPLICIT INTEGER (A-Z))   	CHARACTER*(*) PROMPT_STRING  
 	BYTE DEFAULT(  # 	CHARACTER*11 ADD / '? (Y/N) [N]' /	   	CHARACTER RESPONSE*8,R*1    	EQUIVALENCE (RESPONSE,R)E   	LOGICAL ARG_EXIST,DEF,NUL 	INTEGER*4 IARGPTR  # 	DEF = ARG_EXIST(%VAL(IARGPTR()),2)T   	IF (DEF) THEN   	    LADD = 11   	    IF (DEFAULT.EQ.1HY) THENt   		ADD(10:10) = 'Y'  	 	    ELSEl   		ADD(10:10) = 'N'  
 	    ENDIF   	ELSE   
 	    LADD = 7m   	ENDIF  ? 10	CALL PROMPT( PROMPT_STRING // ADD(:LADD) , RESPONSE , LRES )b  1 	NUL = LRES .EQ. 0 .OR. RESPONSE(1:LRES) .EQ. ' 'i   	IF (NUL) THEN   	    IF (.NOT.DEF) GO TO 10   " 	    PROMPT_YES = DEFAULT .EQ. 1HY   	ELSE4  % 	    IF (R.EQ.'Y' .OR. R.EQ.'y') THEN*   		PROMPT_YES = .TRUE.)  * 	    ELSE IF (R.EQ.'N' .OR. R.eq.'n') THEN   		PROMPT_YES = .FALSE.  	 	    ELSE   
 		GO TO 10  
 	    ENDIF   	ENDIF   	END; 	INTEGER FUNCTION PROMPT_INT(PROMPT_STRING,DEFAULT,OPTIONS)C   **9 *	INTEGER FUNCTION PROMPT_INT( prompt_string [, default ]a *n *+							     [, options ])s *e *tD *	Displays a prompt message (the string PROMPT_STRING) on the  term-D *	inal, then reads the user's response.   The response is assumed to *	be an integer value. *e9 *	The response may be in either of the following formats:h *T *		i	%i	%Di	%Oj	%Xke *cD *	where 'i' is one or more decimal digits,  'j' is one or more octalD *	digits, and 'k' is one or more hexadecimal digits. If the response; *	is not in one of these formats, the question is repeated.a *rD *	The  INTEGER*4  converted value of the response is returned as the *	functional result. *AD *	If the response is null or blank, then the action taken depends on: *	whether the optional INTEGER*4 argument DEFAULT is used: *FD *	    If DEFAULT is used, then its value is returned as the function
 *	    result.  * < *	    If DEFAULT is not used, then the question is repeated. *=D *	The prompt string is preceded by a blank line, and is  accompaniedD *	by two rings  of the bell.   The question is followed by a  colon.D *	These attributes can be changed by using the optional OPTIONS arg-? *	ument; see routine PROMPT for a description of this argument.O *ND *	The response is read from the file  SYS$COMMAND,  so from within aD *	command procedure, this will still obtain an interactive response. *	 *	.INDEX TERMINAL I/O>>I *C1 *	Alan L. Zirkle     Naval Surface Warfare Centert *			   Code K53e* *	15 Apr 1984	   Dahlgren, Virginia  22448 *H   	IMPLICIT INTEGER (A-Z)l   	CHARACTER*(*) PROMPT_STRING   	CHARACTER*32 RAW_VALUE  	CHARACTER*1  RADIX2   	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR  
 	OPTIONS_ = 015 	IF (ARG_EXIST(%VAL(IARGPTR()),3)) OPTIONS_ = OPTIONS/  5 10	CALL PROMPT(PROMPT_STRING,RAW_VALUE,VLEN,OPTIONS_)R  0 	IF (VLEN.EQ.0.OR.RAW_VALUE(1:VLEN).EQ.' ') THEN  + 	    IF (ARG_EXIST(%VAL(IARGPTR()),2)) THEN  		PROMPT_INT = DEFAULT 		RETURN	 	    ELSE)
 		GO TO 10
 	    ENDIF  % 	ELSE IF (RAW_VALUE(1:1).EQ.'%') THEN   * 	    CALL STR$UPCASE(RADIX,RAW_VALUE(2:2))   	    IF (RADIX.EQ.'D') THENN0 		STATUS = OTS$CVT_TI_L(RAW_VALUE(3:VLEN),VALUE)  	    ELSE IF (RADIX.EQ.'X') THEN0 		STATUS = OTS$CVT_TZ_L(RAW_VALUE(3:VLEN),VALUE)  	    ELSE IF (RADIX.EQ.'O') THEN0 		STATUS = OTS$CVT_TO_L(RAW_VALUE(3:VLEN),VALUE)	 	    ELSEr0 		STATUS = OTS$CVT_TI_L(RAW_VALUE(2:VLEN),VALUE)
 	    ENDIF   	ELSE   3 	    STATUS = OTS$CVT_TI_L(RAW_VALUE(1:VLEN),VALUE)e   	ENDIF   	IF (.NOT.STATUS) GO TO 10   	PROMPT_INT = VALUEr   	END& 	SUBROUTINE SMGL_GET_TERMINAL_SETTINGS   **' *	SUBROUTINE SMGL_GET_TERMINAL_SETTINGSc *a *rD *	Gets the current settings  of the terminal characteristics for theD *	device SYS$OUTPUT. This routine is used by other library routines,= *	so direct calls by the user should obey the following rule:r *tD *	This routine should only be called once.  It should only be calledD *	if CHARBUF.DEVICE_CLASS is zero; if it is not zero, it has alreadyD *	been called.  Structure  CHARBUF  contains the current settings ofD *	the terminal characteristics, and structure  CHARBUF_DEFAULT  con-D *	tains the initial settings when this image started.  The structure) *	CHARBUF_DEFAULT should NOT be modified!  *r5 *	The definitions of CHARBUF and CHARBUF_DEFAULT are:e *n *		STRUCTURE /CHARBUF/' *		  BYTE DEVICE_CLASS	/ 0 /	! DC$_TERMi- *		  BYTE DEVICE_TYPE	/ 0 /	! DT$_VT100, etc. , *		  INTEGER*2 PAGE_WIDTH  / 0 /	! 80 or 132
 *		  union
 *		    map6 *		      INTEGER*4 BASIC_CHAR	! First 3 bytes ($TTDEF) *		    end map
 *		    map *		      BYTE %FILL (3):' *		      BYTE PAGE_LENGTH		! Usually 24b *		    end map *		  end union$ *		  INTEGER*4 EXT_CHAR		! ($TT2DEF) *		END STRUCTURE *b+ *		RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULTk *n- *		COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT- *sD *	See "VAX/VMS I/O User's Reference Manual:  Part I" (for VMS V4.0), *	Figure 8-8, on page 8-38.- *  *	.INDEX TERMINAL I/O>>	 *	1 *	Alan L. Zirkle     Naval Surface Warfare Centero *			   Code K53L* *	19 May 1985	   Dahlgren, Virginia  22448 *n   	IMPLICIT INTEGER (A-Z)i  & 	PARAMETER ( IO$_SENSEMODE =   '27'X )   	LOGICAL*1 HANDLER_ONw 	INTEGER*2 CHAN,IOSB(4)    	STRUCTURE /CHARBUF/& 	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERM, 	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc.+ 	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132  	  union 	    map8 	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF) 	    end map 	    map 	      BYTE %FILL (3)S& 	      BYTE PAGE_LENGTH			! Usually 24 	    end map 	  end union# 	  INTEGER*4 EXT_CHAR			! ($TT2DEF)a 	END STRUCTURE  ) 	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULTe  @ 	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ON   	IF (CHAN.EQ.0) THEN  - 	    STATUS = SYS$ASSIGN('SYS$OUTPUT',CHAN,,)G  1 	    IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))A   	ENDIF  3 	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SENSEMODE),T& 	1				    IOSB,,,CHARBUF,%VAL(12),,,,)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))   / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))L   	CHARBUF_DEFAULT = CHARBUF   	END$ 	SUBROUTINE SMGL_SET_TERMINAL(DUMMY)   ** *	SUBROUTINE SMGL_SET_TERMINAL *  *TD *	This routine  should not be called  by the user.   It is called byD *	other  library routines to modify specific characteristics  of the7 *	terminal associated with the logical name SYS$OUTPUT.E * * *	The procedure for using this routine is: * D *	  1.  If CHARBUF.DEVICE_CLASS is zero  (for a definition of struc-D *	      ture CHARBUF,  see routine SMGL_GET_TERMINAL_SETTINGS), callD *	      SMGL_GET_TERMINAL_SETTINGS to get the  terminal default set- *	      tings. *I< *	  2.  Modify the relevant fields in the CHARBUF structure. *  *	  3.  Call this routine. * D *	Any characteristics set by using  this routine will be set back to- *	their original values when the image exits.I *_ *	.INDEX TERMINAL I/O>>_ *)1 *	Alan L. Zirkle     Naval Surface Warfare CenterI *			   Code K53O* *	19 May 1985	   Dahlgren, Virginia  22448 *)   	IMPLICIT INTEGER (A-Z)W  $ 	PARAMETER ( IO$_SETMODE =   '23'X )   	LOGICAL*1 HANDLER_ON, 	INTEGER*2 CHAN,IOSB(4)1   	STRUCTURE /CHARBUF/& 	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERM, 	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc.+ 	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132( 	  union 	    map8 	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF) 	    end map 	    map 	      BYTE %FILL (3)\& 	      BYTE PAGE_LENGTH			! Usually 24 	    end map 	  end union# 	  INTEGER*4 EXT_CHAR			! ($TT2DEF)P 	END STRUCTURE  ) 	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULTG  @ 	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ON   	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR  @ 	IF (ARG_EXIST(%VAL(IARGPTR()),1)) THEN		! Called at image exit.  : 	    IF (CHARBUF.PAGE_WIDTH.NE.CHARBUF_DEFAULT.PAGE_WIDTH)A 	1      CALL SMGL_SET_TERMINAL_WIDTH(CHARBUF_DEFAULT.PAGE_WIDTH,)2   	    CHARBUF = CHARBUF_DEFAULT   	ENDIF  1 	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_SETMODE),P& 	1				    IOSB,,,CHARBUF,%VAL(12),,,,)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))L  / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))s  3 	IF (.NOT.HANDLER_ON) CALL SMGL_ENABLE_EXIT_HANDLER_   	END$ 	SUBROUTINE SMGL_ENABLE_EXIT_HANDLER   **% *	SUBROUTINE SMGL_ENABLE_EXIT_HANDLER  *  *)D *	This routine is normally not called by the user.   It is called byD *	SMGL_SET_TERMINAL  to declare an exit handler,  which will set anyD *	changed characteristics back to the original settings when the im-D *	age exits.  The original settings are assumed to be in the CHARBUF- *	structure (see SMGL_GET_TERMINAL_SETTINGS).k *  *	.INDEX TERMINAL I/O>>C *e1 *	Alan L. Zirkle     Naval Surface Warfare Centerr *			   Code K53 * *	19 May 1985	   Dahlgren, Virginia  22448 *E   	IMPLICIT INTEGER (A-Z).  ! 	LOGICAL*1 HANDLER_ON / .FALSE. /v 	INTEGER*2 CHAN,IOSB(4)O   	STRUCTURE /CHARBUF/& 	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERM, 	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc.+ 	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132  	  union 	    map8 	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF) 	    end map 	    map 	      BYTE %FILL (3) & 	      BYTE PAGE_LENGTH			! Usually 24 	    end map 	  end union# 	  INTEGER*4 EXT_CHAR			! ($TT2DEF)u 	END STRUCTURE  ) 	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULTr  @ 	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ON   	EXTERNAL SMGL_SET_TERMINALq   	HANDLER_ON = .TRUE.  - 	CALL DECLARE_EXIT_HANDLER(SMGL_SET_TERMINAL)t   	END% 	SUBROUTINE SMGL_DISABLE_LINE_EDITINGo   **& *	SUBROUTINE SMGL_DISABLE_LINE_EDITING *r *tD *	Turns off the  'Line Editing'  terminal feature for the SYS$OUTPUTD *	device  so the application  has more control  over the  terminal's *	function keys.   *  *	.INDEX TERMINAL I/O>>T *	1 *	Alan L. Zirkle     Naval Surface Warfare Center' *			   Code K53o* *	19 May 1985	   Dahlgren, Virginia  22448 *n   	IMPLICIT INTEGER (A-Z)]  & 	PARAMETER ( TT2$M_EDITING = '1000'X )   	LOGICAL*1 HANDLER_ONd 	INTEGER*2 CHAN,IOSB(4)p   	STRUCTURE /CHARBUF/& 	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERM, 	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc.+ 	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132> 	  union 	    map8 	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF) 	    end map 	    map 	      BYTE %FILL (3) & 	      BYTE PAGE_LENGTH			! Usually 24 	    end map 	  end union# 	  INTEGER*4 EXT_CHAR			! ($TT2DEF)/ 	END STRUCTURE  ) 	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULTP  @ 	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ON  ? 	IF (CHARBUF.DEVICE_CLASS.EQ.0) CALL SMGL_GET_TERMINAL_SETTINGS   = 	CHARBUF.EXT_CHAR = IAND(CHARBUF.EXT_CHAR,NOT(TT2$M_EDITING))S   	CALL SMGL_SET_TERMINAL    	END6 	INTEGER FUNCTION SMGL_SET_TERMINAL_WIDTH(WIDTH,DUMMY)   **3 *	INTEGER FUNCTION SMGL_SET_TERMINAL_WIDTH( width )L *L * D *	Sets the width of the terminal screen, in characters, to the valueD *	of the integer 'width' parameter,  which must be either 132 or 80.D *	If  the terminal  is already  at the desired width,  no setting isD *	done.   If the width  is changed,  then an exit handler  is set upD *	which resets  the terminal  back to  its original width  when thisA *	program exits.  If the width is changed, the screen is blanked.U *ID *	The function result is the previous value of the screen width.  IfD *	this value is not needed, SMGL_SET_TERMINAL_WIDTH may be CALLed as& *	a subroutine rather than a function. *' *	.INDEX TERMINAL I/O>>e * 1 *	Alan L. Zirkle     Naval Surface Warfare Centern *			   Code K53e* *	19 May 1985	   Dahlgren, Virginia  22448 *O   	IMPLICIT INTEGER (A-Z)o   	INTEGER*2 WIDTH  $ 	PARAMETER ( IO$_WRITEVBLK = '30'X )   	LOGICAL*1 HANDLER_ONe 	INTEGER*2 CHAN,IOSB(4)h   	STRUCTURE /CHARBUF/& 	  BYTE DEVICE_CLASS	/ 0 /		! DC$_TERM, 	  BYTE DEVICE_TYPE	/ 0 /		! DT$_VT100, etc.+ 	  INTEGER*2 PAGE_WIDTH  / 0 /		! 80 or 132i 	  union 	    map8 	      INTEGER*4 BASIC_CHAR		! Actually 3 bytes ($TTDEF) 	    end map 	    map 	      BYTE %FILL (3)m& 	      BYTE PAGE_LENGTH			! Usually 24 	    end map 	  end union# 	  INTEGER*4 EXT_CHAR			! ($TT2DEF)u 	END STRUCTURE  ) 	RECORD /CHARBUF/ CHARBUF,CHARBUF_DEFAULTr  @ 	COMMON /SMGL_CHAR/ CHARBUF,CHARBUF_DEFAULT,CHAN,IOSB,HANDLER_ON   	CHARACTER*5 BUFFERo 	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR  ? 	IF (CHARBUF.DEVICE_CLASS.EQ.0) CALL SMGL_GET_TERMINAL_SETTINGSe  - 	SMGL_SET_TERMINAL_WIDTH = CHARBUF.PAGE_WIDTHP  ( 	IF (CHARBUF.PAGE_WIDTH.EQ.WIDTH) RETURN   	CHARBUF.PAGE_WIDTH = WIDTH    	IF (WIDTH.EQ.132) THEN   	    BUFFER = CHAR(27) // '[?3h' 	ELSEs  	    BUFFER = CHAR(27) // '[?3l' 	ENDIF  : 	STATUS = SYS$QIOW(,%VAL(CHAN),%VAL(IO$_WRITEVBLK),IOSB,,,& 	1				       %REF(BUFFER),%VAL(5),,,,)  - 	IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))I  / 	IF (.NOT.IOSB(1)) CALL LIB$STOP(%VAL(IOSB(1)))I  ? *	Don't bother setting characteristics if called at image exit.G  > 	IF (.NOT.ARG_EXIST(%VAL(IARGPTR()),2)) CALL SMGL_SET_TERMINAL   	END: 	SUBROUTINE SMGL_CREATE_TERMINATOR_BITS(STRING,TERMSTRING)   **? *	SUBROUTINE SMGL_CREATE_TERMINATOR_BITS( string , termstring )  *N * D *	Creates a Terminator Mask for specifying a non-standard terminatorD *	set for terminal read QIOs and calls to the SMG$READ_STRING screen *	management routine.  *LD *	Standard VMS read terminators are all ASCII characters with a codeD *	in the range 0 through 31 (decimal) except LF, VT, FF, TAB and BS.D *	The mask which this routine  creates contains these characters, inD *	addition to all characters in character string argument TERMSTRING *	which may have any length. *CD *	The mask is created in character string argument STRING,  which isD *	is assumed to be 16 characters long.   The mask created is a 'longD *	form' mask,  which should be passed to QIO or  SMG$READ_STRING  by
 *	descriptor.  * D *	See the "VAX/VMS I/O User's Reference Manual:  Part I", Figure 8-4? *	and Section 8.4.1.2 for more information on terminator masks.T *.( *	Example:  Make '?' and '!' terminators *e *	    CHARACTER*16 STRINGe3 *	    CALL SMGL_CREATE_TERMINATOR_BITS(STRING,'?!')uA *	    STATUS = SMG$READ_STRING(kb,te,pr,ml,mo,ti,STRING,le,tc,di)A@ *	    STATUS = SYS$QIOW(ef,ch,fu,io,aa,ap,p1,p2,p3,STRING,p5,p6) *c *	.INDEX TERMINAL I/O>>F *o1 *	Alan L. Zirkle     Naval Surface Warfare Centera *			   Code K53t* *	19 May 1985	   Dahlgren, Virginia  22448 *t   	IMPLICIT INTEGER (A-Z)e   	CHARACTER*16 STRING 	CHARACTER*(*) TERMSTRINGN 	b0 	CALL LIB$MOVC5(4,'FFFFE0FF'X,0,16,%REF(STRING))   	DO I=1,LEN(TERMSTRING) ; 	    CALL LIB$INSV(1,ICHAR(TERMSTRING(I:I)),1,%REF(STRING))R 	ENDDO   	END  	SUBROUTINE SCREEN(STRING,VALUE)   **5 *	SUBROUTINE SCREEN( string [ ,value1 ,value2,... ] )	 *  *pD *	Writes a string  to the terminal screen,  performing the following *	translations on the string:F * D *	    *  Everywhere an upside-down question mark appears,  it is re-D *	       placed with an ESCAPE character.  (The upside-down questionD *	       mark is created on  VTxxx  terminals with U.S. keyboards by# *	       entering " COMPOSE ? ? ").  *XD *	    *  Everywhere a cent sign appears, it is replaced by the valueD *	       of the corresponding VALUEn integer argument (which must beD *	       less than  10000),  converted to ASCII.   (The cent sign isD *	       created on VTxxx terminals  with U.S. keyboards by enteringD *	       " COMPOSE C / ").   The VALUEn  arguments do not need to beD *	       present unless this feature is used; if the feature IS usedD *	       and there are fewer VALUEn arguments than cent signs,  this4 *	       routine will abort with status SS$_INSFARG. *ID *	These translations allow you to send screen formatting commands toB *	a VTxxx terminal relatively simply.  For example, the statement: * 0 *		    CALL SCREEN( '[;H[1mHi[m' , 5 , 20 ) *T? *	writes 'Hi' in bold video on line 5, column 20 of the screen.L * D *	By default,  each call to routine SCREEN writes  one record to theD *	file SYS$OUTPUT using an RMS $PUT, with no carriage control on theD *	record.  You can have SCREEN use another file name, or use CR car-D *	cariage control, by calling routine SCREEN_FILE first;  see it forD *	details.   SCREEN_FILE can also be used  to close the file and re-$ *	initialize SCREEN to its defaults. *(D *	You can have SCREEN enter "buffering" mode, where instead of doingD *	a write for each call, it stores the text in a buffer until eitherD *	the buffer is full or the calling program determines that a screenD *	update should take place; see routines SCREEN_START and SCREEN_ENDD *	for more information.   This mode must not be used when writing to	 *	a file.  *s *	.INDEX TERMINAL I/O>>  *C# *	 10 Jul 91	Allow VALUEs above 99.e( *	 11 Jul 91	Implement "buffering" mode. *	 19 Sep 91	Add SCREEN_PUT.  *	 19 Oct 92	Add SCREEN_REPAINT.- *	 27 Oct 92	Allow multiple VALUEn arguments. ? *	 16 Dec 92	In buffering mode, limit size of I/O to 1996 bytesh. *			 to meet limit of SYSGEN parameter MAXBUF. *. * 1 *	Alan L. Zirkle     Naval Surface Warfare Centerw *			   Code K55o* *	28 Jun 1987	   Dahlgren, Virginia  22448 *I   	IMPLICIT NONE  % 	CHARACTER*(*) STRING,FILENAME,BUFFERv 	INTEGER*4 VALUE,CR_FILE   	INCLUDE '($FABDEF)/LIST'1 	INCLUDE '($RABDEF)/LIST'2   	RECORD /FABDEF/ FAB 	RECORD /RABDEF/ RAB  * 	CHARACTER*256 OUTSTRING / 'SYS$OUTPUT:' / 	CHARACTER*4 WORKR/ 	INTEGER*4 OSL / 11 /,ARG_LONGWORD,ARGNO,VALUE_ @ 	INTEGER*4 COL,I,STATUS,SYS$CREATE,SYS$CONNECT,SYS$PUT,SYS$CLOSE 	LOGICAL FIRST_CALL / .TRUE. /@ 	LOGICAL CRFILE / .FALSE. /	! If false, use NONE carriage return 	LOGICAL BUSY / .FALSE. / 0 	LOGICAL QUOTE			! If true, don't process  or 8 	VOLATILE BUSY			! BUSY Prevents problems with AST usage 	LOGICAL ARG_EXIST 	INTEGER*4 IARGPTR 	EXTERNAL SS$_INSFARGR  6 	INTEGER*4 BUFADD /0/, PREV_BUFADD /0/, BUFSIZ, BUFLENH 	INTEGER*4 maxbuf /1996/	! Maximum size of terminal I/O, enforced by VMS   	QUOTE = .FALSE.   1	IF (BUSY) RETURN 	BUSY = .TRUE.   	IF (FIRST_CALL) THEN    	    FAB.FAB$B_BID = FAB$C_BID 	    FAB.FAB$B_BLN = FAB$C_BLN  $ 	    FAB.FAB$L_FNA = %LOC(OUTSTRING) 	    FAB.FAB$B_FNS = OSL 	    FAB.FAB$B_FAC = FAB$M_PUT 	    FAB.FAB$L_FOP = FAB$M_SQO 	    FAB.FAB$B_RFM = FAB$C_VAR  ) 	    IF (CRFILE) FAB.FAB$B_RAT = FAB$M_CR(   	    STATUS = SYS$CREATE(FAB)L4 	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	   	    RAB.RAB$B_BID = RAB$C_BID 	    RAB.RAB$B_BLN = RAB$C_BLN   	    RAB.RAB$L_FAB = %LOC(FAB)   	    STATUS = SYS$CONNECT(RAB)4 	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	   	    FIRST_CALL = .FALSE.    	ENDIF   	OSL = LEN(STRING) 	OUTSTRING(1:OSL) = STRING   	IF (QUOTE) GO TO 30  $ 10	COL = INDEX(OUTSTRING(1:OSL),'')   	IF (COL.NE.0) THENl" 	    OUTSTRING(COL:COL) = CHAR(27)
 	    GO TO 10s 	ENDIF  
 	ARGNO = 1  $ 20	COL = INDEX(OUTSTRING(1:OSL),'')   	IF (COL.NE.0) THEN)   	    ARGNO = ARGNO + 1  J 	    IF (.NOT.ARG_EXIST(%VAL(IARGPTR()),ARGNO)) CALL LIB$STOP(SS$_INSFARG)  3 	    VALUE_ = ARG_LONGWORD(%VAL(IARGPTR()),ARGNO,0)I   	    IF (VALUE_.LT.10) THENC0 		OUTSTRING(COL:COL) = CHAR(VALUE_ + ICHAR('0'))! 	    ELSE IF (VALUE_.LT.100) THENT8 		OUTSTRING(COL:OSL+1) = CHAR(VALUE_/10 + ICHAR('0')) //, 	1			   CHAR(MOD(VALUE_,10) + ICHAR('0')) // 	2					    OUTSTRING(COL+1:OSL)  		OSL = OSL + 1T	 	    ELSEC) 		CALL SYS$FAO('!UL',I,WORK,%VAL(VALUE_))d: 		OUTSTRING(COL:OSL+I-1) = WORK(1:I)//OUTSTRING(COL+1:OSL) 		OSL = OSL + I - 1 
 	    ENDIF  
 	    GO TO 20I   	ENDIF   30	IF (BUFADD.EQ.0) THEN  $ 	    RAB.RAB$L_RBF = %LOC(OUTSTRING) 	    RAB.RAB$W_RSZ = OSL   	    STATUS = SYS$PUT(RAB)4 	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	   	ELSE   # 	    IF (BUFLEN+OSL.GT.BUFSIZ) THENX 		RAB.RAB$L_RBF = BUFADD 		I = BUFLEN 		DO WHILE (I.GT.0)B# 		    RAB.RAB$W_RSZ = MIN(I,maxbuf)S 		    STATUS = SYS$PUT(RAB) 5 		      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	o 		    I = I - maxbuf, 		    RAB.RAB$L_RBF = RAB.RAB$L_RBF + maxbuf 		ENDDOe 		BUFLEN = 0
 	    ENDIF  < 	    CALL LIB$MOVC3(OSL,%REF(OUTSTRING),%VAL(BUFADD+BUFLEN))   	    BUFLEN = BUFLEN + OSL   	ENDIF   	BUSY = .FALSE.  	RETURN,      $ 	ENTRY SCREEN_FILE(FILENAME,CR_FILE)   **1 *	SUBROUTINE SCREEN_FILE( filename [ ,cr_file ] )L *H *LD *	Causes routine SCREEN to  write to a file  other than its default,D *	which is SYS$OUTPUT.  Argument FILENAME must be a character stringD *	containing the desired file name; if the name is blank SCREEN willD *	use its default.   If SCREEN_FILE is called after SCREEN has open-: *	ed its file, the file it currently is using is closed.   * D *	If the optional argument CR_FILE is supplied and is .TRUE., SCREEND *	will use RMS "CR" carriage control attributes for the file; other-B *	wise it will write records with no carriage control information. *ID *	SCREEN_FILE does not actually open any file; the file is opened on& *	the first subsequent call to SCREEN. *	 *	.INDEX TERMINAL I/O>>M *S1 *	Alan L. Zirkle     Naval Surface Warfare CenterR *			   Code K55,* *	28 Jun 1987	   Dahlgren, Virginia  22448 *N   	IF (.NOT.FIRST_CALL) THEN   	    STATUS = SYS$CLOSE(FAB)3 	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))' 	t 	    FIRST_CALL = .TRUE.   	ENDIF	3   	IF (FILENAME.NE.' ') THEN   	    OSL = LEN(FILENAME)  	    OUTSTRING(1:OSL) = FILENAME   	ELSEh  
 	    OSL = 11e% 	    OUTSTRING(1:OSL) = 'SYS$OUTPUT:'e   	ENDIF   	CRFILE = .FALSE.s3 	IF (ARG_EXIST(%VAL(IARGPTR()),2)) CRFILE = CR_FILEw   	RETURNn       	ENTRY SCREEN_START(BUFFER)	   **# *	SUBROUTINE SCREEN_START( buffer )f *e *rD *	Causes routine SCREEN to enter "buffering" mode,  where instead ofD *	performing  an  output  to  the screen every time it is called, itD *	stores the text in a buffer, performing an I/O  only when the buf-D *	fer is full or when routine  SCREEN_END  is called.  One large I/O- *	may be more efficient than many small ones.  *RD *	The caller  must supply the buffer, which must be a CHARACTER var-D *	iable at least 256 characters long.   This routine will abort with0 *	status SS$_INSFARG if the buffer is too small. *.D *	If SCREEN_START is called two times without an intervening call toD *	SCREEN_END,  the  contents of the first buffer are lost.   Calling9 *	SCREEN_END also causes SCREEN to exit "buffering" mode.	 *	 *	.INDEX TERMINAL I/O>>  *d1 *	Alan L. Zirkle     Naval Surface Warfare CenterS *			   Code K55R* *	11 Jul 1991	   Dahlgren, Virginia  22448 *    	BUFADD = %LOC(BUFFER) 	BUFSIZ = LEN(BUFFER)D 	BUFLEN = 0A 	PREV_BUFADD = 0		! 12/16/92  . 	IF (BUFSIZ.LT.256) CALL LIB$STOP(SS$_INSFARG) 	RETURN0       	ENTRY SCREEN_ENDS   ** *	SUBROUTINE SCREEN_ENDW *H *CD *	Causes a buffer full of text, which was created by previous  callsD *	to  routines SCREEN_START and SCREEN, to be written to the screen.D *	If SCREEN_START was not previously called to put routine SCREEN in3 *	"buffering" mode, then this routine does nothing.S *,D *	If it is desired to continue "buffering" mode  after SCREEN_END isD *	called, then SCREEN_START must be called again, since each call to2 *	SCREEN_END causes an exit from "buffering" mode. *	 *	.INDEX TERMINAL I/O>>O *R1 *	Alan L. Zirkle     Naval Surface Warfare Center  *			   Code K55N* *	11 Jul 1991	   Dahlgren, Virginia  22448 *)  3 	IF (BUSY .OR. BUFADD.EQ.0 .OR. BUFLEN.EQ.0) RETURNg   	BUSY = .TRUE. 	RAB.RAB$L_RBF = BUFADDn 	I = BUFLEN    	DO WHILE (I.GT.0)" 	    RAB.RAB$W_RSZ = MIN(I,maxbuf) 	    STATUS = SYS$PUT(RAB)4 	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	 	    I = I - maxbufn+ 	    RAB.RAB$L_RBF = RAB.RAB$L_RBF + maxbuf	 	ENDDO   	PREV_BUFADD = BUFADDl! 	BUFADD = 0		! Turn off buffering	   	BUSY = .FALSE.    	RETURNe       	ENTRY SCREEN_REPAINTs   ** *	SUBROUTINE SCREEN_REPAINTi *h *cD *	Re-displays the preceeding buffer full of text which was displayedD *	by routine SCREEN_END.   This in effect repaints the screen if theD *	text stored  in the buffer  between the calls  to SCREEN_START andD *	SCREEN_END constitute a full screen display, and if the buffer wasD *	large enough.   There is no reason not to use a large buffer (8192 *	bytes or larger).  *	 *	.INDEX TERMINAL I/O>>r *i1 *	Alan L. Zirkle     Naval Surface Warfare Centera *			   Code K55s* *	19 Oct 1992	   Dahlgren, Virginia  22448 *G  8 	IF (BUSY .OR. PREV_BUFADD.EQ.0 .OR. BUFLEN.EQ.0) RETURN   	BUSY = .TRUE. 	RAB.RAB$L_RBF = PREV_BUFADD 	I = BUFLEN=   	DO WHILE (I.GT.0)" 	    RAB.RAB$W_RSZ = MIN(I,maxbuf) 	    STATUS = SYS$PUT(RAB)4 	      IF (.NOT.STATUS) CALL LIB$STOP(%VAL(STATUS))	 	    I = I - maxbufM+ 	    RAB.RAB$L_RBF = RAB.RAB$L_RBF + maxbufI 	ENDDO   	BUSY = .FALSE.C   	RETURN        	ENTRY SCREEN_PUT(STRING)N   **! *	SUBROUTINE SCREEN_PUT( string )% *( *ID *	This routine is almost identical to subroutine  SCREEN.   The onlyD *	difference is that  SCREEN_PUT  does not process the cent sign andD *	upside-down question mark characters specially.  SCREEN_PUT should9 *	be used to write general text which may contain  or .g *	 *	.INDEX TERMINAL I/O>>s * 1 *	Alan L. Zirkle     Naval Surface Warfare Centern *			   Code K55p* *	19 Sep 1991	   Dahlgren, Virginia  22448 *E   	QUOTE = .TRUE.p   	GO TO 1  
 	END									m