!### makefile for Xaw3D shared library

TARGET = XAW3DLIBSHR
TARGET1 = XAW3D_CLIENT
TARGET_TYPE = shared library

CC_DEFINES = /DEF=(VMS,ARROW_SCROLLBAR)

.ifdef __DECC__
CC_QUALIFIER = /NODEB/EXT=COMM/SHARE/PREF=ALL
.endif

.ifdef __VAXC__
CC_QUALIFIER = /NODEB/OPT=(D,I)
.endif

.include X11_ROOT:[COMMAND]X11_RULES.MMS

!### Objects ###################################################################

OBJS1 =\
ALLWIDGETS.$(OBJ_EXT),\
ASCIISINK.$(OBJ_EXT),\
ASCIISRC.$(OBJ_EXT),\
ASCIITEXT.$(OBJ_EXT),\
BOX.$(OBJ_EXT)

OBJS2 =\
COMMAND.$(OBJ_EXT),\
DIALOG.$(OBJ_EXT),\
FORM.$(OBJ_EXT),\
GRIP.$(OBJ_EXT),\
LABEL.$(OBJ_EXT)

OBJS3 =\
LIST.$(OBJ_EXT),\
MENUBUTTON.$(OBJ_EXT),\
PANED.$(OBJ_EXT),\
PANNER.$(OBJ_EXT),\
PORTHOLE.$(OBJ_EXT)

OBJS4 =\
REPEATER.$(OBJ_EXT),\
SCROLLBAR.$(OBJ_EXT),\
SIMPLE.$(OBJ_EXT),\
SIMPLEMENU.$(OBJ_EXT),\
SME.$(OBJ_EXT)

OBJS5 =\
SMEBSB.$(OBJ_EXT),\
SMELINE.$(OBJ_EXT),\
SMETHREED.$(OBJ_EXT),\
STRIPCHART.$(OBJ_EXT),\
TEXT.$(OBJ_EXT)

OBJS6 =\
TEXTACTION.$(OBJ_EXT),\
TEXTPOP.$(OBJ_EXT),\
TEXTSINK.$(OBJ_EXT),\
TEXTSRC.$(OBJ_EXT),\
TEXTTR.$(OBJ_EXT)

OBJS7 =\
THREED.$(OBJ_EXT),\
TOGGLE.$(OBJ_EXT),\
TREE.$(OBJ_EXT),\
VIEWPORT.$(OBJ_EXT),\
XAWINIT.$(OBJ_EXT)

OBJS8 =\
LAYOUT.$(OBJ_EXT),\
FORM3D.$(OBJ_EXT)

! The following widgets have been excluded
! You may include them but you should edit ALLWIDGETS.C then.

! CLOCK.$(OBJ_EXT),\
! LOGO.$(OBJ_EXT),\
! MAILBOX.$(OBJ_EXT),\

!### Targets ##################################################################

DEFAULT   :   $(TARGET).$(EXE_EXT)
   @  write_ sys$output ""
   @  write_ sys$output "  $(TARGET).$(EXE_EXT), $(TARGET1).$(OPT_EXT) available"
   @  write_ sys$output ""

.ifdef __vax__
OPTION_FILES =\
  $(TARGET).$(OPT_EXT)/OPT,\
  $(TARGET).UNIVERSAL/OPT,\
  $(TARGET).PSECT/OPT
PSECT_EXT = PSECT
.endif

.ifdef __alpha__
OPTION_FILES =\
  $(TARGET).$(OPT_EXT)/OPT,\
  $(TARGET).UNIVERSAL$(ALPHA_EXT)/OPT,\
  $(TARGET).UNIVERSAL_PSECT$(ALPHA_EXT)/OPT,\
  $(TARGET).PSECT$(ALPHA_EXT)/OPT
PSECT_EXT = PSECT$(ALPHA_EXT)
.endif

$(TARGET).$(EXE_EXT) :  $(OBJS1), $(OBJS2), $(OBJS3), $(OBJS4), $(OBJS5),\
			$(OBJS6), $(OBJS7), $(OBJS8)
  @ WRITE_ SYS$OUTPUT "  generating $(TARGET).$(OPT_EXT)"  
  @ OPEN_/WRITE FILE  $(TARGET).$(OPT_EXT)
  @ WRITE_ FILE "!" 
  @ WRITE_ FILE "! ### $(TARGET).$(OPT_EXT) generated by DESCRIP.MMS"
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "$(OBJS1)"
  @ WRITE_ FILE "$(OBJS2)"
  @ WRITE_ FILE "$(OBJS3)"
  @ WRITE_ FILE "$(OBJS4)"
  @ WRITE_ FILE "$(OBJS5)"
  @ WRITE_ FILE "$(OBJS6)"
  @ WRITE_ FILE "$(OBJS7)"
  @ WRITE_ FILE "$(OBJS8)"
  @ CLOSE_ FILE
  @ APPEND_/NOLOG XMU_DIRECTORY:XMULIBSHR.$(PSECT_EXT) $(TARGET).$(OPT_EXT)
  @ OPEN_/APPEND FILE  $(TARGET).$(OPT_EXT)
  @ WRITE_ FILE "!" 
  @ WRITE_ FILE "! ### Shareable Images:"
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "$(RTL_LIBRARY)"
  @ WRITE_ FILE "DECW$XEXTLIBSHR/SHARE"
  @ WRITE_ FILE "DECW$XLIBSHR/SHARE"
  @ $(IF_R4) WRITE_ FILE "DECW$XTSHR/SHARE"
  @ $(IF_R5) WRITE_ FILE "DECW$XTLIBSHRR5/SHARE"
  @ WRITE_ FILE "XMULIBSHR/SHARE"   
  @ CLOSE_ FILE       
  @ WRITE_ SYS$OUTPUT "  generating $(TARGET).$(MAP_EXT) ..."
  @ LINK_/NODEB/NOSHARE/NOEXE/MAP=$(TARGET).$(MAP_EXT)/FULL -
    $(TARGET).$(OPT_EXT)/OPT
  @ WRITE_ SYS$OUTPUT "  analyzing Map ..."
  @ @X11_LIBRARY:ANALYZE_MAP $(TARGET).$(MAP_EXT) QUIET
  @ WRITE_ SYS$OUTPUT "  generating $(TARGET1).$(OPT_EXT)"
  @ OPEN_/WRITE FILE $(TARGET1).$(OPT_EXT)
  @ WRITE_ FILE "!" 
  @ WRITE_ FILE "! ### $(TARGET1).$(OPT_EXT) generated by DESCRIP.MMS"
  @ WRITE_ FILE "!"
  @ CLOSE_ FILE
  @ APPEND_/NOLOG XMU_DIRECTORY:XMULIBSHR.$(PSECT_EXT) $(TARGET1).$(OPT_EXT)
  @ APPEND_/NOLOG $(TARGET).$(PSECT_EXT) $(TARGET1).$(OPT_EXT)
  @ OPEN_/APPEND FILE $(TARGET1).$(OPT_EXT)
  @ WRITE_ FILE "!" 
  @ WRITE_ FILE "! ### Shareable Images:"
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "$(RTL_LIBRARY)"
  @ WRITE_ FILE "DECW$XEXTLIBSHR/SHARE"
  @ WRITE_ FILE "DECW$XLIBSHR/SHARE"
  @ $(IF_R4) WRITE_ FILE "DECW$XTSHR/SHARE"
  @ $(IF_R5) WRITE_ FILE "DECW$XTLIBSHRR5/SHARE"
  @ WRITE_ FILE "XMULIBSHR/SHARE"   
  @ WRITE_ FILE "$(TARGET)/SHARE"   
  @ CLOSE_ FILE
  @ WRITE_ SYS$OUTPUT "  linking $(TARGET).$(EXE_EXT)"
  @ LINK_/NODEB/SHARE=$(TARGET).$(EXE_EXT)/MAP=$(TARGET).$(MAP_EXT)/FULL/CROSS -
    $(OPTION_FILES)

