/*
 * note.c
 * Copyright (C) 1995  Johannes Plass
 *   Author: Johannes Plass
 *           Department of Physics
 *           Johannes-Gutenberg University, Mainz, Germany
 * Internet: plass@dipmza.physik.uni-mainz.de
*/

/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/

#include "config.h"

#include <stdio.h>

/*
#define MESSAGES
#define MESSAGE_NO_ESC
*/
#include "message.h"

#ifdef VMS
#   include <X11_DIRECTORY/IntrinsicP.h>
#   include <X11_DIRECTORY/StringDefs.h>
#   include <XAW_DIRECTORY/Command.h>
#   include <XAW_DIRECTORY/Label.h>
#   include <X11_DIRECTORY/Shell.h>
#   ifdef _LAYOUT_LOCAL_
#      include "Layout.h"
#   else
#      include <XAW_DIRECTORY/Layout.h>
#   endif
#else
#   include <X11/IntrinsicP.h>
#   include <X11/StringDefs.h>
#   include <X11/Xaw/Command.h>
#   include <X11/Xaw/Label.h>
#   include <X11/Shell.h>
#endif

#include "popup.h"

#ifndef max
#   define max(a, b)    ((a) > (b) ? (a) : (b))
#endif

/*### Application dependencies ##############################################*/

#define NOTE_TOPLEVEL	toplevel       			/* the Application Shell   */
#define NOTE_POPUP	notepopup
#define NOTE_POPUP_NAME	"notePopup"

#include "gv.h"
#include "note.h"

static Bool notePopupVisible = False;
static Bool notePopupCreated = False;

/*###############################################################################
   cb_popupNotePopup
###############################################################################*/

void cb_popupNotePopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(cb_popupNotePopup)
   if (!notePopupVisible) {
      if (!notePopupCreated) makeNotePopup(); 
      positionPopup(NOTE_POPUP,2,NOTE_TOPLEVEL,50,50, 1,1);
      XtPopup(NOTE_POPUP, XtGrabNone);
      notePopupVisible = True;
   }
   ENDMESSAGE(cb_popupNotePopup)
}      

/*###############################################################################
   cb_popdownNotePopup
###############################################################################*/

void cb_popdownNotePopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(cb_popdownNotePopup)
   if (notePopupVisible) {
      XtPopdown(NOTE_POPUP);
      notePopupVisible = False;
   }
   ENDMESSAGE(cb_popdownNotePopup)
}

/*###############################################################################
   action_handleNotePopup
###############################################################################*/

void 
action_handleNotePopup(top, event, params, num_params)
    Widget top;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    BEGINMESSAGE(action_handleNotePopup)
    if (!params) {
       INFMESSAGE(no parameters)
       ENDMESSAGE(action_handleNotePopup)
       return;
    }
    if (!(strcmp(params[0],"popup"))) {
       cb_popupNotePopup((Widget)NULL,(XtPointer)NULL,NULL);
    } else
    if (!(strcmp(params[0],"popdown"))) {
       cb_popdownNotePopup((Widget)NULL,(XtPointer)NULL,NULL);
    }
    ENDMESSAGE(action_handleNotePopup)
}

/*###############################################################################
   makeNotePopup
###############################################################################*/

void makeNotePopup()
{
   Arg          args[10];
   Cardinal     n;
   Dimension	minw,minh;
   Widget   noteLayout;
   Widget   doneButton;
   Widget   messageLabel;   

   BEGINMESSAGE(makeNotePopup)

							n=0;
        XtSetArg(args[n], XtNallowShellResize, True);	n++;
   NOTE_POPUP = XtCreatePopupShell(NOTE_POPUP_NAME,transientShellWidgetClass,NOTE_TOPLEVEL, args, n);

							n=0;
        XtSetArg(args[n], XtNresizeWidth, True);	n++;
        XtSetArg(args[n], XtNresizeHeight, True);	n++;
        XtSetArg(args[n], XtNconditionedResize, False);	n++;
   noteLayout = XtCreateManagedWidget("noteLayout",layoutWidgetClass,NOTE_POPUP,args,n);

							n=0;
         XtSetArg(args[n], XtNresize, True);		++n;
   messageLabel = XtCreateManagedWidget("message", labelWidgetClass,noteLayout, args, n);

							n=0;
   doneButton = XtCreateManagedWidget("done", commandWidgetClass,noteLayout, args, n);
         XtAddCallback(doneButton, XtNcallback, cb_popdownNotePopup,(XtPointer)NULL);

   XtRealizeWidget(NOTE_POPUP);

						n=0;
   XtSetArg(args[n], XtNminWidth, 100);		++n;
   XtSetArg(args[n], XtNminHeight, 50);		++n;
   XtSetArg(args[n], XtNmaxWidth, XtUnspecifiedShellInt);  ++n;
   XtSetArg(args[n], XtNmaxHeight, XtUnspecifiedShellInt); ++n;
   XtSetValues(NOTE_POPUP, args, n);
                                 
   XSetWMProtocols(XtDisplay(NOTE_POPUP),XtWindow(NOTE_POPUP),&wm_delete_window,1);
   notePopupCreated =True;

   ENDMESSAGE(makeNotePopup)
}

/*###############################################################################
    NotePopupShowMessage
###############################################################################*/

void
NotePopupShowMessage(message)
    String message;
{
    Arg args[5];
    Cardinal n;
    Widget label;

    BEGINMESSAGE(NotePopupShowMessage)
    if (!message) {INFMESSAGE(no message) ENDMESSAGE(NotePopupShowMessage) return;}
    if (!notePopupCreated) makeNotePopup(); 
    label = XtNameToWidget(NOTE_POPUP, "*message");
    n=0;
    XtSetArg(args[n], XtNlabel, message); n++;
    XtSetValues(label, args, n);
    cb_popupNotePopup((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
    ENDMESSAGE(NotePopupShowMessage)
}
