/*
 * config.h
 * Copyright (C) 1995  Johannes Plass
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Johannes Plass
 *           Department of Physics
 *           Johannes Gutenberg University, Mainz, Germany
 *
 * Internet: plass@dipmza.physik.uni-mainz.de
 *
*/

#ifndef _GV_CONFIG_H_
#define _GV_CONFIG_H_

/*
----------------------------------------------------------
Enabling the following option causes ghostscript to be 
restarted whenever a new page should be displayed but
gv-vms thinks that the interpreter is busy. This may solve
some problems that may occur for some incorrectly
formatted files, but will slow down previewing for many
correct files also. (yes Jim, this option is for you)
----------------------------------------------------------
*/

/* #define GV_RESTART_IF_BUSY */

/*
##########################################################
##########################################################
  Private Declarations
##########################################################
##########################################################
*/

/*
----------------------------------------------------------
Where to find the message file in case the resources do
not provide its location.
----------------------------------------------------------
*/

#define GV_DEFAULT_MESSAGE_FILE "X11_ROOT:[DEFAULTS]GV_MESSAGE.DAT"

/*
----------------------------------------------------------
Whether you want to use the Xaw3D widget set.
----------------------------------------------------------
*/

#define USE_XAW3D

/*
----------------------------------------------------------
Whether you want to use the FORM3D widget to get frames on
some widgets. Needs USE_XAW3D.
----------------------------------------------------------
*/

#define USE_FORM3D

/*
----------------------------------------------------------
Whether to show the compile date as partof the window
title.
----------------------------------------------------------
*/

/*#define SHOW_COMPILE_DATE*/

#define	GV_MAX_FILENAME_LENGTH		256

#ifdef VMS
#   define GV_APPLICATION_NAME		"GhostView-VMS"
#   define GV_CLASS			"GV"
#endif

/*
----------------------------------------------------------
Miscellaneous defaults
----------------------------------------------------------
*/
#define GV_ERROR_PRINT_FAIL	"'%s' Command failed."
#define GV_PRINT_MESSAGE	"Print Command:"
#define GV_PRINT_MARKED_MESSAGE	"Print Marked Pages"
#define GV_PRINT_PAGE_MESSAGE	"Print Current Page"
#define GV_PRINT_ALL_MESSAGE	"Print Document"
#define GV_PRINT_BUTTON_LABEL	"Print"
#define GV_ERROR_OPEN_FAIL	"Cannot open file"
#define GV_OPEN_MESSAGE		"Open"
#define GV_ERROR_SAVE_FAIL	"Cannot write to file"
#define GV_SAVE_MESSAGE		"Save"
#define GV_AUTO_RESIZE_YES	"  Resize  "
#define GV_AUTO_RESIZE_NO	"Fixed Size"
#define GV_DOCUMENT_MENU_NAME	"documentMenu"
#define GV_LABEL_MENU_NAME	"labelMenu"
#define MAX_LOCATOR_LENGTH	48
#define GV_MINIMUM_SIZE         150
#define TOC3D_INITIAL_HEIGHT	30
#define TOC3D_INITIAL_WIDTH	10

/*
----------------------------------------------------------
Where to find some widget code.
----------------------------------------------------------
*/

/* #define _LAYOUT_LOCAL_ */
#define _FILESEL_LOCAL_
/* #define _FORM3D_LOCAL_ */

/*
----------------------------------------------------------
Might be activated again in some future version.
----------------------------------------------------------
*/

/* #define USE_SWAP_LANDSCAPE */
/* #define FALLBACK_RESOURCES "app-defaults.h"*/

#endif /* _GV_CONFIG_H_ */
