$! X11 setup command file
$! Copyright (C) 1995, Johannes Plass, dipmza@phsyik.uni-mainz.de
$!
$  x11_release = "(02/95)"
$!
$! Parameters:	NOLOG	- suppress messages
$!		COMPILE	- define XMMK as foreign command
$!				 IF_X11R5,IF_X11R4 as X11 Release indicators
$!				 UTILITY programs like AD2C etc.
$!		DISTRIB - exclude certain definitions ...
$!		DECC=CC/DECC - indicates the use of DECC with CC/DECC as compiler command
$!		VAXC=CC/VAXC - indicates the use of VAXC with CC/VAXC as compiler command
$!		DECC=CC      - indicates the use of DECC with CC      as compiler command
$!		VAXC=CC      - indicates the use of VAXC with CC      as compiler command
$
$  set on
$  on control_y    then goto   emergency_exit
$  on warning      then goto   emergency_exit
$
$  d		:= define_/process/nolog
$  d_tc		:= define_/process/nolog/trans=conc
$
$  X11_PARAM 	=  F$EDIT("''P1',''P2',''P3',''P4',''P5',''P6',''P7',''P8'","UPCASE,COLLAPSE")
$  X11_SAY	= "WRITE_ SYS$OUTPUT"
$  X11_END_MESSAGE = "Runtime Setup Done"
$
$  IF X11_PARAM - "NOLOG" .NES. X11_PARAM THEN X11_SAY = "! "+X11_SAY
$
$  IF_NOT_DIST	= ""
$  if X11_PARAM - "DISTRIB"  .NES. X11_PARAM THEN IF_NOT_DIST="! Excluded"
$  IF_DIST	= ""
$  'IF_NOT_DIST	  IF_DIST = "! Excluded"
$
$  temp		= f$environment("PROCEDURE")
$  tempname	= f$parse(temp,,,"NAME")+f$parse(temp,,,"TYPE")+f$parse(temp,,,"VERSION")
$  X11_ROOT	= F$PARSE(temp,,,,"NO_CONCEAL")-"]["-tempname-".COMMAND]"
$
$!### BASIC DEFINITIONS
$
$  ARCHITECTURE	=	F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE")
$  IF_VAX	=	"! VAX" - "! ''ARCHITECTURE'"
$  IF_ALPHA	=	"! ALPHA" - "! ''ARCHITECTURE'"
$
$ 'X11_SAY "[1m  X11 Setup[m ''x11_release': Executing ..."
$
$!### BASIC X11 LOGICALS
$
$		D_TC	X11_ROOT  		'X11_ROOT.]
$		D	BITMAP_DIRECTORY	X11_ROOT:[BITMAPS]
$  'IF_VAX	D	X11_LIBRARY		X11_ROOT:[EXE]
$  'IF_ALPHA	D	X11_LIBRARY		X11_ROOT:[EXE_ALPHA]
$  
$!### redefining DECW$USER_DEFAULTS
$
$ table = f$trnlnm("DECW$USER_DEFAULTS",,,,,"TABLE_NAME")
$ if table .eqs. "" then table = "LNM$PROCESS_TABLE"
$ defaults = "_???_"
$ i = 0
$ repeat_trn:
$    trn = f$trnlnm("DECW$USER_DEFAULTS",table,i)
$    defaults = defaults + "," + trn
$    i = i+1
$    if trn .nes. "" then goto repeat_trn
$
$ x11_defaults = "X11_ROOT:[DEFAULTS]"
$ if defaults-x11_defaults .eqs. defaults
$ then
$    defaults = defaults + x11_defaults - "_???_,"
$    D  DECW$USER_DEFAULTS 'defaults
$ endif
$
$!### X11 SOFTWARE 
$
$!### XMU/XAW3D LIBRARIES
$
$		D	XAW3DLIBSHR		X11_LIBRARY:XAW3DLIBSHR.EXE
$		D	XMULIBSHR		X11_LIBRARY:XMULIBSHR.EXE
$
$!### GHOSTSCRIPT
$
$ 'IF_NOT_DIST	D	GS_LIB			'X11_ROOT.GS.SYS],'X11_ROOT.GS.FONTS]
$ 'IF_NOT_DIST		GS	:==		$X11_LIBRARY:GS
$
$!### GHOSTVIEW
$
$			GV	:==		$X11_LIBRARY:GV
$
$!### MOSAIC
$
$ 'IF_NOT_DIST		MOSAIC	:==		$X11_LIBRARY:MOSAIC
$! first index of MOSAIC_HOME must be of form device:[dir] to use the annotation facility
$ 'IF_NOT_DIST		D MOSAIC_HOME		'F$TRNLNM("DECW$USER_DEFAULTS")', -
						DECW$USER_DEFAULTS:
$
$!### XDVI
$
$ 'IF_NOT_DIST	D 	XDVIFONTS		"TEX_PK_LN03:[%d]%f.%p/TEX_USER_PK_LN03:[%d]%f.%p"
$ 'IF_NOT_DIST	D 	XDVISIZES		"150/180/210/240/270/300/329/360/432/518/622/746"
$ 'IF_NOT_DIST		XDVI	:==		$X11_LIBRARY:XDVI
$
$!### XFIG
$
$		D	XFIGLIBDIR		'X11_ROOT.DATA]
$			XFIG	:==		$X11_LIBRARY:XFIG
$			FIG2DEV	:==		$X11_LIBRARY:FIG2DEV
$			! XFIG_PS_PRINT :==	PRINT/DELETE/QUEUE=my_ps_queue
$!### XRN
$
$ 'IF_NOT_DIST		XRN :==			$X11_LIBRARY:MXRN
$
$!### XV
$
$ 'IF_NOT_DIST		BGGEN :==		$X11_LIBRARY:BGGEN
$ 'IF_NOT_DIST		DECOMPRESS :==		$X11_LIBRARY:DECOMPRESS
$ 'IF_NOT_DIST		VDCOMP :==		$X11_LIBRARY:VDCOMP
$ 'IF_NOT_DIST		XCMAP :==		$X11_LIBRARY:XCMAP
$ 'IF_NOT_DIST		XV :==			$X11_LIBRARY:XV
$
$!### SET DISPLAY UTILITY
$
$ 'IF_NOT_DIST		SET_DISPLAY :==		@X11_ROOT:[COMMAND]SET_DISPLAY
$
$!##########################################################################
$!### Compile Time Definitions
$!##########################################################################
$
$ IF X11_PARAM - "COMPILE" .nes. X11_PARAM
$ THEN
$		D	X11_DIRECTORY		DECW$INCLUDE
$		D	XAW_DIRECTORY		X11_ROOT:[XAW3D]
$		D	XMU_DIRECTORY		X11_ROOT:[XMU]
$		D	X11R4_VMS_DIRECTORY	X11_ROOT:[X11R4_VMS]
$
$    IF F$SEARCH("SYS$SHARE:DECW$XTLIBSHRR5.EXE") .NES. ""
$    THEN
$       IF_X11R5 == ""
$       IF_X11R4 == "!"
$    ELSE
$       IF_X11R5 == "!"
$       IF_X11R4 == ""
$    ENDIF
$
$    CC_COMPILER=""
$    if X11_PARAM-"VAXC=CC"	 .nes. X11_PARAM then CC_COMPILER:=__VAXC__=CC
$    if X11_PARAM-"DECC=CC"	 .nes. X11_PARAM then CC_COMPILER:=__DECC__=CC
$    if X11_PARAM-"VAXC=CC/VAXC" .nes. X11_PARAM then CC_COMPILER:=__VAXC__=CC/VAXC
$    if X11_PARAM-"DECC=CC/DECC" .nes. X11_PARAM then CC_COMPILER:=__DECC__=CC/DECC
$    IF "''CC_COMPILER'" .eqs. ""
$    THEN
$       'IF_VAX   CC_COMPILER := __VAXC__=CC
$       'IF_ALPHA CC_COMPILER := __DECC__=CC
$    ENDIF
$
$    IF "''MMK'" .nes. ""
$    THEN
$      'IF_X11R5		XMMK :== 'MMK'/MAC=("""''CC_COMPILER'""",X11R5=1)
$      'IF_X11R4		XMMK :== 'MMK'/MAC=("""''CC_COMPILER'""",X11R4=1)
$    ELSE
$      'IF_VAX 'IF_X11R5	XMMK :== MMS/MAC=(__VAX__=1,"""''CC_COMPILER'""",X11R5=1)
$      'IF_VAX 'IF_X11R4	XMMK :== MMS/MAC=(__VAX__=1,"""''CC_COMPILER'""",X11R4=1)
$      'IF_ALPHA 'IF_X11R5	XMMK :== MMS/MAC=(__ALPHA__=1,"""''CC_COMPILER'""",X11R5=1)
$      'IF_ALPHA 'IF_X11R4	XMMK :== MMS/MAC=(__ALPHA__=1,"""''CC_COMPILER'""",X11R4=1)
$    ENDIF
$
$ 'IF_NOT_DIST		PATHPATCH :==		$X11_LIBRARY:PATHPATCH
$ 'IF_NOT_DIST		TRIM :==		$X11_LIBRARY:TRIM
$ 'IF_NOT_DIST		AD2C :==		$X11_LIBRARY:AD2C
$ 'IF_NOT_DIST		XMAKE :==		@X11_ROOT:[COMMAND]XMAKE
$ 'IF_DIST		XMAKE :==		@X11_ROOT:[COMMAND]XMAKE DISTRIB
$
$ X11_END_MESSAGE="Compile Setup Done"
$
$ ENDIF
$
$!### EXIT
$
$  'X11_SAY "M[2K[1m  X11 Setup[m ''x11_release': ''X11_END_MESSAGE'"
$  EXIT_
$
$EMERGENCY_EXIT:
$  EXIT_ 
