/*
 * popup.c
 * Copyright (C) 1995  Johannes Plass
 *   Author: Johannes Plass
 *           Department of Physics
 *           Johannes-Gutenberg University, Mainz, Germany
 * Internet: plass@dipmza.physik.uni-mainz.de
*/

/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/

#include "config.h"

#include <stdio.h>

/*
#define MESSAGES
#define MESSAGE_NO_ESC
*/
#include "message.h"

#ifdef VMS
#   include <X11_DIRECTORY/IntrinsicP.h>
#   include <X11_DIRECTORY/StringDefs.h>
#   include <X11_DIRECTORY/Shell.h>
#else
#   include <X11/Intrinsic.h>
#   include <X11/StringDefs.h>
#   include <X11/Shell.h>
#endif     

/*##################################################################*/
/* cb_popdownPopup Callback */
/*##################################################################*/

void
cb_popdownPopup(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    BEGINMESSAGE(cb_popdownPopup)
    XtPopdown((Widget)client_data);
    ENDMESSAGE(cb_popdownPopup)
}

/*##################################################################*/
/* cb_popupPopup Callback */
/* Popup a window. */
/*##################################################################*/

void
cb_popupPopup(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    BEGINMESSAGE(cb_popupPopup)
    XtPopup((Widget)client_data,XtGrabNone);
    XRaiseWindow(XtDisplay((Widget)client_data), XtWindow((Widget)client_data));
    ENDMESSAGE(cb_popupPopup)
}

/*#################################################################################################
   positionPopup(w, from, fromWidget, x, y, hJust, vJust)
   set the position of a popup window. 
   w     is the popup widget.
   from  takes the values:
             POS_none 
             POS_pointer 
             POS_appPanel 
             POS_screen
   fromWidget is the shell widget to position relative to (for POS_appPanel)
   x, y  are integer percent values for a point of the appPanel or screen
   hJust/vJust are {0, 1, 2} for left/top, center, right/bottom justification
    of the popup against the point x, y.
#################################################################################################*/

#define POS_none        0
#define POS_pointer     1
#define POS_appPanel    2
#define POS_screen      3

#include <stdio.h>
#include "message.h"

void
positionPopup(w, from, fromWidget, x, y, hJust, vJust)  
   Widget w;
   int from;
   Widget fromWidget;
   int x, y;
   int hJust, vJust;
{
   Arg args[5];
   Cardinal n;
   Position rootX, rootY;
   Dimension popupWidth, popupHeight;
   Dimension screenWidth, screenHeight;

   BEGINMESSAGE(positionPopup)
   
   if ( (w == NULL) || (from == POS_none)) {
      INFMESSAGE(aborting)
      ENDMESSAGE(positionPopup)
      return;
   }
   screenWidth =  XtScreen(w)->width;
   screenHeight = XtScreen(w)->height;

   switch (from) {                                            /* find a reference point */
      case POS_pointer: {
           Window        root, child;
           int           ptrX, ptrY, winX, winY;
           unsigned int  keysButtons;

           INFMESSAGE(POS_pointer)
           XQueryPointer(XtDisplay(w), XtWindow(w),
                         &root, &child, &ptrX, &ptrY, &winX, &winY,
                         &keysButtons);
           rootX = (Position) ptrX;
           rootY = (Position) ptrY;
      }
      break;

      case POS_appPanel: {
           Dimension     panelWidth, panelHeight;
           Position      relX, relY;
           INFMESSAGE(POS_appPanel)

           n=0;
           XtSetArg(args[n], XtNwidth, &panelWidth);  n++;
           XtSetArg(args[n], XtNheight, &panelHeight);  n++;
           XtGetValues(fromWidget, args, n);
           relX = panelWidth * x / 100;
           relY = panelHeight * y / 100;
           XtTranslateCoords(fromWidget, relX, relY, &rootX, &rootY);
      }
      break;

      case POS_screen: {
           INFMESSAGE(POS_screen)
           rootX = screenWidth * x / 100;
           rootY = screenHeight * y / 100;
      }
      break;
   }
   						n=0;
   XtSetArg(args[n], XtNwidth, &popupWidth);    n++;
   XtSetArg(args[n], XtNheight, &popupHeight);  n++;
   XtGetValues(w, args, n);

   if (hJust == 1)      rootX -= popupWidth / 2;
   else if (hJust == 2) rootX -= popupWidth;

   if (vJust == 1)      rootY -= popupHeight / 2;
   else if (vJust == 2) rootY -= popupHeight;
 
   if (rootX < 0)                               rootX = 0;
   else if (rootX + popupWidth > screenWidth)   rootX = screenWidth - popupWidth;

   if (rootY < 0)                               rootY = 0;
   else if (rootY + popupHeight > screenHeight) rootY = screenHeight - popupHeight;

   IIMESSAGE(rootX,rootY)

   n = 0;
   XtSetArg(args[n], XtNx, rootX); n++;
   XtSetArg(args[n], XtNy, rootY); n++;
   XtSetValues(w, args, n);

   ENDMESSAGE(positionPopup)
   return;
}
