/*
 * Copyright (C) 1995  Johannes Plass
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Johannes Plass
 *           Department of Physics
 *           Johannes Gutenberg University, Mainz, Germany
 *
 * Internet: plass@dipmza.physik.uni-mainz.de
 *
 */  


#ifndef _XawFileSelectionP_h
#define _XawFileSelectionP_h

#ifdef VMS
#   include <XAW_DIRECTORY/Viewport.h>
#   include <XAW_DIRECTORY/ListP.h>
#   include <XAW_DIRECTORY/Command.h>
#   include <XAW_DIRECTORY/AsciiText.h>
#   include <XAW_DIRECTORY/Grip.h>
#   include <XAW_DIRECTORY/Paned.h>
#   include <XAW_DIRECTORY/Form.h>
#   if defined(USE_XAW3D) &&  defined(USE_FORM3D)
#      ifdef _FORM3D_LOCAL_
#         include "Form3d.h"
#      else
#         include <XAW_DIRECTORY/Form3d.h>
#      endif
#   endif
#   ifdef _LAYOUT_LOCAL_
#      include "LayoutP.h"
#   else
#      include <XAW_DIRECTORY/LayoutP.h>
#   endif
#   include "vms_dirent.h"
#else
#   include <X11/Xaw/Viewport.h>
#   include <X11/Xaw/ListP.h>
#   include <X11/Xaw/Command.h>
#   include <X11/Xaw/AsciiText.h>
#   include <X11/Xaw/Paned.h>
#   include <X11/Xaw/Grip.h>
#   include <X11/Xaw/Form.h>
#   if defined(USE_XAW3D) &&  defined(USE_FORM3D)
#      ifdef _FORM3D_LOCAL_
#         include "Form3d.h"
#      else
#         include <X11/Xaw/Form3d.h>
#      endif
#   endif
#   include <X11/Xaw/Layoutp.h>
#   include <sys/dirent.h>
#endif

#include "FileSel.h"

/*####################################################################
   Private Delarations
####################################################################*/

typedef struct {
	String	*entry;
	int	num_of_entries;
} FSDir;

/* New fields for the Layout widget class record */

typedef struct _FileSelectionClassPart {
    int foo;			/* keep compiler happy. */
} FileSelectionClassPart;

/* New Fields for the FileSelection widget record */

typedef struct {
    /* resources */
    Pixel	highlightPixel;
    String      path;
    String      file;
    int		view_mode;
    String	view_order;
    int         buttons;
    int		preferredButton;    
    /* private data */
    Widget	pathformFS;
    Widget	pathFS;
    Widget	fileformFS;
    Widget	fileFS;
    Widget	rescanFS;
    Widget	filterFS;
    Widget	panedFS;
    Widget	topformFS;
    Widget	topviewFS;
    Widget	toplistFS;
    Widget	curformFS;
    Widget	curviewFS;
    Widget	curlistFS;
    Widget	subformFS;
    Widget	subviewFS;
    Widget	sublistFS;
    Widget	button1FS;
    Widget	button2FS;
    Widget	button3FS;
    Widget	button4FS;
    FSDir       topdir;
    int         topdir_alloc;
    FSDir       curdir;
    int         curdir_alloc;
    FSDir       subdir;
    int         subdir_alloc;
    String      app_dir;
    String      both;
    String      current_dir;
    String      path_field_value;
    String      file_field_value;    
    int         internal_buttons;    
    unsigned long multiclick;
    Pixel	old_highlightPixel;
} FileSelectionPart;

typedef struct _FileSelectionClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    LayoutClassPart     layout_class;
    FileSelectionClassPart   file_selection_class;
} FileSelectionClassRec;

extern FileSelectionClassRec file_selectionClassRec;

/**************************************************************************
 *
 * Full instance record declaration
 *
 **************************************************************************/

typedef struct {int empty;} FileSelectionConstraintsPart;

typedef struct _FileSelectionConstraintsRec {
    SubInfoRec	layout;
    FileSelectionConstraintsPart file_selection;
} FileSelectionConstraintsRec, *FileSelectionConstraints;

typedef struct _FileSelectionRec {
    CorePart       core;
    CompositePart  composite;
    ConstraintPart constraint;
    LayoutPart     layout;
    FileSelectionPart file_selection;
} FileSelectionRec;

#endif /* _XawFileSelectionP_h */
