/*
 * error.c
 * Copyright (C) 1995  Johannes Plass
 *   Author: Johannes Plass
 *           Department of Physics
 *           Johannes-Gutenberg University, Mainz, Germany
 * Internet: plass@dipmza.physik.uni-mainz.de
*/

/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

/*
#define MESSAGES
#define MESSAGE_NO_ESC
*/
#include "message.h"

#ifdef VMS
#   include <X11_DIRECTORY/Xos.h>
#   include <X11_DIRECTORY/Intrinsic.h>
#else
#   include <X11/Xos.h>
#   include <X11/Intrinsic.h>
#endif

#include "gv.h"

#ifdef VMS
#   include <errno.h>
#   include <perror.h>
#   include <string.h>
#   ifdef __DECC
#      ifndef __ERRNO_MAX /*###jp### __ERRNO_MAX is undefined in lower versions of DEC C */
#         define __ERRNO_MAX 85
#      endif
#   endif
#else
    extern int sys_nerr;
    extern char *sys_errlist[];
#   include <errno.h>
    /* BSD 4.3 errno.h does not declare errno */
    extern int errno;
#endif

char* open_fail_error(errornumber,error_str,file_name,show)
int errornumber;
char *error_str;
char *file_name;
Boolean show;
{
   char buf[1024];

   BEGINMESSAGE(open_fail_error_message)
#  ifdef __DECC
      if (errornumber < __ERRNO_MAX) {
         if (show) sprintf(buf,"  %s: %s %s, %s\n",gv_application_name,error_str,file_name,strerror(errornumber));
         else      sprintf(buf,"%s %s: %s",error_str,file_name,strerror(errornumber));
      } else {
	 if (show) sprintf(buf,"  %s: %s %s\n",gv_application_name,error_str,file_name);
	 else      sprintf(buf,"%s %s",error_str,file_name);
      }
#  else
      if (errornumber <= sys_nerr) {
	 if (show) sprintf(buf,"  %s: %s %s, %s\n",gv_application_name,error_str,file_name,sys_errlist[errornumber]);
	 else      sprintf(buf,"%s %s: %s",error_str,file_name,sys_errlist[errornumber]);
      } else {
	 if (show) sprintf(buf,"  %s: %s %s\n",gv_application_name,error_str,file_name);
	 else      sprintf(buf,"%s %s",error_str,file_name);
      }
#  endif

   ENDMESSAGE(open_fail_error_message)
   if (show) { fprintf(stderr,buf); return NULL;             }
   else      {                      return XtNewString(buf); }
}

