( $! UPDATE_SAVI.COM	Install a SAVI update $!I $! This command procedure is run to install an update to the SAVI engine.  $!K $! P1 = Location of VSWEEP.ZIP kit supplied by Sophos (will be prompted for % $!      if not specified by the user) % $! P2 = SAVI data version e.g. "4.35"  $! $! SAVI is updated as follows: $!G $! 1.  A new directory is created to hold the SAVI engine and IDE files > $! 2.  The VSWEEP.ZIP file is UNZIPped into the new directory.F $! 3.  The procedure will attempt to determine the SAVI release numberF $!     by checking the files supplied in the kit.  Any value specifiedE $!     in parameter P2 will be compared to the determined version and 8 $!     an alert will be issued if there is a difference.; $! 4.  The IDEs for this update are downloaded and checked. ? $! 5.  A control file is updated and logical names are defined.  $!H $! The procedure can be run interactively or in batch.  If run in batch,L $! P1 *must* be spsecified and P2 should be specified.  If run interactivelyL $! the user will be prompted for missing information and to confirm the SAVI $! version.  $!D $!	Created 3-Jan-2008 by Jeremy Begg, VSM Software Services Pty Ltd.J $!	Copyright (c) 2008 VSM Software Services Pty Ltd.  All Rights Reserved.E $!	Permission is granted to freely use this and modify this procedure J $!	provided that this copyright notice remains intact, and that you notifyJ $!	the original author (jeremy@vsm.com.au) if you judge your modifications  $! 	to be of interest to others. $! $! Modifications $! -------------$ $!  3-Jan-2008	J.Begg		First version $!P $!****************************************************************************** $ 
 $	set noon $  $	create		= "create", $	interactive	= f$mode() .eqs. "INTERACTIVE"( $	old_default	= f$environment("DEFAULT") $	say		= "write sys$output" ) $	newdir		= f$fao("SAVI_!AS", f$unique())  $	savi_data_version = ""/ $	user		= f$edit(f$getjpi(0,"USERNAME"),"TRIM")  $ / $	control_file		= "SOPHOS_COM:SAVI_VERSION.DAT"  $	control_file_open	= "FALSE"  $  $	readme_file		= "RELNOTES.TXT"  $	readme_file_open	= "FALSE" $ P $!------------------------------------------------------------------------------) $! Determine the location of the SAVI kit  $!+ $	kit_location = f$edit(p1,"TRIM,COLLAPSE") 9 $	if kit_location .nes. "" then $ goto Check_Kit_Location  $	if .not. interactive $	thenV $	    say "%SOPHOS-F-KITLOC, location of Sophos kit must be specified in parameter P1"# $	    exit %X10000114	! SS$_INSFARG  $	endif  $Get_Kit_Location:f $	read/end=No_Kit/error=No_Kit/prompt="Location of SAVI kit, e.g. DKA400:[OPENVMS] : " sys$command ans, $	kit_location = f$edit(ans,"TRIM,COLLAPSE")7 $	if kit_location .eqs. "" then $ goto Get_Kit_Location  $  $Check_Kit_Location:/ $	kit_file = f$parse(kit_location,"VSWEEP.ZIP")   $	if f$search(kit_file) .eqs. "" $	thenK $	    say "%SOPHOS-F-NOKIT, the SAVI kit ", kit_file, " could not be found" $ $	    exit %X10000014	! SS$_BADPARAM $	endif  $ P $!------------------------------------------------------------------------------. $! Create a new directory for this SAVI update $!" $	set default SOPHOS_ROOT:[000000] $	say ""' $	say "Creating directory for SAVI kit" M $	create/directory/log ['newdir'] /owner=parent /prot=(s:rwe,o:rwe,g:re,w:re) Q $	create/directory/log ['newdir'.AUX] /owner=parent /prot=(s:rwe,o:rwe,g:re,w:re) * $	set security ['newdir']AUX.DIR;1 /acl=(-' 		(identifier=SOPHUPDATE,access=R+W), - < 		(identifier=SOPHUPDATE,options=default,access=R+W+E+D+C) - 		)  $ P $!------------------------------------------------------------------------------, $! UNZIP the SAVI kit into the new directory $! $	set default ['newdir'] $	unzip 'kit_file' $	if .not. $status $	then $	    set default 'old_default' 
 $	    exit 44  $	endif : $	set file/owner=parent/prot=(s:rwed,o:rwed,g:re,w:re) *.* $	set file/prot=w:e *.exe  $ P $!------------------------------------------------------------------------------O $! Attempt to determine the SAVI version.  We search the READMEVMS.TXT file for  $! three lines like this: + $!	Product version                 : 4.24.0 + $!	Threat detection engine version : 2.52.1 8 $!	Threat data version             : 4.24, December 2007 $! $	say "", $	say "Attempting to determine SAVI version"  $	open/read readme 'readme_file' $	if .not. $status $	thenS $	    say "%SOPHOS-F-NOREADME, ", readme_file, " not found or could not be opened!"  $	    say ""P $	    say "The installation procedure is unable to continue because Sophos have"D $	    say "changed the contents of the VSWEEP.ZIP installation kit." $	    say "" $	    set default 'old_default'  $	    exit 44	! SS$_ABORT  $	endif  $	readme_file_open = "TRUE" 	 $Read_Me: 8 $	    read/end=readme_end/error=readme_error readme line $	    say f$fao("!_!AS", line)0 $	    readme_line = f$edit(line,"TRIM,COMPRESS")1 $	    if readme_line .eqs. "" then $ goto Read_Me ; $	    if f$locate("Product version : ", readme_line) .eq. 0 
 $	    thenB $		savi_full_version = f$edit(f$element(1,":",readme_line),"TRIM") $		show sym savi_full_version  $	    endif K $	    if f$locate("Threat detection engine version : ", readme_line) .eq. 0 
 $	    thenD $		savi_engine_version = f$edit(f$element(1,":",readme_line),"TRIM") $		show sym savi_engine_version  $	    endif ? $	    if f$locate("Threat data version : ", readme_line) .eq. 0 
 $	    thenK $		savi_data_version = f$edit(f$element(1,":",readme_line),"TRIM,COLLAPSE")  $		show sym savi_data_version  $	    endif  $	    goto Read_Me $Readme_Error: $	sts = $status  $	msg = f$message(sts) - "%"6 $	say "%SOPHOS-E-READERR, error reading ", readme_file $	say "-", msg $Readme_End: $	close readme $	readme_file_open = "FALSE" $ P $!------------------------------------------------------------------------------ $! See what we found $! $	if savi_data_version .eqs. ""  $	thenW $	    say "%SOPHOS-W-NOVERSION, unable to determine SAVI data version from README file" 4 $	    savi_data_version = f$edit(p2,"TRIM,COLLAPSE"): $	else if (savi_data_version .nes. p2) .and. (p2 .nes. "") $	thenp $	    say "%SOPHOS-W-P2VERS, SAVI version in P2 (", p2, ") does not match README file (", savi_data_version, ")" $	endif  $	endif , $	if interactive then $ goto Confirm_Version $No_Version: $	if savi_data_version .eqs. ""  $	thenW $	    say "%SOPHOS-F-VERSREQD, the SAVI data version must be specified in parameter P2"  $	    set default 'old_default' # $	    exit %X10000114	! SS$_INSFARG  $	endif  $  $Confirm_Version:  $	if savi_data_version .eqs. ""  $	thenJ $	    say "The SAVI version could not be determined from the README file,": $	    say "nor was it specified on the command line (P2)."n $	    read/end=No_Version/error=No_Version/prompt="Please enter SAVI version number (n.nn) : " sys$command ans5 $	    savi_data_version = f$edit(ans,"TRIM,COLLAPSE")  $	    goto Confirm_Version $	else if p2 .nes. ""  $	thenA $	    say "Using SAVI version ", p2, " specified on command line"  $	endif  $	endif  $ P $!------------------------------------------------------------------------------$ $! Get some IDEs for the new version $!= $	savi_IDE_version = f$element(0,",",savi_data_version) - "." - $	if f$type(savi_IDE_version) .nes. "INTEGER"  $	thenT $	    say "%SOPHOS-F-BADVERSION, IDE version ", savi_IDE_version, " not an integer!" $	    set default old_default 
 $	    exit 44  $	endif 6 $	@ sophos_com:update_ides 'savi_IDE_version' "[.AUX]" $	if .not. $status $	thenK $	    say "%SOPHOS-F-IDEFAIL, failed to download IDEs for this SAVI update"  $	    set default 'old_default' 
 $	    exit 44  $	endif  $ P $!------------------------------------------------------------------------------F $! Update the control file and define logical names for the new update $!$ $	if f$search(control_file) .eqs. "" $	thenH $	    say "%SOPHOS-I-NEWCONTROL, creating new SAVI version control file"? $	    create/fdl=SOPHOS_COM:SAVI_VERSION.FDL 'control_file'/log  $	endif # $	open/read/write cf 'control_file'  $	if .not. $status $	then $	    set default 'old_default' 
 $	    exit 44  $	endif  $	control_file_open = "TRUE" $  $	! SAVI_VERSION record V $	call write_record "SAVI_VERSION" "''f$fao("!AS, installed !%D", savi_IDE_version, 0) $ " $	set default SOPHOS_ROOT:[000000]1 $	rename 'newdir'.DIR SAVI_'savi_IDE_version'.DIR B $	define/sys/exec	SOPHOS_EXE	SOPHOS_ROOT:[SAVI_'savi_IDE_version']J $	define/sys/exec VSWEEP_AUX_DIR	SOPHOS_ROOT:[SAVI_'savi_IDE_version'.AUX] $  $Write_Record: Subroutine  $! P1 = key 
 $! P2 = value ) $	record_data = f$fao("!16AS!AS", p1, p2) N $	read/key="''p1'"/index=0/error=Write_Record_new/end=Write_Record_new cf junk $	write/update cf record_data  $	exit $Write_Record_new: $	write cf record_data $	exit $	EndSubroutine  $ P $!------------------------------------------------------------------------------ $! All done  $! $	set default 'old_default' & $	if control_file_open then $ close cf) $	if readme_file_open then $ close readme  $ F $	say "%SOPHOS-S-UPDATED, SAVI updated to version ", savi_data_version $	exit