  J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              ViewFile             %%   \ @  *                %% |          Support.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *A  *     Copyright (C) 2001-2004 Lyle W. West, All Rights Reserved. K  *     Permission is granted to copy and use this program provided [1] this K  *     copyright notice is preserved, and [2] no financial gain is involved K  *     in copying the program.  This program may not be sold as "shareware" J  *     or "public domain" software without the express, written permission  *     of the author.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module Support VERSION   #include  <stdio.h>  #include  <descrip.h>  #include  <fcntl.h>  #include  <iodef.h>  #include  <jpidef.h> #include  <lnmdef.h> #include  <psldef.h>J #include  <rms.h>           /* this is only module doing rms operations */ #include  <ssdef.h>  #include  <starlet.h>  #include  <stdlib.h> #include  <string.h> #include  <types.h>  #include  <unixio.h> #include  <Xm/Xm.h>  #include  <Xm/ArrowB.h>  #include  <Xm/BulletinB.h> #include  <Xm/Command.h> #include  <Xm/DialogS.h> #include  <Xm/Form.h>  #include  <Xm/FileSB.h>  #include  <Xm/Label.h> #include  <Xm/LabelG.h>  #include  <Xm/MainW.h> #include  <Xm/MessageB.h>  #include  <Xm/MenuShell.h> #include  <Xm/PushB.h> #include  <Xm/PushBG.h>  #include  <Xm/RowColumn.h> #include  <Xm/ScrollBar.h> #include  <Xm/ScrolledW.h> #include  <Xm/ScrolledWP.h>  #include  <Xm/SelectioB.h> #include  <Xm/Text.h>  #include  <Xm/TextF.h> #include  "defs.h" #include  "externs.h"   D     /* Declare the rms structures used exclusively in this module */  : struct FAB Fab;                    /* File access block */8 struct NAM Nam;                    /* File name block */< struct XABDAT xabdat;              /* Date and time block */K struct XABFHC xabfhc;              /* The file header characteristic XAB */ 7 struct XABPRO xabpro;              /* Protection XAB */    extern void CloseDlgCB();  extern void InputDlgCB();  extern void NewAscCacheList(); extern void MainWinCB(); extern void OptionMenuCB();     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: AddRecallEntryF  * Description: User clicked on Select from Fileselbox to view a file.G  *              This routine is called to save the selected filespec to H  *              the top of RecallListw. It first checks that this stringJ  *              is not already present in which case it returns to caller.I  *              If list if full it deletest the last item in the list and /  *              places new item at top of list.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void AddRecallEntry()  {      int status;      int position;        char NewItemStr[80];  %     strcpy(NewItemStr, ViewFileSpec); 4     CpStr = XmStringCreateLtoR(NewItemStr, charset);  9         /* see if this filespec already in recall list */        if(NumRecallItems) {6         status = XmListItemExists(RecallListw, CpStr);         if(status) return;     }   1         /* if list is full, delete oldest item */   "     if(NumRecallItems == MAXRCL) {         position = MAXRCL;/         XmListDeletePos(RecallListw, position);      }      else NumRecallItems++;  4         /* insert new item at the top of the list */       position = 1; 0     XmListAddItem(RecallListw, CpStr, position);     XmStringFree(CpStr); }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckFilePath G  * Description: Callback issued as user modifies the filter text window H  *              must verify entered target filepaths. They are passed toI  *              CheckFilePath which parses these pathnames for validity.  H  *              If the path is valid, we return True, else return False.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ " int CheckFilePath(char *InputFile) {      int status; I     char ps_rsa[NAM$C_MAXRSS];      /* parse/search resultant filename */ I     char ps_esa[NAM$C_MAXRSS];      /* parse/search expanded  filename */   -         /* initialize Fab & Nam structures */        Fab = cc$rms_fab; =     Fab.fab$l_fna = InputFile;             /* name of file */ &     Fab.fab$b_fns = strlen(InputFile);J     Fab.fab$l_nam = &Nam;                  /* FAB has an associated NAM */E     Nam = cc$rms_nam;                      /* (currently not used) */ B     Nam.nam$l_esa = &ps_esa;               /* expanded filespec */#     Nam.nam$b_ess = sizeof(ps_esa); C     Nam.nam$l_rsa = &ps_rsa;               /* resultant filespec */ #     Nam.nam$b_rss = sizeof(ps_rsa);            /* perform sys$parse */        status = sys$parse(&Fab); ,     if(status != RMS$_NORMAL) return(False);     status = sys$search(&Fab);,     if(status != RMS$_NORMAL) return(False);     return(True);  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetFileInfo F  * Description: Collect file information regarding the current displayE  *              file and format the output emulating a condensed view H  *              of the DCL 'directory/full' command. This collected infoH  *              is stored in memory for display by the calling function.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetFileInfo()  { 
     int i;     int itemCount;     int rmsstat;     int *poslst;     int poscnt;      short fspeclen;      short fulllen;     short datelen;     short namelen;     char ascuic[32];     char date[24];     char fullfilespec[132];      char nambuf[31];,     char stored[XAB$K_SEMANTICS_MAX_LEN -1];     char titlestr[132]; M     char directive[] = "!%I";      /* FAO directive that converts longword to @                                       alphanumeric identifier.*/     char *ptr;     char *text;   #     $DESCRIPTOR(dsc_nambuf,nambuf);      $DESCRIPTOR(dsc_date,date); )     $DESCRIPTOR(dsc_directive,directive); #     $DESCRIPTOR(dsc_ascuic,ascuic);        ?     Fab = cc$rms_fab;            /* Initialize fab structure */ F     xabdat = cc$rms_xabdat;      /* Initialize the XABDAT structure */D     xabpro = cc$rms_xabpro;      /* Initialize the Protection XAB */E     xabfhc = cc$rms_xabfhc;      /* File Header Characteristic XAB */         strcpy(nambuf, ViewFileStr);'     strcpy(fullfilespec, ViewFileSpec);   #        /* Set up the fab and xab */   E     Fab.fab$l_fna = fullfilespec;           /* set filename in fab */ O     Fab.fab$b_fns = strlen(fullfilespec);   /* Set length of filename in fab */ D     Fab.fab$l_xab = (char *) &xabdat;       /* chain the date xab */J     xabdat.xab$l_nxt = (char *)&xabpro;     /* chain the protection xab */K     xabpro.xab$l_nxt = (char *)&xabfhc;     /* chain the file header xab */            /* open the file */        rmsstat = sys$open(&Fab); K     if(rmsstat != RMS$_NORMAL) {                /* should never get here */          DoBell(0);-         sprintf(titlestr, "File Open Error");          D         sprintf(Buffer, "RMS is unable to open input file:\n'%s'%s",K                 ViewFileSpec,"\nfor read. Please verify correct filespec"); -         ErrorPopup(&Buffer, &titlestr, TRUE);          Buffer[0] = '\0'; ,         XmTextSetString(ViewWindow, Buffer);         OpenErr = TRUE;          return(rmsstat);     }   #         /* Display the file name */   4     sprintf(Buffer, "     Filename:  %s\n", nambuf);  #         /* Display the file size */   H     sprintf(Buffer+strlen(Buffer), "    File Size:  %d/%d (%d bytes)\n",L                              xabfhc.xab$l_ebk, Fab.fab$l_alq, ViewFileSize);  %         /* Print the creation date */   D     rmsstat = sys$asctim(&datelen, &dsc_date, &xabdat.xab$q_cdt, 0);0     if(rmsstat != SS$_NORMAL) lib$stop(rmsstat);;     ptr = strchr(date+2, ' ');  /* this is somewhat iffy */      if(ptr) *ptr = '\0';L     sprintf(Buffer+strlen(Buffer), "Creation Date:  %.*s\n", datelen, date);  %         /* Print the revision date */   D     rmsstat = sys$asctim(&datelen, &dsc_date, &xabdat.xab$q_rdt, 0);0     if(rmsstat != SS$_NORMAL) lib$stop(rmsstat);;     ptr = strchr(date+2, ' ');  /* this is somewhat iffy */      if(ptr) *ptr = '\0';I     sprintf(Buffer+strlen(Buffer), "Revision Date:  %.*s",datelen, date); A     sprintf(Buffer+strlen(Buffer), "  (%d)\n", xabdat.xab$w_rvn);            /* Print the owner */   H     rmsstat = sys$fao(&dsc_directive, 0, &dsc_ascuic, xabpro.xab$l_uic);     ptr = strchr(ascuic, ']');
     if(ptr) {          ptr++;         *ptr = '\0';     } C     sprintf(Buffer+strlen(Buffer), "        Owner:  %s\n", ascuic);   )         /* Print the protection values */   8     sprintf(Buffer+strlen(Buffer), "   Protection:  (");  ,     if ((( (1 << XAB$V_SYS) << XAB$V_NOREAD)F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "R");-     if ((( (1 << XAB$V_SYS) << XAB$V_NOWRITE) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "W");+     if ((( (1 << XAB$V_SYS) << XAB$V_NOEXE) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "E");+     if ((( (1 << XAB$V_SYS) << XAB$V_NODEL) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "D");  (     sprintf(Buffer+strlen(Buffer), ",");,     if ((( (1 << XAB$V_OWN) << XAB$V_NOREAD)F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "R");-     if ((( (1 << XAB$V_OWN) << XAB$V_NOWRITE) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "W");+     if ((( (1 << XAB$V_OWN) << XAB$V_NOEXE) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "E");+     if ((( (1 << XAB$V_OWN) << XAB$V_NODEL) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "D");  (     sprintf(Buffer+strlen(Buffer), ",");,     if ((( (1 << XAB$V_GRP) << XAB$V_NOREAD)F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "R");-     if ((( (1 << XAB$V_GRP) << XAB$V_NOWRITE) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "W");+     if ((( (1 << XAB$V_GRP) << XAB$V_NOEXE) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "E");+     if ((( (1 << XAB$V_GRP) << XAB$V_NODEL) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "D");  (     sprintf(Buffer+strlen(Buffer), ",");,     if ((( (1 << XAB$V_WLD) << XAB$V_NOREAD)F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "R");-     if ((( (1 << XAB$V_WLD) << XAB$V_NOWRITE) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "W");+     if ((( (1 << XAB$V_WLD) << XAB$V_NOEXE) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "E");+     if ((( (1 << XAB$V_WLD) << XAB$V_NODEL) F           & xabpro.xab$w_pro)==0) sprintf(Buffer+strlen(Buffer), "D");  ,     sprintf(Buffer + strlen(Buffer), ")\n");  '        /*  Close the file and return */   F     if ((rmsstat = sys$close(&Fab)) != RMS$_NORMAL) lib$stop(rmsstat); }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: LoadCache E  * Description: This routine is called as a part of InitCacheDlg() if D  *              the LoadCacheFile flag is set. The specified file in=  *              the buffer CacheFileSpec is  opened and read, G  *              the pathnames therein are stored in the compound string G  *              table which feeds the cache list widget. Errors on open <  *              and file content info are displayed to user.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int LoadCache()  { 
     int done;      int indx = 0;      int rindx = 0;     int LoadItemCount = 0;     int NumLoadItems = 0;      int UpperBound = 0;      int LowerBound = 0;      int status;      char PathStr[80];      char *ptr;  8         /* open the file specified by 'CacheFileSpec' */  (     CacheFp = fopen(CacheFileSpec, "r");     if(!CacheFp) {K         sprintf(Buffer, "Unable to open Cache file:\n %s ", CacheFileSpec); *         ErrorPopup(&Buffer, "Cache File");         return(False);     }   A         /* we expect the first line to include string 'ViewFile', @            as a generated loadfile would. Exit if not present */  6     status = fgets(Buffer, sizeof(Buffer)-1, CacheFp);%     ptr = strstr(Buffer, "ViewFile");      if(!ptr) {8         sprintf(Buffer, "Invalid Load Format, File:\n");>         sprintf(Buffer+strlen(Buffer), " %s ", CacheFileSpec);/         ErrorPopup(&Buffer, "Load Cache List");          return(False);     }   B         /* read file lines until the item count value (preceded byE            '@' character) is read. Save this value in NumLoadItems */        NumLoadItems = 0;      done = False;      while (!done) { :         status = fgets(Buffer, sizeof(Buffer)-1, CacheFp);         if(status == &Buffer) {              ptr = &Buffer;             if(*ptr == '@') {                  *ptr = ' '; 4                 sscanf(Buffer, "%d", &NumLoadItems);                 done = True;
             } 	         }          else done = TRUE;      }   D         /* just to be sure, verify NumLoadItems value we just loadedC            is not larger than the MAXCSH value. If so, tell user we -            have an error and stop the load */        if(NumLoadItems > MAXCSH) {          fclose(CacheFp);         sprintf(Buffer, ;             "Loadfile '%s'\ncontains more than %d items. ", #             CacheFileSpec, MAXCSH); D         sprintf(Buffer+strlen(Buffer), "Edit loadfile to limit\n%s",:             "items to 35 or less, then restart Viewfile");0         ErrorPopup(&Buffer, "Cache Load Error");%         XmUpdateDisplay(ErrorPopDlg);          NumCacheItems = 0;         return(False);     }   G     /* it is possible the loadfile was created/modified manually, so it G        is prudent to verify the just read item count matches the number G        of records that follow. If any error, post message and return */   
     indx = 0;      ptr = &Buffer;     while(isspace(*ptr)) {:         status = fgets(Buffer, sizeof(Buffer)-1, CacheFp);%         if(status == &Buffer) indx++;      }       if(indx-1 != NumLoadItems) {         fclose(CacheFp);         sprintf(Buffer, M             "Loadfile '%s'\nindicates %d items. however, reading the file\n", )             CacheFileSpec, NumLoadItems); &         sprintf(Buffer+strlen(Buffer),D             "indicates %d items in loadfile. Load aborted", indx-1);0         ErrorPopup(&Buffer, "Cache Load Error");%         XmUpdateDisplay(ErrorPopDlg);          NumCacheItems = 0;         return(False);     }      rewind(CacheFp);     while(Buffer[0] != '@') { :         status = fgets(Buffer, sizeof(Buffer)-1, CacheFp);     } H     Buffer[0] = ' ';    /* fudge the input for next 'while' statement */  E         /* read and save filepath strings while lines start with ' '. D            Filepath strings are merged into the ascii filepath array=            so the final list will we sorted alphabetically */        ptr = &Buffer;     while(isspace(*ptr)) {+         memset(&Buffer, 0, sizeof(Buffer)); :         status = fgets(Buffer, sizeof(Buffer)-1, CacheFp);         if(status == &Buffer) {              ptr = &Buffer;             if(*ptr == ' ') { /                 sscanf(Buffer, "%s", &PathStr);                  done = FALSE;                  indx = 0;                  while(!done) {3                     if(!strlen(CacheArray[indx])) { :                         strcpy(CacheArray[indx], PathStr);$                         done = TRUE;                         break;                     } ?                     if(strcmp(PathStr, CacheArray[indx]) > 0) { F                         while(strcmp(PathStr, CacheArray[indx]) > 0 &&=                                 indx < LoadItemCount) indx++;%.                         rindx = LoadItemCount;-                         while(rindx > indx) { K                             strcpy(CacheArray[rindx], CacheArray[rindx-1]); $                             rindx--;U                             memset(&CacheArray[rindx], 0, sizeof(CacheArray[rindx]));                          } :                         strcpy(CacheArray[indx], PathStr);$                         done = TRUE;                     }                      else {.                         rindx = LoadItemCount;-                         while(rindx > indx) {tK                             strcpy(CacheArray[rindx], CacheArray[rindx-1]);d$                             rindx--;U                             memset(&CacheArray[rindx], 0, sizeof(CacheArray[rindx]));h                         }a:                         strcpy(CacheArray[indx], PathStr);$                         done = TRUE;                     }*                 }*                  LoadItemCount++;
             }*	         }c     }e     fclose(CacheFp);  ;         /* now copy the contents of the array into to cacheh3            compound sting list in the same order */u  /     for(indx = 0; indx < LoadItemCount; indx++)lJ         CsCacheList[indx] = XmStringCreateLtoR(CacheArray[indx], charset);  E     if(NumCacheItems != LoadItemCount) NumCacheItems = LoadItemCount;>     return(True);. }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowVers?  * Description: Displays current image version, build date, ande?  *              required privs for interactive usage and/or the $  *              VMS install utility.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */h void ShowVers()X {u2     sprintf(Buffer, " ViewFile by Lyle W West\n");@     sprintf(Buffer+strlen(Buffer), "   Version: %s\n", VERSION);A     sprintf(Buffer+strlen(Buffer), " Link Date: %s\n", __DATE__); C     sprintf(Buffer+strlen(Buffer), "User Privs: None (ReadAll)\n");c   }t    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetDisplayInfoD  * Description: Show the X11 (DecWindows) connection information forF  *              the current image. This includes the node the Viewfile@  *              image is executing on, the display node and the G  *              display transport method (Decnet, Tcpip, Lat or Local). H  *              This is provided for remote ViewFile display operations.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */* int GetDisplayInfo() {*     int     gdistat;     long    iosb[2];     short   channel;     char    client_name[32];     char    device_name[32];     char    node_name[80];     char    transport_name[32];p     char    server_name[32];     char    screen_name[32];     char    output_string[512];      char    *ptr;p  :         /* Input - display_name is a descriptor containing<                    the logical name/device of the display */  .     $DESCRIPTOR(display_name, "DECW$DISPLAY");  ,         /* Assign a channel to the device */  8     gdistat = sys$assign(&display_name, &channel, 0, 0);/     if (gdistat != SS$_NORMAL) return(gdistat);r  ,         /* Get the local node information */  H     gdistat = sys$qiow(0, channel, IO$_SENSEMODE|IO$M_WS_DISPLAY, &iosb,=                          0, 0, node_name, sizeof(node_name), m6                          DECW$C_WS_DSP_NODE, 0, 0, 0);/     if (gdistat != SS$_NORMAL) return(gdistat); /     if (iosb[0] != SS$_NORMAL) return(iosb[0]);m     node_name[iosb[1]] = 0;   +         /* Get the transport information */   N     gdistat = sys$qiow(0, channel, IO$_SENSEMODE|IO$M_WS_DISPLAY, &iosb, 0, 0,<                       transport_name,sizeof(transport_name),8                       DECW$C_WS_DSP_TRANSPORT, 0, 0, 0);/     if (gdistat != SS$_NORMAL) return(gdistat);*/     if (iosb[0] != SS$_NORMAL) return(iosb[0]);*      transport_name[iosb[1]] = 0;  0         /* Get the display server information */  N     gdistat = sys$qiow(0, channel, IO$_SENSEMODE|IO$M_WS_DISPLAY, &iosb, 0, 0,:                          server_name, sizeof(server_name),8                          DECW$C_WS_DSP_SERVER, 0, 0, 0);/     if (gdistat != SS$_NORMAL) return(gdistat);l/     if (iosb[0] != SS$_NORMAL) return(iosb[0]);*     server_name[iosb[1]] = 0;*  (         /* Get the screen information */  N     gdistat = sys$qiow(0, channel, IO$_SENSEMODE|IO$M_WS_DISPLAY, &iosb, 0, 0,O                         screen_name, sizeof(screen_name), DECW$C_WS_DSP_SCREEN, !                         0, 0, 0);*/     if (gdistat != SS$_NORMAL) return(gdistat); /     if (iosb[0] != SS$_NORMAL) return(iosb[0]);      screen_name[iosb[1]] = 0;         /* get rid of the channel */  "     gdistat = sys$dassgn(channel);/     if (gdistat != SS$_NORMAL) return(gdistat);c  '         /* get other variable values */y  .     strcpy(client_name, "SYS$NET_SERVICES_3");%     gdistat = CheckLnm(&client_name);a-     client_name[0] = toupper(client_name[0]);s     ptr = &client_name[1];     while(*ptr) {c         *ptr = tolower(*ptr);f         ptr++;     }*(     strcpy(device_name, "decw$display");%     gdistat = CheckLnm(&device_name);O     ptr = &device_name; 
     if(ptr) {a         if(*ptr == '_') {=             ptr++;%             strcpy(device_name, ptr);*	         }*     }   C     if(strcmp(node_name, "0") == 0) strcpy(node_name, client_name);c  %         /* build the output string */c  6     sprintf(Buffer, "   VMS Node: %s\n", client_name);E     sprintf(Buffer+strlen(Buffer), "   Disp Dev: %s\n", device_name); C     sprintf(Buffer+strlen(Buffer), "  X Display: %s\n", node_name); H     sprintf(Buffer+strlen(Buffer), "  Transport: %s\n", transport_name);E     sprintf(Buffer+strlen(Buffer), "     Screen: %s\n", screen_name);*E     sprintf(Buffer+strlen(Buffer), "     Server: %s\n", server_name);n       return(SS$_NORMAL);;   }   N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: FindTxtString J  * Description: Search the current target file for a match with a providedE  *              character string. If a match is located, display the  N  *              matched string in highlighted video within the displayed text.H  *              Subsequent calls to this function will first restore theN  *              highlighted string, search for another match and if found willI  *              again highlight the string; this assumes the input search(C  *              string remains constant within successive searches.t  *J  *              Note that we create a local text widget (TargetTxtTmp) to N  *              use for the text search. Into this widget we load the contentsG  *              of the current viewfile, after converting all chars to BG  *              lowercase. This widget is used by 'XmTextFindString' tolH  *              locate occurances of 'Pattern'. This widget is destroyedI  *              and recreated each time a new search pattern is presentedn  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */&  int FindTxtString(char *Pattern) {/     int colnum = 0;t     int patternlen;      int rownum = 0;t     int scrollvalue = 5;     int status;&     Boolean found = FALSE;     char foundstr[20];     char *ptr;     char *FileText;a"     XmTextDirection direction = 0;I     XmTextPosition EndPos = 0;      /* end position of highlite string */e      XmTextPosition foundpos = 0;     XmTextPosition start = 0;      Position *PrevX = 0;     Position *PrevY = 0;     Position *StartX = 0;      Position *StartY = 0;e  :         /* if a new search string, reset some variables */  C     if(FirstPass) {     /* always True first time for any string */S         EndPos = 0;f         EofPos = 0;          LastPos = 0;         PrevPos = 0;         StartPos = 0;e         NumFound = 0;p         if(TargetTxtTmp) {*             XtDestroyWidget(TargetTxtTmp);;             memset(&TargetTxtTmp, 0, sizeof(TargetTxtTmp));e	         }%9         XmTextSetInsertionPosition(ViewWindow, StartPos);_         FirstPass = FALSE;     }   2         /* clear highlight from previous search */  H     XmTextSetHighlight(ViewWindow, 0, XmTextGetLastPosition(ViewWindow),              XmHIGHLIGHT_NORMAL);  >         /* get the text (file) that is about to be searched */  +     FileText = XmTextGetString(ViewWindow);(
 #ifdef ARF     if(!strlen(FileText)) {n9         printf("Failed to get string from ViewWindow\n");m         return(0);     }, #elsea      EofPos = strlen(FileText)-1;     if(!EofPos) {M9         printf("Failed to get string from ViewWindow\n");t         return(0);     }    #endif  F         /* convert the copy of the target text file 'FileText' and theE            search pattern string 'Pattern' to lowercase. This permitsa/            any search to be case insensitive */   8     ptr = FileText;       /* copy of target viewfile */      while (*ptr) {         *ptr = tolower(*ptr);p         ptr++;     }   1     ptr = Pattern;    /* current search string */e     while (*ptr) {         *ptr = tolower(*ptr);          ptr++;     }t  1         /* get length of search pattern string */"  !     patternlen = strlen(Pattern);   @         /* set the direction; variable based on the state of the'            variable 'FindReverseFlg' */f       if(FindReverseFlg) {$         direction = XmTEXT_BACKWARD;
 #ifdef ARF(         if(!PrevPos) StartPos = LastPos; #else          if(!PrevPos) {             StartPos = EofPos;             PrevPos = EofPos;(=             XmTextSetInsertionPosition(ViewWindow, StartPos); 	         }a #endif     }=
     else {#         direction = XmTEXT_FORWARD;p"         if(!PrevPos) StartPos = 0;     }(  J         /* save converted file text to the TargetTxtTmp widget, which willM            be used for the string search. If TargetTxtTmp is not initialized, F            do that first, then load modified text. The widget must be L            reinitialized each time a new search string is presented to us */       if(!TargetTxtTmp) {f         n = 0;*         XtSetArg(args[n], XmNx, 800); n++;*         XtSetArg(args[n], XmNy, 800); n++;?         XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;"Q         TargetTxtTmp  = XmCreateScrolledText(TopParent, "TargetTxtTmp", args, n);      }(,     XmTextSetString(TargetTxtTmp, FileText);  A         /* start searching at current cursor position + 1 to findiG          * the NEXT occurrance of the search pattern. Search direction EE          * is determined by the value of 'FindReverseFlg' whose value"7          * controlled by the state of 'FindReverseBtn'  B          * If we reach a 'found = False' indicate same to user and          * return to callerf          */   3     StartPos = XmTextGetCursorPosition(ViewWindow);      PrevPos = StartPos;i*     if(FindReverseFlg) start = StartPos-1;     else start = StartPos+1;:     found = XmTextFindString(TargetTxtTmp, start, Pattern,&                 direction, &foundpos);  :     if(!found) {           /* no [more] pattern matches */         DoBell(0);         XtFree(FileText);(         FileText = 0;V#         XmUpdateDisplay(TopParent);o         NoMoreMatch = True;u'         XtSetSensitive(FindBtn, False);e         return(True);      }   ?         /* we found a pattern match, display match highlited */)       StartPos = foundpos;#     EndPos = StartPos + patternlen;*5     XmTextSetInsertionPosition(ViewWindow, StartPos);*     if(SeaHiliteRev)8         XmTextSetHighlight(ViewWindow, StartPos, EndPos,1                            XmHIGHLIGHT_SELECTED);d9     else XmTextSetHighlight(ViewWindow, StartPos, EndPos, ;                            XmHIGHLIGHT_SECONDARY_SELECTED);      NumFound++; I     XmTextShowPosition(ViewWindow, foundpos);  /* display found string */d      XmUpdateDisplay(ViewWindow);C     status = XmTextPosToXY(ViewWindow, StartPos, &StartX, &StartY); @     status = XmTextPosToXY(ViewWindow, PrevPos, &PrevX, &PrevY);
 #ifdef VF_DBG*1     printf("Start X,Y: %d,%d\n", StartX, StartY);n/     printf(" Prev X,Y: %d,%d\n", PrevX, PrevY);n #endif  G         /* get row/col values of search result. We really need only the0?            row info to decide if we need to scroll text down */   E     status = TextPosToRowCol(ViewWindow, StartPos, &rownum, &colnum);o  '         /* scroll window as required */{  ;     if(rownum >= 22) XmTextScroll(ViewWindow, scrollvalue);a  A         /* add callback to remove above hilite if mouse initiatede@            selection occurs. This callback also disables motion-E            verify callbacks until another successful search occurs */t  A     XtAddCallback(ViewWindow, XmNmotionVerifyCallback, MainWinCB,c&                   VIEW_MOTION_VERIFY);     MotionCount = 0;       XtFree(FileText);      return(TRUE);    i }\    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ExitPopup)F  * Description: User has selected the Exit button from the option menuD  *              but the cache database has been modified. Popup the I  *              ExitDlg to display message as such with the user choosinglE  *              which action to take via appropriate pupup pushbuttonr  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ * void ExitPopup(char *message, char *title) {'     char msgstr[50];  E     sprintf(msgstr, "  Cache List has been\nmodified but not saved"); 7     CsMessageStr = XmStringCreateLtoR(msgstr, charset);   
     n = 0;%     XtSetArg(args[n], XmNx,260); n++;u&     XtSetArg(args[n], XmNy, 385); n++;%     XtSetArg(args[n], XmNdialogTitle,s:         XmStringCreateLtoR("Exit Warning", charset)); n++;'     XtSetArg(args[n], XmNokLabelString,c2         XmStringCreateLtoR("Quit", charset)); n++;+     XtSetArg(args[n], XmNcancelLabelString,.2         XmStringCreateLtoR("Save", charset)); n++;)     XtSetArg(args[n], XmNhelpLabelString,l3         XmStringCreateLtoR("Close", charset)); n++;h2     XtSetArg(args[n], XmNautoUnmanage, True); n++;;     XtSetArg(args[n], XmNmessageString, CsMessageStr); n++; 6     XtSetArg(args[n], XmNdefaultPosition, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;C     ExitDlg = XmCreateWarningDialog(TopParent, "ExitDlg", args, n);pE     XtAddCallback(ExitDlg, XmNokCallback, InputDlgCB, EXIT_QUIT_BTN);hI     XtAddCallback(ExitDlg, XmNcancelCallback, InputDlgCB, EXIT_SAVE_BTN);eH     XtAddCallback(ExitDlg, XmNhelpCallback, CloseDlgCB, EXIT_CLOSE_BTN);       XmStringFree(CsMessageStr);p     XtManageChild(ExitDlg);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowFlags G  * Description: User selected the option menu Logicals button. Create a F  *              bb dialog to display a table showing relevant ViewfileB  *              logicals, the flag symbols, default, current stateE  *              and a brief description of the default action of each !  *              optional logical.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowFlags() {r     char string1[99];      char string2[1024];      char *pbuf;i     XmTextPosition StartPos;-     Widget ScrolledWin, TextLabelW, CloseBtn; ,     XmString        CpStr1, CpStr2, CpFlags;#     XmFontListEntry entry1, entry2;y     XmFontList      fontlist;   7         /* if dialog already created, just manage it */u       if(ShowLnmDlg) {"         XtManageChild(ShowLnmDlg);         return;      }u  <         /* Create a table of logicals, flag locs, state info/            and a default condition statement */,  I     sprintf(string1, "\n  %-19s %-15s %-6s %-9s %-20s\n", "Logical Name", :         "Flag Symbol", "Deflt", "Curr", "Default Action");0     sprintf(string1+strlen(string1), "     \n");  7     sprintf(string2, "  %-19s %-15s %-6s %-9s %-20s\n",e/         "VF_AUTOFILTER", "AutoFilter", "False", C         AutoFilter ? "True (1)" : "False (1)", "Normal filtering");xG     sprintf(string2+strlen(string2), "  %-19s %-15s %-6s %-9s %-20s\n",]1         "VF_GETALLFILES", "GetAllFiles", "False",a;         GetAllFiles ? "True" : "False", "List ascii only");mG     sprintf(string2+strlen(string2), "  %-19s %-15s %-6s %-9s %-20s\n", /         "VF_HELPENABLE", "HelpEnable", "False",n8         HelpEnable ? "True" : "False", "Help disabled");G     sprintf(string2+strlen(string2), "  %-19s %-15s %-6s %-9s %-20s\n",)A         "VF_HELPLIB", " <string>", " ", " ", "Default filespec");eG     sprintf(string2+strlen(string2), "  %-19s %-15s %-6s %-9s %-20s\n", 4         "VF_HILITEREVERSE", "SeaHiliteRev", "False",>         SeaHiliteRev ? "True" : "False", "Underscore hilite");G     sprintf(string2+strlen(string2), "  %-19s %-15s %-6s %-9s %-20s\n",a/         "VF_NOPRIVCHECK", "CheckPrivs", "True", <         CheckPrivs ? "True" : "False", "Check for READALL");G     sprintf(string2+strlen(string2), "  %-19s %-15s %-6s %-9s %-20s\n", 2         "VF_CACHE-ENABLE", "CacheEnable", "False",=         CacheEnable ? "True" : "False", "Cache not enabled"); G     sprintf(string2+strlen(string2), "  %-19s %-15s %-6s %-9s %-20s\n", 3         "VF_CACHEADD (2)", "AutoCacheAdd", "False",pH         AutoCacheAdd ? "True (1)" : "False (1)", "Filepaths not added");G     sprintf(string2+strlen(string2), "  %-19s %-15s %-6s %-9s %-20s\n",lG         "VF_CACHEFILE (2)", " <string>", " ", " ", "Default filespec");tI     sprintf(string2+strlen(string2), "  %-19s %-15s %-6s %-9s %-20s\n\n",>5         "VF_CACHELOAD (2)", "LoadCacheFile", "False",*C         LoadCacheFile ? "True" : "False", "Don't load cache file");i0     sprintf(string2+strlen(string2), "     \n");  )         /* explain the exception rules */   M     sprintf(string2+strlen(string2), "   (1)  Changeable at runtime with %s",l         "Toggle button\n");*K     sprintf(string2+strlen(string2), "   (2)  Ignored if VF_NOCACHE is %s",X         "defined TRUE\n\n");  
 #ifdef VF_DBGWP     printf(" ShowFlags: string1: %d of %d\n", strlen(string1), sizeof(string1));P     printf(" ShowFlags: string2: %d of %d\n", strlen(string2), sizeof(string2)); #endif  9         /* create a fontlist exclusive to this routine */*  *7     entry1 = XmFontListEntryLoad (XtDisplay(TopParent),*I             "-dec-terminal-bold-r-normal--14-100-100-100-c-80-iso8859-1",e$             XmFONT_IS_FONT, "TAG1");6     entry2 = XmFontListEntryLoad(XtDisplay(TopParent),K             "-dec-terminal-medium-r-normal--14-100-100-100-c-80-iso8859-1",h$             XmFONT_IS_FONT, "TAG2");  4     fontlist = XmFontListAppendEntry (NULL, entry1);8     fontlist = XmFontListAppendEntry (fontlist, entry2);  "     XmFontListEntryFree (&entry1);"     XmFontListEntryFree (&entry2);  1     CpStr1 = XmStringCreateLtoR(string1, "TAG1");s1     CpStr2 = XmStringCreateLtoR(string2, "TAG2");   3         /* concatenate the 2 strings on top of each;3            other, CpStr1 and CpStr2 into CpFlags */a  -     CpFlags = XmStringConcat(CpStr1, CpStr2);   *         /* Create BulletinBoard Dialog for)            text and pushbutton widgets */p  K     CpStr = XmStringCreateLtoR("Optional Logical Names - Status", charset);m
     n = 0;2     XtSetArg(args[n], XmNdialogTitle, CpStr); n++;*     XtSetArg(args[n], XmNwidth, 680); n++;+     XtSetArg(args[n], XmNheight, 300); n++;&L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;5     XtSetArg(args[n], XmNdefaultPosition, True); n++; H     ShowLnmDlg = XmCreateBulletinBoardDialog(TopParent, "DisplayDialog",             args, n);0     XmStringFree(CpStr);  ;         /* Create ScrolledWindow to display textual info */0  
     n = 0;%     XtSetArg(args[n], XmNx, 10); n++; %     XtSetArg(args[n], XmNy, 20); n++;o*     XtSetArg(args[n], XmNwidth, 660); n++;+     XtSetArg(args[n], XmNheight, 215); n++; <     XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;C     XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;r2     XtSetArg(args[n], XmNshadowThickness, 3); n++;M     ScrolledWin = XmCreateScrolledWindow(ShowLnmDlg, "ScrolledWin", args, n);0     XtManageChild(ScrolledWin);*  
     n = 0;4     XtSetArg(args[n], XmNlabelString, CpFlags); n++;2     XtSetArg(args[n], XmNfontList, fontlist); n++;@     XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;4     XtSetArg(args[n], XmNrecomputeSize, False); n++;C     TextLabelW = XmCreateLabel(ScrolledWin, "TextLabelW", args, n);$     XtManageChild(TextLabelW);     XmStringFree(CpFlags);  .         /* Create PushButton to close popup */  1     CpStr = XmStringCreateLtoR("Close", charset);s
     n = 0;)     XtSetArg(args[n], XmNwidth, 80); n++;Y*     XtSetArg(args[n], XmNheight, 30); n++;&     XtSetArg(args[n], XmNx, 300); n++;&     XtSetArg(args[n], XmNy, 250); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;I     CloseBtn = XmCreatePushButtonGadget(ShowLnmDlg, "CloseBtn", args, n); O     XtAddCallback(CloseBtn, XmNactivateCallback, CloseDlgCB, SHOFLG_CLOSE_BTN);)     XtManageChild(CloseBtn);       XmStringFree (CpStr1);     XmStringFree (CpStr2);     XmStringFree (CpStr);c     XmFontListFree (fontlist);       XtManageChild(ShowLnmDlg);   }         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckNewItemE  * Description: The filter filepath has changed in the fsb, which is  H  *              passed to us as NewPath. Convert the NewPath string to aI  *              compound string and check if it already exists within thesF  *              cache list. If not, call AddCacheItem() to update listD  *              widget and display. If already in list, just return.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */m  void CheckNewItem(char *NewPath) {r     int Position = 0;      int status = 0;i     String CachePath;r     XmString CsNewPath;r  B         /* make sure NumCacheItems value we are about to incrementB            will not be larger than the MAXCSH value. If so, informE            user we have a problem, disable further filepath additions*.            to the cache database and return */  "     if(NumCacheItems+1 > MAXCSH) {D         sprintf(Buffer, "This operation will exceed the maximum\n");'         sprintf(Buffer+strlen(Buffer), r:             "Cache item count (%d). Select the Cache\n%s",>              MAXCSH, "  popup and remove one or more items ");0         ErrorPopup(&Buffer, "Exceed Cache Max");%         XmUpdateDisplay(ErrorPopDlg);          AutoCacheAdd = False;r@         XmToggleButtonSetState(AddPathBtn, AutoCacheAdd, False);         return;      }s  5     CsNewPath = XmStringCreateLtoR(NewPath, charset);n     if(NumCacheItems) {e9         status = XmListItemExists(CacheListw, CsNewPath);e         if(status) return;     }   I         /* if physical path of any list item matches the physical/logical I            value of NewPath string, we already have it; so return with no             new path addition */i  &     status = GetPhysicalPath(NewPath);$     if(status != SS$_NORMAL) return;     if(NumCacheItems) {d6         status = ComparePhysPath(COMPARE_TO_PHYSICAL);)         if(status == SS$_DUPLNAM) return;*          strcpy(Buffer, NewPath);5         status = ComparePhysPath(COMPARE_TO_LOGICAL);a)         if(status == SS$_DUPLNAM) return;a     }n  .         /* Update the cache info and output */       AddCacheItem(NewPath); }o      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ComparePhysPathoD  * Description: Perform comparison of cache list physical paths to aF  *              specific string, which is at the location specified byI  *              the input value. If a match is found, return SS$_DUPLNAM,i0  *              otherwise return SS$_NOSUCHENTRY  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */o! int ComparePhysPath(int CompType)0 {      int indx = 0;      CACHE_LST *CachePtr;       CachePtr = AscCacheList;     switch(CompType) {!         case COMPARE_TO_PHYSICAL:))             while(indx < NumCacheItems) {pM                 if(strcmp(CachePtr->PhysicalPath, CachePhysPath) == 0) break;                  indx++;o                 CachePtr++;_
             }P             break;          case COMPARE_TO_LOGICAL:)             while(indx < NumCacheItems) {gF                 if(strcmp(CachePtr->PhysicalPath, Buffer) == 0) break;                 indx++;                  CachePtr++;s
             }a             break;     }X6     if(indx == NumCacheItems) return(SS$_NOSUCHENTRY);     else return(SS$_DUPLNAM);" }l    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: NewAscCacheListPF  * Description: The AscCacheList is an array of filepaths. Each entry G  *              contains two elements, the logical filepath as shown inrH  *              the Cache list and a physical filepath which is actuallyH  *              a physical disection of the logical filepath and is usedD  *              to avoid duplicate entries in the Cache list for theG  *              same physical target. The purpose of AscCacheList is to 4  *              prevent duplicate new cache entries.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void NewAscCacheList() {t     int indx = 0;      int status = 0;(     char *ListItem;      CACHE_LST *CachePtr;       if(!NumCacheItems) return;)     if(AscCacheList) cfree(AscCacheList); @     AscCacheList = calloc(NumCacheItems + 1, sizeof(CACHE_LST));     CachePtr = AscCacheList;  
     indx = 0;;!     while(indx < NumCacheItems) { H         status = XmStringGetLtoR(CsCacheList[indx], charset, &ListItem);'         if(status != SS$_NORMAL) break;a+         status = GetPhysicalPath(ListItem);e(         if(status != SS$_NORMAL) return;0         strcpy(CachePtr->LogicalPath, ListItem);6         strcpy(CachePtr->PhysicalPath, CachePhysPath);         CachePtr++;          indx++;t     }n
 #ifdef VF_DBGr     if(status != SS$_NORMAL)C         printf("NewAscCacheList: status = %d indx: %d Input: %s\n",b$             status, indx, ListItem); #endifD     XtFree(ListItem);   /* XmStringGetLtoR() does allocate memory */ }   