#if 0
From: mccarthy@hndymn.zko.dec.com (Brian J. - C++ Class Libraries)
Subject: Re: Callable EDT/TPU routines

Here ya go - compiles wiht DEC C V5.6, and OpenVMS Alpha V6.2 - does not
require /stand=vaxc 

Brian J.

#endif

/*
Segment of a simple C program to invoke DECTPU.  This program provides its
own FILEIO routine instead of using the one provided by DECTPU. This program
will run correctly if you write the routines it calls.
*/
#include <descrip.h>		/* descriptors */
#include <lib$routines.h>	/* any lib$ routine */
#include <stdio.h>		/* printf etc */
#include <stdlib.h>		/* for exit */
#include <string.h>		/* strxxx routines */
#include <tpudef.h>		/* TPU names */
#include <rmsdef.h>		/* RMS constants */


/* data structures needed */

struct bpv_arg                  /* bound procedure value */
    {
    void *routine_add;        	/* pointer to routine */
    void *env ;                 /* environment pointer */
    } ;

struct item_list_entry          /* item list data structure */
    {
    short int buffer_length;    /* buffer length */
    short int item_code;        /* item code */
    union {
        void *buffer_add;            /* buffer address */
	int  buffer_int;	     /* as an int */
    } buffer_info;
    void *return_len_add;        /* return address */
    } ;

struct stream_type
    {
    FILE      *ident;            /* stream id */
    short int alloc;            /* file size */
    short int flags;            /* file record attributes/format */
    short int length;           /* resultant file name length */
    short int stuff;            /* file name descriptor class & type */
    int nam_add;                /* file name descriptor text pointer */
    } ;


#pragma __extern_model __save
#pragma __extern_model __globalvalue

extern const int tpu$_success;       /* TPU Success code */
extern const int tpu$_quitting;      /* Exit code defined by TPU */

#pragma __extern_model __restore


int tpu$cleanup ();             /* TPU routine to free resources used */
int tpu$control ();             /* TPU routine to invoke the editor */
int tpu$execute_inifile ();     /* TPU routine to execute initialization code */
int tpu$handler ();             /* TPU signal handling routine */
int tpu$initialize ();          /* TPU routine to initialize the editor */

/*
   This function opens a file for either read or write access, based upon
   the itemlist passed as the data parameter.  Note that a full implementation
   of the file open routine would have to handle the default file, related
   file, record attribute, maximize version, flush and file size item code
   properly.
 */
open_file (data, stream)

void *data;
struct stream_type *stream;

{
    struct item_list_entry *item;
    char *access;               /* File access type */
    char filename[256];         /* Max file specification size */

    /* Process the item list */

    item = (struct item_list_entry *)data;
    while (item->item_code != 0 && item->buffer_length != 0)
        {
        if (item->item_code == TPU$_ACCESS)
            {
            if (item->buffer_info.buffer_int == TPU$_FILEIO) access = "r+";
            else if (item->buffer_info.buffer_int == TPU$K_INPUT) access = "r";
            else if (item->buffer_info.buffer_int == TPU$K_OUTPUT) access = "w";
            }
        else if (item->item_code == TPU$_FILENAME)
            {
            strncpy (filename, item->buffer_info.buffer_add, item->buffer_length);
            filename [item->buffer_length] = 0;
            lib$scopy_r_dx (&item->buffer_length, item->buffer_info.buffer_add,
                                                        &stream->length);
            }
        else if (item->item_code == TPU$_DEFAULTFILE)
            {                           /* Add code to handle default file  */
            }                           /* spec here                        */
        else if (item->item_code == TPU$_RELATEDFILE)
            {                           /* Add code to handle related       */
            }                           /* file spec here                   */
        else if (item->item_code == TPU$_RECORD_ATTR)
            {                           /* Add code to handle record        */
            }                           /* attributes for creating files    */
        else if (item->item_code == TPU$_MAXIMIZE_VER)
            {                           /* Add code to maximize version     */
            }                           /* number with existing file here   */
        else if (item->item_code == TPU$_FLUSH)
            {                           /* Add code to cause each record    */
            }                           /* to be flushed to disk as written */
        else if (item->item_code == TPU$_FILESIZE)
            {                           /* Add code to handle specification */
            }                           /* of initial file allocation here  */
        ++item;         /* get next item */
        }
    stream->ident = fopen(filename,access);
    if (stream->ident != 0)
        return tpu$_success;
    else
        return RMS$_FNF;
}
/*
  This procedure closes a file
 */
close_file (data,stream)
struct stream_type *stream;

{
    fclose(stream->ident);
    return tpu$_success;
}
/*
  This procedure reads a line from a file
 */
read_line(data,stream)
struct dsc$descriptor *data;
struct stream_type *stream;

{
    char textline[984];                 /* max line size for TPU records */
    int len;

    if (fgets(textline,984,stream->ident) == NULL)
        return RMS$_EOF;
    else
        {
        len = strlen(textline);
        if (len > 0)
            len = len - 1;
        return lib$scopy_r_dx (&len, textline, data);
        }
}
/*
  This procedure writes a line to a file
 */
write_line(data,stream)
struct dsc$descriptor *data;
struct stream_type *stream;

{
    char textline[984];                 /* max line size for TPU records */

    strncpy (textline, data->dsc$a_pointer, data->dsc$w_length);
    textline [data->dsc$w_length] = 0;
    fputs(textline,stream->ident);
    fputs("\n",stream->ident);
    return tpu$_success;
}
/*
   This procedure will handle I/O for TPU
 */
fileio(code,stream,data)
int *code;
int *stream;
int *data;

{
    int status;

/* Dispatch based on code type.  Note that a full implementation of the      */
/* file I/O routines would have to handle the close and delete code properly */
/* instead of simply closing the file                                        */

    if (*code == TPU$K_OPEN)                    /* Initial access to file */
        status = open_file (data,stream);
    else if (*code == TPU$K_CLOSE)              /* End access to file */
        status = close_file (data,stream);
    else if (*code == TPU$K_CLOSE_DELETE)       /* Treat same as close */
        status = close_file (data,stream);
    else if (*code == TPU$K_GET)                /* Read a record from a file */
        status = read_line (data,stream);
    else if (*code == TPU$K_PUT)                /* Write a record to a file */
        status = write_line (data,stream);
    else
        {                                       /* Who knows what we got? */
        status = tpu$_success;
        printf ("Bad FILEIO I/O function requested");
        }
    return status;
}
/*
   This procedure formats the initialization item list and returns it as
   its return value.
 */
struct item_list_entry *callrout()
{
    static struct bpv_arg add_block =
        { (void *)fileio, 0 } ;         /* BPV for fileio routine */
    int options ;
    char *section_name = "TPU$SECTION";
    static struct item_list_entry arg[] =
        {/* length code              buffer add return add */
               { 4,TPU$_FILEIO,     0,         0 },
               { 4,TPU$_OPTIONS,    0,         0 },
               { 0,TPU$_SECTIONFILE,0,         0 },
               { 0,0,                0,         0 }
        };


    /* Setup file I/O routine item entry */
    arg[0].buffer_info.buffer_add = &add_block;

    /* Setup options item entry.  Leave journaling off. */
    options = TPU$M_DISPLAY | TPU$M_SECTION;
    arg[1].buffer_info.buffer_add = &options;

    /* Setup section file name */
    arg[2].buffer_length = strlen(section_name);
    arg[2].buffer_info.buffer_add = section_name;

    return arg;
}

/*
   Main program.  Initializes TPU, then passes control to it.
 */
main()
{
    int return_status ;
    int cleanup_options;
    struct bpv_arg add_block;

/* Establish as condition handler the normal DECTPU handler */

    lib$establish(tpu$handler);

/* Setup a BPV to point to the callback routine */

    add_block.routine_add = (void *)callrout ;
    add_block.env = 0;

/* Do the initialize of DECTPU */

    return_status = tpu$initialize(&add_block);
    if (!return_status)
        exit(return_status);

/* Have TPU execute the procedure TPU$INIT_PROCEDURE from the section file */
/* and then compile and execute the code from the command file */

    return_status = tpu$execute_inifile();
    if (!return_status)
        exit (return_status);

/* Turn control over to DECTPU */

    return_status = tpu$control ();
    if (!return_status)
        exit(return_status);

/* Now clean up. */

    cleanup_options = TPU$M_LAST_TIME | TPU$M_DELETE_CONTEXT;
    return_status = tpu$cleanup (&cleanup_options);
    exit (return_status);

    printf("Experiment complete");
}
