 #include <string.h>  #include <stdio.h> #include "tm_include:quint.h"  #include "tm_include:tape.h" #include "tm_include:macro.h"  #include "tm_include:tm.h"   /********************/  @ char tm_state = '0';      /* the turing machine state         */D int  tm_num_exe = 0;      /* total number of quintuple executions */J int  trace=0;             /* flag for showing tape at each machine step */@ int  debug=1;             /* flag for setting debug on or off */I int  max_step=10000;      /* maximum number of steps to take with 'go' */   @ struct quint *lastquint;  /* last quintuple that was executed */= struct quint *nextquint;  /* next quintuple to be executed */   ) /************  'WATCH' variables *******/   ? char watch_state[WATCH_LIM + 1];   /* buffer for watch points*/ E int nwatchstate = -1;              /* pointer to watch point buffer*/   ! char watch_symbol[WATCH_LIM + 1];  int nwatchsymbol = -1;  ! /*******************************/     9 void write_file(struct qlist *lptr, struct maclist *mptr)        { %       void getcmd(/*char*, char* */); #       int iscmd(/*char*, char* */); #       void message(/*char*, int*/); 8       void write_tm_file(/*char*,struct qlist*,int* */);;       void write_mac_file(/*char*,struct maclist*,int* */); '       void flushcmd(/*char*, char* */);        int status;        char fname[40];          while(1)	         { 2         getcmd("what kind? ('mac' or 'tm') ",ans);         if ( iscmd(ans,"tm"))            { +           getcmd("enter filename: ",fname); :           if ( !iscmd(fname,"exit") && !iscmd(fname,".") )
             { .             write_tm_file(fname,lptr,&status);             if (status != OK) !               message("",status); 
             }            break;           } #         else if ( iscmd(ans,"mac"))            { +           getcmd("enter filename: ",fname); :           if ( !iscmd(fname,"exit") && !iscmd(fname,".") )
             { /             write_mac_file(fname,mptr,&status);              if (status != OK) !               message("",status); 
             }            break;           }          else/           flushcmd("invalid response -> ",ans); 	         }        }   8 void read_file(struct qlist *lptr, struct maclist *mptr)       { %       void getcmd(/*char*, char* */); #       int iscmd(/*char*, char* */); #       void message(/*char*, int*/); 9       void read_tm_file(/*char*, struct qlist*, int* */); <       void read_mac_file(/*char*, struct maclist*, int* */);'       void flushcmd(/*char*, char* */);        int status;          while(1)	         { 2         getcmd("what kind? ('mac' or 'tm') ",ans);           if (iscmd(ans,"tm") )            { -           getcmd("enter name of file: ",ans); )           read_tm_file(ans,lptr,&status);            if ( status != OK)              message(ans,status);           else!             strcpy(filename,ans);            break;           } #         else if (iscmd(ans,"mac") )            { -           getcmd("enter name of file: ",ans); *           read_mac_file(ans,mptr,&status);           if ( status != OK)              message(ans,status);           break;           }          else/           flushcmd("invalid response -> ",ans); 	         }        }    void dele(struct qlist *ql)        { %       void getcmd(/*char*, char* */); #       int iscmd(/*char*, char* */); '       void flushcmd(/*char*, char* */);         void get_help(/*char* */);#       void message(/*char*, int*/); ;       void del_quint(/*struct qlist*, char, char, int* */); 3       void del_all_quint(/*struct qlist*, int* */); 4       void del_list_quint(/*struct qlist*, int* */);       int status;               while(1)	         { $         getcmd("delete what? ",ans);  4         if ( iscmd(ans,"?") ||  iscmd(ans,"h*elp") )            get_help("tm delete");N         else if ( iscmd(ans,"e*xit") || iscmd(ans,"quit" ) || iscmd(ans,".") )           break;+         else if ( iscmd(ans,"quin*tuple") )            {            while(1)
             { 9             getcmd("enter a two character string: ",ans);   6             if ( iscmd(ans,"exit") || iscmd(ans,".") )               break;  0             del_quint(ql,ans[0],ans[1],&status);             if (status == OK)                break;             else               { "               message(ans,status);N               if (status != NO_SUCH_Q)  /* don't ask again--there is no list*/                 break;               } 
             }            break;           } %         else if ( iscmd(ans,"a*ll") )            { $           del_all_quint(ql,&status);           if (status != OK )             message("",status);            break;           } &         else if ( iscmd(ans,"l*ist") )           { %           del_list_quint(ql,&status); $           if (status != EMPTY_QLIST)             message("",status);            break;           }          elseB           flushcmd("invalid or ambiguous delete command -> ",ans);	         }        }   , /* prompts the user for a quintuple list. */ /**/ void enter(struct qlist *ql)       { #       void message(/*char*, int*/); H       struct quint *new_quint(/* struct qlist*, char *, char*, int* */);        char cmmt[COMMENT_LENGTH];/       char quint[6], inbuf[COMMENT_LENGTH + 8];        char ch;       int i,status;   I     printf("Input quintuples with (optional) comments, one per line.\n"); K     printf("Start each quintuple with '('.  End with '.' in column 1. \n");          quint[5] = '\0';       while (1) 	         { ) /*   get a line from standard input.   */          i = 0;0         while ( (ch=getchar())!=EOF && ch!= 10 )           inbuf[i++] = ch;         inbuf[i] = '\0';   /*   quit if requested.    */ A         if ( inbuf[0] == '.' || (inbuf[0] == '\0' && ch == EOF) )            break;  > /*   check the line, and store it as a quintuple if valid.  */1         if ( inbuf[0] != '(' && inbuf[0] != '.' ) H           printf("column one must have ( for quintuple or . to quit\n");%         else if ( strlen(inbuf) < 6 ) 8           printf("quintuples must have 5 characters\n");         else           { #           strncpy(quint,inbuf+1,5); !           if ( inbuf[6] != '\0' ) !             strcpy(cmmt,inbuf+6);            else             cmmt[0] = '\0'; / /*    add the quintuple, signal on error     */ :           if ( new_quint(ql, quint,cmmt,&status) == NULL )"             message(quint,status);           if ( ch == EOF )             break;           } 	         }        }      main (int argc, char* argv[])        {   I       struct qlist alist;          /* the quintuple list               */ I       struct tape  tp;             /* the turing machine tape          */ I       struct maclist mlist;        /* a macro buffer                   */   "       struct qlist *lptr = &alist;       struct tape  *tptr = &tp; $       struct maclist *mptr = &mlist;  F       int status;       /* returned by some routines to signal successN                            or failure.  See TM.H for possible status values.*/         char buff[80];  @ /* function prototypes*****************************************/9       void read_tm_file(/*char*, struct qlist*, int* */); #       void message(/*char*, int*/); !       void init_help(/*char* */);         void get_help(/*char* */);%       void getcmd(/*char*, char* */); #       int iscmd(/*char*, char* */);        int morecmd();'       void flushcmd(/*char*, char* */); B       void set(/*struct qlist*, struct tape*, struct maclist* */);#       void add(/*struct qlist* */); &       void cancel(/*struct qlist* */);C       void show(/*struct qlist*, struct tape*, struct maclist* */); 2       void list_quints(/* struct qlist*, int* */);8       void step(/*struct qlist*, struct tape*, int* */);6       void go(/*struct qlist*, struct tape*, int* */);.       void show_tape(/*struct tape*, int* */);/       void run_mac(/*struct maclist*, int* */); )       void move(/*struct tape*, int* */); )       void edmacro(/*struct maclist* */);   ; /******** Executable code:  ******************************/   G       lptr->root = NULL;                /* pointer to quintuple list */ O       tptr->head = tptr->root = NULL;   /* pointer to tape and the tape head */ M       tptr->leftend = NULL;             /* pointer to left end of the tape */ C       mptr->root = NULL;                /* pointer to macrolist  */ O       lastquint = NULL;                 /* for displaying last executed quint*/ N       nextquint = NULL;                 /* for displaying next quint to use */  H       printf( "         TM 1.3 --  Turing machine interpreter.\n  Enter\  'help' for help.\n");  -       strcpy(filename,"(none selected yet)");          if (argc == 2)	         { +         read_tm_file(argv[1],lptr,&status);          if ( status != OK ) "           message(argv[1],status);         else#           strcpy(filename,argv[1]); 	         }   =       init_help("tm_hlp:tm.hlp");    /* read the help file */    /* main program loop */          while(1)	         {          getcmd("tm> ",ans);   9         if ( ans[0] == 0 );     /* flush invalid input */ <         else if ( iscmd (ans,"exit") || iscmd (ans,"quit") )           break;&         else if (iscmd (ans,"en*ter"))G           enter(lptr);                   /*primitive quintuple editor*/ $         else if (iscmd (ans,"se*t"))           set(lptr,tptr,mptr);$         else if (iscmd (ans,"ad*d"))=           add(lptr);                      /*add a quintuple*/ &         else if (iscmd(ans,"ca*ncel"))B           cancel(lptr);                   /*cancel a break point*/%         else if (iscmd (ans,"sh*ow"))            show(lptr,tptr,mptr); %         else if (iscmd (ans,"l*ist"))            { A           list_quints(lptr, &status);     /*show the quintuples*/            if ( status != OK )              message("",status);            } %         else if (iscmd (ans,"st*ep"))            { M           step(lptr,tptr,&status);        /*perform some machine executions*/            if ( status != OK )              message("",status);            } "         else if (iscmd (ans,"go"))           { A           go(lptr,tptr,&status);           /*execute till halt*/  ;           if ( status == HALTED_FINAL || status == HALTED ) 
             {              buff[0]=tm_state;              buff[1]='\0'; !             message(buff,status); 
             } )           else if ( status == SHOW_TAPE ) O             show_tape(tptr,&status);       /*if display of tape was requested*/ "           else if ( status != OK )             message("",status);            } B         else if ( iscmd (ans,"run") )     /*run the stored macro*/           { O           run_mac(mptr, &status);      /* pushes the macro onto command stack*/            if ( status != OK )              message("",status);            } )         else if ( iscmd (ans,"del*ete") ) J           dele(lptr);                    /* delete one or all quintuples*/%         else if (iscmd (ans,"m*ove"))            { K           move(tptr, &status);          /* move the tape head on the tape*/            if ( status != OK )              message("",status);            } %         else if (iscmd (ans,"re*ad")) C           read_file(lptr,mptr);        /* read a mac or a tm file*/ &         else if (iscmd (ans,"wr*ite"))D           write_file(lptr,mptr);       /* write a mac or a tm file*/(         else if (iscmd (ans,"ed*macro"));           edmacro(mptr);                /* edit the macro*/ #         else if (iscmd (ans,"say"))            { #           getcmd("say what? ",ans);            printf("%s\n",ans);            } 9         else if ( iscmd(ans,"?") || iscmd (ans,"h*elp") )            { M           strcpy(buff,"tm");     /* create the string to send to help prog.*/            while (morecmd() > 0) 
             {              strcat(buff," ");              getcmd("",ans);              strcat(buff,ans); 
             } 3           get_help(buff);   /* call help program */            }          else>           flushcmd("invalid or ambiguous tm command -> ",ans);	         }        }   