$ #include <stdio.h>    /* for NULL */ #include <string.h> ( #include <ctype.h>    /* for isdigit  */& #include <stdlib.h>   /* for calloc */< /***********************************************************   Written by:   E       David S. Woodruff,  MIT Lab for Nuclear Science,  (617)253-6943 E       dsw@mitlns.mit.edu,     BITnet: dsw@mitlns    FAX (617)258-6923 G ***********************************************************************   M A set of routines for processing a stream of tokens and strings from standard 5 input.  The stream is stored in a queue (fifo stack).   H Contains the following routines.  See also the comments in the routines.  ( void getcmd(char *prompt, char *retword)D                  'prompt' - string issued if command queue is empty.H                  'retword' - word or string returned from commmand queueL    Maintains a queue (fifo stack) of tokens.  The front token is returned asK    'retword'.  If the queue is empty, prints the 'prompt', and uses getword (    to get 'retword' from standard input.  % int getint(char *prompt, int *retnum) H                 'prompt' - string printed if the command queue is empty.B                 'retnum' - number returned from the command queue.J    Use this to prompt for an integer.  Function value is 1 if a number hasL    been entered, 0 if user has entered an 'exit'.  In the latter case retnum    is undefined.  + int getdouble(char *prompt, double *retnum) H                 'prompt' - string printed if the command queue is empty.B                 'retnum' - number returned from the command queue.M    Use this to prompt for a real number.  Function value is 1 if a number has L    been entered, 0 if user has entered an 'exit'.  In the latter case retnum    is undefined.  $ int iscmd (char *entered, char *cmd)D                  'entered' - a token accepted from the getcmd queue.G                  'cmd' - the string against which 'entered' is checked. J    Returns 1 if 'input' is the same as 'cmd', else returns 0.  Will accept;    abbreviations.  See the comments with iscmd for details.   ) void flushcmd(char *warning, char *about) 9                  'warning' - optional string for printing >                  'about' - second optional string for printingI    Removes everything on the command queue and prints a 'warning' 'about' 
    something.    int morecmd()       >    Returns the number of commands that remain to be processed.   int getifint(int *retnum) K                 'retnum' - number to be returned from the command queue, if 0                            there was an integer.J    Use this to get an optional integer.  Function value is 1 if an integer+    was at the front of the queue, else 0.   /       Example of use.  Compare the two streams:            'set value do next job'#          'set value 10 do next job' H    getifint would be used after 'value' is accepted to set a value to 10I    if the second stream is entered, or do nothing if the first stream is  I    entered.  User could supply a default integer if the returned function     value was 0.   % int getifcmd(char *cmd, char *cmdstr) G                 'cmd'  -  string to be returned from the command queue, (                           if it is there+                 'cmdstr' - returned string. F    Tests the command queue to see if the next command is 'cmd'.  If itF    is, it is removed from the queue and returned in 'cmdstr', and the J    function value is 1.  If it is not, 'cmdstr' is undefined, and function    value is 0.       Example of use: L         'set trace' and 'set no trace'.  getifcmd would be used to detect ifE    the word after 'set' was 'no', with no effect on the word 'trace'. G    'cmd' may be abbreviated.  See the comments in routine iscmd for how     abbreviation is handled.    void pushcmd(char *cmd) ?                  'cmd' - a command to be returned to the queue. F    Puts 'cmd' at the front of the queue.  Used for filling the commandE    stack from the program, and for returning commands that should be  -    used during the next invocation of getcmd.    void showcmd(char *strn)2                  'strn' - something to be printed.H    Use this for debugging purposes.  It reports the commands that remainF    to be processed, and the value of the command pointer and the queue    top pointer.    int getword(char *token)G                  'token' - word or string returned from standard input.     Used by getcmd.' **************************************/    /* for getcmd routines */ N #define CMDBUFFSIZE 80    /* maximum number of commands that can be stored. */N #define WORDSIZE    80    /* is big, because it might need to handle strings*/  " static char *cmdbuff[CMDBUFFSIZE];B static int cmdptr = 0;     /* next token to return from cmdbuff */? static int topptr = -1;    /* top token location on cmdbuff  */ H static int firstcall = 1;  /* initialize command buffer at first call */     void move_queue() C /* used in getcmd and pushcmd to relocated the command queue to the     bottom of the stack.  */        {                        void *calloc();        int newptr=0;        while (cmdptr <= topptr)         {   $         if (cmdbuff[newptr] == NULL)?           {  /* probably never used-- since queue is at the top I                 all of the memory must have been allocated already.    */ C           cmdbuff[newptr] = (char *) calloc(WORDSIZE,sizeof(char)); &           if (cmdbuff[newptr] == NULL)
             { N             printf("getcmd:  Input not accepted: memory allocation error.\n");             return; 
             }            } 2         strcpy( cmdbuff[newptr], cmdbuff[cmdptr]);         newptr++;          cmdptr++; 	         }        cmdptr = 0;        topptr = newptr - 1;       }     + void flushcmd(char *warning, char *about)   + /*clear the command stack.  Issue message*/        { &       printf("%s %s\n",warning,about);       topptr = -1;       cmdptr = 0;        }    int morecmd()       @ /* returns the number of commands that remain to be processed */       {        return(topptr-cmdptr+1);       }      void showcmd(char *strn)J /* use this for debugging.  'strn' is used to print out information about,C         for example, where the call to showcmd was placed.       */        {        int i;F       printf("getcmd: %s: cmdptr=%d, topptr=%d\n",strn,cmdptr,topptr);$       for (i=cmdptr; i<=topptr; i++)(         printf("   -- %s\n",cmdbuff[i]);       }     ( void getcmd(char *prompt, char *retword)D /* Returns string 'retword' from a queue of tokens.  If there are noI    tokens, it issues the string 'prompt' as a prompt and waits for input. H    Given input, it places each input token into the queue in fifo order.  J    'topptr' points to the back of the queue, and is incremented every timeL    a new command is entered.  'cmdptr' points to the front of the queue, and4    is incremented every time a command is processed.   I    getword, which is called by this routine,  pushes a string with white  F    space on the queue if a token starts with a double quote.  All the C    following characters are accepted until the next double quote.   O    Processing halts only if white space is encounterd after a new double quote.      ;    Pushes 'exit' on the queue if a ^Z is entered (for VMS).  */       {        int getword(char*);        int retnum;        char strbuf[WORDSIZE];       int i;  G /* memory for commands is allocated when needed and then never freed.   G    Number of allocations never exceeds CMDBUFFSIZE.   On the first call E    to getcmd or pushcmd we initialize pointers to this memory.     */          if (firstcall)	         { '         for ( i=0; i<CMDBUFFSIZE; i++ )            cmdbuff[i] = NULL;         firstcall = 0;	         }   I       if (cmdptr > topptr)   /* command buffer is empty, get some input*/ 
         {              topptr = -1;         cmdptr = 0;          printf("%s",prompt);/         while ( (retnum=getword(strbuf)) != 0 )            { =           if (retnum == -1)     /* ^Z was entered (for VMS)*/ 
             { #             strcpy(retword,"exit");              return; 
             } O           if (topptr >= CMDBUFFSIZE - 1)  /* commands have reached stack top */ 
             { O             if (cmdptr > 0)    /* see if any space is available at the bottom*/ D               move_queue();    /* if so, then move the queue down.*/C             else   /* no space is available in the command stack */                { O             printf("getcmd: command buffer too full.  Increase CMDBUFFSIZE\n");                return;                } 
             } G           topptr++;    /* there is room for the command on the stack */ &           if (cmdbuff[topptr] == NULL)
             { E             cmdbuff[topptr] = (char *) calloc(WORDSIZE,sizeof(char)); (             if (cmdbuff[topptr] == NULL)               { J               printf("getcmd:  Not accepted: memory allocation error.\n");               return;                } 
             } 3           strncpy(cmdbuff[topptr],strbuf,WORDSIZE);            } 	         }   :       if (topptr == -1)  /* entered a <cr>, for example.*/	         {          strcpy(retword,"");          return; 	         }   P /* once we are here, we know that there is one or more commands in the buffer.*/  &       strcpy(retword,cmdbuff[cmdptr]);       cmdptr++;        }          void pushcmd(char *cmd) E /* A command is returned to the token queue by the calling program.*/        {        int i;         if (firstcall)	         { '         for ( i=0; i<CMDBUFFSIZE; i++ )            cmdbuff[i] = NULL;         firstcall = 0;	         }   N       if (topptr >= CMDBUFFSIZE - 1 )  /* queue is moving out of stack space*/	         { K         if (cmdptr > 0)    /* see if any space is available at the bottom*/ J           move_queue();    /* if so, move the queue to the stack bottom */@         else   /* no space is available in the command stack. */           { O         printf("pushcmd: command buffer is too full. Increase CMDBUFFSIZE.\n");            return;            } 	         }   E       topptr++;  /* there is room on the stack for the new command */   "       if (cmdbuff[topptr] == NULL)	         { A         cmdbuff[topptr] = (char *) calloc(WORDSIZE,sizeof(char)); $         if (cmdbuff[topptr] == NULL)           { K           printf("getcmd:  Word not accepted: memory allocation error.\n");            return;            } 	         }   J /* the pushed command goes to the front of queue:  move the queue back and(    insert the command at the front.   */#       for (i=topptr; i>cmdptr; i--) )         strcpy(cmdbuff[i], cmdbuff[i-1]); "       strcpy(cmdbuff[cmdptr],cmd);       }     % /* int iscmd (char *input, char *cmd)   @    Returns 1 if 'input' is equal to 'cmd' up to an abbreviation.I    If any characters in 'input' differ from those in cmd, except for '*',          returns 0.F    If characters match, but input is shorter than cmd location of '*',         ambiguous, returns 0. <    If characters match at least up to '*' in cmd, returns 1.      Examples:  C      iscmd(ans,"exit")  returns 1 if ans is "exit", else returns 0.   I      iscmd(ans,"ex*it") returns 1 when ans is "ex", "exi" or "exit", else D                             returns 0  (e.g., for "exity", "e", "ey"    */ " int iscmd (char *input, char *cmd)       {        int i,j,foundstar=0;         i = j = -1;          while(1)	         {          i++;         j++;A         if ( input[i] == '\0' && ( cmd[j] == '\0' || foundstar) )            return(1);         if (input[i] != cmd[j])            { *           if (cmd[j] == '*' && !foundstar)
             {              i--;             foundstar = 1;
             }            else             return(0);           } 	         }        }     K /************************************************************************** +       getch, ungetch      used in 'getword'   E       Read standard input a character at a time.  Keep each character 6 that is read in a lifo stack so that it can be reread.  )       Adopted from Kernighan and Ritchie.   M ****************************************************************************/    #define STKSIZE 103 char buf[STKSIZE];    /*buffer for the characters*/ ' int bufp = 0;         /*stack pointer*/    char getch()       { 2       return( (bufp>0) ? buf[--bufp] : getchar());       }    char ungetch(int c)        {        if (bufp > STKSIZE) N         printf("getcmd:  ungetch:  too many characters.  Increase STKSIZE\n");
       else         buf[bufp++]=c;
       return;        }   I /************************************************************************ &       getword           used by getcmd       1 Return a token or a string from standard input.     L A 'token' is anything delimited by white space.  'Strings' are delimited  byK double quotes.  In a string, If a second quote is followed by white space,  M terminate the string, else accept second quote.  Only if a quote is followed  ( by white space is the string terminated.  F Commas and semicolons are ignored unless they are internal to strings.        Returns:  (         -1 - found ^Z   (useful for VMS)         1 -- on success          0 -- no word found  I ************************************************************************/     C int getword(char *token)     /* gets 'token' from standard input */        { 
       char c;        int retflag=0; /* move past white space*/?       while ( (c=getch())==' ' || c=='\t' || c==',' || c==';');          if (c==10)  7         return(0);   /* encountered newline character*/        else if (c==-1) 3         return(-1);   /* encountered ^Z (for VMS)*/  /*      else if (c=='\\') 6         c=getch();        ignore the next character */   /* string mode:   */       if ( c == '\"' )         while(1)           {            retflag=1;           c = getch();           if ( c!= '\"' )              *token++ = c; G           else           /* see if the " is followed by white space. */ 
             {              c = getch();M             if ( (c==' ') || (c=='\t') || (c=='\n') || (c==',') || (c==';'))                 break;             else               {                *token++ = '\"';               ungetch(c);                } 
             }            }  /* word mode:     */       else      6         while( c!='\n' && c!=' ' && c!=',' && c!=';' )           {            retflag=1;           *token++ = c;            c=getch();           } P       *token='\0';                 /* end of the token.  Terminate the string.*/       ungetch(c);        return (retflag);          }       # /* prompt the user for an integer.    J       Returns:   1 if an integer was entered, then 'response' is the valueI                  0 if 'exit' was entered, then 'response' is not defined.  */' int getint(char *prompt, int *response)        {        int atoi();        char ans[WORDSIZE];        int i,length;        int okay;          while(1)	         {          getcmd(prompt,ans); 1         if (iscmd(ans,"exit") || iscmd(ans,".") )            return(0);         length = strlen(ans);          okay = 1; H         if ( !isdigit(ans[0]) && ans[0] != '-' )  /* check for - sign */           okay = 0;           for (i=1; i<length; i++)!           if ( !isdigit(ans[i]) )              okay = 0;          if (okay)            {             *response = atoi(ans);           return(1);           }          else*           flushcmd("need an integer.","");	         }        }   1 /* prompt the user for an floating point number.    I       Returns:   1 if an double was entered, then 'response' is the value I                  0 if 'exit' was entered, then 'response' is not defined.  */- int getdouble(char *prompt, double *response)        {        char ans[WORDSIZE];        int i,length;        int okay;        double atof();         while(1)	         {          getcmd(prompt,ans); 1         if (iscmd(ans,"exit") || iscmd(ans,".") )            return(0);         length = strlen(ans);          okay = 1;           for (i=0; i<length; i++)N           if ( !isdigit(ans[i]) && ans[i]!='.' && ans[i]!='+' && ans[i]!='-' )             okay = 0;          if (okay)            {             *response = atof(ans);           return(1);           }/         else(           flushcmd("need a number.","");	         }i       }t    N /*  If next word on the command queue is an integer, returns it, else puts the#     word back on the command stack..K         function value:   1  word is an integer and is returned in 'retnum'tL                           0  word is not an integer.  'retnum' is undefined,I                               and word is made available for next getcmd.c */ int getifint(int *retnum)t       {m       int atoi();        char ans[WORDSIZE];u       int isint,i,length;i  G       if (morecmd() == 0)  /* there is nothing on the commnand stack */g         return(0);         getcmd("",ans);        length = strlen(ans);e       isint = 1;       for (i=0; i<length; i++)         if ( !isdigit(ans[i]) )f           isint = 0;       if (isint)	         {k         *retnum = atoi(ans);         return(1);	         }I
       else	         {r         pushcmd(ans);u         return(0);	         }d       }a      I /*  If next word on the command queue is 'cmd', returns it, else puts the-L     word back on the command stack.  'cmd' may be abbreviated... see routine,     iscmd for how abbreviations are handled.  L         function value:   1  if 'cmd' was on the command stack-- returned in(                               'queuword'O                           0  if 'cmd' was not on the command stack--'queuword' e,                                is undefined. */' int getifcmd(char *cmd, char *queuword) %       {                              h       char ans[WORDSIZE];i       int i,j,foundstar=0;  +       if (morecmd() == 0 || cmd[0] == '\0')e5         return(0);     /* there is nothing to test */t         getcmd("",ans);e       j = i = -1;        while(1)	         {          j++;         i++;?         if (ans[i] == '\0' && (cmd[j] == '\0' || foundstar) )  -8           {       /* all the characters were the same */           strcpy(queuword,ans);m           return(1);           }          if (cmd[j] != ans[i] )           {fH           if (cmd[j] == '*' && !foundstar)       /* for abbreviations */
             {o             i--;             foundstar = 1;
             }n           else
             {              pushcmd(ans);e6             return(0);      /* the strings differed */
             }o           } 	         }s       } 