/**/
/******************************************************************************/
/**                                                                          **/
/**  Copyright (c) 1995                                                      **/
/**  by DIGITAL Equipment Corporation, Maynard, Mass.                        **/
/**                                                                          **/
/**  This software is furnished under a license and may be used and  copied  **/
/**  only  in  accordance  with  the  terms  of  such  license and with the  **/
/**  inclusion of the above copyright notice.  This software or  any  other  **/
/**  copies  thereof may not be provided or otherwise made available to any  **/
/**  other person.  No title to and ownership of  the  software  is  hereby  **/
/**  transferred.                                                            **/
/**                                                                          **/
/**  The information in this software is subject to change  without  notice  **/
/**  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  **/
/**  Corporation.                                                            **/
/**                                                                          **/
/**  DIGITAL assumes no responsibility for the use or  reliability  of  its  **/
/**  software on equipment which is not supplied by DIGITAL.                 **/
/**                                                                          **/
/******************************************************************************/
/********************************************************************************************************************************/
/* Created:  4-MAY-1995 18:45:32 by OpenVMS SDL EV1-36     */
/* Source:   6-MAY-1993 15:21:04 $64$DUA3210:[LIB_H.SRC]IHDDEF.SDL;1 */
/********************************************************************************************************************************/
/*** MODULE $IHDDEF ***/
#ifndef __IHDDEF_LOADED
#define __IHDDEF_LOADED 1
 
#pragma __nostandard			 /* This file uses non-ANSI-Standard features */
#pragma __member_alignment __save
#pragma __nomember_alignment
 
#ifdef __cplusplus
    extern "C" {
#define __unknown_params ...
#else
#define __unknown_params
#endif
 
#if !defined(__VAXC)
#define __struct struct
#define __union union
#else
#define __struct variant_struct
#define __union variant_union
#endif
 
/*+                                                                         */
/* IMAGE HEADER RECORD DEFINITIONS - FIRST RECORD OF IMAGE HEADER           */
/*-                                                                         */
#define IHD$K_MAJORID 12848             /* Major id value                   */
#define IHD$K_MINORID 13616             /* Minor id value                   */
#define IHD$K_EXE 1                     /* Executable image                 */
#define IHD$K_LIM 2                     /* Linkable image                   */
#define IHD$M_LNKDEBUG 0x1
#define IHD$M_LNKNOTFR 0x2
#define IHD$M_NOP0BUFS 0x4
#define IHD$M_PICIMG 0x8
#define IHD$M_P0IMAGE 0x10
#define IHD$M_DBGDMT 0x20
#define IHD$M_INISHR 0x40
#define IHD$M_IHSLONG 0x80
#define IHD$M_MATCHCTL 0x7000000
#define IHD$K_LENGTH 48                 /* Length of fixed area             */
#define IHD$C_LENGTH 48                 /* Length of fixed area             */
#define IHD$C_MINCODE -1                /* Low bound of ALIAS values        */
#define IHD$C_NATIVE -1                 /* Native mode image                */
#define IHD$C_RSX 0                     /* RSX image produced by TKB        */
#define IHD$C_BPA 1                     /* BASIC plus analog                */
#define IHD$C_ALIAS 2                   /* Last 126 bytes contains ASCIC of image to activate */
#define IHD$C_CLI 3                     /* Image is a CLI, run LOGINOUT     */
#define IHD$C_PMAX 4                    /* PMAX system image                */
#define IHD$C_ALPHA 5                   /* ALPHA image                      */
#define IHD$C_MAXCODE 5                 /* High bound of ALIAS values       */
/*                                                                          */
#define IHD$C_GEN_XLNKR 1               /* Cross linker                     */
#define IHD$C_GEN_NATIVE 2              /* First native mode image header.  */
/*  does not have LNKFLAGS, SYSVER and IAFVA fields                         */
#define IHD$C_GEN_LNKFLG 3              /* Native with LNKFLAGS longword added */
/*  does not have SYSVER and IAFVA fields                                   */
#define IHD$C_GEN_SYSVER 4              /* Native with LNKFLAGS and SYSVER added */
/*  does not have IAFVA field                                               */
#define IHD$C_GEN_FIXUP 5               /* Version III image                */
/*  contains LNKFLAGS, SYSVER, and IAFVA fields                             */
#define IHD$C_GEN_NEWISD 6              /* ISD size field is a byte         */
#define IHD$S_IHDDEF 512                /* Old size name - synonym          */
typedef struct _ihd {
    unsigned short int ihd$w_size;      /* Size in bytes of Image Header record  */
    unsigned short int ihd$w_activoff;  /* Byte offset to activation data   */
    unsigned short int ihd$w_symdbgoff; /* Byte offset to symbol table and debug data  */
    unsigned short int ihd$w_imgidoff;  /* Byte offset to image ident data  */
    unsigned short int ihd$w_patchoff;  /* Byte offset to patch data        */
    unsigned short int ihd$w_version_array_off; /* Byte offset to version number array */
    unsigned short int ihd$w_majorid;   /* Major id                         */
    unsigned short int ihd$w_minorid;   /* Minor id                         */
    unsigned char ihd$b_hdrblkcnt;      /* Count of header blocks           */
    unsigned char ihd$b_imgtype;        /* Image type                       */
/*                                                                          */
/* IMAGE TYPE CODES                                                         */
/*                                                                          */
    short int ihddef$$_fill_2;          /* Reserved                         */
#ifdef __ALPHA
    unsigned __int64 ihd$q_privreqs;    /* Requested privilege mask         */
#else
    unsigned   int   ihd$q_privreqs[2]; /* Requested privilege mask         */
#endif
    unsigned short int ihd$w_iochancnt; /*! of channels requested           */
/*0 if default                                                              */
    unsigned short int ihd$w_imgiocnt;  /*! of pages of image i/o section requested  */
/*0 if default                                                              */
    __union  {
        unsigned int ihd$l_lnkflags;    /* Linker produced image flags      */
        __struct  {
            unsigned ihd$v_lnkdebug : 1; /* Full debugging requested        */
            unsigned ihd$v_lnknotfr : 1; /* First transfer address missing  */
            unsigned ihd$v_nop0bufs : 1; /* RMS use of P0 for image i/o disabled  */
            unsigned ihd$v_picimg : 1;  /* Image is position independent    */
            unsigned ihd$v_p0image : 1; /* Image is in P0 space only        */
            unsigned ihd$v_dbgdmt : 1;  /* Image header has dmt fields      */
            unsigned ihd$v_inishr : 1;  /* Transfer array contains valid IHA$L_INISHR */
            unsigned ihd$v_ihslong : 1; /* Longword DSTBLKS and GSTRECS valid in IHS$ */
            unsigned ihddef$$_fill_3 : 16; /*FILL OUT TO HIGH BYTE OF LONG WORD */
            unsigned ihd$v_matchctl : 3; /* Match control for linkable image */
            unsigned ihd$v_fill_0 : 5;
            } ihd$r_lnkflags_bits;
        } ihd$r_lnkflags_overlay;
    unsigned int ihd$l_ident;           /* GBL SEC ident value for linkable image  */
    unsigned int ihd$l_sysver;          /* SYS$K_VERSION or 0 if not linked with exec  */
    void *ihd$l_iafva;                  /* Relative virtual address of fixup info  */
    char ihd$t_skip [462];              /* ALIAS should be last word in 512 byte block */
    unsigned short int ihd$w_alias;     /* Code to use secondary image name */
/******************************************                                 */
/*                                                                          */
/*  Define legal range of ALIAS constants. MINCODE must be equal to the     */
/*	lowest value and MAXCODE must be equal to the highest value.        */
/*                                                                          */
/*******************************************                                */
/*                                                                          */
/*	Generation number returned by IMGSHR IMG$GET_IHD to SYSIMGACT.      */
/*	These do not appear in the image header but are inferred from the   */
/*	contents of the image header                                        */
/*                                                                          */
    } IHD;
 
#if !defined(__VAXC)
#define ihd$l_lnkflags ihd$r_lnkflags_overlay.ihd$l_lnkflags
#define ihd$r_lnkflags_bits	ihd$r_lnkflags_overlay.ihd$r_lnkflags_bits
#define ihd$v_lnkdebug ihd$r_lnkflags_bits.ihd$v_lnkdebug
#define ihd$v_lnknotfr ihd$r_lnkflags_bits.ihd$v_lnknotfr
#define ihd$v_nop0bufs ihd$r_lnkflags_bits.ihd$v_nop0bufs
#define ihd$v_picimg ihd$r_lnkflags_bits.ihd$v_picimg
#define ihd$v_p0image ihd$r_lnkflags_bits.ihd$v_p0image
#define ihd$v_dbgdmt ihd$r_lnkflags_bits.ihd$v_dbgdmt
#define ihd$v_inishr ihd$r_lnkflags_bits.ihd$v_inishr
#define ihd$v_ihslong ihd$r_lnkflags_bits.ihd$v_ihslong
#define ihd$v_matchctl ihd$r_lnkflags_bits.ihd$v_matchctl
#endif		/* #if !defined(__VAXC) */
 
 
#pragma __member_alignment __restore
#ifdef __cplusplus
    }
#endif
#pragma __standard
 
#endif /* __IHDDEF_LOADED */
 
