  r /*****************************************************************************************************************  C  Program:	SIXEL_DEAMON		Print a sixel screen dump on an HP LaserJet    Module:	SIXEL_DEAMON	(the root)"  Author:	Nick de Smith	August 1989R 		Applied Telematics Group, 7 Vale Avenue, Tunbridge Wells, Kent TN1 1DJ, England.( 		+44 892 511000, PSI%234213300154::NICK
  Description: _  This program is designed to run as a detached process in a DECwindows or VWS etc. environment. o  The program creates a mailbox, called SIXEL_DEAMON. If you select the session manager "Customise Print Screen" h  menu, and then change the output format to SIXEL, and the output file name to "SIXEL_DEAMON:" (note thel  trailing ":"), then when you CAPTURE portions of the screen with the session manager "Print Screen" option,5  the sixel output will be redirected to this program.   n  This program will convert any current sixel format output into a format acceptable to an HP LaserJet printer.q  Once the format has been converted, the file is queued to the specified VMS print queue (by default, SYS$LASER). Q  Change the definition of the QUEUE_NAME constant below to change the queue name.   i  The SYS$LASER queue can be the implemented with the PSM_LASER symbiont in the [.LASER] directory in this   distribution .   *  The program requires elevated privileges:  & 	PRMMBX		to create a permanent mailbox4 	SYSNAM		to put the mailbox name in the system tableb 	WORLD		to be able to determine the username of a PID so we can find the user sending us the file.h 	SYSPRV		to read the UAF records of users who queue data to this program so we can determine SYS$SCRATCHY 	BYPASS		to create the temporary files in the SYS$SCRATCH directories of the above users. ^ 	EXQUOTA		to be able to always create the HP file (its deleted after printing, so who cares!).' 	TMPMBX		to talk to the job controller.   J  Copyright (c) 1989 by Applied Telematics Group Limited and Nick de Smith.m  This software is supplied for information only. No guarantee is supplied for this software, and no liability m  will be accepted for any action resulting from the use of this software or the information contained herein. i  Under no circumstances may this software be used for commercial gain, including its sale, lease or loan. N  This software may be copied only with the inclusion of this copyright notice.f  The author is prepared to enter into correspondance with interested parties, but will not necessarily8  maintain this software. Having said all that, enjoy it!    Edit	Edit date	By	Reason a   02	28-Nov-89	NMdS	A few fixes. Change name to SIXEL_DEAMON as it is not specific to DECwindows. !   01	21-Aug-89	NMdS	First attempt   r *****************************************************************************************************************/   #module		SIXEL_DEAMON	"V01.02"  . #include	descrip							/* VMS descriptors			*/. #include	iodef							/* I/O control flags			*/9 #include	jpidef							/* Job/Process information flags	*/ 2 #include	psldef							/* Process status flags			*/* #include	rms							/* RMS definitions			*/4 #include	ssdef							/* VMS system status values		*/3 #include	stsdef							/* VMS system statii bits		*/   : #include	"sjcdef.h"						/* Job controller definitions		*/< #include	"uafdef.h"						/* SYSUAF.DAT format definition		*/3 #include	"uaidef.h"						/* $GETUAI item codes			*/   G #define	QUEUE_NAME	"SYS$LASER"					/* Name of queue to spool file to	*/ J #define	MAILBOX_NAME	"SIXEL_DEAMON"					/* Name for the mailbox to use		*/L #define	FILE_NAME	"SIXEL_DEAMON.DAT"				/* Name to use for HP format file	*/  = #define	MBX_MSGMAX	1024						/* Maximum size of a message		*/ K #define	MBX_BUFQUO	(MBX_MSGMAX * 10)				/* Ammount of buffering to allow	*/ 5 static	short	w_mbx_chan;						/* Mailbox channel			*/ 9 static	long	l_mbx_efn;						/* Mailbox I/O event flag		*/ ; static	long	l_sender_pid;						/* PID of message sender		*/ T static	struct	dsc$descriptor_d x_file_name = {			/* Incoming mailbox message data	*/' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0 }; 2 static struct FAB fab;							/* RMS FAB block			*/2 static struct NAM nam;							/* RMS NAM block			*/2 static struct RAB rab;							/* RMS RAB block			*/  < typedef	struct ITEM_LIST {						/* General VMS item list		*/ 	short	w_buffer_length;  	short	w_item_code;  	long	l_buffer_address;   	long	l_returned_length_address; } ITEM_LIST, *ITEM_LIST_PTR;  + /* Macro to check returned system status	*/   ! #define	ss_check( command ) {			\  	long status = (command);		\) 	if ( (status & STS$M_SUCCESS) == 0 ) {	\  		return status;			\ 	}					\ }     r /*****************************************************************************************************************   					S I X E L _ D E A M O N  5  Main routine for the Sixel-to-HP conversion program. &  The logic is fairly straight forward:   	1.  Create a permanent mailbox & 	2.  Wait for a message in the mailbox_ 	3.  Determine the USERNAME of the sender of the message, then work out their scratch directory 9 	    name so that we can create files in the right place.  	4.  Open the scratch file 	5.  Output initial HP commands  	6.  Initialise the scanner   	7.  Process the mailbox messageB 	8.  Read a new message. If it is not an end-of-file, goto step 7. 	9.  Flush any pending output  	10. Output final HP commands  	11. Close the file  	12. Queue the file. 	13. Goto step 2  4  The escape sequences sent to the HP are as follows:  \  	<esc>*t<num>R		Set DPI for printing. The LaserJet resolution is 300dpi both vertically andO 				horizontally. Allowable values for <num> are 75,100,150 and 300. We use 100 Q 				as things from a 15" or 19" workstation come out nicely. You may change this. 3 	<esc>&a0C		Start printing graphics at left margin.  	<esc>*r1A		Start graphics. " 	<esc>*b<byte-count>W<byte-stream>< 				A single pixel line of byte-count bytes (in byte-stream) 	<esc>*rB		End of graphics  r *****************************************************************************************************************/   SIXEL_DEAMON() { N 	struct	dsc$descriptor_s x_mbx_data = {				/* Incoming mailbox message data	*/' 		0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0 }; W 	$DESCRIPTOR( x_hp_initial, "\x1B*t100R\x1B&a0C\x1B*r1A" );	/* Initial HP commands			*/ C 	$DESCRIPTOR( x_hp_final  , "\x1B*rB" );				/* Final   ''   ''			*/ / 	void	OUTPUT_LINE();						/* Output a line			*/   D 	ss_check( Create_Mailbox() )					/* Create the spooling mailbox		*/  # 	for (;;) {							/* For ever				*/ P 		ss_check( Read_MBX_Message( &x_mbx_data ) )		/* Wait for the first message		*/I 		ss_check( Find_File_Name() )				/* Find the name to use for the file	*/ : 		ss_check( Open_File() )					/* Open the scratch file		*/D 		OUTPUT_LINE( &x_hp_initial );				/* Output initial HP commands		*/3 		SIXEL_RESET();						/* Reset the sixel parser		*/  		do {D 			SIXEL_PARSE_STRING( &x_mbx_data );		/* Parse the sixel string		*/> 		} while ( Read_MBX_Message( &x_mbx_data ) & STS$M_SUCCESS );9 		SIXEL_FLUSH();						/* Flush the sixel parser and...	*/ @ 		OUTPUT_LINE( &x_hp_final );				/* Output final HP commands		*/4 		ss_check( Close_File() )				/* Close the file			*/D 		ss_check( Queue_File_To_Printer() )			/* ...send the file off			*/ 	}			   8 	return SS$_NORMAL;						/* Return success to caller		*/ }     r /*****************************************************************************************************************    					C r e a t e _ M a i l b o x  n  Create the mailbox to be used for I/O. Make it permanent, marked for deletion so that if we crash, it will go  away.  r *****************************************************************************************************************/ static Create_Mailbox() { L 	$DESCRIPTOR( x_mbx_name, MAILBOX_NAME );			/* Name of mailbox to create		*/  6 	ss_check( LIB$GET_EF (						/* Get an event flag			*/; 		&l_mbx_efn ) )						/* Event flag number returned here	*/   9 	ss_check( SYS$CREMBX(						/* Create logging mailbox		*/ ' 		1		,					/* Mailbox is permanent			*/ 7 		&w_mbx_chan	,					/* Channel number returned here		*/ 2 		MBX_MSGMAX 	,					/* Maximum size of message		*/) 		MBX_BUFQUO	 ,					/* Buffer quota				*/ " 		0		,					/* Protection mask			*/+ 		PSL$C_USER	,					/* User mode access			*/ + 		&x_mbx_name	) )					/* Mailbox name				*/   ? 	ss_check( SYS$DELMBX(						/* Mark the mailbox for deletion	*/  		w_mbx_chan	) )  8 	return SS$_NORMAL;						/* Return success to caller		*/ }     r /*****************************************************************************************************************  $ 					R e a d _ M B X _ M e s s a g e  K  Read a message from the mailbox. Return the message and the system status.   r *****************************************************************************************************************/ static Read_MBX_Message( E 	struct dsc$descriptor_s	*ax_message	)			/* Returned message read		*/  { 4 	long	sys_status;						/* Returned system status		*/> 	static	char	t_buffer[ MBX_MSGMAX ];				/* Message buffer			*/	 	struct { , 		short	w_status;					/* Status of $QIO			*/6 		short	w_byte_count;					/* Byte count of message		*/( 		long	l_pid;						/* PID of sender			*/0 	} iosb;								/* I/O status block for $QIO		*/   	sys_status = SYS$QIOW( / 		l_mbx_efn	,					/* Use our own event flag		*/ ) 		w_mbx_chan	,					/* Channel to use			*/ 1 		IO$_READVBLK	,					/* Write network channel		*/ ' 		&iosb		,					/* I/O status block			*/ " 		0		,					/* QIO AST address			*/$ 		0		,					/* QIO AST parameter			*/, 		t_buffer	,					/* P1 = Message buffer			*/. 		MBX_MSGMAX	,					/* P2 = Size of buffer			*/ 		0		,					/* P3					*/  		0		,					/* P4					*/  		0		,					/* P5					*/  		0		);					/* P6					*/$ 	if ( sys_status & STS$M_SUCCESS ) { 		sys_status = iosb.w_status;  	}G 	if ( sys_status & STS$M_SUCCESS ) {				/* If the read succeeded...		*/ T 		ax_message->dsc$w_length = iosb.w_byte_count;		/* ...return the message length		*/I 		ax_message->dsc$a_pointer= t_buffer;			/* ...and the buffer address		*/ < 		l_sender_pid = iosb.l_pid;				/* PID of message sender		*/	 	} else { B 		ax_message->dsc$w_length = 0;				/* ...else, no message data		*/ 		ax_message->dsc$a_pointer= 0;  	}; 	return sys_status;						/* Pass back the system status		*/  }     r /*****************************************************************************************************************    					F i n d _ F i l e _ N a m e  e  Determine the name to use for the temporary file - in particular, we must decide where to put it for   accounting purposes. p  To do this, we determine the username under which the process identified by "l_sender_pid" is running, and then]  read their default device and directory. The resultant file name is then made up as follows:    	defdev:[defdir]FILE_NAME   n  where FILE_NAME is defined at the top of this file. The generated name if returned in the string x_file_name.  r *****************************************************************************************************************/ static Find_File_Name() { O 	static $DESCRIPTOR( x_default_file, FILE_NAME );		/* Default for file name		*/   d #define	USERNAME_LENGTH	12		/* Defined by $GETJPI as 12, should be UAF$S_USERNAME (or so I think)	*/@ 	char	t_user_name[ USERNAME_LENGTH ];				/* Username buffer			*/N 	struct dsc$descriptor_s x_user_name = {				/*    ''      ''   as a string		*/? 		USERNAME_LENGTH, DSC$K_DTYPE_T, DSC$K_CLASS_S, t_user_name }; : 	ITEM_LIST	getjpi_items[] = {				/* $GETJPI item list			*/S 		{ USERNAME_LENGTH, JPI$_USERNAME, t_user_name, 0 },	/* Return username of PID		*/  		{ 0, 0, 0, 0 } 	};   > 	char	t_defdev[ UAF$S_DEFDEV ];				/* Default device name			*/N 	struct dsc$descriptor_s x_defdev = {				/*    ''      ''   ''  as a string	*/4 		0, DSC$K_DTYPE_T, DSC$K_CLASS_S, &t_defdev[ 1 ] };  @ 	char	t_defdir[ UAF$S_DEFDIR ];				/* Default directory name		*/Q 	struct dsc$descriptor_s x_defdir = {				/*    ''      ''      ''  as a string	*/ 4 		0, DSC$K_DTYPE_T, DSC$K_CLASS_S, &t_defdir[ 1 ] };  : 	ITEM_LIST	getuai_items[] = {				/* $GETUAI item list			*/- 		{ UAF$S_DEFDEV, UAI$_DEFDEV, t_defdev, 0 }, - 		{ UAF$S_DEFDIR, UAI$_DEFDIR, t_defdir, 0 },  		{ 0, 0, 0, 0 } 	}; < 	long	iosb[ 2 ];						/* $GETJPIW I/O status is two longs	*/   	ss_check( SYS$GETJPIW( / 		l_mbx_efn	,					/* Use mailbox event flag		*/ 4 		&l_sender_pid	,					/* PID to get username for		*/+ 		0		,					/* No process name specified		*/ 0 		getjpi_items	,					/* Item list to return			*/1 		&iosb		,					/* Completion I/O status block		*/ ! 		0		,					/* No AST address			*/ % 		0		) )					/* No AST parameter			*/ 9 	ss_check( iosb[ 0 ] )						/* Check I/O status block		*/    	ss_check( SYS$GETUAI( 		0		,					/* Not used				*/ 		0		,					/* Not used				*/4 		&x_user_name	,					/* User name to get info on		*/0 		getuai_items	,					/* Item list to return			*/ 		0		,					/* Not used				*/ 		0		,					/* Not used				*/ 		0		) )					/* Not used				*/U 	x_defdev.dsc$w_length = (short) t_defdev[ 0 ];			/* Fill in device    name length	*/ T 	x_defdir.dsc$w_length = (short) t_defdir[ 0 ];			/*  ''  '' directory  ''    ''		*/  7 	ss_check( STR$CONCAT(						/* Build the file name			*/ 2 		&x_file_name	,					/* => Resultant file name		*/& 		&x_defdev	,					/* Device name				*/( 		&x_defdir	,					/* Directory name			*/3 		&x_default_file	) )					/* Default file name			*/    #ifdef	TESTING  	LIB$PUT_OUTPUT( &x_file_name ); #endif	TESTING  8 	return SS$_NORMAL;						/* Return success to caller		*/ }     r /*****************************************************************************************************************   					O p e n _ F i l e    Open the specified file. K  The file name has been created by Find_File_Name() above (in x_file_name).   r *****************************************************************************************************************/ static Open_File()  { 4 	nam = cc$rms_nam;						/* Initialise NAM block			*/  4 	fab = cc$rms_fab;						/* Initialise FAB block			*/1 	fab.fab$l_nam	= &nam;						/* => NAM block				*/ J 	fab.fab$l_fna	= x_file_name.dsc$a_pointer;			/* => File name to open			*/E 	fab.fab$b_fns	= x_file_name.dsc$w_length;			/* File name length			*/   D 	fab.fab$b_fac	= FAB$M_PUT;					/* Just want to write to the file	*/= 	fab.fab$l_fop	= FAB$M_TEF;					/* Truncate file on close		*/    	fab.fab$b_rat	= 0; 7 	fab.fab$w_mrs	= 0;						/* No limit on record size		*/ > 	fab.fab$b_rfm	= FAB$C_VAR;					/* Variable length records		*/> 	fab.fab$b_shr	= FAB$M_NIL;					/* No sharing of this file		*/  4 	rab = cc$rms_rab;						/* Initialise RAB block			*/1 	rab.rab$l_fab	= &fab;						/* => FAB block				*/   ; 	ss_check( SYS$CREATE( &fab ) )					/* Create the file			*/   @ 	ss_check( SYS$CONNECT( &rab ) )					/* Connect to the file			*/  8 	return SS$_NORMAL;						/* Return success to caller		*/ }     r /*****************************************************************************************************************   					C l o s e _ F i l e    Close the specified file.   r *****************************************************************************************************************/ static Close_File() { 9 	ss_check( SYS$CLOSE( &fab ) )					/* Close the file			*/ 8 	return SS$_NORMAL;						/* Return success to caller		*/ }     r /*****************************************************************************************************************   					O U T P U T _ L I N E    Output a line to the file.   r *****************************************************************************************************************/ void OUTPUT_LINE(C 	struct dsc$descriptor_s *ax_data	)			/* => Data line to output		*/  {  	long	sys_status;   @ 	rab.rab$b_rac	= RAB$C_SEQ;					/* Sequential access to file		*/C 	rab.rab$l_rbf	= ax_data->dsc$a_pointer;			/* => Data to write			*/ @ 	rab.rab$w_rsz	= ax_data->dsc$w_length;			/* Length of data			*/  < 	sys_status = SYS$PUT( &rab );					/* Write the record			*/	E 	if ( (sys_status & STS$M_SUCCESS) == 0 ) {			/* If it failed...			*/  		LIB$SIGNAL( sys_status );  	} #ifdef	TESTING 	LIB$PUT_OUTPUT( ax_data );  #endif	TESTING }     r /*****************************************************************************************************************  - 				Q u e u e _ F i l e _ T o _ P r i n t e r*  q  Queue the created file to the printer. We do a queue by FID. This is safer than queueing by name because severall@  people may be creating images at one, under the same user name.  r *****************************************************************************************************************/ static Queue_File_To_Printer()a {sH 	$DESCRIPTOR( x_queue, QUEUE_NAME );				/* Name of queue to spool to		*/; 	ITEM_LIST	sndjbc_items[] = {				/* $SNDJBCW item list			*/IF 		{ x_queue.dsc$w_length	, SJC$_QUEUE			, x_queue.dsc$a_pointer	, 0 },; 		{ 28			, SJC$_FILE_IDENTIFICATION	, &nam.nam$t_dvi	, 0 },m( 		{ 0			, SJC$_DELETE_FILE		, 0			, 0 },% 		{ 0			, SJC$_PASSALL			, 0			, 0 },  		{ 0, 0, 0, 0 } 	};sA 	long	iosb[ 2 ];						/* $SNDJBC I/O status block is two longs */e  : 	ss_check( SYS$SNDJBCW(						/* Send print request off		*// 		l_mbx_efn	,					/* Use mailbox event flag		*/o1 		SJC$_ENTER_FILE	,					/* Function required			*/  		0		,					/* Not used				*/' 		sndjbc_items	,					/* Item list				*/u& 		iosb		,					/* I/O status block			*/! 		0		,					/* No AST routine			*/o% 		0		) )					/* No AST parameter			*/S 	ss_check( iosb[ 0 ] );m 		8 	return SS$_NORMAL;						/* Return success to caller		*/ }i