[INHERIT ('SYS$LIBRARY:STARLET'),

ENVIRONMENT ('SCUglobal')]

MODULE SCUglobal;

CONST

    max_users		= 100;		(* Total users per VAX node *)
    node_name_size	= 8;

TYPE

    $BYTE		= [BYTE] -128..127;
    $WORD		= [WORD] -32768..32767;
    $UBYTE		= [BYTE] 0..255;
    $UWORD		= [WORD] 0..65535;

    iosb_type		= ARRAY [1..4] OF $WORD;

    descr_type		=	RECORD
	len		: INTEGER;
	adr		: INTEGER;
    END;

    jpi_list_type	=	RECORD
	len		: $WORD;
	code		: $UWORD;
	buf_adr		: UNSIGNED;
	len_adr		: INTEGER;
    END;
	
    scu_class_type	= (
	scu$_count,
	scu$_user,
	scu$_disc_user,
	scu$_done);
 
    scu_rec_type	=	RECORD
	class		: scu_class_type;
	string		: VARYING [15] OF CHAR;
    END;


[ASYNCHRONOUS, EXTERNAL(STR$COMPARE)] FUNCTION STR$COMPARE (
	src1_str : [class_s] PACKED ARRAY [l1..u1 : INTEGER] OF CHAR;
	src2_str : [class_s] PACKED ARRAY [l2..u2 : INTEGER] OF CHAR)
    : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(LIB$SIGNAL)] FUNCTION LIB$SIGNAL (
	%IMMED STATUS : INTEGER := %IMMED 0) : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(LIB$WAIT)] FUNCTION LIB$WAIT (
        VAR seconds : REAL ) : INTEGER; EXTERN;


[ASYNCHRONOUS, EXTERNAL(SMG$CREATE_PASTEBOARD)] FUNCTION
    SMG$CREATE_PASTEBOARD (
	VAR new_pasteboard_id : INTEGER;
	output_device : [class_s] PACKED ARRAY [l1..u1 : INTEGER]
		OF CHAR := %IMMED 0;
	VAR pb_rows : INTEGER := %IMMED 0;
	VAR pb_columns : INTEGER := %IMMED 0;
	preserve_screen_flag : INTEGER := %IMMED 0) : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(STR$COMPARE_EQL)] FUNCTION STR$COMPARE_EQL (
	src1_str : [class_s] PACKED ARRAY [l1..u1 : INTEGER] OF CHAR;
	src2_str : [class_s] PACKED ARRAY [l2..u2 : INTEGER] OF CHAR)
    : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(SMG$CREATE_VIRTUAL_DISPLAY)] FUNCTION
    SMG$CREATE_VIRTUAL_DISPLAY (
	num_rows : INTEGER;
	num_columns : INTEGER;
	VAR new_display_id : INTEGER;
	display_attributes : INTEGER := SMG$M_BORDER;
	video_attributes : INTEGER := %IMMED 0;
	char_set : INTEGER := SMG$C_ASCII) : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(SMG$PASTE_VIRTUAL_DISPLAY)] FUNCTION
    SMG$PASTE_VIRTUAL_DISPLAY (
	display_id : INTEGER;
	pasteboard_id : INTEGER;
	pasteboard_row : INTEGER;
	pasteboard_column : INTEGER) : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(SMG$PUT_WITH_SCROLL)] FUNCTION
    SMG$PUT_WITH_SCROLL (
	display_id : INTEGER;
	txt : [class_s] PACKED ARRAY [l2..u2 : INTEGER] OF CHAR;
	direction : INTEGER := SMG$M_UP;
	rendition_set : INTEGER := %IMMED 0;
	rendition_complement : INTEGER := %IMMED 0;
	wrap_flag : INTEGER := %IMMED 0;
	char_set : INTEGER := %IMMED 0): INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(SMG$SET_PHYSICAL_CURSOR)] FUNCTION
    SMG$SET_PHYSICAL_CURSOR (
	pasteboard_id	: INTEGER;
	pb_row		: INTEGER;
	pb_column	: INTEGER) : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(SMG$DRAW_LINE)] FUNCTION
    SMG$DRAW_LINE (
	display_id		: INTEGER;
	start_row		: INTEGER;
	start_column		: INTEGER;
	end_row			: INTEGER;
	end_column		: INTEGER;
	rendition_set 		: INTEGER := %IMMED 0;
	rendition_complement 	: INTEGER := %IMMED 0) : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(SMG$RETURN_CURSOR_POS)] FUNCTION
    SMG$RETURN_CURSOR_POS (
	display_id		: INTEGER;
	VAR row_number		: INTEGER;
	VAR column_number	: INTEGER) : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(SMG$SET_CURSOR_ABS)] FUNCTION
    SMG$SET_CURSOR_ABS (
	display_id	: INTEGER := %IMMED 0;
	row		: INTEGER := %IMMED 0;
	column		: INTEGER) : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(SMG$CURSOR_ROW)] FUNCTION
    SMG$CURSOR_ROW (
	display_id	: INTEGER) : INTEGER; EXTERN;

[ASYNCHRONOUS, EXTERNAL(SMG$PUT_CHARS_HIGHWIDE)] FUNCTION
    SMG$PUT_CHARS_HIGHWIDE (
	display_id : INTEGER;
	txt : [class_s] PACKED ARRAY [l2..u2 : INTEGER] OF CHAR;
	line_number : INTEGER := %IMMED 0;
	column_number : INTEGER := %IMMED 0;
	rendition_set : INTEGER := %IMMED 0;
	rendition_complement : INTEGER := %IMMED 0;
	char_set : INTEGER := %IMMED 0): INTEGER; EXTERN;

END.	(* SCUglobal *)
