#module directqio
#pragma builtins
#include <stdio.h>
#include "infodefs.h"
#define		  FAB$M_CBT      0x00200000       
#define		  FAB$M_UFO      0x00020000
#define		  FAB$C_BLN      0x00000050
#define		  IO$_READVBLK   0x00000031       
#define		  IO$_WRITEVBLK  0x00000030
#define		  RMSIF_CREATE		1
#define		  RMSIF_OPEN		2
#define		  RMSIF_READ		3
#define		  RMSIF_WRITE		4
#define		  RMSIF_CLOSE		5

static struct directqio_locals
  { int ifi;
    unsigned short iosbw[4];
  } directqio_data={0, 0, 0, 0, 0};
    
int RMSIF$_$directqio_create(char *filespec_string, int *channel, int destiny)
{
  int fops, retstatus;
  char *fab_addr;
  rms_fabdef( ifi_(&directqio_data.ifi), str_("rfm=fix; mrs=512; rat=") );
  /* give user's specs the final say in file structure */
  rms_fabdef( ifi_(&directqio_data.ifi), str_(filespec_string) );
  rms_info(directqio_data.ifi, RMS__FAB, &fab_addr, RMS__FOP_M, &fops);
  fops = fops | FAB$M_UFO | FAB$M_CBT;
  rms_fabdef( ifi_(&directqio_data.ifi), str_("fac=bio,put"), fop_m_(fops) );
  if (destiny == RMSIF_CREATE)
    retstatus=rms_create_only(ifi_(&directqio_data.ifi));
    /* retstatus=sys$create(fab_addr); */
  else
    retstatus=rms_open_only(ifi_(&directqio_data.ifi));
    /* retstatus=sys$open(fab_addr); */
  rms_info(directqio_data.ifi,RMS__FABSTV,channel);  /* pass pointer value */
  /*_MOVC5(0,fab_addr,0, FAB$C_BLN-2, fab_addr+2);*/
  return retstatus;
}

int directqio_create(char *filespec_string, int *channel)
{return RMSIF$_$directqio_create(filespec_string, channel, RMSIF_CREATE);}

int directqio_open(char *filespec_string, int *channel)
{return RMSIF$_$directqio_create(filespec_string, channel, RMSIF_OPEN);}

int directqio_read(int channel, char *buffer, int length, int vbn)
{ 
  sys$qiow( 0, channel, IO$_READVBLK, &directqio_data.iosbw, 0, 0,
  	    buffer, length, vbn, 0, 0, 0);
  return directqio_data.iosbw[0];
}

int directqio_write(int channel, char *buffer, int length, int vbn)
{ 
  sys$qiow( 0, channel, IO$_WRITEVBLK, &directqio_data.iosbw, 0, 0,
  	    buffer, length, vbn, 0, 0, 0);
  return directqio_data.iosbw[0];
}

int directqio_close( int *channel)
{ int retstatus = sys$dassgn( *channel );
  *channel=0;
}

struct directqio_locals *directqio_dataptr(void)
{return &directqio_data;}
  
