#
#  VMS MMS build file for PS utilities
#
#  Hunter Goatley, 16-MAR-1993 14:47
#  Updated by Hunter Goatley, 21-MAY-1998 16:35
#
PAPER = letter		!I'm in the US! 8-)
#PAPER = a4		!Angus's default

CFLAGS = /NOLIST/OBJECT=$(MMS$TARGET)/DEFINE=(PAPER="""$(PAPER)""")
LFLAGS = /NOTRACE/EXEC=$(MMS$TARGET)/MAP/CROSS/FULL

.IFDEF OBJ
.ELSE
OBJ = .OBJ
EXE = .EXE
.ENDIF

.IFDEF __ALPHA__
OPTIONS_FILE =
LINKOPT =
CFLAGS = $(CFLAGS)/L_DOUBLE=64
.ELSE
.IFDEF __DECC__
.ELSE
CC = $(CC)/VAXC
OPTIONS_FILE = ,VAXC.OPT
LINKOPT = $(options_file)/OPTIONS
.FIRST
	@ define sys sys$library:
.ENDIF
.ENDIF

# epsffit fits an epsf file to a given bounding box
# psbook rearranges pages into signatures
# psselect selects page ranges
# pstops performs general page rearrangement and merging
# psnup puts multiple logical pages on one physical page
# psresize scales and moves pages to fit on different paper sizes

all : psbook$(exe), psselect$(exe), pstops$(exe), epsffit$(exe), psnup$(exe),-
	psresize$(exe)
        @ write sys$output "PSUTILS build complete"

epsffit$(exe) : epsffit$(obj),pserror$(obj)$(options_file)
        $(LINK)$(LFLAGS) $(MMS$SOURCE),pserror$(obj)$(linkopt)

psnup$(exe) :   psnup$(obj), psutil$(obj),psspec$(obj),pserror$(obj)$(options_file)
        $(LINK)$(LFLAGS) psnup$(obj),psutil$(obj),psspec$(obj),pserror$(obj)$(linkopt)

psbook$(exe) :  psbook$(obj), psutil$(obj), pserror$(obj)$(options_file)
        $(LINK)$(LFLAGS) psbook$(obj),psutil$(obj),pserror$(obj)$(linkopt)

psselect$(exe) :        psselect$(obj), psutil$(obj),pserror$(obj)$(options_file)
        $(LINK)$(LFLAGS) psselect$(obj),psutil$(obj),pserror$(obj)$(linkopt)

pstops$(exe) :  pstops$(obj), psutil$(obj), psspec$(obj),pserror$(obj)$(options_file)
        $(LINK)$(LFLAGS) pstops$(obj),psutil$(obj),psspec$(obj),pserror$(obj)$(linkopt)

psresize$(exe) :  psresize$(obj), psutil$(obj),psspec$(obj),pserror$(obj)$(options_file)
        $(LINK)$(LFLAGS) psresize$(obj),psutil$(obj),psspec$(obj),pserror$(obj)$(linkopt)

psutil$(obj) : psutil.h patchlev.h pserror.h psutil.c

psspec$(obj) : psutil.h patchlev.h psspec.h pserror.h psspec.c

pserror$(obj) : psutil.h patchlev.h pserror.h pserror.c

epsffit$(obj) : epsffit.c pserror.h patchlev.h

psresize$(obj) : psutil.h patchlev.h psspec.h pserror.h psresize.c

psbook$(obj) : psutil.h patchlev.h pserror.h psbook.c

psselect$(obj) : psutil.h patchlev.h pserror.h psselect.c

pstops$(obj) : psutil.h patchlev.h psspec.h pserror.h pstops.c

clean :
        delete/log *$(obj);*,psnup$(exe);*,psbook$(exe);*,-
                psselect$(exe);*,pstops$(exe);*,epsffit$(exe);*


VAXC.OPT :
	@ open/write tmp $(MMS$TARGET)
	@ write tmp "sys$share:vaxcrtl.exe/share"
	@ close tmp
