#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */

/*
 *	Check that we sent the file (PROTO_OUT_FILE) to the specified
 *	addressee on a remote node
 *
 *	mai$ax_node		Node name from address (to the right of the
 *				'%') if a '::' was found, else a blank string
 *	mai$ax_addressee	Addressee at remote node to check that we sent
 *				to.
 *	mai$a_error		Passed address of a routine to be used to read
 *				back error texts from the remote node and to
 *				format them correctly for MAIL. 
 *				Call this routine with:
 *					4(AP)	Context block address
 *				8(AP)	Address of routine to call to read next record
 *
 * Return: System status code for success/failure
 *
 */

PROTO_OUT_CKSEND(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_OUT_CKSEND */
	va_list	arglist)			/* remainder of arguments */
{
	struct	dsc$descriptor	*mai$ax_node ;	/* Node to check */
	struct	dsc$descriptor	*mai$ax_addressee ; /* Addressee to check for */
	long	(*mai$a_error)() ;		/* Routine to read error text */

	mai$ax_node =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$ax_addressee =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$a_error = (long (*)()) va_arg(arglist, long *) ;

	printf( "* Operation type = %d (LNK_C_OUT_CKSEND)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );
	printf( "  Node name      = %.*s\n", mai$ax_node->dsc$w_length, mai$ax_node->dsc$a_pointer );
	printf( "  Addressee      = %.*s\n", mai$ax_addressee->dsc$w_length, mai$ax_addressee->dsc$a_pointer );
	printf( "  Error routine  = 0x%08x\n", mai$a_error );

	return(SS$_NORMAL) ;			/* Return success to caller */
}

