% #pragma module pppdutil_dialout "X-8"  /*N  *****************************************************************************  *2  * Copyright  1996 Digital Equipment Corporation.  * All rights reserved.   *B  * Redistribution and use in source and binary forms are permittedB  * provided that the above copyright notice and this paragraph are;  * duplicated in all such forms and that any documentation, =  * advertising materials, and other materials related to such C  * distribution and use acknowledge that the software was developed 5  * by Digital Equipment Corporation.  The name of the E  * Corporation may not be used to endorse or promote products derived @  * from this software without specific prior written permission.A  * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR A  * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED F  * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  *N  *****************************************************************************    
 	FACILITY:   		PPPD  
 	ABSTRACT:  N                 This module contains the main line code for the user interfaceO         to the Point to Point (PPPD) Utility.  All the routines enclosed are in P         alphabetic order, except for dialout_main, which is at the bottom of the
         file.    	AUTHOR:  5 		Barry W. Kierstein                      27-JUN-1996    	REVISION HISTORY:) 	X-9 	JPT002		Joe P. Tavares		19-Mar-1997 9 		QAR EVMS-RAVEN 833 fixed.  ACCVIO when modem connection  		fails do to time out.   /         X-8	JPT001		Joe P. Tavares		04-Mar-1997 5 		QAR EVMS-RAVEN 853 fixed. Removed incorrect typedef , 		declaration in port_block_tag declaration.  C         X-7     BWK007          Barry W. Kierstein      17-Dec-1996 <                 Replaced the standard Digital copyright with6                 one compatible with the CMU copyright.  C         X-6     BWK006          Barry W. Kierstein      23-Sep-1996 O                 QAR EVMS-GRYPHON 2437 fixed.  The calls to allocate_iosb_buffer L                 did not check for a NULL return status, giving the potential1                 for an access violation later on. 6                 Also standardized the error reporting.  C         X-5     BWK005          Barry W. Kierstein      21-Aug-1996 I                 QAR EVMS-GRYPHON-FT 116 fixed.  Changed the order of when M                 the hangup AST and the port hangup QIO was done, restructured O                 hangup_ast to accomodate the system's use of the AST parameter.   C         X-4     BWK004          Barry W. Kierstein      07-Aug-1996 N                 QAR EVMS-GRYPHON 99 fixed.  In changing the io_port.*_portnameM                 from a C string to a descriptor, did not change the parameter M                 passing from value to reference in several places.  Also took E                 out error text PORTSETUP2, as it is no longer needed.   C         X-3     BWK003          Barry W. Kierstein      02-Aug-1996 J                 Added CHECK_AND_REPORT* macros for better error reporting.  C         X-2     BWK002          Barry W. Kierstein      24-Jul-1996 +                 Corrected copyright notice.   C         X-1     BWK001          Barry W. Kierstein      11-JUL-1996 0                 Initial check in of this module. */   #include <stdio.h> #include <stdlib.h>  #include <stdarg.h>  #include <ssdef.h> #include <iodef.h> #include <libdef.h>  #include <lib$routines.h>  #include <starlet.h> #include <ttdef.h> #include <tt2def.h>  #include <tt3def.h>  #include <descrip.h> #include <str$routines.h>  #include <namdef.h>  #include "pppd.h"  #include "pppddef.h" #include "asndef.h"  #include "ppp_mgmt_if.h" #include "pppdutil_common.h" #include "pppdutil.h"  #include "pppdutil_dialout.h"    /* Constants, defines, etc. */ #define DIALOUT_STRING_SIZE 20. int dialout_string_size = DIALOUT_STRING_SIZE; #define SINGLE_CHAR 1LO #define PPPD$C_DEVICENAME_MAX 15    /* No system defined constant exists for */ O                                     /* the maximum length of a device.       */ O #define HANGUP_DEFAULT_PARAMETER -1 /* Hangup AST will pass in P1 or         */ O                                     /* SS$_HANGUP if the line hangs up.      */ O                                     /* This will help detect which one.      */  /* Macro routines */  < #define WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS(status)       \<     io_port->dialout_return_status = status;               \     sys$wake (0L, 0L);  > #define WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS_2(status)       \8  	io_port_block->dialout_return_status = status;       \ 	sys$wake (0L, 0L);   W #define DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS(location,context,status)          \ W     if FAILURE(status)                                                                \ W     {                                                                                 \ W         REPORT_CONTEXT_AND_STATUS(location,context,status);                           \ W         WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS(DIALOUT_ERROR_ABORT);                    \ W         return FALSE;                                                                 \      };  W #define DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0(location,context,status,p1)   \ W     if FAILURE(status)                                                                \ W     {                                                                                 \ W         REPORT_CONTEXT_AND_STATUS_1_0(location,context,status,p1);                    \ W         WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS(DIALOUT_ERROR_ABORT);                    \ W         return FALSE;                                                                 \      };    /* Global variables and types */   #define DIALOUT_BUFFER_SIZE 512    #ifdef DIALOUT_TRACE FILE *dialout_trace_file; - char  dialout_trace_filename[NAM$C_MAXRSS+1];  int   iosb_buffer_id_max;  #endif  + typedef struct iosb_buffer_tag iosb_buffer; * typedef struct port_block_tag  port_block; struct iosb_buffer_tag { A     iosb_buffer *next;          /* Next buffer in the list     */ A     port_block  *io_port;       /* Pointer to global variables */ A     RW_IOSB     iosb;           /* IOSB for the $QIO call      */  #ifdef DIALOUT_TRACEA     int         id;             /* Easily identify this buffer */  #endif };   struct port_block_tag  { 0     iosb_buffer *allocated_iosb_buffer_listhead;+     iosb_buffer *free_iosb_buffer_listhead; - #define INITIAL_IOSB_BUFFER_LISTHEAD_SIZE   4        CHAN        serial_channel; !     D_DESCRIPTOR serial_portname; )     DEV_CHAR    serial_orig_device_chars; )     DEV_CHAR    serial_curr_device_chars;   !     CHAN        terminal_channel; #     D_DESCRIPTOR terminal_portname; +     DEV_CHAR    terminal_orig_device_chars;   #     VMS_STATUS  serial_read_status; !     RW_IOSB     serial_read_iosb;       EFN         serial_read_efn;!     EFN         serial_break_efn; 8     char        serial_read_buffer[DIALOUT_BUFFER_SIZE];  $     VMS_STATUS  serial_write_status;"     RW_IOSB     serial_write_iosb;O     int         serial_io_cancelled;    /* Let AST routine know we did this. */   %     VMS_STATUS  terminal_read_status; #     RW_IOSB     terminal_read_iosb; :     char        terminal_read_buffer[DIALOUT_BUFFER_SIZE];  &     VMS_STATUS  terminal_write_status;$     RW_IOSB     terminal_write_iosb;O     int         terminal_io_cancelled;  /* Let AST routine know we did this. */   &     int         dialout_return_status;        char        disconnect_char;     char        switch_char;     char        break_char;    #ifdef DIALOUT_STATS #define READALL_MAX 5      int         serial_reads; !     int         serial_read_alls; +     int         serial_read_aborts_ignored;      int         serial_writes;,     int         serial_write_aborts_ignored;:     int         serial_longest_read_all_size[READALL_MAX];;     int         serial_longest_read_all_count[READALL_MAX];        int         terminal_reads;       int         terminal_writes;  -     int         calls_to_create_iosb_buffers;  #endif   };     /* Function prototypes */   O PROC_STATIC iosb_buffer *allocate_iosb_buffer (iosb_buffer *allocated_listhead, J                                                iosb_buffer *free_listhead,E                                                port_block  *io_port); C PROC_STATIC VMS_STATUS cancel_io (CHAN channel, int *io_cancelled); 1 PROC_STATIC VMS_STATUS close_port (CHAN channel); e PROC_STATIC int create_iosb_buffers (iosb_buffer *listhead, int number_buffers, port_block *io_port); B PROC_STATIC int free_iosb_buffer (iosb_buffer *allocated_listhead,=                                   iosb_buffer *free_listhead, 6                                   iosb_buffer *buffer,8                                   port_block  *io_port);a PROC_STATIC int get_port_chars (CHAN channel, D_DESCRIPTOR *device_name, DEV_CHAR *device_chars); 1 PROC_STATIC int hangup_ast (port_block *io_port); e PROC_STATIC int hangup_serial_port (CHAN channel, D_DESCRIPTOR *device_name, DEV_CHAR *device_chars); I PROC_STATIC int init_iosb_buffer_lists (iosb_buffer **allocated_listhead, D                                         iosb_buffer **free_listhead,?                                         port_block   *io_port); B PROC_STATIC int open_port (D_DESCRIPTOR *portname, CHAN *channel);G PROC_STATIC int release_iosb_buffers (iosb_buffer **allocated_listhead, B                                       iosb_buffer **free_listhead,=                                       port_block   *io_port); G PROC_STATIC int send_break_signal_to_serial_port (port_block *io_port); 7 PROC_STATIC int serial_port_read (port_block *io_port); ; PROC_STATIC int serial_port_read_all (port_block *io_port); 9 PROC_STATIC int serial_port_read_ast (iosb_buffer *iosb); 8 PROC_STATIC int serial_port_write (port_block *io_port);: PROC_STATIC int serial_port_write_ast (iosb_buffer *iosb);a PROC_STATIC int set_port_chars (CHAN channel, D_DESCRIPTOR *device_name, DEV_CHAR *device_chars); 7 PROC_STATIC int setup_hangup_ast (port_block *io_port); 9 PROC_STATIC int terminal_port_read (port_block *io_port); ; PROC_STATIC int terminal_port_read_ast (iosb_buffer *iosb);*: PROC_STATIC int terminal_port_write (port_block *io_port);< PROC_STATIC int terminal_port_write_ast (iosb_buffer *iosb);T PROC_STATIC int timed_wait (EFN wait_efn, VMS_TIME *wait_time, port_block *io_port);   r /* ** Function Name ** **    allocate_iosb_buffer ** ** Functional Descriptiona **H **    This routine allocates a buffer for the IOSB parameter for the QIOG **    calls in this module.  They are obtained from a free list that is C **    maintained by the other *iosb_buffer* routines, or created if.2 **    necessary by the create_iosb_buffer routine. ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.* **	 ** Inputs* **K **    allocated_listhead        - listhead of all previously allocated IOSB	) **                                buffersmF **    free_listhead             - listhead of unallocated IOSB buffersR **    io_port                   - structure holding the dialout functional context **
 ** Outputs **J **    allocated_listhead        - updated list of all previously allocated. **                                IOSB buffersJ **    free_listhead             - updated list of unallocated IOSB buffers **
 ** Returns **C **    Address of the newly allocated IOSB buffer, or NULL for error  ** */- PROC_STATIC iosb_buffer *allocate_iosb_bufferS%     (iosb_buffer *allocated_listhead,e       iosb_buffer *free_listhead,      port_block  *io_port) {  iosb_buffer *temp;   #ifdef DIALOUT_TRACED     fprintf (dialout_trace_file, "Entering allocate_iosb_buffer\n"); #endif  '     /* Create a new buffer if needed */o$     if (free_listhead->next == NULL)>         if (!create_iosb_buffers (free_listhead, 1L, io_port))             return NULL;  *     /* Take a buffer from the free list */6     temp                        = free_listhead->next;<     free_listhead->next         = free_listhead->next->next;  &     /* Put it on the allocated list */;     temp->next                  = allocated_listhead->next;e'     allocated_listhead->next    = temp;    #ifdef DIALOUT_TRACEH     fprintf (dialout_trace_file, "    Allocated buffer %d\n", temp->id); #endif       return temp; }r u /* ** Function Name ** **    cancel_ioa ** ** Functional Descriptionp **? **    This routine will cancel any IO on the specified channel.  ** ** Environment ** **    User mode. **	 ** Inputs  **8 **    channel           - IO channel for IO cancellationM **    io_cancelled      - flag to set that signals that an IO cancel was doner **
 ** Outputs **
 **    None **
 ** Returns **# **    Status of SYS$CANCEL routine.S ** */B PROC_STATIC VMS_STATUS cancel_io (CHAN channel, int *io_cancelled) {KM     /* Cancel the I/O on the specified channel, and signal that it is done */bM     /* for the associated AST routines.                                    */      if (io_cancelled != NULL)          *io_cancelled = TRUE;       return sys$cancel (channel); }  K /* ** Function Name ** **    close_port ** ** Functional Description. **? **    This routine will close the channel assigned to the port.h ** ** Environment ** **    User mode. **	 ** Inputsd **0 **    channel           - IO channel for closing **
 ** Outputs **
 **    None **
 ** Returns **' **    Status of the SYS$DASSGN routine.c ** */0 PROC_STATIC VMS_STATUS close_port (CHAN channel) {h(     /* Deassign the specified channel */      return sys$dassgn (channel); }u " /* ** Function Name ** **    create_iosb_buffers" ** ** Functional Descriptiont **I **    This routine creates the desired number of IOSB buffers and inserts ' **    them onto the specified listhead.A ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.  **	 ** Inputs  **: **    listhead          - listhead to insert the new nodes: **    number_buffers    - number of IOSB buffers to createJ **    io_port           - structure holding the dialout functional context **
 ** Outputs **& **    listhead          - updated list **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */d PROC_STATIC int create_iosb_buffers (iosb_buffer *listhead, int number_buffers, port_block *io_port) {a iosb_buffer *temp; VMS_STATUS status; int i;   #ifdef DIALOUT_TRACEZ     fprintf (dialout_trace_file, "Entering create_iosb_buffers, number of buffers = %d\n",2                                   number_buffers); #endif   #ifdef DIALOUT_STATS,     io_port->calls_to_create_iosb_buffers++; #endif  K     /* Create the number of buffers requested, and add them to the queue */ (     for (i = 0; i < number_buffers; i++)     { E         temp            = (iosb_buffer *)malloc(sizeof(iosb_buffer));I         if (temp == NULL)E	         {U)             status      = LIB$_INSVIRMEM; %             REPORT_CONTEXT_AND_STATUS I                 ("create_iosb_buffers (malloc)", PPPD$_DIALINIT, status); G             WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS (DIALOUT_ERROR_ABORT);T             return FALSE;a
         };)         temp->next      = listhead->next;          listhead->next  = temp;T #ifdef DIALOUT_TRACE/         temp->id        = iosb_buffer_id_max++; M         fprintf (dialout_trace_file, "    Buffer id %d created\n", temp->id);G #endif     }        return TRUE; }  L /* ** Function Name ** **    free_iosb_buffer ** ** Functional Descriptioni **E **    This routine takes the specified IOSB buffer from the allocated * **    list and puts it onto the free list. ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.d **	 ** Inputs* **K **    allocated_listhead        - listhead of all previously allocated IOSBo) **                                buffers F **    free_listhead             - listhead of unallocated IOSB buffers@ **    buffer                    - address of IOSB buffer to freeR **    io_port                   - structure holding the dialout functional context **
 ** Outputs **J **    allocated_listhead        - updated list of all previously allocated. **                                IOSB buffersJ **    free_listhead             - updated list of unallocated IOSB buffers **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */B PROC_STATIC int free_iosb_buffer (iosb_buffer *allocated_listhead,=                                   iosb_buffer *free_listhead, 6                                   iosb_buffer *buffer,7                                   port_block  *io_port)  { ' iosb_buffer *curr_buffer, *prev_buffer;h VMS_STATUS status;   #ifdef DIALOUT_TRACER     fprintf (dialout_trace_file, "Entering free_iosb_buffer, freeing buffer %d\n",.                                   buffer->id); #endif       /* Find current entry */-     curr_buffer         = allocated_listhead; <     while ((curr_buffer != buffer) && (curr_buffer != NULL))     { &         prev_buffer     = curr_buffer;,         curr_buffer     = curr_buffer->next;     }a       /* Didn't find the entry */l     if (curr_buffer == NULL)     {r(         status      = PPPD$_BADIOSBADDR;O         REPORT_LOCATION_AND_STATUS_1 ("free_iosb_buffer", status, (int)buffer);rC         WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS (DIALOUT_ERROR_ABORT);o         return FALSE;      }   K     /* Take entry out of the allocated list, and put it on the free list */l,     prev_buffer->next   = curr_buffer->next;.     curr_buffer->next   = free_listhead->next;&     free_listhead->next = curr_buffer;       return TRUE; }    /* ** Function Name **& **    get_port_chars (characteristics) ** ** Functional Description  **A **    This routine will return the current device characteristicsn **    on the specified channel.c ** ** Environment ** **    User mode. **	 ** Inputs) **2 **    channel           - IO channel of the device **
 ** Outputs **/ **    channel           - channel of the devicer? **    device_name       - descriptor containing the device name N **    device_chars      - structure for returning the device's characteristics **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */` PROC_STATIC int get_port_chars (CHAN channel, D_DESCRIPTOR *device_name, DEV_CHAR *device_chars) {I VMS_STATUS status; SENSE_IOSB sense_iosb;  )     /* Get the current characteristics */l9     status = sys$qiow (PPPD_EFN,                /* EFN */C:                        channel,                 /* chan */:                        IO$_SENSEMODE,           /* func */:                        &sense_iosb,             /* iosb */<                        0,                       /* astadr */<                        0,                       /* astprm */8                        device_chars,            /* p1 */8                        sizeof(*device_chars),   /* p2 */=                        0, 0, 0, 0);             /* p3 - p6 */R+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0t?         ("get_port_chars (status)", PPPD$_NOPORTACCESS, status,b          device_name);+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0oB         ("get_port_chars (sense_iosb.status)", PPPD$_NOPORTACCESS,*           sense_iosb.status, device_name);       return TRUE; }A   /* ** Function Name ** **    hangup_ast ** ** Functional Descriptiona **C **    This routine will report the hangup event on the serial port.RA **    The routine assumes that it will be called with the io_port @ **    structure address before the hangup AST handler is set up. ** ** Environment **! **    User mode or user mode AST.  **	 ** Inputsr **E **    io_port   - structure holding the dialout functional context ORuE **                HANGUP_DEFAULT_PARAMETER                         ORt **                SS$_HANGUP **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */0 PROC_STATIC int hangup_ast (port_block *io_port) {a( static port_block *io_port_block = NULL;   #ifdef DIALOUT_TRACES     fprintf (dialout_trace_file, "Entering hangup_ast, P1 = %X\n", (u_int)io_port);  #endif  I     /* If the port was closed, or discontinued processing, just return */l     if (io_port_block != NULL)3         if ((io_port_block->serial_io_cancelled) ||tH             (io_port_block->dialout_return_status != DIALOUT_STATUS_OK))             return TRUE;  #     if ((int)io_port == SS$_HANGUP)v     {n%         /* Report the hangup event */ R         REPORT_LOCATION_AND_STATUS ("hangup_ast (SS$_HANGUP)", PPPD$_MODEMHANGUP);F         WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS_2 (DIALOUT_MODEM_HANGUP);         return TRUE;     }n6     else if ((int)io_port == HANGUP_DEFAULT_PARAMETER)     {t0         /* Report the unexpected hangup event */S         REPORT_LOCATION_AND_STATUS ("hangup_ast (default P1)", PPPD$_INVHANGASTP1);tE         WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS_2 (DIALOUT_ERROR_ABORT);          return FALSE;i     }n8     else /* The port block address is being passed in */     {n"         if (io_port_block != NULL)	         { )             /* Report the invalid call */o(             REPORT_LOCATION_AND_STATUS_2Z                 ("hangup_ast (unknown P1)", PPPD$_INVHANGASTINIT, io_port, io_port_block);G             WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS (DIALOUT_ERROR_ABORT);l             return FALSE;d	         }*  "         io_port_block   = io_port;         return TRUE;     }N       return TRUE; }t o /* ** Function Name ** **    hangup_serial_port ** ** Functional Description  **? **    This routine will send a hangup to the specified channel.l= **    Note that for the hangup to take effect, no pending IOs-& **    should be on the device's queue. ** ** Environment ** **    User mode. **	 ** Inputse **3 **    channel           - IO channel for the hangupp? **    device_name       - descriptor containing the device name M **    device_chars      - device characteristics of the port for the QIO callF **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */d PROC_STATIC int hangup_serial_port (CHAN channel, D_DESCRIPTOR *device_name, DEV_CHAR *device_chars) {O VMS_STATUS status; SENSE_IOSB set_iosb;       /* Set up the hangup AST */a9     status = sys$qiow (PPPD_EFN,                /* EFN */o:                        channel,                 /* chan */:                        IO$_SETMODE|IO$M_HANGUP, /* func */:                        &set_iosb,               /* iosb */<                        0L,                      /* astadr */<                        0L,                      /* astprm */8                        device_chars,            /* p1 */8                        sizeof(*device_chars),   /* p2 */@                        0,                       /* p3 - speed */=                        0, 0, 0);                /* p4 - p6 */t+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 C         ("hangup_serial_port (status)", PPPD$_NOPORTACCESS, status,            device_name); +     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 D         ("hangup_serial_port (set_iosb.status)", PPPD$_NOPORTACCESS,(           set_iosb.status, device_name);       return TRUE; }n s /* ** Function Name ** **    init_iosb_buffer_lists ** ** Functional Description* **N **    This routine allocates an IOSB buffer for each of the allocated and freeI **    lists for use as the listheads of each list, and then populates ther7 **    free list with an initial number of IOSB buffers.y ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.n **	 ** Inputs  **F **    allocated_listhead        - address of pointer for the allocated/ **                                listhead nodeeA **    free_listhead             - address of pointer for the free / **                                listhead node  **
 ** Outputs **L **    allocated_listhead        - updated pointer to allocated listhead nodeG **    free_listhead             - updated pointer to free listhead nodeSR **    io_port                   - structure holding the dialout functional context **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */I PROC_STATIC int init_iosb_buffer_lists (iosb_buffer **allocated_listhead,sD                                         iosb_buffer **free_listhead,>                                         port_block   *io_port) {  iosb_buffer *temp_listhead;  iosb_buffer temp;f   #ifdef DIALOUT_TRACE     /* Inititialization */     iosb_buffer_id_max  = 0; #endif  3     /* Init a temporary list for the create call */T      temp_listhead       = &temp;.     temp_listhead->next = (iosb_buffer *)NULL;  H     /* Create the listhead entries (only the next field will be used) */:     if (!create_iosb_buffers (temp_listhead, 2L, io_port))         return FALSE;e  "     /* Initialize the listheads */6     *allocated_listhead         = temp_listhead->next;<     *free_listhead              = temp_listhead->next->next;6     (*allocated_listhead)->next = (iosb_buffer *)NULL;6     (*free_listhead)->next      = (iosb_buffer *)NULL;  K     /* Create an initial number of buffers and put them on the free list */tZ     if (!create_iosb_buffers (*free_listhead, INITIAL_IOSB_BUFFER_LISTHEAD_SIZE, io_port))         return FALSE;*       return TRUE; }l F /* ** Function Name ** **    open_port  ** ** Functional DescriptionS **C **    This routine will open an IO channel on the specified device.  ** ** Environment ** **    User mode. **	 ** Inputs  **> **    portname          - name of the device for the port open **
 ** Outputs **F **    channel           - IO channel returned from the SYS$ASSIGN call **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */A PROC_STATIC int open_port (D_DESCRIPTOR *portname, CHAN *channel)I {  VMS_STATUS status;       /* Open the channel */6     status = sys$assign (portname,   /* device name */9                          channel,    /* channel number */t1                          0,          /* acmode */ 1                          0,          /* mbxnam */ 0                          0);         /* flags */  +     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0i;         ("open_port (sys$assign status)", PPPD$_ASSIGNCHAN,e           status, portname);       return TRUE; }    /* ** Function Name ** **    release_iosb_buffers ** ** Functional Description  **I **    This routine depopulates and deallocates the free IOSB buffer list, L **    including the listhead node, and then deallocates the allocated list'sL **    listhead node.  A check is made to see if the allocated list is empty,H **    since destroying the lists while buffers are allocated is an error **    condition. ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.  **	 ** InputsS **F **    allocated_listhead        - address of pointer for the allocated/ **                                listhead nodeOA **    free_listhead             - address of pointer for the free / **                                listhead nodepR **    io_port                   - structure holding the dialout functional context **
 ** Outputs **- **    allocated_listhead        - set to NULLr- **    free_listhead             - set to NULLn **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */G PROC_STATIC int release_iosb_buffers (iosb_buffer **allocated_listhead, B                                       iosb_buffer **free_listhead,<                                       port_block   *io_port) {h" iosb_buffer *temp, *temp_listhead; VMS_STATUS status; int i;   #ifdef DIALOUT_TRACED     fprintf (dialout_trace_file, "Entering release_iosb_buffers\n"); #endif  9     /* Depopulate the free list including the listhead */*)     temp_listhead       = *free_listhead;n!     while (temp_listhead != NULL)      { (         temp            = temp_listhead;%         temp_listhead   = temp->next;  #ifdef DIALOUT_TRACEJ         fprintf (dialout_trace_file, "    Freeing buffer %d\n", temp->id); #endif         free (temp);     }P  4     /* The allocated list should be empty already */,     if ((*allocated_listhead)->next != NULL)     { &         status      = PPPD$_IOSBALLOC;D         REPORT_LOCATION_AND_STATUS ("release_iosb_buffers", status);C         WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS (DIALOUT_ERROR_ABORT);          return FALSE;      }   %     /* Free the allocated listhead */v #ifdef DIALOUT_TRACE`     fprintf (dialout_trace_file, "    Freeing listhead buffer %d\n", (*allocated_listhead)->id); #endif     free (*allocated_listhead);C  %     /* Clear the listhead pointers */      *allocated_listhead = NULL;P     *free_listhead      = NULL;        return TRUE; }H _ /* ** Function Name **& **    send_break_signal_to_serial_port ** ** Functional DescriptionC **? **    This routine will send a break signal to the serial port.  ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.  **	 ** Inputsu **B **    io_port   - structure holding the dialout functional context **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */F PROC_STATIC int send_break_signal_to_serial_port (port_block *io_port) {R VMS_STATUS status; SENSE_IOSB set_iosb;c static VMS_TIME wait_time = { -1*250*1000*10, -1 }; /* 250 milliseconds in 10ns tics, delta time */b   #ifdef DIALOUT_TRACEP     fprintf (dialout_trace_file, "Entering send_break_signal_to_serial_port\n"); #endif  Y     /* Cancel any pending I/Os to the serial port so that we can send the break signal */l:     status      = cancel_io (io_port->serial_channel, 0L);3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0k8         ("send_break_signal_to_serial_port (cancel io)",           PPPD$_BREAKERR,i           status,A$          &io_port->serial_portname);       /* Send the break signal */CK     status = sys$qiow (PPPD_EFN,                                  /* EFN */EL                        io_port->serial_channel,                   /* chan */L                        IO$_SETMODE,                               /* func */L                        &set_iosb,                                 /* iosb */N                        0L,                                        /* astadr */N                        0L,                                        /* astprm */Y                        &io_port->serial_curr_device_chars,        /* p1 - device chars */ b                        sizeof(io_port->serial_curr_device_chars), /* p2 - sizeof (device chars) */R                        0L,                                        /* p3 - speed */^                        0L,                                        /* p4 - CR/LF fill counts */Y                        TT$M_BREAK,                                /* p5 - parity flags */;J                        0L);                                       /* p6 */3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 ?         ("send_break_signal_to_serial_port (break QIO status)",            PPPD$_BREAKERR,t           status,e$          &io_port->serial_portname);3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0.D         ("send_break_signal_to_serial_port (break QIO iosb status)",           PPPD$_BREAKERR,            set_iosb.status,$          &io_port->serial_portname);  H     /* Wait 250ms.  If not successful, the routine will do the $WAKE, */H     /* and we need to cancel the break anyway, so we can throw away   */     /* the status. */*@     timed_wait (io_port->serial_break_efn, &wait_time, io_port);  !     /* Cancel the break signal */rK     status = sys$qiow (PPPD_EFN,                                  /* EFN */AL                        io_port->serial_channel,                   /* chan */L                        IO$_SETMODE,                               /* func */L                        &set_iosb,                                 /* iosb */N                        0L,                                        /* astadr */N                        0L,                                        /* astprm */Y                        &io_port->serial_curr_device_chars,        /* p1 - device chars *//b                        sizeof(io_port->serial_curr_device_chars), /* p2 - sizeof (device chars) */R                        0L,                                        /* p3 - speed */^                        0L,                                        /* p4 - CR/LF fill counts */Y                        0L,                                        /* p5 - parity flags */PJ                        0L);                                       /* p6 */3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0_F         ("send_break_signal_to_serial_port (cancel break QIO status)",           PPPD$_BREAKERR,a           status, $          &io_port->serial_portname);3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 K         ("send_break_signal_to_serial_port (cancel break QIO iosb status)",*           PPPD$_BREAKERR,F           set_iosb.status,$          &io_port->serial_portname);  5     /* Start another read (cancelled the last one) */n$     if (!serial_port_read (io_port))         return FALSE;t       return TRUE; }s t /* ** Function Name ** **    serial_port_read ** ** Functional Descriptiono **F **    This routine starts a read on the serial port.  It will allocateD **    an IOSB buffer, start a read QIO on the serial port, and check **    the QIO call status. ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.R **	 ** Inputs  **B **    io_port   - structure holding the dialout functional context **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */6 PROC_STATIC int serial_port_read (port_block *io_port) {o iosb_buffer     *iosb;   #ifdef DIALOUT_TRACE@     fprintf (dialout_trace_file, "Entering serial_port_read\n"); #endif  +     /* Allocate and set up an IOSB block */ *     iosb            = allocate_iosb_bufferC                           (io_port->allocated_iosb_buffer_listhead,i>                            io_port->free_iosb_buffer_listhead,$                            io_port);     if (iosb == NULL)(         return FALSE;o     iosb->io_port   = io_port;  ,     /* Start the read for the serial port */"     io_port->serial_read_status  =8         sys$qio  (PPPD_EFN,                    /* EFN */@                   io_port->serial_channel,     /* I/O channel */B                   IO$_READVBLK|IO$M_NOECHO,    /* Function code */?                   &iosb->iosb,                 /* IOSB block */*@                   &serial_port_read_ast,       /* AST address */>                   iosb,                        /* AST param */M                   io_port->serial_read_buffer, /* P1 - data buffer address */ J                   SINGLE_CHAR,                 /* P2 - data buffer size */G                   0L,                          /* P3 - timeout count */ X                   0L,                          /* P4 - read term. desc. block address */O                   0L,                          /* P5 - prompt buffer address */ L                   0L);                         /* P6 - prompt buffer size */  3     /* If the read failed, then signal the error */a3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0n)         ("serial_port_read (QIO status)",            PPPD$_READERR,&           io_port->serial_read_status,$          &io_port->serial_portname);       return TRUE; }*   /* ** Function Name ** **    serial_port_read_all ** ** Functional Description  **D **    This routine will read the rest of the serial port's typeaheadL **    buffer, and append any characters read to the serial port read buffer. ** ** Environment ** **    User mode, AST level.  **	 ** Inputss **B **    io_port   - structure holding the dialout functional context **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */: PROC_STATIC int serial_port_read_all (port_block *io_port) {  int read_timeout        = 0;: static int terminator_mask[8]  = {0, 0, 0, 0, 0, 0, 0, 0}; struct {*     short size;*     short filler;*     int   *mask; } terminator_desc =p4     { sizeof(terminator_mask), 0, terminator_mask }; #ifdef DIALOUT_STATS
 int i,j,k; #endif #ifdef DIALOUT_TRACE int l,m; #endif   #ifdef DIALOUT_TRACED     fprintf (dialout_trace_file, "Entering serial_port_read_all\n"); #endif  L     /* Read remaining characters, appending them to what is in the buffer */"     io_port->serial_read_status  =<         sys$qiow (PPPD_EFN,                        /* EFN */D                   io_port->serial_channel,         /* I/O channel */J                   IO$_READVBLK|IO$M_TIMED|IO$M_NOECHO, /* Function code */C                   &io_port->serial_read_iosb,      /* IOSB block */oD                   0L,                              /* AST address */B                   0L,                              /* AST param */Q                   &io_port->serial_read_buffer[1], /* P1 - data buffer address */fN                   DIALOUT_BUFFER_SIZE-1,           /* P2 - data buffer size */K                   read_timeout,                    /* P3 - timeout count */ \                   &terminator_desc,                /* P4 - read term. desc. block address */S                   0L,                              /* P5 - prompt buffer address */DP                   0L);                             /* P6 - prompt buffer size */  3     /* If the read failed, then signal the error */ 3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0e-         ("serial_port_read_all (QIO status)",A           PPPD$_READERR,&           io_port->serial_read_status,$          &io_port->serial_portname);;     if (io_port->serial_read_iosb.status == SS$_DATAOVERUN)e     { F         signal_error (PPPD$_DATAOVERUN, 1, &io_port->serial_portname);     }D@     else if ((io_port->serial_read_iosb.status != SS$_NORMAL) &&?              (io_port->serial_read_iosb.status != SS$_TIMEOUT))I     {RP         REPORT_CONTEXT_AND_STATUS_1_0 ("serial_port_read_all (QIO iosb.status)",6                                         PPPD$_READERR,I                                         io_port->serial_read_iosb.status,fB                                        &io_port->serial_portname);C         WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS (DIALOUT_ERROR_ABORT);          return FALSE;U     }    #ifdef DIALOUT_TRACE     /* Output the buffer */_)     l = io_port->serial_read_iosb.count +o0         io_port->serial_read_iosb.term_size + 1;?     fprintf (dialout_trace_file, "    Buffer[0:%3d] = >", l-1);A     for (m = 0; m < l; m++)c*         fprintf (dialout_trace_file, "%c",1                  io_port->serial_read_buffer[m]);t(     fprintf (dialout_trace_file, "<\n"); #endif   #ifdef DIALOUT_STATS     /* Gather statistics */T)     j = io_port->serial_read_iosb.count +d,         io_port->serial_read_iosb.term_size;     if (j != 0)      { $         io_port->serial_read_alls++;!         for (i = READALL_MAX - 1;*I              (i >= 0) && (j >= io_port->serial_longest_read_all_size[i]);A               i--);g         i++;         if (i < READALL_MAX)	         {S>             if (j == io_port->serial_longest_read_all_size[i])
             {1<                 io_port->serial_longest_read_all_count[i]++;
             }              else
             {"6                 for (k = READALL_MAX - 2; k >= i; k--)                 { A                     io_port->serial_longest_read_all_size[k+1]  =lA                         io_port->serial_longest_read_all_size[k]; A                     io_port->serial_longest_read_all_count[k+1] =bB                         io_port->serial_longest_read_all_count[k];                 };>                 io_port->serial_longest_read_all_size[i]  = j;>                 io_port->serial_longest_read_all_count[i] = 1;
             }*	         }      }  #endif  :     /* Patch up the offset to terminator since there is */+     /* a character in the buffer already */ &     io_port->serial_read_iosb.count++;       return TRUE; }    /* ** Function Name ** **    serial_port_read_ast ** ** Functional Description  **J **    This routine processes the serial port output.  It releases the IOSBG **    buffer, reads any other characters in the serial port's typeahead_B **    buffer, starts a write with these characters to the terminal7 **    port, and queues another read to the serial port.  ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.  **	 ** Inputs  **H **    iosb      - IOSB buffer holding the dialout functional context and( **                the IOSB status block. **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */8 PROC_STATIC int serial_port_read_ast (iosb_buffer *iosb) {  port_block  *io_port;oa static VMS_TIME wait_time = { -1*50*1000*10, -1 }; /* 50 milliseconds in 10ns tics, delta time */    #ifdef DIALOUT_TRACE^     fprintf (dialout_trace_file, "Entering serial_port_read_ast, iosb buffer %d\n", iosb->id); #endif  0     /* Store IOSB information and free buffer */0     io_port                     = iosb->io_port;-     io_port->serial_read_iosb   = iosb->iosb; C     if (!free_iosb_buffer (io_port->allocated_iosb_buffer_listhead, >                            io_port->free_iosb_buffer_listhead,*                            iosb, io_port))         return FALSE;   I     /* If the port was closed, or discontinued processing, just return */ )     if ((io_port->serial_io_cancelled) || >         (io_port->dialout_return_status != DIALOUT_STATUS_OK))         return TRUE;  L     /* If the status is SS$_ABORT or SS$_CANCEL, this may be from a break */4     /* command sent from the user, so ignore here */;     if ((io_port->serial_read_iosb.status == SS$_ABORT)  || 9         (io_port->serial_read_iosb.status == SS$_CANCEL))*     {i #ifdef DIALOUT_STATS.         io_port->serial_read_aborts_ignored++; #endif         return TRUE;     }   3     /* If the read failed, then signal the error */ ;     if (io_port->serial_read_iosb.status == SS$_DATAOVERUN)      { F         signal_error (PPPD$_DATAOVERUN, 1, &io_port->serial_portname);     }      else     { 7         DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0_6             ("serial_port_read_ast (QIO iosb status)",               PPPD$_READERR,/               io_port->serial_read_iosb.status, (              &io_port->serial_portname);     }t   #ifdef DIALOUT_STATS     /* Gather statistics */U     io_port->serial_reads++; #endif  4     /* Wait a while for more characters to arrive */D     if (!timed_wait (io_port->serial_read_efn, &wait_time, io_port))         return FALSE;*  4     /* Read more characters if they are out there */(     if (!serial_port_read_all (io_port))         return FALSE;u       /* Write out the data */'     if (!terminal_port_write (io_port))*         return FALSE;o       /* Start another read */$     if (!serial_port_read (io_port))         return FALSE;u       return TRUE; }o h /* ** Function Name ** **    serial_port_write. ** ** Functional Description  **G **    This routine starts a write to the serial port.  It will allocate E **    an IOSB buffer, start a write QIO on the serial port, and checke **    the QIO call status. ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled./ **	 ** Inputsn **B **    io_port   - structure holding the dialout functional context **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */7 PROC_STATIC int serial_port_write (port_block *io_port)_ {f iosb_buffer     *iosb; int             write_size;b   #ifdef DIALOUT_TRACEA     fprintf (dialout_trace_file, "Entering serial_port_write\n");  #endif  +     /* Allocate and set up an IOSB block */ *     iosb            = allocate_iosb_bufferC                           (io_port->allocated_iosb_buffer_listhead,->                            io_port->free_iosb_buffer_listhead,$                            io_port);     if (iosb == NULL)          return FALSE;      iosb->io_port   = io_port;  =     /* Start the write for the data out to the serial port */ 5     write_size  = io_port->terminal_read_iosb.count +r8                   io_port->terminal_read_iosb.term_size;#     io_port->serial_write_status  =S:         sys$qio  (PPPD_EFN,                      /* EFN */B                   io_port->serial_channel,       /* I/O channel */D                   IO$_WRITEVBLK,                 /* Function code */A                   &iosb->iosb,                   /* IOSB block */ B                   &serial_port_write_ast,        /* AST address */@                   iosb,                          /* AST param */O                   io_port->terminal_read_buffer, /* P1 - data buffer address */rL                   write_size,                    /* P2 - data buffer size */I                   0L,                            /* P3 - timeout count */tZ                   0L,                            /* P4 - read term. desc. block address */Q                   0L,                            /* P5 - prompt buffer address */eN                   0L);                           /* P6 - prompt buffer size */  3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0f*         ("serial_port_write (QIO status)",           PPPD$_WRITEERR, '           io_port->serial_write_status,l$          &io_port->serial_portname);       return TRUE; }n h /* ** Function Name ** **    serial_port_write_ast  ** ** Functional Description  **K **    This routine simply checks the IOSB status block of any writes to thee5 **    serial port, and reports any unexpected errors.t ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.O **	 ** Inputsp **H **    iosb      - IOSB buffer holding the dialout functional context and' **                the IOSB status blockh **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */9 PROC_STATIC int serial_port_write_ast (iosb_buffer *iosb)/ {/ port_block *io_port;  0     /* Store IOSB information and free buffer */0     io_port                     = iosb->io_port;-     io_port->serial_write_iosb  = iosb->iosb; C     if (!free_iosb_buffer (io_port->allocated_iosb_buffer_listhead, >                            io_port->free_iosb_buffer_listhead,*                            iosb, io_port))         return FALSE;e   #ifdef DIALOUT_TRACEE     fprintf (dialout_trace_file, "Entering serial_port_write_ast\n");  #endif  I     /* If the port was closed, or discontinued processing, just return */ )     if ((io_port->serial_io_cancelled) ||r>         (io_port->dialout_return_status != DIALOUT_STATUS_OK))         return TRUE;  L     /* If the status is SS$_ABORT or SS$_CANCEL, this may be from a break */4     /* command sent from the user, so ignore here */<     if ((io_port->serial_write_iosb.status == SS$_ABORT)  ||:         (io_port->serial_write_iosb.status == SS$_CANCEL))     {t #ifdef DIALOUT_STATS/         io_port->serial_write_aborts_ignored++;u #endif         return TRUE;     }e  4     /* If the write failed, then signal the error */3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0R3         ("serial_port_write_ast (QIO iosb status)",i           PPPD$_WRITEERR,s,           io_port->serial_write_iosb.status,$          &io_port->serial_portname);       return TRUE; }  E /* ** Function Name **& **    set_port_chars (characteristics) ** ** Functional Description  **6 **    This routine will set the device characteristics **    on the specified channel.s ** ** Environment ** **    User mode. **	 ** Inputsr **3 **    channel           - IO channel of the device.O: **    device_name       - descriptor with the device name.J **    device_chars      - structure for the desired device characteristics **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */` PROC_STATIC int set_port_chars (CHAN channel, D_DESCRIPTOR *device_name, DEV_CHAR *device_chars) {  VMS_STATUS status; SENSE_IOSB set_iosb;  &     /* Set the port characteristics */9     status = sys$qiow (PPPD_EFN,                /* EFN */s:                        channel,                 /* chan */:                        IO$_SETMODE,             /* func */:                        &set_iosb,               /* iosb */<                        0,                       /* astadr */<                        0,                       /* astprm */8                        device_chars,            /* p1 */8                        sizeof(*device_chars),   /* p2 */@                        0,                       /* p3 - speed */=                        0, 0, 0);                /* p4 - p6 */ +     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0)=         ("set_port_chars (sys$qiow status)", PPPD$_PORTSETUP,s           status, device_name); +     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0aB         ("set_port_chars (sys$qiow iosb.status)", PPPD$_PORTSETUP,(           set_iosb.status, device_name);       return TRUE; }d l /* ** Function Name ** **    setup_hangup_ast ** ** Functional Descriptions **< **    This routine will set up an AST to fire when the modemA **    hangs up.  Since actual control-Ys are passed through, thist1 **    AST will only fire when the modem hangs up.  ** ** Environment ** **    User mode. **	 ** Inputss **B **    io_port   - structure holding the dialout functional context **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */6 PROC_STATIC int setup_hangup_ast (port_block *io_port) {r VMS_STATUS status; SENSE_IOSB set_iosb;       /* Set up the hangup AST */s;     status = sys$qiow (PPPD_EFN,                  /* EFN */r<                        io_port->serial_channel,   /* chan */<                        IO$_SETMODE|IO$M_CTRLYAST, /* func */<                        &set_iosb,                 /* iosb */>                        0L,                        /* astadr */>                        0L,                        /* astprm */I                        &hangup_ast,               /* p1 - "hangup" AST */bF                        HANGUP_DEFAULT_PARAMETER,  /* p2 - AST param */L                        0L,                        /* p3 - AST access mode */?                        0L, 0L, 0L);               /* p4 - p6 */R+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0e=         ("set_hangup_ast (sys$qiow status)", PPPD$_PORTSETUP, -           status, &io_port->serial_portname);1+     CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0AB         ("set_hangup_ast (sys$qiow iosb.status)", PPPD$_PORTSETUP,6           set_iosb.status, &io_port->serial_portname);       return TRUE; }e f /* ** Function Name ** **    terminal_port_read ** ** Functional Descriptioni **H **    This routine starts a read on the terminal port.  It will allocateF **    an IOSB buffer, start a read QIO on the terminal port, and check **    the QIO call status. ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.o **	 ** Inputs  **B **    io_port   - structure holding the dialout functional context **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */8 PROC_STATIC int terminal_port_read (port_block *io_port) {d iosb_buffer     *iosb;   #ifdef DIALOUT_TRACEB     fprintf (dialout_trace_file, "Entering terminal_port_read\n"); #endif  +     /* Allocate and set up an IOSB block */n*     iosb            = allocate_iosb_bufferC                           (io_port->allocated_iosb_buffer_listhead,E>                            io_port->free_iosb_buffer_listhead,$                            io_port);     if (iosb == NULL)          return FALSE;d     iosb->io_port   = io_port;  .     /* Start the read for the terminal port */$     io_port->terminal_read_status  =:         sys$qio  (PPPD_EFN,                      /* EFN */B                   io_port->terminal_channel,     /* I/O channel */D                   IO$_READVBLK|IO$M_NOECHO,      /* Function code */A                   &iosb->iosb,                   /* IOSB block */rB                   &terminal_port_read_ast,       /* AST address */@                   iosb,                          /* AST param */O                   io_port->terminal_read_buffer, /* P1 - data buffer address */ L                   SINGLE_CHAR,                   /* P2 - data buffer size */I                   0L,                            /* P3 - timeout count */eZ                   0L,                            /* P4 - read term. desc. block address */Q                   0L,                            /* P5 - prompt buffer address */ N                   0L);                           /* P6 - prompt buffer size */  3     /* If the read failed, then signal the error */t3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0n+         ("terminal_port_read (QIO status)",o           PPPD$_READERR,(           io_port->terminal_read_status,&          &io_port->terminal_portname);       return TRUE; }  c /* ** Function Name ** **    terminal_port_read_ast ** ** Functional Description, **L **    This routine processes the terminal port output.  It releases the IOSBJ **    buffer, does the appropriate processing if the character is a switchH **    character, and will start the write to the serial port and restartD **    the read to the terminal port if the character is not a switch **    character. ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.t **	 ** Inputst **H **    iosb      - IOSB buffer holding the dialout functional context and( **                the IOSB status block. **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */: PROC_STATIC int terminal_port_read_ast (iosb_buffer *iosb) {  port_block  *io_port;L   #ifdef DIALOUT_TRACEF     fprintf (dialout_trace_file, "Entering terminal_port_read_ast\n"); #endif  0     /* Store IOSB information and free buffer */0     io_port                     = iosb->io_port;-     io_port->terminal_read_iosb = iosb->iosb; C     if (!free_iosb_buffer (io_port->allocated_iosb_buffer_listhead, >                            io_port->free_iosb_buffer_listhead,*                            iosb, io_port))         return FALSE;3  I     /* If the port was closed, or discontinued processing, just return */-)     if ((io_port->serial_io_cancelled) || >         (io_port->dialout_return_status != DIALOUT_STATUS_OK))         return TRUE;  3     /* If the read failed, then signal the error */u;     if (io_port->serial_read_iosb.status == SS$_DATAOVERUN)U     { H         signal_error (PPPD$_DATAOVERUN, 1, &io_port->terminal_portname);     }      else     {r7         DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0 8             ("terminal_port_read_ast (QIO iosb status)",               PPPD$_READERR,1               io_port->terminal_read_iosb.status, *              &io_port->terminal_portname);     }    #ifdef DIALOUT_TRACE!     /* Output what was read in */ Z     fprintf (dialout_trace_file, "    Buffer = >%c<\n", io_port->terminal_read_buffer[0]); #endif   #ifdef DIALOUT_STATS     /* Gather statistics */r     io_port->terminal_reads++; #endif  5     /* Has the user specified a special character? */oE     if (io_port->terminal_read_buffer[0] == io_port->disconnect_char)I     { @         /* Disconnect from the port and return to the utility */L         WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS (DIALOUT_DISCONNECT_FROM_PORT);         return TRUE;     }*F     else if (io_port->terminal_read_buffer[0] == io_port->switch_char)     { $         /* Switch the line to PPP */E         WAKEN_MAIN_ROUTINE_WITH_ERROR_STATUS (DIALOUT_SWITCH_TO_PPP);          return TRUE;     } E     else if (io_port->terminal_read_buffer[0] == io_port->break_char)o     {b6         /* Send a break signal over the serial port */8         if (!send_break_signal_to_serial_port (io_port))             return FALSE;             /* Start another read */*         if (!terminal_port_read (io_port))             return FALSE;t           return TRUE;     }o  .     /* Normal character, write out the data */%     if (!serial_port_write (io_port))j         return FALSE;(       /* Start another read */&     if (!terminal_port_read (io_port))         return FALSE;K       return TRUE; };   /* ** Function Name ** **    terminal_port_write  ** ** Functional Descriptionc **I **    This routine starts a write to the terminal port.  It will allocatesG **    an IOSB buffer, start a write QIO on the terminal port, and check  **    the QIO call status. ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.a **	 ** Inputsa **B **    io_port   - structure holding the dialout functional context **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */9 PROC_STATIC int terminal_port_write (port_block *io_port)c {n iosb_buffer     *iosb; int             write_size;*   #ifdef DIALOUT_TRACEC     fprintf (dialout_trace_file, "Entering terminal_port_write\n");  #endif  +     /* Allocate and set up an IOSB block */ *     iosb            = allocate_iosb_bufferC                           (io_port->allocated_iosb_buffer_listhead,R>                            io_port->free_iosb_buffer_listhead,$                            io_port);     if (iosb == NULL)i         return FALSE;c     iosb->io_port   = io_port;  *     /* Figure out the size of the write */3     write_size  = io_port->serial_read_iosb.count + 6                   io_port->serial_read_iosb.term_size;  ?     /* Start the write for the data out to the terminal port */ %     io_port->terminal_write_status  = ;         sys$qio  (PPPD_EFN,                       /* EFN */ C                   io_port->terminal_channel,      /* I/O channel */ E                   IO$_WRITEVBLK,                  /* Function code */ B                   &iosb->iosb,                    /* IOSB block */C                   &terminal_port_write_ast,       /* AST address */eA                   iosb,                           /* AST param */ P                   io_port->serial_read_buffer,    /* P1 - data buffer address */M                   write_size,                     /* P2 - data buffer size */EJ                   0L,                             /* P3 - timeout count */[                   0L,                             /* P4 - read term. desc. block address */*R                   0L,                             /* P5 - prompt buffer address */O                   0L);                            /* P6 - prompt buffer size */n  3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0S,         ("terminal_port_write (QIO status)",           PPPD$_WRITEERR, )           io_port->terminal_write_status,r&          &io_port->terminal_portname);       return TRUE; }O u /* ** Function Name ** **    terminal_port_write_astS ** ** Functional Descriptiont **K **    This routine simply checks the IOSB status block of any writes to theM7 **    terminal port, and reports any unexpected errors.h ** ** Environment **H **    User mode, AST level.  For the proper synchronization in accessingF **    the allocated and free IOSB lists, this routine must run withoutH **    interruption from any other routine that uses these lists.  If theI **    environment is not AST level, then user mode ASTs must be disabled.a **	 ** Inputs  **H **    iosb      - IOSB buffer holding the dialout functional context and( **                the IOSB status block. **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */; PROC_STATIC int terminal_port_write_ast (iosb_buffer *iosb)  {0 port_block  *io_port;    #ifdef DIALOUT_TRACEG     fprintf (dialout_trace_file, "Entering terminal_port_write_ast\n");w #endif  0     /* Store IOSB information and free buffer */0     io_port                     = iosb->io_port;-     io_port->terminal_write_iosb= iosb->iosb;wC     if (!free_iosb_buffer (io_port->allocated_iosb_buffer_listhead,->                            io_port->free_iosb_buffer_listhead,*                            iosb, io_port))         return FALSE;   I     /* If the port was closed, or discontinued processing, just return */ )     if ((io_port->serial_io_cancelled) ||h>         (io_port->dialout_return_status != DIALOUT_STATUS_OK))         return TRUE;  4     /* If the write failed, then signal the error */3     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS_1_0t5         ("terminal_port_write_ast (QIO iosb status)",n           PPPD$_WRITEERR,h.           io_port->terminal_write_iosb.status,&          &io_port->terminal_portname);       return TRUE; }    /* ** Function Name ** **    timed_wait ** ** Functional DescriptionO **F **    This routine will wait the process the amount of time specified. ** ** Environment ** **    User mode. **	 ** Inputsm **B **    wait_efn          - event flag number for this routine's use0 **    wait_time         - amount of time to waitJ **    io_port           - structure holding the dialout functional context **
 ** Outputs **
 **    None **
 ** Returns **< **    TRUE or FALSE, depending on the success of the routine ** */S PROC_STATIC int timed_wait (EFN wait_efn, VMS_TIME *wait_time, port_block *io_port)  {  VMS_STATUS status;  !     /* Start the timer routine */nD     status = sys$setimr (wait_efn,      /* EFN to set when done   */D                          wait_time,     /* amount of time to wait */D                          0L,            /* AST routine address    */D                          0L,            /* Timer request ID       */D                          0L);           /* Timer flags            */  8     /* If the set timer failed, then signal the error *//     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUS #         ("timed_wait (sys$setimr)",            PPPD$_TIMERSETUP,            status);  /     /* Wait for the event flag to be changed */a#     status = sys$waitfr (wait_efn);C  B     /* If the wait for event flag failed, then signal the error *//     DIALOUT_CHECK_AND_REPORT_CONTEXT_AND_STATUSu#         ("timed_wait (sys$waitfr)",            PPPD$_TIMERSETUP,            status);       return TRUE; }    /* ** Function Name ** **    dialout_main ** ** Functional Description  **I **    This is the external routine to be called for the dialout function.IG **    It handles everything from opening the channels to the devices toTJ **    the cleanup after the session is done, and returns either a functionH **    desired by the user (switch to PPP, disconnect) or an error status: **    reporting an unrecoverable error within the session. ** ** Environment ** **    User mode. **	 ** Inputs  **N **    current_device    - pointer to the internal device information structureN **    break_char        - character used to signal that a break should be sentN **    disconnect_char   - character used to signal a rundown on the connection, **                        to the serial portP **    switch_char       - character used to signal the start of a PPP connection, **                        on the serial port **
 ** Outputs **
 **    None **
 ** Returns **A **    Dialout status code from the result of the dialout session.f ** */H DIALOUT_STATUS dialout_main(DEVICE_REC *current_device, char break_char,M                                                         char disconnect_char, I                                                         char switch_char)  {  D_DESCRIPTOR terminal_port;* DEV_CHAR temp_device_chars;  VMS_STATUS status; port_block io_port;n unsigned int i;s   #ifdef DIALOUT_TRACE char *temp;  #endif   #ifdef DIALOUT_TRACE3     temp        = getenv("DIALOUT_TRACE_FILENAME");D     if (temp != NULL)t     {o.         strcpy (dialout_trace_filename, temp);F         dialout_trace_file      = fopen (dialout_trace_filename, "w");     }      else'         dialout_trace_file      = NULL;r #endif       /* Initialization */<     io_port.dialout_return_status       = DIALOUT_STATUS_OK;5     io_port.break_char                  = break_char;r:     io_port.disconnect_char             = disconnect_char;6     io_port.switch_char                 = switch_char;  C     INIT_DYNAMIC_DESCRIPTOR (terminal_port, PPPD$C_DEVICENAME_MAX);a3     SET_DYNAMIC_DESCRIPTOR  (terminal_port, "TT:");    #ifdef DIALOUT_STATS.     io_port.calls_to_create_iosb_buffers  = 0; #endifI     if (!init_iosb_buffer_lists (&io_port.allocated_iosb_buffer_listhead,VD                                  &io_port.free_iosb_buffer_listhead,+                                  &io_port)) #         return DIALOUT_ERROR_ABORT;E  7     /* Set up the I/O channels and related variables */IK     if (!open_port (&current_device->device_name, &io_port.serial_channel))a     {i1         FREE_DYNAMIC_DESCRIPTOR (&terminal_port);a#         return DIALOUT_ERROR_ABORT;      }O  N     INIT_DYNAMIC_DESCRIPTOR (io_port.serial_portname, PPPD$C_DEVICENAME_MAX); R     status = str$copy_dx (&io_port.serial_portname, &current_device->device_name);     if (FAILURE(status))     {i!         REPORT_CONTEXT_AND_STATUStQ             ("dialout_main (str$copy_dx serial status)", PPPD$_DIALINIT, status);]1         FREE_DYNAMIC_DESCRIPTOR (&terminal_port);D;         FREE_DYNAMIC_DESCRIPTOR (&io_port.serial_portname); #         return DIALOUT_ERROR_ABORT;(     }_  0     io_port.serial_io_cancelled         = FALSE; #ifdef DIALOUT_STATS,     io_port.serial_reads                = 0;,     io_port.serial_read_alls            = 0;,     io_port.serial_read_aborts_ignored  = 0;,     io_port.serial_writes               = 0;,     io_port.serial_write_aborts_ignored = 0;%     for (i = 0; i < READALL_MAX; i++)o     {b6         io_port.serial_longest_read_all_size[i]   = 0;6         io_port.serial_longest_read_all_count[i]  = 0;     }  #endif3     status = lib$get_ef (&io_port.serial_read_efn); "     DIALOUT_CHECK_STATUS (status);  4     status = lib$get_ef (&io_port.serial_break_efn);"     DIALOUT_CHECK_STATUS (status);  ?     if (!open_port (&terminal_port, &io_port.terminal_channel))      {u/         lib$free_ef (&io_port.serial_read_efn);f0         lib$free_ef (&io_port.serial_break_efn);1         FREE_DYNAMIC_DESCRIPTOR (&terminal_port); ;         FREE_DYNAMIC_DESCRIPTOR (&io_port.serial_portname);i#         return DIALOUT_ERROR_ABORT;      }   P     INIT_DYNAMIC_DESCRIPTOR (io_port.terminal_portname, PPPD$C_DEVICENAME_MAX); T     status = str$copy_dx (&io_port.terminal_portname, &current_device->device_name);     if (FAILURE(status))     {e!         REPORT_CONTEXT_AND_STATUSgS             ("dialout_main (str$copy_dx terminal status)", PPPD$_DIALINIT, status);r/         lib$free_ef (&io_port.serial_read_efn);t0         lib$free_ef (&io_port.serial_break_efn);1         FREE_DYNAMIC_DESCRIPTOR (&terminal_port);a;         FREE_DYNAMIC_DESCRIPTOR (&io_port.serial_portname);n=         FREE_DYNAMIC_DESCRIPTOR (&io_port.terminal_portname); #         return DIALOUT_ERROR_ABORT;      }   *     io_port.terminal_io_cancelled = FALSE; #ifdef DIALOUT_STATS&     io_port.terminal_reads        = 0; #endif  F     /* Set device characteristics for the serial and terminal lines */E     get_port_chars (io_port.serial_channel, &io_port.serial_portname, 6                    &io_port.serial_orig_device_chars);E     temp_device_chars             = io_port.serial_orig_device_chars;fP     temp_device_chars.tt2_chars   = temp_device_chars.tt2_chars | TT2$M_PASTHRU;D     if (!lookup_asn_item (current_device->asn_items, ASN$_FLOW, &i))     {L6         signal_error (PPPD$_INVASNCODE, 1, ASN$_FLOW);/         lib$free_ef (&io_port.serial_read_efn);p0         lib$free_ef (&io_port.serial_break_efn);1         FREE_DYNAMIC_DESCRIPTOR (&terminal_port);t;         FREE_DYNAMIC_DESCRIPTOR (&io_port.serial_portname);p=         FREE_DYNAMIC_DESCRIPTOR (&io_port.terminal_portname); #         return DIALOUT_ERROR_ABORT;      };7     i = (int)current_device->asn_items[i].itm$l_bufadr;      if (i == ASN$M_XON_XOFF)     { I         temp_device_chars.basic_chars   = temp_device_chars.basic_chars | F                                           TT$M_HOSTSYNC | TT$M_TTSYNC;     }a$     else /* hardware flow control */     { >         if ((temp_device_chars.basic_chars & TT$M_MODEM) != 0)G             temp_device_chars.tt3_chars = temp_device_chars.tt3_chars |t9                                           TT3$M_RTS_FLOW;      };A     current_device->device_channel      = io_port.serial_channel; K     current_device->old_device_chars    = io_port.serial_orig_device_chars;k/     current_device->restore_device      = TRUE; Z     set_port_chars (io_port.serial_channel, &io_port.serial_portname, &temp_device_chars);<     io_port.serial_curr_device_chars    = temp_device_chars;:     if ((temp_device_chars.basic_chars & TT$M_MODEM) != 0)     {s/         /* Initialize the hangup AST context */o#         if (!hangup_ast (&io_port)) '             return DIALOUT_ERROR_ABORT;e  L         /* Set up the hangup AST to fire for the forced hangup below.     */L         /* Set the serial_io_cancelled flag to have the AST just return.  */3         io_port.serial_io_cancelled         = TRUE;,$         setup_hangup_ast (&io_port);M         hangup_serial_port (io_port.serial_channel, &io_port.serial_portname,t>                            &io_port.serial_curr_device_chars);  L         /* Now, set up the hangup AST for real.                           */4         io_port.serial_io_cancelled         = FALSE;$         setup_hangup_ast (&io_port);     }   I     get_port_chars (io_port.terminal_channel, &io_port.terminal_portname,c8                    &io_port.terminal_orig_device_chars);G     temp_device_chars             = io_port.terminal_orig_device_chars;nP     temp_device_chars.basic_chars = temp_device_chars.basic_chars | TT$M_TTSYNC;R     temp_device_chars.tt2_chars   = temp_device_chars.tt2_chars   | TT2$M_PASTHRU;C     current_device->terminal_channel    = io_port.terminal_channel;dM     current_device->old_terminal_chars  = io_port.terminal_orig_device_chars; /     current_device->restore_terminal    = TRUE;r^     set_port_chars (io_port.terminal_channel, &io_port.terminal_portname, &temp_device_chars);  !     /* Start the initial reads */eJ     sys$setast(0);      /* Disable ASTs while allocating an IOSB buffer */%     if (!serial_port_read (&io_port))s     {,/         sys$setast(1);      /* Reenable ASTs */ ,         close_port (io_port.serial_channel);.         close_port (io_port.terminal_channel);/         lib$free_ef (&io_port.serial_read_efn);r0         lib$free_ef (&io_port.serial_break_efn);1         FREE_DYNAMIC_DESCRIPTOR (&terminal_port);";         FREE_DYNAMIC_DESCRIPTOR (&io_port.serial_portname);_=         FREE_DYNAMIC_DESCRIPTOR (&io_port.terminal_portname); #         return DIALOUT_ERROR_ABORT;      }u'     if (!terminal_port_read (&io_port))*     { /         sys$setast(1);      /* Reenable ASTs */*,         close_port (io_port.serial_channel);.         close_port (io_port.terminal_channel);/         lib$free_ef (&io_port.serial_read_efn);e0         lib$free_ef (&io_port.serial_break_efn);1         FREE_DYNAMIC_DESCRIPTOR (&terminal_port);a;         FREE_DYNAMIC_DESCRIPTOR (&io_port.serial_portname);u=         FREE_DYNAMIC_DESCRIPTOR (&io_port.terminal_portname);s#         return DIALOUT_ERROR_ABORT;o     }u+     sys$setast(1);      /* Reenable ASTs */   %     /* Hibernate until we are done */t     sys$hiber();   #ifdef DIALOUT_STATS<     /* Print out statistics while in the dialout routines */4     fprintf (stderr, "\n\nDialout statistics:\n\n");c     fprintf (stderr, "    Create_io_buffers calls:  %10d\n", io_port.calls_to_create_iosb_buffers); U     fprintf (stderr, "    Terminal reads:           %10d\n", io_port.terminal_reads);rS     fprintf (stderr, "    Serial reads:             %10d\n", io_port.serial_reads); a     fprintf (stderr, "    Serial read aborts:       %10d\n", io_port.serial_read_aborts_ignored);Eb     fprintf (stderr, "    Serial write aborts:      %10d\n", io_port.serial_write_aborts_ignored);W     fprintf (stderr, "    Serial read alls:         %10d\n", io_port.serial_read_alls);)]     fprintf (stderr, "        (%d largest)              Length        Count\n", READALL_MAX);_%     for (i = 0; i < READALL_MAX; i++)i     {tG         fprintf (stderr, "                              %10d   %10d\n", A                          io_port.serial_longest_read_all_size[i], C                          io_port.serial_longest_read_all_count[i]);e     }c     fprintf (stderr, "\n");n #endif  ;     /* Process the status returned from the AST routines */s;     /* (disconnect, hangup, switch to PPP, error)        */s*     switch (io_port.dialout_return_status)     {c*         case DIALOUT_DISCONNECT_FROM_PORT:"         case DIALOUT_MODEM_HANGUP:!         case DIALOUT_ERROR_ABORT:n	         {*5             /* Cancel any outstanding I/O requests */ef             DIALOUT_CHECK_STATUS (cancel_io (io_port.serial_channel,   &io_port.serial_io_cancelled));h             DIALOUT_CHECK_STATUS (cancel_io (io_port.terminal_channel, &io_port.terminal_io_cancelled));  E             /* Reset the devices to their original characteristics */ R             if (!set_port_chars (io_port.serial_channel, &io_port.serial_portname,C                                 &io_port.serial_orig_device_chars))r+                 return DIALOUT_ERROR_ABORT;s8             current_device->restore_device      = FALSE;V             if (!set_port_chars (io_port.terminal_channel, &io_port.terminal_portname,E                                 &io_port.terminal_orig_device_chars)) +                 return DIALOUT_ERROR_ABORT;r8             current_device->restore_terminal    = FALSE;  -             /* Close down the I/O channels */nG             DIALOUT_CHECK_STATUS (close_port (io_port.serial_channel));fI             DIALOUT_CHECK_STATUS (close_port (io_port.terminal_channel));f  .             /* Free the dynamic descriptors */5             FREE_DYNAMIC_DESCRIPTOR (&terminal_port); ?             FREE_DYNAMIC_DESCRIPTOR (&io_port.serial_portname); A             FREE_DYNAMIC_DESCRIPTOR (&io_port.terminal_portname);/  2             /* Return the allocated event flags */<             status = lib$free_ef (&io_port.serial_read_efn);*             DIALOUT_CHECK_STATUS (status);  =             status = lib$free_ef (&io_port.serial_break_efn);t*             DIALOUT_CHECK_STATUS (status);  *             /* Release the IOSB buffers */O             if (!release_iosb_buffers (&io_port.allocated_iosb_buffer_listhead,.J                                        &io_port.free_iosb_buffer_listhead,1                                        &io_port)) +                 return DIALOUT_ERROR_ABORT;u  %             /* Exit from this case */              break;	         }u#         case DIALOUT_SWITCH_TO_PPP:t	         { 5             /* Cancel any outstanding I/O requests */(D             DIALOUT_CHECK_STATUS (cancel_io (io_port.serial_channel,K                                             &io_port.serial_io_cancelled));AF             DIALOUT_CHECK_STATUS (cancel_io (io_port.terminal_channel,M                                             &io_port.terminal_io_cancelled));c  E             /* Reset the devices to their original characteristics */ER             if (!set_port_chars (io_port.serial_channel, &io_port.serial_portname,C                                 &io_port.serial_orig_device_chars))p+                 return DIALOUT_ERROR_ABORT;p8             current_device->restore_device      = FALSE;V             if (!set_port_chars (io_port.terminal_channel, &io_port.terminal_portname,E                                 &io_port.terminal_orig_device_chars))s+                 return DIALOUT_ERROR_ABORT;r8             current_device->restore_terminal    = FALSE;  -             /* Close down the I/O channels */;I             DIALOUT_CHECK_STATUS (close_port (io_port.terminal_channel));n  .             /* Free the dynamic descriptors */5             FREE_DYNAMIC_DESCRIPTOR (&terminal_port); ?             FREE_DYNAMIC_DESCRIPTOR (&io_port.serial_portname);CA             FREE_DYNAMIC_DESCRIPTOR (&io_port.terminal_portname);k  2             /* Return the allocated event flags */<             status = lib$free_ef (&io_port.serial_read_efn);*             DIALOUT_CHECK_STATUS (status);  =             status = lib$free_ef (&io_port.serial_break_efn); *             DIALOUT_CHECK_STATUS (status);  *             /* Release the IOSB buffers */O             if (!release_iosb_buffers (&io_port.allocated_iosb_buffer_listhead,CJ                                        &io_port.free_iosb_buffer_listhead,1                                        &io_port))t+                 return DIALOUT_ERROR_ABORT;s  .             /* Send the serial channel back */D             current_device->device_channel = io_port.serial_channel;  %             /* Exit from this case */r             break;	         }i         default:	         {e?             /* We should never get here, but just in case... */ N             signal_error (PPPD$_INVDIALSTS, 1, io_port.dialout_return_status);  %             /* Exit from this case */              break;	         }O     };  )     return io_port.dialout_return_status;A };