I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      ppp_log.c  **
 **  ABSTRACT:  **F **      This module implements routines required to implement logging. ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      29-November-1995 ** **  MODIFICATION HISTORY:  **C **      X-4     BWK002          Barry W. Kierstein      17-DEC-1996 < **              Replaced the standard Digital copyright with6 **              one compatible with the CMU copyright. **- **	X-3	BWK001		Barry W. Kierstein	24-Jul-1996  **		Corrected copyright notice.  **, **	X-2	FAK001		Forrest A. Kenney	10-May-1996> **		Change ppp_log, and ppp_sprintf to correctly pass variable  **		length argument list around. **+ **      29-November-1995  Original version.  ** **-- */   /* ** Include files */   /* ** ** import definitions:/ **        prototypes for this module's routines  ** */ #ifndef _PPP_LOG_H_  #include "ppp_log.h" #endif   /* ** ** import definitions:
 **        fsm  ** */ #ifndef _FSM_H_  #include "fsm.h" #endif   /* ** ** import definitions: **        PPPLine  ** */ #ifndef _LCP_VMS_H_  #include "lcp_vms.h" #endif   /* ** ** import definitions: **        varargs  ** */ #ifndef __STDARG_LOADED  #include "stdarg.h"  #endif   /* ** ** import definitions: **        isascii  **        isdigit  ** */ #ifndef __CTYPE_LOADED #include "ctype.h" #endif   /* ** ** import definitions:
 **        UCB  ** */ #ifndef _UCBDEF_LOADED #include "ucbdef.h"  #endif   /* ** ** import definitions: **        deviceGetUCB ** */ #ifndef _PPP_ASYNC_H_  #include "ppp_async.h" #endif   /* ** Local routines  */E int ppp_sprintf( char *string_buf, const char *format, va_list *ap ); @ int ppp_vsprintf( char *dest, const char *fmt0, va_list *argp );   /* ** External variables  */0 extern __int64 EXE$GQ_SYSTIME;	/* system time */     /* **++ **  FUNCTION NAME: ** **      ppp_log  ** **  FUNCTIONAL DESCRIPTION:  **F **      This routine writes a debug message to the debug mailbox setup **      on the PPP line. **    I **      The first time this routine is called the the UCB associated with P **      the debug mailbox is found.   A pointer to the UCB is then saved in the U **      PPP line.   The UCB is searched for at this stage because a situation existed U **      where the mailbox disappeared between setting it in the line and the logging  O **      of an event.  To be totally safe we really should check the mailbox is  W **      still present everytime an event is logged but it was decided that this imposes X **      too much of an overhead and if the mailbox has vanished someone (with privilege) **      has been naughty.  ** **  FORMAL PARAMETERS: **2 **      fmsPtr     Pointer to fsm to log event forM **      prioriy    The level (e.g. LOG_INFO) of the debug message to be sent. C **      format     Pointer to string containing the debug message.   ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **C **      A pointer to the UCB associated with the debug mailbox will ! **      be saved in the PPP line.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **? **      If the UCB associated with the mailbox cannot be found  ; **      then debugging on the line is turned off by setting ) **      the debug mailbox lenght to zero.  ** **-- */< void ppp_log( fsm *fsmPtr, int priority, char *format, ... ) { :     va_list    ap;		/* pointer to variable arg  list    */>     logRecord *logRec;		/* pointer to log record            */<     PPPLine   *line;		/* pointer to PPP line structure    */=     u_int     status;		/* function return status           */ B     UCB       *debugMbxUCB;	/* pointer to the debug mailbox UCB */     $     line = LINE_ENTRY(fsmPtr->line);  0     /* check if debugging enabled on the line */8     if ( line->debug == TRUE && line->debugMbxLen != 0 )     { A 	/* check to see if UCB for the mailbox has already been found */  	if ( line->debugMbxUCB == 0 ) 	{N 	    status = deviceGetUCB( line->debugMbx, line->debugMbxLen, &debugMbxUCB ); 	    /* D 	     ** If the GetUCB function fails it means the mailbox has gone @ 	     ** away.  Turn off debugging by setting the length of the  	     ** debug mailbox to zero.  	     */  	    if ( status != SS$_NORMAL ) 	    { 		line->debugMbxLen = 0;	 		return;  	    }	 	    else  	    {, 		line->debugMbxUCB = (MB_UCB *)debugMbxUCB; 	    } 	}  #         /* allocate a log record */ 5 	ALLOC_MEM( logRec, sizeof(logRecord), logRecord * );      	if ( logRec )     	{& 		logRec->timeStamp = EXE$GQ_SYSTIME;  		logRec->msgType = priority;  		if ( format )  		{ / 	    	    /* put message into message buffer */ ! 	    	    va_start( ap, format ); N 	            logRec->msgLen = ppp_sprintf( (char *)logRec->msg, format, &ap ); 	            va_end( ap );
 	        } 		else 		{  	    	    logRec->msgLen = 0;  		}    		/*: 	 	** Post message. Ignore return code as there is nothing, 	 	** we can do if posting the message fails 	 	*/ K 		(void)exe_std$wrtmailbox( line->debugMbxUCB, sizeof(logRecord), logRec );  		DEALLOC_MEM( logRec );     	} /* end-if logRec */"     } /* end-if line->debug */         return;  }      /* **++ **  FUNCTION NAME: ** **      ppp_sprintf  ** **  FUNCTIONAL DESCRIPTION:  **K **      This implements a scaled version of sprintf.   It is needed because M **      sprintf isn't in the kernel and the logging code of pppd required it.  ** **  FORMAL PARAMETERS: **% **      see documentation for sprintf  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **" **      Lenght of formatted string ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */B int ppp_sprintf(char * string_buf,const char *format, va_list *ap) {      int rc;   .     rc = ppp_vsprintf(string_buf, format, ap);       return (rc); }      /* **++ **  FUNCTION NAME: ** **      ppp_vsprintf ** **  FUNCTIONAL DESCRIPTION:  **L **      This implements a scaled version of vsprintf.   It is needed becauseO **      vsprintf isn't in the kernel and the logging code of pppd required it..  ** **  FORMAL PARAMETERS: **' **      see documentation for vsprintf.  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **# **      Length of formatted string.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */   #define	DEFPREC		6   #define	BUF		20   # #define	PUTC(ch)	*dp++ = ch; cnt++;    #define	ARG() \ 0 _ulong = flags&LONGINT ? va_arg(*argp, long) : \; flags&SHORTINT ? va_arg(*argp, short) : va_arg(*argp, int);    #define	todigit(c)	((c) - '0') #define	tochar(n)	((n) + '0')   8 /* have to deal with the negative buffer count kludge */ #define	NEGATIVE_COUNT_KLUDGE   ) #define	LONGINT		0x01		/* long integer */ 7 #define	LONGDBL		0x02		/* long double; unimplemented */ * #define	SHORTINT	0x04		/* short integer */' #define	ALT		0x08		/* alternate form */ , #define	LADJUST		0x10		/* left adjustment */; #define	ZEROPAD		0x20		/* zero (as opposed to blank) pad */ 1 #define	HEXPREFIX	0x40		/* add 0x or 0X prefix */   > int ppp_vsprintf( char *dest, const char *fmt0, va_list *argp) { 2     register const char *fmt;  /* format string */7     register char *dp;	       /* Destination pointer */ 4     register int ch;	       /* character from fmt */;     register int cnt;	       /* return value accumulator */ 5     register int n;	       /* random handy integer */ 1     register char *t;	       /* buffer pointer */ @     unsigned long _ulong;      /* integer arguments %[diouxX] */A     unsigned short base = 10;  /* base for [diouxX] conversion */ :     int dprec;		       /* decimal precision in [diouxX] */>     int fieldsz;	       /* field size expanded by sign, etc */+     int flags;		       /* flags as above */ C     int fpprec;		       /* `extra' floating precision in [eEfgG] */ ?     int prec;		       /* precision from format (%.3d), or -1 */ F     int realsz;		       /* field size expanded by decimal precision */=     int size;		       /* size of converted field or string */ :     int width;		       /* width from format (%8d), or 0 */?     char sign;		       /* sign prefix (' ', '+', '-', or \0) */ B     char softsign;	       /* temporary negative sign for floats */A     const char *digs;	       /* digits for [diouxX] conversion */ A     char buf[BUF];	       /* space for %c, %[diouxX], %[eEfgG] */      int error_number = 0;        dp = dest;     fmt = fmt0;      digs = "0123456789abcdef";     for (cnt = 0;; ++fmt) { * 	for (; (ch = *fmt) && ch != '%'; ++fmt) { 	    PUTC(ch); 	} 	if (!ch) {  	    PUTC(ch); 	    return (--cnt); 	} 	flags = 0;* 	dprec = 0;* 	fpprec = 0; 	width = 0;  	prec = -1; 
 	sign = '\0';          rflag:switch (*++fmt) {  	    case ' ': 		/*6 		 * ``If the space and + flags both appear, the space 		 * flag will be ignored.'' 		 *	-- ANSI X3J11 		 */  		if (!sign) 		    sign = ' '; 
 		goto rflag;  	    case '#': 		flags |= ALT; 
 		goto rflag;  	    case '*': 		/*4 		 * ``A negative field width argument is taken as a2 		 * - flag followed by a  positive field width.'' 		 *	-- ANSI X3J114 		 * They don't exclude field widths read from args. 		 */n( 		if ((width = va_arg(*argp, int)) >= 0) 		    goto rflag;l 		width = -width;  		/* FALLTHROUGH */b 	    case '-': 		flags |= LADJUST;f
 		goto rflag;o 	    case '+':
 		sign = '+';m
 		goto rflag;. 	    case '.': 		if (*++fmt == '*') 		    n = va_arg(*argp, int);d 		else { 		    n = 0;, 		    while (isascii(*fmt) && isdigit(*fmt))  			n = 10 * n + todigit(*fmt++); 		    --fmt; 		}* 		prec = n < 0 ? -1 : n;
 		goto rflag;W 	    case '0': 		/*1 		 * ``Note that 0 is taken as a flag, not as the " 		 * beginning of a field width.'' 		 *	-- ANSI X3J11 		 */I 		flags |= ZEROPAD;P
 		goto rflag;S 	    case '1': 	    case '2': 	    case '3': 	    case '4': 	    case '5': 	    case '6': 	    case '7': 	    case '8': 	    case '9': 		n = 0; 		do {! 		    n = 10 * n + todigit(*fmt);_- 		} while (isascii(*++fmt) && isdigit(*fmt));d 		width = n; 		--fmt;
 		goto rflag;l 	    case 'L': 		flags |= LONGDBL; 
 		goto rflag;  	    case 'h': 		flags |= SHORTINT;
 		goto rflag;  	    case 'l': 		flags |= LONGINT;e
 		goto rflag;  	    case 'c':" 		*(t = buf) = va_arg(*argp, int); 		size = 1;  		sign = '\0';
 		goto pforw;  	    case 'D': 		flags |= LONGINT;  		/*FALLTHROUGH*/i 	    case 'd': 	    case 'i': 		ARG(); 		if ((long) _ulong < 0) { 		    _ulong = -_ulong;i 		    sign = '-';	 		}c 		base = 10; 		goto number;   	    case 'n': 		if (flags & LONGINT)# 		    *va_arg(*argp, long *) = cnt;  		else if (flags & SHORTINT)$ 		    *va_arg(*argp, short *) = cnt; 		else" 		    *va_arg(*argp, int *) = cnt; 		break; 	    case 'O': 		flags |= LONGINT;  		/*FALLTHROUGH*/i 	    case 'o': 		ARG(); 		base = 8;o 		goto nosign; 	    case 'p': 		/*4 		 * ``The argument shall be a pointer to void.  The4 		 * value of the pointer is converted to a sequence3 		 * of printable characters, in an implementation-  		 * defined manner.'' 		 *	-- ANSI X3J11 		 */L 		/* NOSTRICT */1 		_ulong = (unsigned long) va_arg(*argp, void *);i 		base = 16; 		goto nosign;   	    case 's': 		t = va_arg(*argp, char *); 		if (!t) {  		    strcpy(buf, "(null)"); 		    t = buf; 		}  	      string:if (prec >= 0) {8 		    for (size = 0; (size < prec) && t[size]; size++) ; 		} else 		    size = strlen(t);C 		sign = '\0';
 		goto pforw;D 	    case 'U': 		flags |= LONGINT;* 		/*FALLTHROUGH*/i 	    case 'u': 		ARG(); 		base = 10; 		goto nosign; 	    case 'B': 		digs = "_|"; 		/* FALLTHROUGH */c 	    case 'b': 		ARG(); 		base = 2;  		goto binhex; 	    case 'X': 		digs = "0123456789ABCDEF"; 		/* FALLTHROUGH */s 	    case 'x': 		ARG(); 		base = 16;4 	      binhex:			/* leading 0x/X only if non-zero */! 		if (flags & ALT && _ulong != 0)+ 		    flags |= HEXPREFIX;*   		/* unsigned conversions */ 	      nosign:sign = '\0'; 		/*3 		 * ``... diouXx conversions ... if a precision iss- 		 * specified, the 0 flag will be ignored.''  		 *	-- ANSI X3J11 		 */ & 	      number:if ((dprec = prec) >= 0) 		    flags &= ~ZEROPAD;   		/*4 		 * ``The result of converting a zero value with an3 		 * explicit precision of zero is no characters.''e 		 *	-- ANSI X3J11 		 */  		t = buf + BUF;! 		if (_ulong != 0 || prec != 0) { 
 		    do { 			*--t = digs[_ulong % base]; 			_ulong /= base; 		    } while (_ulong);l2 		    if (flags & ALT && base == 8 && *t != *digs)& 			*--t = *digs;	/* octal leading 0 */ 		}h 		size = buf + BUF - t;   
 	      pforw:e 		/*9 		 * All reasonable formats wind up here.  At this point,*8 		 * `t' points to a string which (if not flags&LADJUST)0 		 * should be padded out to `width' places.  If6 		 * flags&ZEROPAD, it should first be prefixed by any8 		 * sign or other prefix; otherwise, it should be blank4 		 * padded before the prefix is emitted.  After any1 		 * left-hand padding and prefixing, emit zeroesU9 		 * required by a decimal [diouxX] precision, then printd8 		 * the string proper, then emit zeroes required by any6 		 * leftover floating precision; finally, if LADJUST, 		 * pad with blanks.C 		 */*   		/*4 		 * compute actual size, so we know how much to pad6 		 * fieldsz excludes decimal prec; realsz includes it 		 */n 		fieldsz = size + fpprec; 		if (sign)e 		    fieldsz++; 		if (flags & HEXPREFIX) 		    fieldsz += 2; - 		realsz = dprec > fieldsz ? dprec : fieldsz;t  % 		/* right-adjusting blank padding */c2 		if ((flags & (LADJUST | ZEROPAD)) == 0 && width)& 		    for (n = realsz; n < width; n++)
 			PUTC(' ');e 		/* prefix */ 		if (sign)	 		    PUTC(sign);  		if (flags & HEXPREFIX) { 		    PUTC(*digs); 		    PUTC((char) *fmt); 		}o$ 		/* right-adjusting zero padding *// 		if ((flags & (LADJUST | ZEROPAD)) == ZEROPAD)e& 		    for (n = realsz; n < width; n++) 			PUTC(*digs);e- 		/* leading zeroes from decimal precision */C# 		for (n = fieldsz; n < dprec; n++)u 		    PUTC(*digs);  # 		/* the string or number proper */e 		BCOPY(t, (char *) dp, size);
 		dp += size;& 		cnt += size; 		/* trailing f.p. zeroes */ 		while (--fpprec >= 0)s 		    PUTC(*digs);- 		/* left-adjusting padding (always blank) */n 		if (flags & LADJUST)& 		    for (n = realsz; n < width; n++)
 			PUTC(' ');t 		digs = "0123456789abcdef"; 		break;7 	    case '\0':			/* "%?" prints ?, unless ? is NULL */i 		PUTC((char) *fmt); 		return (--cnt); 
 	    default:  		PUTC((char) *fmt); 	}     }      /* NOTREACHED */ }e