I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      ppp_lib  **
 **  ABSTRACT:  **= **      This module contains the routine required to find the @ **      find the vector's of routines exported by the PPP driverA **      i.e. the vector of management functions and the vector of  **      fsm functions. ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      1-March-1996 ** **  MODIFICATION HISTORY:  **, **      17-December-1996  Barry W. KiersteinF **                        Replaced the standard Digital copyright with@ **                        one compatible with the CMU copyright. **, **      24-July-1996      Barry W. Kierstein5 **                        Corrected copyright notice.  **+ **      1-March-1996      Original version.  ** **-- */   /* ** ** import definitions: **        strncpy  ** */ #ifndef __STRING_LOADED  #include "string.h"  #endif   /* ** ** import definitions: **        IOC$M_ANY  ** */ #ifndef __IOCDEF_LOADED  #include "iocdef.h"  #endif   /* ** ** import definitions: **        ioc_std$searchint  **        ioc_std$parsdevnam ** */ #ifndef __IOC_ROUTINES_LOADED  #include "ioc_routines.h"  #endif   /* ** ** import definitions: **        SS$_xxx  ** */ #ifndef __SSDEF_LOADED #include "ssdef.h" #endif     /* **++ **  FUNCTION NAME: ** **      PPPD$LIBRTNS ** **  FUNCTIONAL DESCRIPTION:  **J **      This routine returns a pointer to the set of routines specified byN **      vectorCode.   PPP stores the address of a table of the vector pointersP **      in the ps_vector field of the DPT.   The address of the table is located= **      and the pointer to the requested vector is returned.   ** **  FORMAL PARAMETERS: **H **      vectorCode    The code indicating the requried vector to return N **                    e.g. PPP_MGMT_RTNS for the vector of management routines ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **3 **      Pointer to the required vector of routines. % **      NULL if the vector not found.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */$ void *PPPD$LIBRTNS( int vectorCode ) { M     int     status;        /* Function return code                         */ M     DDB    *ddbPtr;        /* Pointer to PPP device's data block           */ M     SB     *sbPtr;         /* Pointer to PPP device's system control block */ J     void   *lockPtr;	   /* Pointer to PPP device's lock                 */M     char   *devName;       /* Pointer to parsed device name                */ M     int32   devNameLen;    /* Lenght of parsed device name                 */ M     int32   unit;          /* Unit number of parsed device name            */ M     int32   scsLen;        /* Length of scs field in device name           */ M     int     flagsIn;       /* Flags to call parsedev with                  */ M     int32   flagsOut;      /* Flags returned by parsdev                    */ M     UCB    *ucbPtr;        /* Pointer to PPP devices's UCB                 */ M     void   *rtnStructAddr; /* Pointer to returned vector                   */ M     void   **vectors;      /* Table containing vector pointers             */ M     char     pppDev[4];    /* String to hold PPP device name               */        rtnStructAddr = NULL;	  ;     /* parsdevnam needs a writable string - so do a copy */ -     strncpy( pppDev, "PPP0", strlen("PPP0")); $     flagsIn = IOC$M_ANY | IOC$M_PHY;8     status = ioc_std$parsdevnam( sizeof(pppDev), pppDev,+ 				 flagsIn, &unit, &scsLen, &devNameLen,   				 &devName, &flagsOut );           if ( status == SS$_NORMAL )      { @ 	status = ioc_std$searchint( unit, scsLen, devNameLen, devName,  				    flagsIn, &ucbPtr, $ 				    &ddbPtr, &sbPtr, &lockPtr ); 	if ( status == SS$_NORMAL ) 	{: 	    vectors = (void **)ddbPtr->ddb$ps_dpt->dpt$ps_vector;) 	    rtnStructAddr = vectors[vectorCode];  	}     }      return( rtnStructAddr ); } 