I /************************************************************************ I **                                                                      * I ** Copyright  1996 Digital Equipment Corporation.                      * I ** All rights reserved.                                                 * I **                                                                      * I ** Redistribution and use in source and binary forms are permitted      * I ** provided that the above copyright notice and this paragraph are      * I ** duplicated in all such forms and that any documentation,             * I ** advertising materials, and other materials related to such           * I ** distribution and use acknowledge that the software was developed     * I ** by Digital Equipment Corporation.  The name of the                   * I ** Corporation may not be used to endorse or promote products derived   * I ** from this software without specific prior written permission.        * I ** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR       * I ** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       * I ** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  * I **                                                                      * I *************************************************************************  **++
 **  FACILITY:  ** **      lcp_vms.c  **
 **  ABSTRACT:  **< **      This module contains routines specific to VMS which 4 **      implement the link control protocol for PPP. ** **  AUTHORS: **; **      Patrick Crilly,   Networks Engineering (Australia).  ** **  CREATION DATE: ** **      29-Novemver-1995 ** **  MODIFICATION HISTORY:  **C **      X-5     BWK001          Barry Kierstein         17-Dec-1996 H **              Replaced the standard Digital copyright with            6 **              one compatible with the CMU copyright. **C **      X-4     PWC001          Patrick W. Crilly       27-Aug-1996 F **              lcp_up sets MRU and asyncmap to default values if they( **              haven't been negotiated. **+ **      29-November-1995  Original version.  ** **-- */   /* ** Include files */   /* ** ** import definitions: **        types  ** */ #ifndef _PPPD_H_ #include "pppd.h"  #endif   /* ** ** import definitions:/ **        prototypes for this module's routines  **        line defintions  ** */ #ifndef _LCP_VMS_H_  #include "lcp_vms.h" #endif   /* ** ** import definitions:( **        prototypes for device routines ** */ #ifndef _PPP_ASYNC_H_  #include "ppp_async.h" #endif   /* ** ** import definitions:- **        prototypes for ppp-2.2 lcp routines  ** */ #ifndef _LCP_H_  #include "lcp.h" #endif   /* ** ** import definitions: **        fork_wait  ** */ #ifndef __VMS_DRIVERS_LOADED_  #include "vms_drivers.h" #endif   /* ** ** import definitions: **        protEnt  **        prottbl  ** */ #ifndef _FSM_VMS_H_  #include "fsm_vms.h" #endif   /* ** Global variables  */C lineEntry lineTbl[MAX_LINES];	/* Global array of line            */ < protEnt   lcpProtEnt;		/* Entry to register LCP protocol  */     /* **++ **  FUNCTION NAME: ** **      lcp_deleteLine ** **  FUNCTIONAL DESCRIPTION:  **; **      Delete a line entry from the global table of lines.  ** **  FORMAL PARAMETERS: **; **      line      The identifier of the line to be deleted.  ** **  IMPLICIT INPUTS: *** **      lineTbl  The global array of lines ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */" void lcp_deleteLine( lineId line ) { 5     /* inform VCI code we're blowing the line away */ &     VCILineEvent( line, LineDeleted );  ,     /* log that the line is being deleted */C     PPPDEBUG((&LINE_ENTRY(line)->lcpFsm, LOG_EOF, "Line deleted"));        /* get rid of the line */ $     DEALLOC_MEM( LINE_ENTRY(line) );#     LINE_ENTRY( line ) = NULL_LINE;           return;  }      /* **++ **  FUNCTION NAME: ** **      lcp_deviceFail ** **  FUNCTIONAL DESCRIPTION:  **I **      This function is called to handle a failure of the communications * **      port the PPP line is running over. ** **  FORMAL PARAMETERS: **- **      line      The identifier of the line.  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **@ **      If the type of the line is transient it will be deleted. ** **-- */" void lcp_deviceFail( lineId line ) { /     /* tell ports no LCP because device gone */ %     VCILineEvent( line, DeviceFail );   1     /* if this is a transient line - delete it */ .     if ( LINE_ENTRY(line)->type == Transient )     { ! 	LINE_ENTRY(line)->delete = TRUE;  	lcp_shutLine( line );     }        return;  }      /* **++ **  FUNCTION NAME: ** **      lcp_down ** **  FUNCTIONAL DESCRIPTION:  **= **     This routine is called to handle notification that LCP " **     has left the OPENED state.  ** **  FORMAL PARAMETERS: **G **      fsmPtr    Pointer to the state machine associated with the line  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */ void lcp_down( fsm *fsmPtr ) { O     lineId line = fsmPtr->line;	              /* line the down occurred on   */   O     lcp_options *ho = &LCP_HISOPTIONS(line);  /* Options that we ack'd       */ O     lcp_options *go = &LCP_GOTOPTIONS(line);  /* Options that peer ack'd     */ O     lcp_options *wo = &LCP_WANTOPTIONS(line); /* Options that we request     */ O     lcp_options *ao = &LCP_WANTOPTIONS(line); /* Options peer can request    */   $     /* reset line characteristics */     *go = *wo;     go->neg_pcompression  = 0;     go->neg_accompression = 0;$     go->mru               = PPP_MRU;'     go->asyncmap          = 0xffffffff;      *ho = *ao;     ho->neg_pcompression  = 0;     ho->neg_accompression = 0;$     ho->mru               = PPP_MRU;+     ho->asyncmap          = 0xffffffff;       3     /* inform device of new line characteristics */       if ( deviceSetChar( line ) )     { 3 	/* notify ports that LCP in no longer available */  	VCILineEvent( line, LCPDown );       	/* turn off LCP echos */  	lcp_echo_lowerdown( line );     }      /* device failed */      else     {  	LCP_DEVFAIL( line );      }        return;  }      /* **++ **  FUNCTION NAME: ** **      lcp_finished ** **  FUNCTIONAL DESCRIPTION:  **P **      This function is called to process notification that LCP no longer needs **      the lower layer. ** **  FORMAL PARAMETERS: **G **      fsmPtr    Pointer to the state machine associated with the line  ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **F **      If the type of the line is transient it will be deleted.       ** **-- */  void lcp_finished( fsm *fsmPtr ) { E     lineId line = fsmPtr->line;	/* line the finished occurred on   */      -     /* turn off data reception on the line */       if ( deviceDisable( line ) )     { * 	/* tell state machine lower layer gone */ 	lcp_lowerdown( line );  	  	/* close state machine */ 	lcp_close( line );    	/* tell ports no LCP */# 	VCILineEvent( line, LCPFinished );      . 	/* if this is a transient line - delete it */+ 	if ( LINE_ENTRY(line)->type == Transient )  	{% 	    LINE_ENTRY(line)->delete = TRUE;  	    lcp_shutLine( line ); 	}     }      /* device failed */      else     {  	LCP_DEVFAIL( line );      }        return;  }      /* **++ **  FUNCTION NAME: ** **      lcp_init ** **  FUNCTIONAL DESCRIPTION:  **A **      This function is called when PPP starts to initialise the H **      the opertaion of the link control protocol.  The vector of linesH **      is initialised and the LCP added to the liked list of registered **      control protocols  ** **  FORMAL PARAMETERS: **
 **      None.  ** **  IMPLICIT INPUTS: **, **      lineTbl    The global array of linesD **      prottbl    The pointer to the linked list of registered NCPs ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.  ** **  SIDE EFFECTS:  **
 **      None.  ** **-- */ void lcp_init()  {      int index;			   #     /* initialise table of lines */ 1     for ( index = 0; index < MAX_LINES; index++ )      {  	lineTbl[index].linePtr = 0; 	lineTbl[index].id      = 0;     }        /*  G      ** Register the LCP protocol.  The fsm_register routine isn't used H      ** because LCP needs a slightly different entry in the table to the      ** usual NCPs      */ 0     lcpProtEnt.ctrlProtocol           = PPP_LCP;1     lcpProtEnt.callbacks.open         = lcp_open; 2     lcpProtEnt.callbacks.close        = lcp_close;4     lcpProtEnt.callbacks.resetci      = lcp_resetci;4     lcpProtEnt.callbacks.cilen        = lcp_cilen;  2     lcpProtEnt.callbacks.addci        = lcp_addci;2     lcpProtEnt.callbacks.ackci        = lcp_ackci;2     lcpProtEnt.callbacks.nakci        = lcp_nakci;2     lcpProtEnt.callbacks.rejci        = lcp_rejci;2     lcpProtEnt.callbacks.reqci        = lcp_reqci;-     lcpProtEnt.callbacks.clientUp     = NULL; -     lcpProtEnt.callbacks.clientDown   = NULL; /     lcpProtEnt.callbacks.up           = lcp_up; 1     lcpProtEnt.callbacks.down         = lcp_down; -     lcpProtEnt.callbacks.starting     = NULL; 5     lcpProtEnt.callbacks.finished     = lcp_finished; -     lcpProtEnt.callbacks.protreject   = NULL; -     lcpProtEnt.callbacks.retransmit   = NULL; 4     lcpProtEnt.callbacks.extcode      = lcp_extcode;.     lcpProtEnt.callbacks.proto_name   = "LCP";          /*:      ** There shouldn't be any other protocols registered ;      ** so just add LCP to the list of registered protocols       */      prottbl = &lcpProtEnt;         return;  }    * /* **++ **  FUNCTION NAME: ** **      lcp_deleteLine ** **  FUNCTIONAL DESCRIPTION:  **; **      Delete a line entry from the global table of lines.g ** **  FORMAL PARAMETERS: **; **      line      The identifier of the line to be deleted.  ** **  IMPLICIT INPUTS: *** **      lineTbl  The global array of lines ** **  IMPLICIT OUTPUTS:  **
 **      None.  **& **  function value or completion codes **
 **      None.i ** **  SIDE EFFECTS:e **
 **      None.p ** **-- */  void lcp_shutLine( lineId line ) {p/     u_int status; /* status from deviceClose */i  2     /* stop any timeouts running on the lcp fsm */E     UNTIMEOUT( fsm_timeout, (caddr_t)(&(LINE_ENTRY(line)->lcpFsm)) );w  %     /* attempt to close the device */ !     status = deviceClose( line );t     if ( status == SS$_NORMAL )      { +         LINE_ENTRY(line)->devClosed = TRUE;r/         if ( LINE_ENTRY(line)->delete == TRUE )w 	{ 	    lcp_deleteLine( line ); 	}     }.'     else if ( status == SS$_OPINCOMPL )`     {'  	/* re-attempt the shut later */P         fork_wait( lcp_shutLine, (uint64)line, 0,&(LINE_ENTRY(line)->frkBlck) );     }T     return;N }I Y /* **++ **  FUNCTION NAME: ** **      lcp_start  ** **  FUNCTIONAL DESCRIPTION:  **J **      The function is called to kick off LCP on the communications port. ** **  FORMAL PARAMETERS: **- **      line      The identifier of the line.* ** **  IMPLICIT INPUTS: **
 **      None.s ** **  IMPLICIT OUTPUTS:h **
 **      None.m **& **  function value or completion codes **
 **      None.* ** **  SIDE EFFECTS:  **
 **      None.g ** **-- */ void lcp_start( lineId line )* { O     fsm *f          = LCP_FSM(line);          /* LCP state machine           */   )     /* enable data reception on device */*     if ( deviceEnable(line) )d     {i  	/* kick-start state machine  */ 	lcp_lowerup(line);p 	lcp_open(line);     }i     /* device failed */      else     {a 	LCP_DEVFAIL( line );7     }9       return;  }    p /* **++ **  FUNCTION NAME: ** **      lcp_up ** **  FUNCTIONAL DESCRIPTION:t **A **      This function is called when LCP enters the OPENED state. A **      It informs the protocols that LCP is up and it starts LCP  **      echos on the line. ** **  FORMAL PARAMETERS: **F **      fsmPtr   Pointer to the state machine associated with the line ** **  IMPLICIT INPUTS: **
 **      None.  ** **  IMPLICIT OUTPUTS:  **
 **      None.. **& **  function value or completion codes **
 **      None.p ** **  SIDE EFFECTS:  **
 **      None.P ** **-- */ void lcp_up( fsm *fsmPtr )   {*O     lineId line = fsmPtr->line;	             /* line the up occurred on      */   O     lcp_options *ho = &LCP_HISOPTIONS(line); /* ptr to options we agreed to  */*O     lcp_options *go = &LCP_GOTOPTIONS(line); /* ptr to opts we got from peer */.          /* *8      ** If use magic number hasn't been negotiated then        ** set it's value  to zero       */i     if (!go->neg_magicnumber)*     {o 	go->magicnumber = 0;e     }i     if (!ho->neg_magicnumber)a     {n 	ho->magicnumber = 0;n     }P       /*  G      ** ho options are cleared everytime we receive a confiure request.*H      ** We therefore need to set the values of MRU and asyncmap to their1      ** defualts if they haven't been negotiated.       */O     if ( !ho->mru )      {  	ho->mru = PPP_MRU;i     }h       if ( !ho->neg_asyncmap )     {T 	ho->asyncmap = 0xffffffff;      }o  /     /* inform device of line characteristics */       if ( deviceSetChar( line ) )     {  	/* start lcp echo requests */ 	lcp_echo_lowerup( line );  0 	/* inform the upper layer that LCP is opened */ 	VCILineEvent( line, LCPUp );i     }C     /* device failed */l     else     {  	LCP_DEVFAIL( line );e     }        return;		  a }h              