 $ verify = 'f$verify (0)' P $!******************************************************************************E $!  SYS_SYSTEM:POSTMAN.COM	- This *SITE-specific* name is used below.  $!, $!  Handle various aspects of mail delivery. $!A $!  *** This procedure *REQUIRES* Innosoft's PMDF DELIVER !!! ***  $!A $!  Currently, the procedure supports the establishment, changing  $!  and removal of:  $!	- a vacation message  $!	- multiple forwards' $!	- multiple reject and accept filters - $!	- accept filters which deliver to a folder  $!I $!  This procedure is also called as the vacation notification procedure, D $!  delivering a specified text file to the sender of received mail.2 $!  In that case, the following assumptions apply:; $!    - the file specified exists and is a valid text file; 7 $!    - the user has an appropriate MAIL.DELIVERY file; 7 $!    - the user's mail is forwarded to IN%"~username".  $!F $!  This procedure is also called to log rejected message information. $!I $!  *** NOTE ***  This procedure's file PROTECTION should be EXECUTE ONLY > $!		  for "normal" users, so that TRACE doesn't work for them. $! $!  Invocation: P $!    $ POSTMAN :== @SYS_SYSTEM:POSTMAN	! ... or whatever the procedure's called3 $!    $ POSTMAN				! "User mode" - normal user use. 9 $!    $ POSTMAN BRIEF			! Avoid lengthy explanatory text. I $!    $ POSTMAN DELETE_ON_ERROR		! Delete message files if DELIVER bombs. I $!    $ POSTMAN DEBUG [filename]	! Debug DELIVER, alternate logfile name. + $!    $ POSTMAN FOLDERS			! Enable folders. @ $!    $ POSTMAN TRACE			! Verify this procedure - see NOTE above= $!    $ POSTMAN ALOHA  filename		! Vacation message delivery. ; $!    $ POSTMAN SIEVE			! Log rejected message information.  $!M $!  Note that, with the exception of ALOHA and SIEVE, multiple parameters may H $!  be specified in any order.  If DEBUG is specified with an empty fileP $!  specification, it *must* either be the last parameter or it must be followed
 $!  by "".P $!.............................................................................. $!  Author:	Jonathan Ridler,$ $!		Information Technology Services,  $!		The University of Melbourne, $!		Victoria, Australia. $!" $!  Email:	jonathan@unimelb.edu.au $!( $!  (c) The University of Melbourne 1999 $!M $!  This procedure may be freely distributed and modified, provided that this L $!  copyright information remains intact.  The procedure is freeware and mayH $!  not be sold under any circumstances, whether in its original form or
 $!  modified. P $!.............................................................................. $!  History:) $! v1.0	07-Oct-1998	JER	Original version. ; $! v1.1	12-Oct-1998	JER	Allow logging of rejected messages. > $! v1.2	14-Oct-1998	JER	Checks for non-Postman generated file.> $! v1.3	15-Oct-1998	JER	For a single forward (ONLY), use MAIL.H $! v1.4	30-Oct-1998	JER	Allow multiple parameters to this procedure, and3 $!				message files on error to stay or be deleted. H $! v1.5	04-Nov-1998	JER	Cater for forward with IN% and no quotes at all.H $! v2.0	23-Nov-1998	JER	Implement Reject, Accept, Folder and To filters.+ $! v2.1	25-Nov-1998	JER	Minor enhancements. 9 $! v2.2	22-Dec-1998	JER	Minor fixes to vacation handling. H $! v2.3	10-Feb-1999	JER	Implement vacation sender db and overall confirmB $! v2.4	17-Feb-1999	JER	Allow accept-filtered messages to be fully6 $!				processed, and various minor fixes and cleanups.H $! v2.5	11-Mar-1999	JER	Avoid sending vacation message to mailing lists.C $! v2.6	30-Mar-1999	JER	Add precedence "junk" to "bulk" and "list". / $! v2.7	24-Jun-1999	JER	Implement BRIEF option. 6 $! v2.8	02-Jul-1999	JER	More checks for mailing lists.H $! v2.9	06-Oct-1999	JER	Avoid external symbol definitions except PMDF's.P $!****************************************************************************** $  $ on warning    then  goto  END  $ on control_y  then  goto  END  $ ) $!  Avoid external symbol definitions ...  $  $ set := set& $ set symbol /scope=(nolocal,noglobal) $  $ say 	:= write SYS$OUTPUT7 $ ask	:= read  SYS$COMMAND /error=END /end=END /prompt= : $ put   := write deliver /error=ERROR_EXIT /end=ERROR_EXIT: $ putt  := write tmpfyl  /error=ERROR_EXIT /end=ERROR_EXIT $ blurb := type  SYS$INPUT $ z	:= type /page NLA0: 8 $ hold  := 'ask' """Press RETURN to continue ... """ ans $ M $ version = "2.9 (06-Oct-1999)"  ! Keep the VERSION information up-to-date!!! M $ divider = "---------------------------------------------------------------"  $  $ bell[0,8]  = %X07  $ ss$_normal = 1 $  $!  No PMDF?  No can do!!! $ $ $ if f$trnlnm ("PMDF_ROOT") .eqs. "" $ then
 $   say ""O $   say "*** This utility *REQUIRES* Innosoft's PMDF DELIVER !!! ***",bell,bell 
 $   say "" $   commit = 1		! Fudge it.  $   goto  END		! Escape! $ endif  $  $ pid  = f$getjpi ("","PID")5 $ user = f$edit (f$getjpi ("","USERNAME"),"COLLAPSE")  $ node = f$getsyi ("NODENAME")% $ vms_version  = f$getsyi ("VERSION") * $ pmdf_version = f$trnlnm ("PMDF_VERSION") $ & $ tmp := SYS$SCRATCH:POSTMAN_'pid'.TMPH $ postie := SYS_SYSTEM:POSTMAN		! SITE-specific name of this procedure !* $ reject_log  := SYS$LOGIN:MAIL.REJECT_LOG. $ vac_db_file := SYS$LOGIN:VACATION.RECEIPT_DB $ E $ options = "|ALOHA|BRIEF|DEBUG|DELETE_ON_ERROR|FOLDERS|SIEVE|TRACE|"  $  $ forward  = ""  $ actor    = "" G $ debugger = "DELIVER.LOG"	! Must be only filename - no directory, etc.  $ vacating = 0 $ delivering = 0 $ forwarding = 0 $ deactivate = 0 $ use_vac_db = 0
 $ folders = 0 
 $ tilded  = 0 
 $ active  = 0 
 $ fwcnt   = 0 
 $ debug   = 0 
 $ commit  = 0 
 $ full    = 1  $ diskver = "???"  $ log_rejects   = 0  $ need_vacation = 0  $ delete_files  = 0  $ reject_filter_cnt = 0  $ accept_filter_cnt = 0  $ 3 $ retain_mail = 1		! Default is to deliver to self.  $  $CHECK_PARAMS:. $ p1 = f$edit (p1,"UPCASE,COLLAPSE,UNCOMMENT")% $ if p1 .eqs. ""  then  goto  FIRE_UP  $ ; $ if f$locate ("|"+p1+"|",options) .eqs. f$length (options)  $ then, $   say "*** Invalid option: ''p1' ***",bell $   commit = 1		! Fudge it. 
 $   goto  END  $ endif  $ G $ if p1 .eqs. "TRACE"  then  set verify		! Watch what's happening here.  $ < $ if p1 .eqs. "FOLDERS"  then  folders = 1	! Enable folders. $ 9 $ if p1 .eqs. "BRIEF"  then  full = 0		! Don't ramble on.  $ / $ if p1 .eqs. "ALOHA"				! Take me away P&O !!!  $ then& $   set symbol /scope=(nolocal,global) $   send_msg = 1A $   sender = f$edit (f$element (0,"""",from-"IN%"""),"lowercase") - $   if vac_db	! Global symbol set by DELIVER.  $   thenD $     if f$search (vac_db_file) .eqs. ""  then  create 'vac_db_file'; $     search 'vac_db_file' "''sender'" /nooutput /nowarning   $     if $status .eq. ss$_normal
 $     then $	send_msg = 0
 $     else $	close /nolog vdb2 $	open /append vdb 'vac_db_file' /error=ERROR_EXIT$ $	write vdb /error=ERROR_EXIT sender $	close /nolog vdb $     endif 	 $   endif  $  $   if send_msg  $   thenN $     if f$extract (0,3,f$edit(subject,"COLLAPSE,UPCASE")) .nes. "RE:"  then - 	subject = "Re: " + subject 9 $     mail 'p2' "''sender'" /subject="''subject'" /noself 	 $   endif  $   commit = 1		! Fudge it. ( $   set symbol /scope=(nolocal,noglobal) $   goto  END		! Escape! $ endif  $ 4 $ if p1 .eqs. "SIEVE"				! Log the filtered message. $ then@ $   if f$search (reject_log) .eqs. ""  then  create 'reject_log' $   close /nolog tmpfyl F $   open /append /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl 'reject_log'& $   set symbol /scope=(nolocal,global) $   putt ""  $   putt "Date:	", f$cvtime() 1 $   putt "From:	", f$element(0,"""",from-"IN%""") - $   putt "To:	", f$element(0,"""",to-"IN%""")  $   putt "Subj:	", subject( $   set symbol /scope=(nolocal,noglobal) $   close /nolog tmpfyl  $   commit = 1		! Fudge it.  $   goto  END		! Escape! $ endif  $ 3 $ if p1 .eqs. "DEBUG"				! Watch what DELIVER does.  $ then
 $   debug = 1 0 $   p2 = f$edit (p2,"UPCASE,COLLAPSE,UNCOMMENT")H $   if p2 .nes. ""  then  debugger = p2		! Either DEBUG must be the last9 $   gosub SHUFFLE_PARAMS			!  or P2 *must* exist or be ""  $ endif  $ P $ if p1 .eqs. "DELETE_ON_ERROR"  then -	! Delete message files if DELIVER bombs? 	delete_files = 1  $  $ gosub SHUFFLE_PARAMS $ goto  CHECK_PARAMS $ P $!..............................................................................	 $FIRE_UP:  $ say ""$ $ say "Postman - Version ''version'" $ blurb   6 Postman allows you to manage incoming electronic mail.$ You can establish, change or remove:     - a vacation message!   - multiple forwarding addresses ;   - multiple filters to accept or discard messages based on $     "From", "To" and "Subject" lines $ P $ if folders  then  say "  - automatically file messages to a given mail folder" $ blurb   ?                ***    Postman uses PMDF's DELIVER system.   *** ?                *** If you wish to control DELIVER yourself, *** ?                ***    you should NOT use this utility.      ***   ? Enter Control-Z or Control-C or Control-Y at any time to abort. H ("Control" is the "Ctrl" key - use it like "Shift" with "Z", "C" or "Y")   $ hold $ say ""
 $ say divider / $ say "Checking your current configuration ..."  $ P $!..............................................................................L $!  Check for a forward, and if it exists, check to see if it's for DELIVER. $ 9 $ if f$search (tmp) .nes. ""  then  delete /nolog 'tmp';*  $  $ define /user sys$output 'tmp'  $ mail show forward exit $ ' $ search 'tmp';-1 forward /output='tmp'  $ close /nolog tmpfyl ; $ open /read /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl 'tmp' 3 $ read /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl rec  $ close /nolog tmpfyl  $ delete /nolog 'tmp';*  $ A $ forwarding = rec .nes. "You have not set a forwarding address."  $ if forwarding  $ thenC $   forward = f$edit (f$extract (32,f$length(rec)-33,rec),"UPCASE") P $   forward = forward-"IN%"-""""-""""-""""-""""-""""-"""" ! Remove any PMDF junk5 $   forward = f$edit (forward,"COMPRESS,TRIM,UPCASE") C $   tilded  = f$locate ("~''user'",forward) .ne. f$length (forward)  $   if .not. tilded 8 $   then		! Not = "~user" therefore it's a real forward. $     fwcnt = 1  $     fw1 = forward 	 $   endif  $ endif  $ 9 $ if f$search (tmp) .nes. ""  then  delete /nolog 'tmp';*  $ H $!  If we already have a DELIVER file (active or inactive), check it for- $!  forwards, filters and a vacation message.  $ < $ delivering = f$search ("SYS$LOGIN:MAIL.DELIVERY") .nes. "" $ active = delivering  $ if .not. delivering  then - D 	delivering = f$search ("SYS$LOGIN:MAIL.DELIVERY_INACTIVE") .nes. ""+ $ if .not. active  then  actor := _INACTIVE  $  $ if delivering  $ then $ = $!  Check for a non-Postman generated MAIL.DELIVERY* file ...  $  $   set noonO $   search SYS$LOGIN:MAIL.DELIVERY'actor' /output='tmp' /nowarn " by Postman v"  $   status = $status
 $   set on $   if status .eq. ss$_normal  $   then $     close /nolog tmpfyl ? $     open /read /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl 'tmp' 3 $     read /error=VER_DONE /end=VER_DONE tmpfyl rec D $     diskver = f$extract (f$locate (" by Postman v",rec)+13,20,rec)) $     diskver = f$element (0," ",diskver) 
 $VER_DONE: $     close /nolog tmpfyl  $   else $     say ""P $     say "** WARNING: You have a PMDF MAIL.DELIVERY''actor' file which was NOT"K $     say "** generated by Postman!  Using Postman will cause your current" 7 $     say "** configuration to be lost.",bell,bell,bell  $     say ""7 $     ask "Do you want to continue? (Yes/No) [No] " ans 4 $     ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")' $     if ans .eqs. ""  then  ans = "No"  $     if ans
 $     then2 $	goto  VACATE		! Don't look for any of our stuff!
 $     else $	goto  END  $     endif 	 $   endif  $  $!  Forwards? ...  $  $   set noonO $   search SYS$LOGIN:MAIL.DELIVERY'actor' "* * * a p " /output='tmp' /nowarning  $   status = $status
 $   set on $   if status .eq. ss$_normal  $   then $     close /nolog tmpfyl ? $     open /read /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl 'tmp' 	 $FW_READ: 1 $     read /error=FW_DONE /end=FW_DONE tmpfyl rec  $     fwcnt = fwcnt + 1 $ $     fw'fwcnt' = rec - "* * * a p " $     goto  FW_READ 	 $FW_DONE:  $     close /nolog tmpfyl 	 $   endif  $  $!  Retain mail? ... $  $   set noonJ $   search SYS$LOGIN:MAIL.DELIVERY'actor' "* * * o d" /nooutput /nowarning) $   retain_mail = $status .eq. ss$_normal 
 $   set on $ ; $   if f$search (tmp) .nes. ""  then  delete /nolog 'tmp';*  $  $!  Filters? ... $ 7 $!  Reject filters and logging of rejected messages ...  $  $   set noon> $   search SYS$LOGIN:MAIL.DELIVERY'actor' "''postie'  SIEVE" - 	/nooutput /nowarning ) $   log_rejects = $status .eq. ss$_normal  $  $   if diskver .lts. "2.4" $   thenL $     search SYS$LOGIN:MAIL.DELIVERY'actor' " y q " /output='tmp' /nowarning $     status = $status $   else $ J $!  Search for PMDF v5.1+ form first, then, if none, the pre-v5.1 form ... $ L $     search SYS$LOGIN:MAIL.DELIVERY'actor' " o q " /output='tmp' /nowarning $     status = $status $     if status .ne. ss$_normal 
 $     thenH $	search SYS$LOGIN:MAIL.DELIVERY'actor' " a q " /output='tmp' /nowarning $	status = $status $     endif 	 $   endif 
 $   set on $  $   if status .eq. ss$_normal  $   then $     close /nolog tmpfyl ? $     open /read /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl 'tmp'  $FILTER_READ1:; $     read /error=FILTER_DONE1 /end=FILTER_DONE1 tmpfyl rec / $     reject_filter_cnt = reject_filter_cnt + 1 D $     reject_filter'reject_filter_cnt'_from = f$element (1,"""",rec) $     if diskver .lts. "2.0"
 $     then- $	reject_filter'reject_filter_cnt'_to   = "*" @ $	reject_filter'reject_filter_cnt'_subj = f$element (3,"""",rec)
 $     else@ $	reject_filter'reject_filter_cnt'_to   = f$element (3,"""",rec)@ $	reject_filter'reject_filter_cnt'_subj = f$element (5,"""",rec) $     endif  $     goto  FILTER_READ1 $FILTER_DONE1: $     close /nolog tmpfyl 	 $   endif  $ # $!  Accept (and folder) filters ...  $  $   set noonJ $   search SYS$LOGIN:MAIL.DELIVERY'actor' " y d " /output='tmp' /nowarning $   status = $status
 $   set on $  $   if status .eq. ss$_normal  $   then $     close /nolog tmpfyl ? $     open /read /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl 'tmp'  $FILTER_READ2:; $     read /error=FILTER_DONE2 /end=FILTER_DONE2 tmpfyl rec / $     accept_filter_cnt = accept_filter_cnt + 1 D $     accept_filter'accept_filter_cnt'_from = f$element (1,"""",rec) $     if diskver .lts. "2.0"
 $     then- $	accept_filter'accept_filter_cnt'_to   = "*" @ $	accept_filter'accept_filter_cnt'_subj = f$element (3,"""",rec)
 $     else@ $	accept_filter'accept_filter_cnt'_to   = f$element (3,"""",rec)@ $	accept_filter'accept_filter_cnt'_subj = f$element (5,"""",rec) $     endif 9 $     accept_filter'accept_filter_cnt'_dest = f$extract - J                                         (f$locate (" y d ",rec)+5,200,rec)J $     if accept_filter'accept_filter_cnt'_dest .nes. ""  then  folders = 1 $     goto  FILTER_READ2 $FILTER_DONE2: $     close /nolog tmpfyl 	 $   endif  $ ; $   if f$search (tmp) .nes. ""  then  delete /nolog 'tmp';*  $  $!  Vacation? ...  $  $   set noon> $   search SYS$LOGIN:MAIL.DELIVERY'actor' "''postie'  ALOHA" - 	/output='tmp' /nowarning & $   vacating = $status .eq. ss$_normal
 $   set on $  $   if vacating  $   then $     close /nolog tmpfyl ? $     open /read /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl 'tmp' 7 $     read /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl rec  $     close /nolog tmpfyl  $     delete /nolog 'tmp';* F $     rec = f$edit (rec-""""-""""-""""-""""-""""-"""","COMPRESS,TRIM")D $     vacation_file = f$element (2," ",f$element (1,"@",rec)) - """"O $     if f$search (vacation_file) .eqs. ""  then  vacating = 0	! File not found  $     set noonN $     search SYS$LOGIN:MAIL.DELIVERY'actor' "vac_db == 1" /nooutput /nowarning* $     use_vac_db = $status .eq. ss$_normal $     set on	 $   endif  $ endif  $  $ say "" $ if delivering  $ then
 $   if active  $   then1 $     say "Your current configuration is ACTIVE."  $   else5 $     say "Your current configuration is NOT ACTIVE." 	 $   endif  $ else $   if fwcnt .eq. 1  $   then3 $     say "You are currently forwarding your mail."  $   else4 $     say "You do not have a current configuration."	 $   endif  $ endif' $eP $!.............................................................................. $VACATE: $ say ""
 $ say dividerC $ blurb  VACATION --------  	 $ if fullw $ then	 $   blurbvG A vacation message can be used to automatically notify a person who hasnD sent you mail that you are on vacation, or simply to indicate to the' sender that you have received the mail.    $ endif  $!
 $ if vacatinge $ thenA $   say "You already have a vacation message file.  Its name is:"!
 $   say "" $   say "  ",vacation_file
 $   say "" $   say "It contains:"
 $   say ""= $   wait 00:00:02.00		! In case a big file scrolls off screend $   type 'vacation_file'
 $   say ""
 $   if activea $   then $     notta = "ACTIVE" $     default = "Yes"e $   else $     notta = "NOT active" $     default = "No"	 $   endifp6 $   say "The vacation message is currently ",notta,"."
 $   say ""K $   msg = "Do you want to have a vacation message (at all)? (Yes/No) [" + -e 	  default + "] "  $   ask "''msg'" ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")( $   if ans .eqs. ""  then  ans = default# $   if ans  then  need_vacation = 1n1 $   if .not. need_vacation  then  goto  CHECK_FWD	
 $   say ""O $   ask "Do you want to continue to use this message file? (Yes/No) [Yes] " ans 2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")& $   if ans .eqs. ""  then  ans = "Yes"
 $   if ans $   then $     goto  CHECK_RETAIN $   else $     gosub  GET_MESSAGE_FILEL	 $   endifn $ else7 $   say "You do not currently have a vacation message." 
 $   say ""D $   ask "Do you want to have a vacation message? (Yes/No) [No] " ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")% $   if ans .eqs. ""  then  ans = "No"a# $   if ans  then  need_vacation = 1w $   if need_vacation $   then $     gosub  GET_MESSAGE_FILE  $   else $     goto  CHECK_FWDf	 $   endifp $ endifi $a $CHECK_RETAIN: $ if .not. retain_mail $ then $   if full  $   then $     blurb   I Your current configuration does NOT retain a copy of incoming mail.  This.I is very unwise if you have a vacation message, since you will NOT receivehJ the incoming message, even though the vacation message will be sent to theJ sender.  Unless you intend also to forward your messages, you are strongly5 urged to retain mail when you use a vacation message.b  	 $   endiff $,K $   ask "Do you want to retain incoming mail messages? (Yes/No) [Yes] " anse2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")& $   if ans .eqs. ""  then  ans = "Yes" $   retain_mail = ans. $ endif. $.	 $ if full. $ then	 $   blurb.  K You can track the sender addresses of incoming messages so that each uniquevI sender address only receives the vacation message once during the currentvN activation of the vacation message.  If you do not track the sender addresses,G the vacation message is sent each and every time a message is received.  $ endifp $m $ if use_vac_dbc $ then $   default = "Yes"e $ else $   default = "No" $ endif! $. $ say ""M $ msg = "Do you want to send the vacation message only once per sender? " + -E 	"(Yes/No) "  $ ask "''msg' [''default'] " ans0 $ ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")& $ if ans .eqs. ""  then  ans = default $ use_vac_db = ans $vP $!.............................................................................. $CHECK_FWD:l $ say ""
 $ say dividerg $ blurbf
 FORWARDING
 ----------  	 $ if fulln $ then	 $   blurbpD Forwarding allows you to send a copy of a message to another person.E You may establish as many forwarding addresses as you wish - each ones# will receive a copy of the message.n   $ endifi $ * $ if need_vacation .and. .not. retain_mail $ then	 $   blurb.F *** You have a vacation message but you are NOT retaining a copy   ***F *** of incoming messages.  You are strongly urged either to retain ***F *** a copy of any incoming message, or use a forward.              ***   $ endif! $v $ if fwcnt .eq. 0  $ then+ $   say "You are not forwarding your mail."p $   gosub  ADD_FORWARDS  $ else! $   if active .or. (fwcnt .eq. 1)S $   then $     default = "Yes"rO $     say "You already have the following ACTIVE forwarding addresses defined."i $   else $     default = "No"H $     say "You already have the following forwarding addresses defined,". $     say "BUT they are NOT currently active."	 $   endifeC $   if need_vacation .and. .not. retain_mail  then  default = "Yes"e $ 
 $   say "" $   cnt = 1-+ $FW_SHOW:			! Display all current forwards.- $   say fw'cnt'e $   cnt = cnt + 1 * $   if cnt .le. fwcnt  then  goto  FW_SHOW $ 
 $   say ""J $   ask "Do you want to forward mail (at all)? (Yes/No) [''default'] " ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")( $   if ans .eqs. ""  then  ans = default $   if .not. ans $   then $     fwcnt = 0  $     goto  CHECK_FILTERS 	 $   endife $ 
 $   say ""J $   ask "Do you want to change your existing forwards? (Yes/No) [No] " ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")% $   if ans .eqs. ""  then  ans = "No"H% $   if .not. ans  then  goto  GET_FWDT $P $   if fullE $   then $     blurbp  9 Indicate what you want to do with each of these forwards._H Enter one of the following (a single letter abbreviation is sufficient):  2   . "Keep" to leave the current forward unchanged.+   . "Modify" to modify the current forward.E+   . "Delete" to delete the current forward.t*   . "Zap" to discard ALL current forwards.2   . "OK" to retain ALL forwards not yet discarded.  	 $   endif  $   inx = 1d
 $FW_CHECK: $   fwd = fw'inx' 
 $   say "": $   ask "''fwd' ? (Keep/Modify/Delete/Zap/OK) [Keep] " ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")' $   if ans .eqs. ""  then  ans = "Keep"  $   ans = f$extract (0,1,ans)  $   if ans .eqs. "M" $   then $     say "" $     ask "Address? " ans ) $     ans = f$edit (ans,"TRIM,UNCOMMENT")T+ $     if ans .eqs. ""  then  goto  FW_CHECK L $     ans = ans - "IN%" - "in%" - "In%" - "iN%" - -	! Remove any PMDF junk !9 		  """" - """" - """" - """" - """" - """" - """" - """"u $     fw'inx' = ansN $     ans = "M" 	 $   endifs+ $   if ans .eqs. "D"  then  fw'inx' = "###"a $   if ans .eqs. "Z" $   then $     fwcnt = 0  $     say ""3 $     say "All current forwards will be discarded."l $     goto  GET_FWD 	 $   endif  $   if ans .eqs. "O" $   then $     say ""< $     say "All forwards not yet discarded will be retained." $     goto  GET_FWDe	 $   endifeJ $   if (ans .nes. "K") .and. (ans .nes. "M") .and. (ans .nes. "D")  then - 	goto  FW_CHECKh $  $   inx = inx + 1v+ $   if inx .le. fwcnt  then  goto  FW_CHECKl $ 	 $GET_FWD:h $   gosub  ADD_FORWARDS" $o4 $!  Re-write the forward list to eliminate holes ... $  $   inx = 0d $   cnt = 1  $FW_LOOPER:s $   if fw'cnt' .nes. "###" $   then $     inx = inx + 1_ $     fw'inx' = fw'cnt'E	 $   endife $   cnt = cnt + 1g, $   if cnt .le. fwcnt  then  goto  FW_LOOPER $   fwcnt = inx  $ endiff $t $CHECK_KEEP_COPY:b $ if fwcnt .gt. 0S $ then
 $   say ""% $   if retain_mail .or. need_vacation  $   then $     default = "Yes""
 $     if fulls
 $     then $	blurb I You are forwarding your mail.  You also are currently retaining a copy ofoE incoming messages.  (If you have a vacation message, this is stronglyeF advisable.)  Please confirm that you wish to retain a copy of incoming	 messages.o $     endif  $   else $     default = "No") $     say "You are forwarding your mail."r	 $   endif  $   if full  then  say ""cG $   msg = "Do you want to retain a copy of each incoming message? " + -	  	  "(Yes/No) [" + default + "] " $   ask "''msg'" ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")( $   if ans .eqs. ""  then  ans = default $   retain_mail = ansp $   if .not. ans $   then $     blurbo  L *** WARNING!!!  You are forwarding without retaining a copy of incoming  ***L *** messages.  This is dangerous!  You are very likely to lose messages! ***L *** If you wish to correct this, exit Postman NOW and then re-run it.    *** $     say bell,bellA
 $     hold	 $   endifi $ endif" $ P $!.............................................................................. $CHECK_FILTERS:l $ say ""
 $ say divideru $ blurb_	 FILTERINGo	 ---------A  	 $ if full. $ then	 $   blurb.I There are two types of filters: Accept and Reject.  Both work together to L allow you to automatically select incoming messages to receive or to discardI completely as if the message had never been received.  Accept filters are I applied before reject filters.  Since reject filters cause messages to besL discarded, by also specifying accept filters, you can allow specific subsetsJ of messages which might normally be rejected to be received.  For example,K you may want all mail from "hotmail.com" to be rejected, except if it comestH from "hilary@hotmail.com".  To do this, implement a reject filter on theH "From" line which is "*@hotmail.com", and an accept filter on the "From"I line which is "hilary@hotmail.com".  (Quotation marks are not necessary.)i  J You do not need to use accept filters if you are not using reject filters.= By default, all mail is accepted unless reject filters exist.. $ endif  $. $ if folders .and. full. $ then	 $   blurb.  I You can, however, use accept filters to automatically file a message in aeF given mail folder or mail file.  Simply specify the folder name and an? optional mail file name (space separated) at the "Dest" prompt.a $ endiff $a $ if pmdf_version .lts. "5.1"  $ then	 $   blurbp  L NOTE:  You are running a version of PMDF earlier than v5.1.  Because PostmanE        needs a feature introduced in PMDF v5.1 to facilitate the full L        processing of Accept-filtered messages, you should note that messagesJ        which are Accept-filtered will *only* be delivered to you locally -N        they will not be forwarded nor will a vacation message be sent if these        have been requested." $ endifo $a	 $ if fullk $ then
 $   say "" $   hold $ endifS $R $ filtyp = "Reject"d $  $DISPLAY_FILTERS:r $ say "" $ say "''filtyp' Filters"  $ say "--------------" $ say "" $  $ if 'filtyp'_filter_cnt .eq. 0o $ then( $   say "You have no ''filtyp' filters." $   gosub  ADD_FILTERS $   if filtyp .eqs. "Reject" $   then $     filtyp = "Accept"! $     goto  DISPLAY_FILTERSR	 $   endifv $ else
 $   if activet $   then $     default = "Yes" L $     say "You already have the following ACTIVE ''filtyp' filters defined." $   else $     default = "No"E $     say "You already have the following ''filtyp' filters defined,".. $     say "BUT they are NOT currently active."	 $   endifr $  $   cnt = 1 . $FILTER_SHOW:			! Display all current filters.
 $   say ""* $   say "From: ",'filtyp'_filter'cnt'_from( $   say "To:   ",'filtyp'_filter'cnt'_to* $   say "Subj: ",'filtyp'_filter'cnt'_subj4 $   if (filtyp .eqs. "Accept") .and. folders  then -' 	say "Dest: ",'filtyp'_filter'cnt'_destn $   cnt = cnt + 1 < $   if cnt .le. 'filtyp'_filter_cnt  then  goto  FILTER_SHOW $ 
 $   say ""H $   msg = "Do you want to ''filtyp' filter mail (at all)? (Yes/No) " + - 	  "[''default'] " $   ask "''msg'" ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")( $   if ans .eqs. ""  then  ans = default $   if .not. ans $   then $     'filtyp'_filter_cnt = 0c $     if filtyp .eqs. "Reject"
 $     then $	filtyp = "Accept"i $	goto  DISPLAY_FILTERSr
 $     else $	goto  MAKE_DELIVER_FILE  $     endifb	 $   endifl $  $CHANGE_FILTERS:
 $   say ""G $   msg = "Do you want to change your existing ''filtyp' filters? " + -S 	  "(Yes/No) [No] "  $   ask "''msg'" ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")% $   if ans .eqs. ""  then  ans = "No"t- $   if .not. ans  then  goto  GET_NEW_FILTERS  $n $   if full  $   then $     blurb   B Indicate what you want to do with each of these groups of filters.H Enter one of the following (a single letter abbreviation is sufficient):  6   . "Keep" to leave the current filter line unchanged./   . "Modify" to modify the current filter line.y-   . "Clear" to clear the current filter line. 0   . "Delete" to delete the current filter group.,   . "Next" to skip to the next filter group.(   . "Zap" to delete ALL current filters.:   . "OK" to retain all filters not yet cleared or deleted.	 $   endif 
 $   inx   = 1G $   fline = "From" $   pad = "" $FILTER_CHECK:> $   if (fline .eqs. "From") .or. (ans .eqs. "M")  then  say "") $   filter = 'filtyp'_filter'inx'_'fline'e, $   msg = "''fline':''pad' ''filter' ? " + -3 	  "(Keep/Modify/Clear/Delete/Next/Zap/OK) [Keep] "  $   ask "''msg'" ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")' $   if ans .eqs. ""  then  ans = "Keep"  $   ans = f$extract (0,1,ans)n $   if ans .eqs. "M" $   then $     say "" $     ask "''fline': ? " ans) $     ans = f$edit (ans,"TRIM,UNCOMMENT")w& $     if ans .eqs. ""  then  ans = "*"( $     'filtyp'_filter'inx'_'fline' = ans $     ans = "M"t	 $   endif > $   if ans .eqs. "C"  then  'filtyp'_filter'inx'_'fline' = "*" $   if ans .eqs. "D" $   then% $     'filtyp'_filter'inx'_from = "*".% $     'filtyp'_filter'inx'_to   = "*"L% $     'filtyp'_filter'inx'_subj = "*"uD $     if filtyp .eqs. "Accept"  then  'filtyp'_filter'inx'_dest = ""	 $   endif + $   if (ans .eqs. "N") .or. (ans .eqs. "D")  $   then% $     if inx .lt. 'filtyp'_filter_cntR
 $     then $	fline = "From"
 $	pad = "" $	inx = inx + 1  $	goto  FILTER_CHECK
 $     else $	goto  GET_NEW_FILTERS  $     endifl	 $   endife $   if ans .eqs. "Z" $   then $     'filtyp'_filter_cnt = 0o $     say ""< $     say "All current ''filtyp' filters will be discarded." $     goto  GET_NEW_FILTERSt	 $   endif  $   if ans .eqs. "O" $   then $     say ""E $     say "All ''filtyp' filters not yet discarded will be retained."  $     goto  GET_NEW_FILTERSe	 $   endif'B $   if (ans .nes. "K") .and. (ans .nes. "M") .and. (ans .nes. "C") $   then) $     if fline .nes. "From"  then  say ""l $     goto  FILTER_CHECK	 $   endift $n $   if fline .eqs. "From"  $   then $     fline = "To" $     pad = "  " $     goto  FILTER_CHECK	 $   endifi $   if fline .eqs. "To"  $   then $     fline = "Subj" $     pad = "" $     goto  FILTER_CHECK	 $   endif  $   if fline .eqs. "Subj"O $   then. $     if (filtyp .eqs. "Accept") .and. folders
 $     then $	fline = "Dest" $	goto  FILTER_CHECK
 $     else $	fline = "From" $     endife	 $   endif  $   if fline .eqs. "Dest"f $   thenP $     if 'filtyp'_filter'inx'_dest .eqs. "*" then 'filtyp'_filter'inx'_dest = "" $     fline = "From"	 $   endif  $  $   inx = inx + 1c= $   if inx .le. 'filtyp'_filter_cnt  then  goto  FILTER_CHECKc $t $GET_NEW_FILTERS:e $   gosub  ADD_FILTERS $" $   if filtyp .eqs. "Reject" $   then $     filtyp = "Accept"" $     goto  DISPLAY_FILTERS 	 $   endife $c4 $!  Re-write the filter lists to eliminate holes ... $  $   inx = 0  $   cnt = 1t $FILTER_LOOPER:,3 $   if ('filtyp'_filter'cnt'_from .nes. "*") .or. -e3        ('filtyp'_filter'cnt'_to   .nes. "*") .or. -A,        ('filtyp'_filter'cnt'_subj .nes. "*") $   then $     inx = inx + 1c; $     'filtyp'_filter'inx'_from = 'filtyp'_filter'cnt'_fromi9 $     'filtyp'_filter'inx'_to   = 'filtyp'_filter'cnt'_toE; $     'filtyp'_filter'inx'_subj = 'filtyp'_filter'cnt'_subj & $     if filtyp .eqs. "Accept"  then -6 	'filtyp'_filter'inx'_dest = 'filtyp'_filter'cnt'_dest	 $   endif  $   cnt = cnt + 1/> $   if cnt .le. 'filtyp'_filter_cnt  then  goto  FILTER_LOOPER $   'filtyp'_filter_cnt = inxp $  $   if filtyp .eqs. "Reject" $   then $     filtyp = "Accept"  $     say "" $     goto  DISPLAY_FILTERS"	 $   endifM $ endifM $ = $!  If we are filtering, do we want to log rejected messages?  $" $FILTER_LOG: $ if reject_filter_cnt .gt. 0  $ then
 $   say """ $   say "Rejected Message Logging"" $   say "------------------------" $   if full  $   then $     say ""K $     say "You can log information about rejected messages to a logfile in"n? $     say "your home directory (''f$trnlnm("SYS$LOGIN")'). ", -  	  "The information logged" P $     say "is the date and the ""From:"", ""To:"" and ""Subject:"" lines of the" $     say "rejected messages."	 $   endift $   if log_rejects $   then $     default = "Yes"a $     blurbi  G You are currently logging rejected message information.  The logfile isn  7 $     say "    ''f$trnlnm("SYS$LOGIN")'MAIL.REJECT_LOG". $   else $     default = "No" $     say ""G $     say "You are NOT currently logging rejected message information."w	 $   endif 
 $   say ""K $   msg = "Do you want to log rejected message information? (Yes/No) [" + -y 	  default + "] "e $   ask "''msg'" ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")( $   if ans .eqs. ""  then  ans = default $   log_rejects = ansa $ endifv $ P $!..............................................................................M $!  Create the new DELIVER file.  Always, keep only ONE version of the active  $!  or inactive DELIVER file.  $y $MAKE_DELIVER_FILE:  $a $ say "" $ say divider,bell $  $ default = "Yes""	 $ if fulla $ then	 $   blurbl  K Your selections above may cause your mail handling configuration to change.vK You may choose to implement your selection, or, if not, end Postman withoutt making any changes.s   $ endif) $YA $ if need_vacation .and. (.not. retain_mail) .and. (fwcnt .eq. 0)  $ then $   default = "No"	 $   blurb)K *** WARNING!  You have a vacation message, but you are NOT retaining    *** K *** incoming mail, and you do NOT have any forwards.  This means that   ***DK *** your incoming mail will be discarded completely!  You should re-run ***nK *** Postman to ensure your messages are delivered to you or forwarded.  ***= $   say bell, bell $ endif  $ + $ if default .and. .not. full  then  say ""GJ $ msg = "Implement changes which may result from your selection? (Yes/No)"  $ ask "''msg' [''default'] " ans0 $ ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")& $ if ans .eqs. ""  then  ans = default $ if .not. ans  then  goto  END  $a $ say ""
 $ say divider"/ $ say "Implementing required mail handling ..."f $e $ commit = 1 $h9 $ if f$search (tmp) .nes. ""  then  delete /nolog 'tmp';*H $_M $!  If no forwards, filters or vacation, then de-activate any active DELIVER.  $ K $ if ((fwcnt .eq. 0) .or. ((fwcnt .eq. 1) .and. .not. retain_mail)) .and. -nH      (reject_filter_cnt .eq. 0) .and. (accept_filter_cnt .eq. 0) .and. -      .not. need_vacation $ then $   deactivate = 1 $   if forwarding  $   then $     close /nolog tmpfyl @ $     open /write /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl 'tmp', $     putt "$ define /user SYS$OUTPUT NLA0:" $     putt "$ mail"  $     if fwcnt .eq. 0 
 $     then $	putt "set noforward"
 $     else+ $	if f$locate ("@",fw1) .eq. f$length (fw1)C $	then8 $	  putt "set forward ''fw1'"	! Not an Internet address. $	elseA $	  if vms_version .lts. "V7.0"	! Quotes are handled differently!o $	  then. $	    putt "set forward in%""""""''fw1'""""""" $	  else& $	    putt "set forward in%""''fw1'"""	 $	  endife $	endife $     endifu $     putt "exit"o $     putt "$ EXIT 1"  $     close /nolog tmpfyln $     @'tmp' $     delete /nolog 'tmp';*t	 $   endifv  $   if delivering .and. vacating $   then $     say ""8 $     say "The vacation message will no longer be sent."	 $   endifn $   if fwcnt .eq. 0  $   then $     say ""D $     say "Forwarding, filtering and vacation message not required." $   else $     say "", $     say "Your forwarding is now in place!"	 $   endif  $ endif. $. $ if deactivated $ then
 $   if activea $   then $     if fwcnt .eq. 1.
 $     then $       say ""O $       say "The remainder of your existing configuration which was active ", -W 	    "is now INACTIVE."f
 $     else $       say ""B $       say "Your configuration which was active is now INACTIVE." $     endifa	 $   endifn $   if deliverings $   then> $     if f$search ("SYS$LOGIN:MAIL.DELIVERY") .nes. ""  then -' 	  purge /nolog SYS$LOGIN:MAIL.DELIVERYt $     if active  then -rI 	  rename /nolog SYS$LOGIN:MAIL.DELIVERY SYS$LOGIN:MAIL.DELIVERY_INACTIVE G $     if f$search ("SYS$LOGIN:MAIL.DELIVERY_INACTIVE") .nes. ""  then -*0 	  purge /nolog SYS$LOGIN:MAIL.DELIVERY_INACTIVE	 $   endif K $   if f$search (vac_db_file) .nes. ""  then  delete /nolog 'vac_db_file';*a
 $   goto  END. $ endifo $ # $!  Create the new DELIVER file ...  $. $ close /nolog deliverO $ open /write /error=ERROR_EXIT /end=ERROR_EXIT deliver SYS$LOGIN:MAIL.DELIVERYa $nF $!  Some general remarks for anyone reading the MAIL.DELIVERY file ... $aG $ put "!  This file was AUTOMATICALLY generated by Postman v''version'" H $ put "!  Created by ''user' on ''node' (running PMDF v''pmdf_version')"7 $ put "!  Creation time: ''f$extract(0,19,f$cvtime())'"n+ $ put "!  Do NOT edit or delete this file!"w/ $ put "!  Use the Postman utility to change or" 3 $ put "!     to activate or de-activate this file."" $  $!  We may want to debug ... ! $(
 $ if debug $ then $   put "!"a $   put "!  Debugger ..."C $   put "!"M $   put "* * * a l ''debugger'" 
 $   say ""- $   say "DELIVER debugging has been enabled."n $ endif  $ D $!  Prevent any non-fatal errors in the DELIVER job from stopping it $!  processing to the end. $d	 $ put "!" $ $ put "!  DELIVER error handler ..."	 $ put "!"M> $ put "* * * a e ""!---------------------------------------"""> $ put "* * * a e ""! Establishing Postman ERROR handler ..."""< $ put "* * * a e ""on severe_error  then  goto error_exit"""# $ put "* * * a e ""goto continue""" = $ put "* * * a e ""error_exit:	! Postman ERROR handler ..."""v $ if delete_filesr $ then/ $   put "* * * a e ""delete 'message_file';*"""E1 $   put "* * * a e ""delete 'message_header';*"""  $ endifd $ put "* * * a e ""exit 1""" $ put "* * * a e ""continue:"""o> $ put "* * * a e ""!---------------------------------------""" $ F $!  Include a "handler" to discard bounced messages and other messagesH $!  which have an empty RETURN-PATH address.  Deliver a copy to the user $!  for information. $p	 $ put "!"  $ put "!  Bounce handlers ..."	 $ put "!""$ $ put """*mailer-daemon@*"" * * t d"$ $ put """*mailer-daemon@*"" * * t q"! $ put """*postmaster@*"" * * t d".! $ put """*postmaster@*"" * * t q" ! $ put "* * * a 1 ""Return-path"""  $ put """<>"" * * t d" $ put """<>"" * * t q" $ put "* * * a 1 ""From""" $" $!  Filtering ...  $  $ filtyp = "Accept" 
 $FILTRATE: $ if 'filtyp'_filter_cnt .gt. 0  $ then $   put "!"a$ $   put "!  ''filtyp' Filtering ..." $   put "!"  $   active = 1 $   inx = 1c
 $   dest = ""  $FILTER_WRITE:' $   filter1 = 'filtyp'_filter'inx'_from % $   filter2 = 'filtyp'_filter'inx'_to ' $   filter3 = 'filtyp'_filter'inx'_subjr $   if filtyp .eqs. "Accept" $   then& $     dest = 'filtyp'_filter'inx'_destD $     put """''filter1'"" ""''filter2'"" ""''filter3'"" y d ''dest'" $   else $ I $!  For Reject filtering, use a feature of PMDF 5.1+ (the asterisk on the H $!  directive) to facilitate Accept filtering passing on by.  Otherwise,' $!  Accept filters must terminate here.F $O! $     if pmdf_version .lts. "5.1" 
 $     then $       if log_rejects  then -A 	   put """''filter1'"" ""''filter2'"" ""''filter3'"" o e """ + -  		"@''postie'  SIEVE""" 9 $	put """''filter1'"" ""''filter2'"" ""''filter3'"" a q "t
 $     else $       if log_rejects  then -B 	   put """''filter1'"" ""''filter2'"" ""''filter3'"" o* e """ + - 		"@''postie'  SIEVE"""r9 $	put """''filter1'"" ""''filter2'"" ""''filter3'"" o q "e $     endify	 $   endifi $   inx = inx + 1o= $   if inx .le. 'filtyp'_filter_cnt  then  goto  FILTER_WRITEs
 $   say ""3 $   say "Your ''filtyp' filtering is now in place!"  $ endifi $ if filtyp .eqs. "Accept" $ then $   filtyp = "Reject"a $   goto  FILTRATE $ endif  $  $!  Vacation message ... $  $ if need_vacation $ then $   active = 1 $   put "!"a6 $   put "!  Vacation message - by default, respond ... $   put "!" # $   put "* * * a e ""respond = 1"""N $   if pmdf_version .ges. "5.1"t $   then
 $     put "!"e4 $     put "!  Check if it's from a mailing list ..."
 $     put "!"N$ $     put "* * * a 1 ""Precedence"""- $     put """bulk"" * * t* e ""respond = 0"""T- $     put """list"" * * t* e ""respond = 0"""m- $     put """junk"" * * t* e ""respond = 0"""e( $     put "* * * a 1 ""Content-return"""3 $     put """prohibited"" * * t* e ""respond = 0"""i$ $     put "* * * a 1 ""X-Listname"""+ $     put """%*"" * * t* e ""respond = 0""".& $     put "* * * a 1 ""X-Listserver"""+ $     put """%*"" * * t* e ""respond = 0"""  $     put "* * * a 1 ""From"""
 $     put "!"y& $     put "!  Respond if required ..."
 $     put "!"t	 $   endifo $   if use_vac_dbs $   thenE $     put "* * * a e ""vac_db == 1"""		! Global variable for DELIVER.d $   elseE $     put "* * * a e ""vac_db == 0"""		! Global variable for DELIVER. 	 $   endifeM $   put "* * * a e ""if respond  then  @''postie'  ALOHA  ''vacation_file'""" 
 $   say ""0 $   say "Your vacation message is now in place!" $ elseK $   if f$search (vac_db_file) .nes. ""  then  delete /nolog 'vac_db_file';*r $ endife $p $!  Forwarding ... $i $ if fwcnt .gt. 0  $ then $   put "!"  $   put "!  Forwarding ..."" $   put "!"s $   active = 1 $   inx = 1p
 $FW_WRITE: $   fwd = fw'inx'i $   put "* * * a p ''fwd'" $   inx = inx + 1r+ $   if inx .le. fwcnt  then  goto  FW_WRITEa
 $   say ""* $   say "Your forwarding is now in place!" $ endifl $a $ if retain_mail $ then $   put "!"i $   put "!  Local delivery ...". $   put "!"  $   put "* * * o d"o $ endifw $r $ close /nolog deliver $o, $!  Ensure OpenVMS MAIL uses DELIVER too ... $  $ if .not. tildedl $ then $   close /nolog tmpfyl > $   open /write /error=ERROR_EXIT /end=ERROR_EXIT tmpfyl 'tmp'* $   putt "$ define /user SYS$OUTPUT NLA0:" $   putt "$ mail"rB $   if vms_version .lts. "V7.0"		! Quotes are handled differently! $   then0 $     putt "set forward in%""""""~''user'""""""" $   else( $     putt "set forward in%""~''user'"""	 $   endifd $   putt "exit"o $   putt "$ EXIT 1"s $   close /nolog tmpfyl-
 $   @'tmp' $   delete /nolog 'tmp';*u $ endif- $ 9 $ if f$search (tmp) .nes. ""  then  delete /nolog 'tmp';*  $s $ if delivering  $ then4 $   if f$search ("SYS$LOGIN:MAIL.DELIVERY") .nes. "" $   then* $     purge /nolog SYS$LOGIN:MAIL.DELIVERYD $     if .not. active  then  delete /nolog SYS$LOGIN:MAIL.DELIVERY;*	 $   endif-= $   if f$search ("SYS$LOGIN:MAIL.DELIVERY_INACTIVE") .nes. ""  $   then3 $     purge /nolog SYS$LOGIN:MAIL.DELIVERY_INACTIVE G $     if active  then  delete /nolog SYS$LOGIN:MAIL.DELIVERY_INACTIVE;*o	 $   endif_ $ endif  $  $ goto  ENDe $ P $!------------------------------------------------------------------------------ $ERROR_EXIT: $ status = $status $ say ""O $ say "*** An error (''status') has occured!  Please notify ITS! ***",bell,bellp $i $END:e $ if .not. commit  $ then
 $   say ""8 $   say "No changes made to your current configuration." $ endifi $a $ close /nolog tmpfyl  $ close /nolog deliver $ close /nolog vdb $t9 $ if f$search (tmp) .nes. ""  then  delete /nolog 'tmp';*S $:  $ EXIT 1 + 0 * f$verify (verify) $(P $!============================================================================== $ADD_FORWARDS:A $ if need_vacation .and. (.not. retain_mail) .and. (fwcnt .eq. 0)H $ then $   default = "Yes"  $ else $   default = "No" $ endif  $  $ say ""C $ ask "Do you wish to add any forwards? (Yes/No) [''default'] " anst0 $ ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")& $ if ans .eqs. ""  then  ans = default $ if ans $ then $   if fullf $   then $     blurbf  O *** CAUTION: Your forwarding addresses should be *valid* mail addresses.    *** O *** If they are not valid, you may inadvertently set up a "mail loop" where ***TO *** rejected ("bounced") mail messages are re-forwarded to the same invalid ***sO *** address when the notification of the rejection is sent to you.          ***A  B Enter the forwarding addresses, ONE per line, a blank line to end:	 $   endif  $   inx = fwcnt + 1I $FW_GET:
 $   say "" $   ask "Address? " ans + $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT")  $   if ans .eqs. ""r $   then $     inx = inx - 1( $   elseL $     ans = ans - "IN%" - "in%" - "In%" - "iN%" - -	! Remove any PMDF junk !9 		  """" - """" - """" - """" - """" - """" - """" - """"i $     fw'inx' = ansc $     inx = inx + 1e $     goto  FW_GET	 $   endife $   fwcnt = inxe) $   if fwcnt .gt. 0  then  forwarding = 1l $ endif. $  $ RETURN $lP $!------------------------------------------------------------------------------
 $ADD_FILTERS:  $ say ""D $ ask "Do you wish to add any ''filtyp' filters? (Yes/No) [No] " ans0 $ ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")# $ if ans .eqs. ""  then  ans = "No"i $ if ans $ then $   if full' $   then $     blurb"  I You can filter based on any or all of the "From:" line, the "To:" line ornI the "Subject:" line.  You can use the percent sign ("%") as a wildcard tosK indicate one single unknown character, and the asterisk ("*") as a wildcard M to indicate zero or more unknown characters.  Filters are not case sensitive.N	 Examples:   F   - to match either "dot", "dont" or "donut", you could specify "do*t"O   - to filter all mail with "free offer" in the subject, specify "*free offer*"'B   - to filter all mail from "hotmail.com", specify "*@hotmail.com"  J To specify filters, you must specify all of the lines, ("From:", "To:" andJ "Subject:"), but you may leave the line BLANK if you do not wish to filterJ that particular type of line.  Leave ALL lines BLANK to terminate input of filters.  	 $   endif  $l7 $   if folders .and. (filtyp .eqs. "Accept") .and. full" $   then $     blurboD You can also use accept filters to automatically file a message in aF given mail folder or mail file.  Simply specify the folder name and an? optional mail file name (space separated) at the "Dest" prompt.e  	 $   endif # $   inx   = 'filtyp'_filter_cnt + 1i $   fline = "From" $   pad = "" $FILTER_GET:% $   'filtyp'_filter'inx'_'fline' = ""y $   ask "''fline':''pad' " ans' $   ans = f$edit (ans,"TRIM,UNCOMMENT")' $   if ans .eqs. ""K $   then( $     'filtyp'_filter'inx'_'fline' = "*" $   elseL $     ans = ans - "IN%" - "in%" - "In%" - "iN%" - -	! Remove any PMDF junk !9 		  """" - """" - """" - """" - """" - """" - """" - """""( $     'filtyp'_filter'inx'_'fline' = ans	 $   endifi $  $   if fline .eqs. "From"  $   then $     fline = "To" $     pad = "  " $     goto  FILTER_GET	 $   endif  $   if fline .eqs. "To"O $   then $     fline = "Subj" $     pad = "" $     goto  FILTER_GET	 $   endifD $   if fline .eqs. "Subj"  $   then. $     if (filtyp .eqs. "Accept") .and. folders
 $     then $	fline = "Dest" $	goto  FILTER_GET
 $     else $	fline = "From"  $	'filtyp'_filter'inx'_dest = "" $     endifn	 $   endif  $   if fline .eqs. "Dest"n $   thenP $     if 'filtyp'_filter'inx'_dest .eqs. "*" then 'filtyp'_filter'inx'_dest = "" $     fline = "From"	 $   endif  $f3 $   if ('filtyp'_filter'inx'_from .nes. "*") .or. -e3        ('filtyp'_filter'inx'_to   .nes. "*") .or. -!,        ('filtyp'_filter'inx'_subj .nes. "*") $   then $     inx = inx + 1  $     say "" $     goto  FILTER_GET	 $   endifn! $   'filtyp'_filter_cnt = inx - 1( $ endiff $e $ RETURN $nP $!------------------------------------------------------------------------------ $GET_MESSAGE_FILE:	 $ if fulll $ then	 $   blurbl  7 You must specify the vacation message you wish to send.f  6 You can either create the message here and now, or you6 can specify the name of a text file which contains the message you wish to be sent. $ endif= $i $ say ""E $ ask "Do you wish to use an existing text file? (Yes/No) [Yes] " ansf0 $ ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")$ $ if ans .eqs. ""  then  ans = "Yes" $ if ans $ then $GET_FILENAME:
 $   say "" $   ask "Filename to use? " ansI2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")- $   if ans .eqs. ""  then  goto  GET_FILENAMEg" $   vacation_file = f$search (ans) $   if vacation_file .eqs. ""  $   then $     say "") $     say "The file does NOT exist!",bell- $     goto  GET_MESSAGE_FILE $   else $     say ""( $     say "The vacation message file is: $     say "" $     say "  ",vacation_file $     say "" $     say "It contains:" $     say ""? $     wait 00:00:02.00		! In case a big file scrolls off screeno $     type 'vacation_file' $     say ""= $     ask "Do you want to use this file? (Yes/No) [Yes] " ansc4 $     ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")( $     if ans .eqs. ""  then  ans = "Yes"0 $     if .not. ans  then  goto  GET_MESSAGE_FILE5 $     vacation_file = f$element (0,";",vacation_file)  $     fyl = vacation_file 	 $   endifa $ else
 $   say ""G $   msg = "Do you want to use the EVE editor to create your file? " + -  	  "(Yes/No) [Yes] " $   ask "''msg'" ans2 $   ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")& $   if ans .eqs. ""  then  ans = "Yes" $C $   inx = 1M $MAKE_VACATION: 9 $   vacation_file := SYS$LOGIN:VACATION_MESSAGE_'inx'.TXTa( $   if f$search (vacation_file) .nes. "" $   then $     inx = inx + 1. $     goto  MAKE_VACATION 	 $   endifn $D
 $   say ""G $   say "Enter the name of the new message file or accept the default."i
 $   say ""- $   ask "Filename? [ ''vacation_file' ] " fyl,2 $   fyl = f$edit (fyl,"COLLAPSE,UNCOMMENT,UPCASE"). $   if fyl .eqs. ""  then  fyl = vacation_file $   if f$parse (fyl) .eqs. ""  $   then $     say ""? $     say "Invalid filename format - please try again ...",bella $     goto  MAKE_VACATIONi	 $   endiff $   if f$search (fyl) .nes. "" $   then $     say ""/ $     say "A file of this name already exists."* $     say "" $     say "It contains:" $     say ""? $     wait 00:00:02.00		! In case a big file scrolls off screenf $     type 'fyl' $     say ""N $     ask "Do you want to use (and edit) this file anyway? (Yes/No) [No] " ans4 $     ans = f$edit (ans,"COLLAPSE,UNCOMMENT,UPCASE")' $     if ans .eqs. ""  then  ans = "No"l- $     if .not. ans  then  goto  MAKE_VACATIONt	 $   endifG $   vacation_file = fylg $   fyl = f$search (fyl) $ 
 $   if ans $   then( $     define /user sys$input sys$command $     edit /tpu 'vacation_file'P $   else $     blurb"  E Please enter your message below - you may use as many lines you wish. H You should press the "Return" key at the end of each line.  When you areF finished, please press Control-Z (i.e., the "Ctrl" key and the "Z" key at the same time).  ( $     define /user sys$input sys$command $     create 'vacation_file'	 $   endif  $ endif( $n $ if fyl .eqs. ""t $ then
 $   say ""6 $   say "Your vacation message file has been created." $ endifq $)< $ vacation_file = f$element (0,";",f$search (vacation_file)) $  $ RETURNP $!------------------------------------------------------------------------------ $SHUFFLE_PARAMS: $l	 $ p1 = p2 	 $ p2 = p3e	 $ p3 = p4S	 $ p4 = p5L	 $ p5 = p6 	 $ p6 = p7l	 $ p7 = p8f	 $ p8 = ""  $  $ RETURNP $!------------------------------------------------------------------------------