$! Parameters:
$!	P1	Build OPTIONS (comma separated list)
$!		NOTCP, MULTINET, NETLIB - Select tcp/ip stack support (accepted but ignored)
$!		COMPILE-ONLY		- Bypass link stage
$!		LINK-ONLY		- Skip compile stage
$!		VAXC			- Force use of VAXC
$!		GNUC			- Force us of GNUC
$!		DEBUG			- Compile/Link with debugger support
$!		NOTRACEBACK		- link with /NOTRACE
$!		OPTIMIZE		- Request optimization if no DEBUG
$!
$!	P2	List of modules to be recompiled
$!		a,b,c...		- List of modules
$!		Null			- Recompile everything
$!
$ defines = "ANSI_DRIVER,ATTACHMENTS,DEBUG"
$
$! -------------------------------------------------------------------------
$! Define location for object files and executables
$! -------------------------------------------------------------------------
$ Arch = "VAX"
$ if f$getsyi("VERSION") .ges. "V5.5" then $ Arch = f$getsyi("ARCH_NAME")
$ OLBDIR      = "[-.OBJ_''Arch']
$ OBJDIR      = "[-.OBJ_''Arch'.PICO]"
$ EXEDIR      = "[-.EXE_''Arch']"
$ if f$parse(OLBDIR) .eqs. "" then $ create/dir 'OLBDIR'
$ if f$parse(OBJDIR) .eqs. "" then $ create/dir 'OBJDIR'
$ if f$parse(EXEDIR) .eqs. "" then $ create/dir 'EXEDIR'
$
$ COMPILEONLY = f$locate("COMPILE-ONLY",P1) .lt. f$length(P1)
$ LINKONLY    = f$locate("LINK-ONLY",   P1) .lt. f$length(P1)
$ if (COMPILEONLY .and. LINKONLY)
$   then
$     write sys$output "%VMSBUILD-E-CONFLICT, Conflicting compile/link options"
$     exit
$ endif
$
$
$! Set up for the appropriate compiler
$ CC_PREF = ""
$ sysdef = ""
$ netdef = ""
$ arpdef = ""
$
$! Find out what compilers we have
$ HAVEDECC = F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$ HAVEVAXC = F$SEARCH("SYS$SYSTEM:VAXC.EXE")          .NES. ""
$ HAVEGNUC = F$SEARCH("GNU_CC:[000000]GCC.EXE")       .NES. ""
$
$! ... and which one we want to use in preference (if any)
$ FORCEVAXC= f$locate("VAXC",P1) .lt. f$length(P1)
$ FORCEGNUC = f$locate("GNUC",P1) .lt. f$length(P1)
$ if .not. (HAVEDECC .or. HAVEVAXC .or. HAVEGNUC)
$   then
$     write sys$output "%VMSBUILD-E-NOCC, No supported C compiler detected"
$     exit
$ endif
$
$
$! Auto-select, in order of preference, the best compiler available
$ COMPILER = ""
$ if (HAVEGNUC) then $ COMPILER = "GNU C"
$ if (HAVEVAXC) then $ COMPILER = "VAX C"
$ if (HAVEDECC) then $ COMPILER = "DEC C"
$
$! Multiple compilers specified?
$ if (FORCEVAXC .and. FORCEGNUC)
$   then
$     write sys$output "%VMSBUILD-E-AMBIG, Multiple C compilers specified"
$     exit
$ endif
$
$! Has user requested GNU C?
$ if FORCEGNUC
$   then
$     if .not. HAVEGNUC
$       then
$         write sys$output "%VMSBUILD-E-NOGNUC, GNUC selected but not installed"
$         exit
$     endif
$     COMPILER = "GNU C"
$ endif
$
$! Has user requested VAX C
$ if (FORCEVAXC)
$   then
$     if .not. HAVEVAXC
$       then
$         write sys$output "%VMSBUILD-E-NOVAXC, VAXC selected but not installed"
$         exit
$     endif
$     COMPILER = "VAX C"
$ endif
$
$ IF (COMPILER .eqs. "GNU C")
$   THEN
$       if f$type(GCC) .nes. ""
$         then
$           CC = GCC		! Defined foreign
$         else
$           CC = "GCC"		! Defined via SET COMMAND
$       endif
$
$       LINK_OPT = ",[-]VMS_GCC_LINK/OPTION"
$ ENDIF
$
$ IF (COMPILER .eqs. "VAX C")
$   THEN
$       if (HAVEDECC) then $ CC_PREF = CC_PREF + "/VAXC"
$       
$       sysdef   = "SYS$LIBRARY"
$	LINK_OPT = ",[-]VMS_VAXC_LINK/OPTION"
$ ENDIF
$
$ IF (COMPILER .eqs. "DEC C")
$   THEN
$       if (HAVEVAXC) then $ CC_PREF = CC_PREF + "/DECC"
$
$	CC_PREF = CC_PREF + "/STANDARD=VAXC"
$	LINK_OPT = ""
$ ENDIF
$
$! Deassign any prior logicals in case we previously run something
$ IF F$TRNLNM("SYS")     .NES. "" THEN $ DEASSIGN SYS
$ IF F$TRNLNM("NETINET") .NES. "" THEN $ DEASSIGN NETINET
$ IF F$TRNLNM("ARPA")    .NES. "" THEN $ DEASSIGN ARPA
$
$! Set up the defines based on the compiler requirements and the network requirements
$ if (sysdef .nes. "") then $ define /nolog sys     'sysdef'
$ if (netdef .nes. "") then $ define /nolog netinet 'netdef'
$ if (arpdef .nes. "") then $ define /nolog arpa    'arpdef'
$ 
$!
$ if f$locate("DEBUG", P1) .LT. F$LENGTH(P1)
$   then
$      CC_PREF = CC_PREF + "/DEBUG/NOOPTIMIZE"
$      LINK   = "LINK /DEBUG"
$   else
$      if f$locate("OPTIMIZE",P1) .lt. f$length(P1)
$        then
$          CC_PREF = CC_PREF + "/OPTIMIZE"	! /OPT is NOT the default!
$        else
$          CC_PREF = CC_PREF + "/NOOPTIMIZE"
$      endif
$      LINK   = "LINK"
$      if f$locate("NOTRACEBACK",P1) .lt. f$length(P1)
$        then
$          LINK_OPT = LINK_OPT + "/NOTRACE"	! /NOTRACEBACK
$      endif
$ ENDIF
$
$ CC_PREF = CC_PREF + "/DEFINE=(''defines')"
$ CC_PREF = CC_PREF + "/OBJECT=''OBJDIR'"
$
$ if LINKONLY then $ goto LINK
$
$! ----------------------------------------------------------------------------
$! ----------------------------------------------------------------------------
$ COPY/NOLOG OS_VMS.H OSDEP.H;
$ PURGE/NOLOG OSDEP.H
$
$ write sys$output "%VMSBUILD-I-BUILD, Building PICO using ", COMPILER
$ if (P2 .nes. "")
$   then
$ SET VERIFY
$ CC'CC_PREF' 'P2'
$ SET NOVERIFY
$   else
$ SET VERIFY
$ CC'CC_PREF' attach
$ CC'CC_PREF' ansi
$ CC'CC_PREF' basic
$ CC'CC_PREF' bind
$ CC'CC_PREF' browse
$ CC'CC_PREF' buffer
$ CC'CC_PREF' composer 
$ CC'CC_PREF' display
$ CC'CC_PREF' file 
$ CC'CC_PREF' fileio
$ CC'CC_PREF' line
$ CC'CC_PREF' pico
$ CC'CC_PREF' random 
$ CC'CC_PREF' region 
$ CC'CC_PREF' search
$ CC'CC_PREF' spell 
$ CC'CC_PREF' window 
$ CC'CC_PREF' word
$ CC'CC_PREF' main
$ CC'CC_PREF' os_VMS
$ SET NOVER
$ endif
$!
$ write sys$output "%VMSBUILD-I-LIBRARY, Creating PICO library"
$ LIBRARY/OBJECT/CREATE/INSERT 'OLBDIR'PICO.OLB 'OBJDIR'attach,'OBJDIR'ansi,-
	'OBJDIR'basic,'OBJDIR'bind,'OBJDIR'browse,'OBJDIR'buffer,'OBJDIR'composer,-
	'OBJDIR'display,'OBJDIR'file,'OBJDIR'fileio,'OBJDIR'line,'OBJDIR'pico,-
	'OBJDIR'random,'OBJDIR'region,'OBJDIR'search,'OBJDIR'spell,'OBJDIR'window,-
	'OBJDIR'word,'OBJDIR'os_vms
$ PURGE/nolog 'OLBDIR'PICO.OLB
$ PURGE/NOLOG 'OBJDIR'*.OBJ
$!
$LINK:
$ if COMPILEONLY then $ exit
$ write sys$output "%VMSBUILD-I-LINK, Linking stand-alone PICO editor utility"
$ DEFINE/USER OBJ 'OBJDIR'
$ LINK/EXE='EXEDIR'pico 'OBJDIR'main,'OLBDIR'pico/libr'LINK_OPT'
$ PURGE/NOLOG 'EXEDIR'*.EXE
