  J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              PERSONA              %%   \ @  *                %% |          utility.c  c1999         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 1999 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module utility VERSION  9 #include <stdio.h>          /* Standard IO definitions */ = #include <ssdef.h>          /* System Service return codes */ 6 #include <iodef.h>          /* I/O Definition codes */@ #include <ttdef.h>          /* basic terminal characteristics */C #include <tt2def.h>         /* extended terminal characteristics */ 5 #include <impdef.h>         /* Persona Definitions */ 8 #include <string.h>         /* currently for strlen() */D #include <jpidef.h>         /* Job/Process Information item codes */? #include <dvidef.h>         /* Device Information item codes */ K #include <uaidef.h>         /* User Authorization Information item codes */ 0 #include <prvdef.h>         /* Priv mask defs */< #include <ptddef.h>         /* PseudoTerminal Definitions */? #include <accdef.h>         /* Accounting record definitions */ 8 #include <prcdef.h>         /* Process Creation flags */ #include <clidef.h>  #include <climsgdef.h>D #include <ossdef.h>         /* defines for get/set_security calls */> #include <descrip.h>        /* Descriptor Definition Macros */ #include "defs.h"   K #define SS$_INVPWD 2        /* can't find a definition, so I made one up */    extern struct _IoBuff {      buff PtdReadBuf,          PtdWrtBuf;  } _align (PAGE) IoBuff;    extern unsigned long inAdr[2];  C extern struct  ITEM DviItem[2];     /* Itemlist for $GETDVI info */ D extern struct  ITEM JpiUser[5];     /* Itemlist for invoking user */H extern struct  ITEM JpiPriv[3];     /* Itemlist for $GETJPI priv info */Q extern struct  ITEM MbxItem[2];     /* Itemlist for Termination mailbox device */ K extern struct  ITEM UaiItem[4];     /* Itemlist for Target user uaf info */   : extern struct IOSB  DviIosb;        /* iosb for $GETDVI */: extern struct IOSB  JpiIosb;        /* iosb for $GETJPI */: extern struct IOSB  MbxIosb;        /* iosb for mailbox */= extern struct IOSB  PtdIosb;        /* iosb for PTD device */ : extern struct IOSB  QioIosb;        /* iosb for $QIO(W) */= extern struct IOSB  TtdIosb;        /* iosb for TT: device */   I extern short MbxChan;               /* Channel for termination mailbox */ P extern short NewProt;               /* Protection for terms during this image */E extern short OldProt;               /* Protection of orig terminal */ E extern short PtdChan;               /* Channel for Pseudo Terminal */ G extern short TtdChan;               /* Channel for original terminal */    extern char CharBuf[80];L extern char CmdVerb[50];            /* foreign symbol invoking this image */: extern char NewUser[16];            /* Target user name */F extern char NewUserTmp[14];         /* temp string for new username */G extern char OldProcN[18];           /* Process name of invoking user */ < extern char OldUser[16];            /* Invoking user name */M extern char PrcName[18];            /* Process name of detached pseudoterm */ : extern char TtdName[32];            /* Original TT name */  I extern int  OldPid;                 /* process id for original process */ I extern int  NewTTChar[3];           /* Target terminal characteristics */ K extern int  OldTTChar[3];           /* Invoking terminal characteristics */ = extern int  PrvBuf[2];              /* Image process privs */  extern int  status;   I struct  ITEM OssItem[2];            /* Itemlist for $GET_SECURITY info */   > char ClassName[]="DEVICE";          /* Name of object class */F char PwdBuf[32];                    /* User entered password string */  V int flags = OSS$M_RELCTX;           /* Mask specifying processing options           */V int context;                        /* Context variable for multiple calls          */V int acmode;                         /* Access mode to be used in object protection  */  E $DESCRIPTOR(DscClass, ClassName);   /* Descriptor for object class */ = $DESCRIPTOR(DscPrn, PrcName);       /* process name string */ E $DESCRIPTOR(DscTt, "TT:");          /* originating terminal device */    extern void ExitHndlr(); extern void PtdReadAst();  extern void TtdReadAst();  extern void CharChangedAst();  extern void DispMsg();   globalvalue PERSONA_CLD;  N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *@  * EchoOff - Save current terminal status and change temporarilyA  *           so as not to echo when the system manager's password   *           is entered.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void EchoOff() { 0     status = sys$assign(&DscTt, &TtdChan, 0, 0);L     status = sys$qiow(0, TtdChan, IO$_SENSEMODE, &QioIosb, 0, 0, &OldTTChar,5                       sizeof(OldTTChar), 0, 0, 0, 0);       NewTTChar[0] = OldTTChar[0];      NewTTChar[1] = OldTTChar[1];      NewTTChar[2] = OldTTChar[2];  @     NewTTChar[1] |= TT$M_NOECHO;       /* term will be Noecho */6     NewTTChar[1] &= ~TT$M_ESCAPE;      /* no escape */E     NewTTChar[1] |= TT$M_NOBRDCST;     /* disable direct broadcast */ 9     NewTTChar[1] &= ~TT$M_HOSTSYNC;    /* no host sync */ H     NewTTChar[1] &= ~TT$M_TTSYNC;      /* do sync at subprocess level */  J     status = sys$qiow(0, TtdChan, IO$_SETMODE, &QioIosb, 0, 0, &NewTTChar,5                       sizeof(NewTTChar), 0, 0, 0, 0);  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *B  * EchoOn - Restore terminal status to same state as it was at theH  *          time this image was activated. Called after system manager's&  *          password has been entered.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 void EchoOn()  { J     status = sys$qiow(0, TtdChan, IO$_SETMODE, &QioIosb, 0, 0, &OldTTChar,5                       sizeof(OldTTChar), 0, 0, 0, 0); !     status = sys$dassgn(TtdChan);  }       J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *H  * TtGets - Read character string from the keyboard, perform no editing,5  *          no echo. Purge typeahead buffer at entry.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int TtGets() { 8     int length;         /* num bytes in typeahead buf */  J     status = sys$qiow(0, TtdChan, IO$_READLBLK|IO$M_PURGE, &QioIosb, 0, 0,;                       &PwdBuf, sizeof(PwdBuf), 0, 0, 0, 0);      length = QioIosb.byte_cnt;     PwdBuf[length] = '\0';     return (length); }     J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *J  * PwdChk - Prompt user for system manager password. Do not echo response,H  *          compare response string to existing password. If response isA  *          is positive return SS$_NORMAL, else return SS$_INVPWD   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int PwdChk() { 
     char Alg;      char UsrNam = "SYSTEM";      short Salt;       long ChkHash[2], CurHash[2];#     $DESCRIPTOR(DscChkPwd, PwdBuf); #     $DESCRIPTOR(DscUser, "SYSTEM");   0     printf("\nEnter System Manager Password: ");     EchoOff();     status = TtGets();
     EchoOn();      printf("\n");   %     DscChkPwd.dsc$a_pointer = PwdBuf; ,     DscChkPwd.dsc$w_length = strlen(PwdBuf);       UaiItem[0].buf_size = 1;(     UaiItem[0].item_code = UAI$_ENCRYPT;     UaiItem[0].buf_addr = &Alg;      UaiItem[0].buf_len = 0;      UaiItem[1].buf_size = 2;%     UaiItem[1].item_code = UAI$_SALT;       UaiItem[1].buf_addr = &Salt;     UaiItem[1].buf_len = 0;      UaiItem[2].buf_size = 8;$     UaiItem[2].item_code = UAI$_PWD;#     UaiItem[2].buf_addr = &CurHash;      UaiItem[2].buf_len = 0;      UaiItem[3].buf_size = 0;     UaiItem[3].item_code = 0;   0     status = str$upcase(&DscChkPwd, &DscChkPwd);;     status = sys$getuai(0, 0, &DscUser, &UaiItem, 0, 0, 0);   A         /* use 'sys$hash_password' to get hash value from user */   I     status = sys$hash_password(&DscChkPwd, Alg, Salt, &DscUser, ChkHash); A     if((CurHash[0] != ChkHash[0]) || (CurHash[1] != ChkHash[1]))           return(SS$_INVPWD);      else return (SS$_NORMAL);  }     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *E  * MbxAst - Ast routine called when a write occurs to the termination D  *          mailbox. This event is called as a result of exiting theI  *          detached pseudo terminal process. Simply cancel the SYS$HIBER I  *          call, then exit. ExitHndlr() will handle the remaining items.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 void MbxAst()  { !     status = sys$dassgn(MbxChan); O     status = sys$wake(&OldPid, 0);  /* as with glogin.mar, this doesn't work */ <     status = sys$exit(SS$_NORMAL);  /* this however, does */ }     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *C  *  GetDevProt - Get the word length protection mask for the device @  *               name buffer pointed to by DevName. The ProtType?  *               constant defines where to save retrieved mask.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ + int GetDevProt(char *DevName, int ProtType)  {      short length = 0; D     $DESCRIPTOR(DscTerm, DevName);  /* Descriptor for object name */  +     DscTerm.dsc$w_length = strlen(DevName);      OssItem[0].buf_size = 2;+     OssItem[0].item_code = OSS$_PROTECTION; #     OssItem[0].buf_addr = &NewProt; "     OssItem[0].buf_len  = &length;     OssItem[1].buf_size = 0;     OssItem[1].item_code = 0;   0     if(ProtType) OssItem[0].buf_addr = &OldProt;F     status = sys$get_security(&DscClass, &DscTerm, 0, flags, &OssItem,1                               &context, &acmode); '     if(!(status & 1)) lib$stop(status);      return(SS$_NORMAL);  }   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *C  *  SetDevProt - Set the word length protection mask for the device @  *               name buffer pointed to by DevName. The ProtType?  *               constant defines where the new protection mask 1  *               is located. (Ugly, but it works)   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ + int SetDevProt(char *DevName, int ProtType)  {      short length = 0; D     $DESCRIPTOR(DscTerm, DevName);  /* Descriptor for object name */  +     DscTerm.dsc$w_length = strlen(DevName);      OssItem[0].buf_size = 2;+     OssItem[0].item_code = OSS$_PROTECTION; #     OssItem[0].buf_addr = &NewProt; "     OssItem[0].buf_len  = &length;     OssItem[1].buf_size = 0;     OssItem[1].item_code = 0;   0     if(ProtType) OssItem[0].buf_addr = &OldProt;F     status = sys$set_security(&DscClass, &DscTerm, 0, flags, &OssItem,1                               &context, &acmode); '     if(!(status & 1)) lib$stop(status);      return(SS$_NORMAL);  }     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *H  *  ExitHndlr - Exit handler from $DCLEXH declaration. Routine is calledD  *              for any exit() call subsequent to SYS$PERSONA_CREATED  *              and is used to cleanup terminal environment prior to%  *              actual image rundown.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */   void ExitHndlr(int *exit_status) { !     status = ptd$delete(PtdChan); '     if(!(status & 1)) lib$stop(status);      strcpy(PrcName, OldProcN);*     DscPrn.dsc$w_length = strlen(PrcName);!     status = sys$setprn(&DscPrn); '     if(!(status & 1)) lib$stop(status); !     status = sys$dassgn(TtdChan); '     if(!(status & 1)) lib$stop(status); 0     status = sys$assign(&DscTt, &TtdChan, 0, 0);'     if(!(status & 1)) lib$stop(status); I     status = sys$qio(0, TtdChan, IO$_SETMODE, &TtdIosb, 0, 0, &OldTTChar, 5                       sizeof(OldTTChar), 0, 0, 0, 0); Q     printf("\n\n%%%s-I-SESCOMP, session completed. Terminal: %s, UserId: %s\n\n", '             CmdVerb, TtdName, OldUser); *     status = SetDevProt(&TtdName, OLDDEV);'     if(!(status & 1)) lib$stop(status); !     status = sys$dassgn(TtdChan); '     if(!(status & 1)) lib$stop(status);  }     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *G  *  TtdReadAst - called whenever a key is pressed on the real keyboard. D  *               It just transfers the keystroke to the psuedo term,9  *               then requeues another read the keyboard.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void TtdReadAst()  { B     status = ptd$write(PtdChan, 0, 0, &IoBuff.PtdWrtBuf, 1, 0, 0);'     if(!(status & 1)) lib$stop(status);   @     status = sys$qio(0, TtdChan, IO$_READVBLK, 0, TtdReadAst, 0,<                       &IoBuff.PtdWrtBuf.dat, 1, 0, 0, 0, 0);'     if(!(status & 1)) lib$stop(status);  }     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *H  *  PtdReadAst - called whenever anything comes in from the psuedo term.A  *               It determines how many characters were read and  B  *               transfers them to the real screen. It then queues5  *               another read to the psuedo terminal.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void PtdReadAst()  { ?     status = sys$qio(0, TtdChan, IO$_WRITEVBLK, &QioIosb, 0, 0, ,                      &IoBuff.PtdReadBuf.dat,;                      IoBuff.PtdReadBuf.length, 0, 0, 0, 0); '     if(!(status & 1)) lib$stop(status);   J     status = ptd$read(0, PtdChan, PtdReadAst, 0, &IoBuff.PtdReadBuf, 508);'     if(!(status & 1)) lib$stop(status);  }     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *G  *  CharChangedAst - This AST routine will be called anytime an attempt E  *                   is made to change the terminal Characteristics.  B  *                   This will be indicated by printing the stringF  *                   the string "--->CHAR" on the terminal screen, but<  *                   is NOT implemented in this application.  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void CharChangedAst()  { )     char charChangedBuf[] = "--->CHAR\n";   #         /* Write to the terminal */   I     status = sys$qiow(0, TtdChan, IO$_WRITEVBLK|IO$M_BREAKTHRU, &QioIosb, C                       0, 0, charChangedBuf, strlen(charChangedBuf), "                       0, 0, 0, 0);'     if(!(status & 1)) lib$stop(status);  }     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *F  *  CheckIdent - Reads the rights database to verify invoking user hasH  *               appropriate identifier granted to assume the persona ofB  *               the target user. If not, return SS$_NOSUCHID else=  *               if proper identifier then return SS$_NORMAL.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckIdent() {      char name[31];     char TargIdentStr[31];     unsigned int HolderBin[2];     unsigned int TargIdentBin;&     unsigned int HeldBin, context = 0;     unsigned short count = 0;       $DESCRIPTOR (DscName, name);'     $DESCRIPTOR(DscPers, TargIdentStr);   <         /* get invoking username, convert to binary value */       strcpy(name, OldUser);(     DscName.dsc$w_length = strlen(name);4     status = sys$asctoid ( &DscName, &HolderBin, 0);'     if(!(status & 1)) lib$stop(status);   7         /* get target username, prefix with PERS_, then %            convert to binary value */   1     sprintf(TargIdentStr, "PERS_%s", NewUserTmp); 0     DscPers.dsc$w_length = strlen(TargIdentStr);5     status = sys$asctoid(&DscPers, &TargIdentBin, 0); C     if(!(status & 1)) return(status);   /* probably SS$_NOSUCHID */   :         /* Make repeated calls to SYS$FIND_HELD to return 6            all identifiers held by holder (OldUser) */  ?     HolderBin[2] = 0;        /* complete the quadword holder */W!     while(status == SS$_NORMAL) {mB         status = sys$find_held(&HolderBin, &HeldBin, 0, &context);1         if(status == SS$_IVIDENT) return(status);c>         if((status == SS$_NOSUCHID) && !count) return(status);"         if(status == SS$_NORMAL) {7             if(HeldBin == TargIdentBin) return(status);p             count++;	         }*     }*B     return(status);     /* probably SS$_NOSUCHID with count > 0 */ }     L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *F  *  version - User entered the /VERSION qualifier to display the imageF  *            version, C compiler type, and required image privileges.D  *            This software application has NOT been built with VaxC  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */<	 version()  { 3     printf("\n\n\t\t%s by Lyle W West\n", CmdVerb); 0     printf("\t\tVersion: %s (DecC)\n", VERSION);.     printf("\t\tImage Build: %s\n", __DATE__);D     printf("\t\tRequired Privs: AUDIT, SYSPRV, DETACH, CMKRNL\n\n");     exit(1); }f    L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *@  *  ShowHelp - User entered the /HELP qualifier to get a list of@  *             parameters and qualifiers available to this image  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */c
 ShowHelp() { ;     printf(" \n\n%s Command line arguments:\n\n", CmdVerb);n"     printf("\n   Parameters\n\n");J     printf("     USERNAME - Required. The USERNAME is a valid user in\n");I     printf("\t\tthe User Authorization File. The user account cannot\n");nN     printf("\t\tbe disabled. If invalid or disabled, %s exits.\n\n", CmdVerb);      printf("   Qualifiers\n\n");P     printf("    /HELP - if present, %s displays list of qualifiers\n", CmdVerb);?     printf("\t\tavailable for %s (this display)\n\n", CmdVerb); O     printf("    /IGNOREID - if present, %s ignores identifier requirements.\n",                  CmdVerb); L     printf("\t\tHowever, user is required to enter the system manager's\n");+     printf("\t\tpassword to continue\n\n");aL     printf("    /VERSION - if present %s displays version, build", CmdVerb);1     printf(" date,\n\t\tand required privs\n\n");      exit(1); }x          N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *"  *            ****** NOTICE ******  *<  *    This routine written by Joe Meadows and is used in his<  *    VERB, FILE and FIND programs. Only minor modifications2  *    have been made for use in this program - lww  *-  *    status = InitCli(table_addr, verb_name)*  *E  *    This routine allows you to define a command as either a foreign I  *  command (via PROG :== $<wherever>PROG), or as a real command (via the K  *  SET COMMAND command). "table_addr" is the address of the command tablesaH  *  (you must do a SET COMMAND/OBJECT and link the resulting object fileB  *  into your code, then use "globalvalue" to reference the table.M  *  "verb_name" is the name of the verb (a null terminated, uppercase string)1  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */*    + /* "table" is a pointer to the internal CLDl:  * "name" is a text string containing the name of the verb  */m  $ int InitCli(char *table, char *name) {eG   static struct dsc$descriptor cmd = {0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0}; #   static $DESCRIPTOR(verb,"$VERB"); #   static $DESCRIPTOR(line,"$LINE");s   int indx, stat;e  #   stat = cli_get_value(&verb,&cmd);l%   if ((stat & 1) && cmd.dsc$w_length)C   {]>     if (strncmp(cmd.dsc$a_pointer,name,cmd.dsc$w_length) == 0)     {fF       return(1);    /* the command must have been properly defined! */     }T   }s  #   stat = cli_get_value(&line,&cmd);T   if (!(stat & 1))   {rI     printf("Unexpected error in InitCli, error %d in retrieving $LINE\n",;             stat);     return(stat);s   }s  E   /* this code assumes that the verb is shorter than than the foreignsF      symbol (which includes device:[dir], so, should be reasonable) */-   for (indx = 0; (indx < cmd.dsc$w_length) &&c1               (cmd.dsc$a_pointer[indx] != ' ') &&u7               (cmd.dsc$a_pointer[indx] != '/'); ++indx)sC     cmd.dsc$a_pointer[indx] = (indx < strlen(name))?name[indx]:' ';N     if (indx < strlen(name))0 #ifdef ARF      /* added by lww - 26-Mar-1998 */,     printf("Unexpected error in InitCli, ");;     printf("verb name wasn't smaller than $line prefix\n");A #else H     printf("\n%%%s-E-NOFORSYMB, must be invoked via foreign symbol\n\n",             CmdVerb);* #endif *F   return(cli$dcl_parse(&cmd,table)); /* initialize the parse tables */ }S   int lib$sig_to_ret();u  G int cli_get_value(struct dsc$descriptor *s1, struct dsc$descriptor *s2)n {r    lib$establish(lib$sig_to_ret);   return cli$get_value(s1, s2);* }*    