  M /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *    *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |             PERSONA               %%   \ @  *                %% |          persona.c  c1999         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 1999 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *  *  * FACILITY: PERSONA  *L  * ABSTRACT:  This program allows a privileged user to obtain an interactiveN  *            session on behalf of another user.  The privileged user inheritsP  *            the complete environment of the target user including DCL symbols,M  *            PROCESS/JOB/GROUP logical names, process quotas, privileges and M  *            rights identifiers as well as any other stuff that is set up in )  *            the target user's LOGIN.COM   *6  * ENVIRONMENT: User mode with SYSPRV, DETACH, CMKRNL.  *+  * SECURITY: Install with CMKRNL and SYSPRV   *  * Usage:    $ PERSONA username   *6  *       PERSONA is defined to be a foreign symbol and2  *       username is a valid userid on the system.  *D  * OTHER:    Requires the FTA psuedo terminal driver. PERSONA is a CE  *           rewrite and enhancement of the GLOGIN utility written by H  *           Anthony C. McCracken, Northern Arizona University, in 1992.  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module persona VERSION  9 #include <stdio.h>          /* Standard IO definitions */ = #include <ssdef.h>          /* System Service return codes */ 6 #include <iodef.h>          /* I/O Definition codes */@ #include <ttdef.h>          /* basic terminal characteristics */C #include <tt2def.h>         /* extended terminal characteristics */ 5 #include <impdef.h>         /* Persona Definitions */ 8 #include <string.h>         /* currently for strlen() */D #include <jpidef.h>         /* Job/Process Information item codes */? #include <dvidef.h>         /* Device Information item codes */ K #include <uaidef.h>         /* User Authorization Information item codes */ 0 #include <prvdef.h>         /* Priv mask defs */< #include <ptddef.h>         /* PseudoTerminal Definitions */? #include <accdef.h>         /* Accounting record definitions */ 8 #include <prcdef.h>         /* Process Creation flags */1 #include <clidef.h>         /* Cli definitions */  #include <climsgdef.h>D #include <ossdef.h>         /* defines for get/set_security calls */> #include <descrip.h>        /* Descriptor Definition Macros */, #include "defs.h"           /* local defs */   struct _IoBuff {     buff PtdReadBuf,          PtdWrtBuf;  } _align (PAGE) IoBuff;    unsigned long inAdr[2];   ; struct  ITEM DviItem[2];    /* Itemlist for $GETDVI info */ < struct  ITEM JpiUser[6];    /* Itemlist for invoking user */@ struct  ITEM JpiPriv[3];    /* Itemlist for $GETJPI priv info */I struct  ITEM MbxItem[2];    /* Itemlist for Termination mailbox device */ C struct  ITEM UaiItem[4];    /* Itemlist for Target user uaf info */   2 struct IOSB  DviIosb;       /* iosb for $GETDVI */2 struct IOSB  JpiIosb;       /* iosb for $GETJPI */2 struct IOSB  MbxIosb;       /* iosb for mailbox */5 struct IOSB  PtdIosb;       /* iosb for PTD device */ 2 struct IOSB  QioIosb;       /* iosb for $QIO(W) */5 struct IOSB  TtdIosb;       /* iosb for TT: device */   C int  OldTTChar[3];          /* Invoking terminal characteristics */ A int  NewTTChar[3];          /* Target terminal characteristics */ 5 int  PrvBuf[2];             /* Image process privs */   ; int  status;                /* global status return info */ - int  indx;                  /* index value */ < int  CliStat;               /* status value for cli calls */K int  Ignore;                /* Ignore identifier checking (undocumented) */ @ int  ImpFlags;              /* flags for $persona_create call */ int  ImpHandle; J int  MbxUnit;               /* termination mailbox unit number (MBAxxx) */A int  NewPid;                /* process id for detached process */ A int  OldPid;                /* process id for original process */ N int  StsFlg;                /* runtime options for created detached process */6 int  UicBufO;               /* uic of original user */1 int  UicBufN;               /* uic of new user */ ; int  UaiFlags;              /* uai flags for target user */   = short PtdChan;              /* Channel for Pseudo Terminal */ ? short TtdChan;              /* Channel for original terminal */ A short MbxChan;              /* Channel for termination mailbox */ = short OldProt;              /* Protection of orig terminal */ H short NewProt;              /* Protection for terms during this image */8 short CvLen;                /* Length of command verb */; short FlagLen;              /* size in bytes of uaiflags */ 0 short PrvLen;               /* size of PrvBuf */< short UicLen;               /* size of UIC value (UicBuf) */C short UserLen;              /* size of username buffer (NewUser) */  short NameLen;  J char CmdVerb[50];           /* foreign symbol used to invoke this image */: char CliStr[50];            /* buffer to store cli info */@ char EscStr[16];            /* clr screen and home cursor str */A char ImgStr[50];            /* image name str for loginout.exe */ B char MbxBuff[90];           /* Mailbox accounting string buffer */2 char NewUser[16];           /* Target user name */> char NewUserTmp[14];        /* temp string for new username */? char OldProcN[18];          /* Process name of invoking user */ 4 char OldUser[16];           /* Invoking user name */E char PrcName[18];           /* Process name of detached pseudoterm */ 2 char TtdName[32];           /* Original TT name */F char PtdName[32];           /* Resultant Pseudoterminal device name */8 char *ptr1;                 /* general string pointer */   extern void ExitHndlr(); extern void MbxAst();  extern void DispMsg(); extern void PtdReadAst();  extern void QioReadAst();  extern void TtdReadAst();   8         /* DESBLK - control block for an exit handler */   static int ExitStatus; static struct {      int flink;     int (*hand_address) ();      int NumOfArgs;     int *ReasonForExit; - } ExitBlock = {0, ExitHndlr, 1, &ExitStatus};    globalvalue PERSONA_CLD;  
 int main() { E     char MsgBuff[80];                  /* temp string for messages */   (         /* Initialize descriptor list */  M     $DESCRIPTOR(DscPrn, PrcName);      /* detached pseudoterm process name */ H     $DESCRIPTOR(DscTt, "TT:");         /* originating terminal device */M     $DESCRIPTOR(DscTtd, TtdName);      /* orig terminal device name string */ O     $DESCRIPTOR(DscPtd, PtdName);      /* pseudo terminal device name string */ H     $DESCRIPTOR(DscUserO, OldUser);    /* originating username string */G     $DESCRIPTOR(DscUserT, NewUserTmp); /* target username tmp string */ C     $DESCRIPTOR(DscUserN, NewUser);    /* target username string */ J     $DESCRIPTOR(DscCli, CliStr);       /* cli param or qualifier string */I     $DESCRIPTOR(DscCmd, CmdVerb);      /* foreign invoking symbol name */ E     $DESCRIPTOR(DscImg, ImgStr);       /* image string for $creprc */       /     sprintf(ImgStr, "SYS$SYSTEM:LOGINOUT.EXE"); H     status = cmdlin(&DscCmd,&CvLen);  /* get invoking foreign cmd str */*     if(status != SS$_NORMAL) exit(status);  -         /* make sure cmd verb is uppercase */        CmdVerb[CvLen] = '\0';     ptr1 = strchr(CmdVerb,'/');      if(ptr1) *ptr1 = '\0';     ptr1 = strchr(CmdVerb,' ');      if(ptr1) *ptr1 = '\0';1     for(indx = 0; indx < strlen(CmdVerb); indx++) /         CmdVerb[indx] = toupper(CmdVerb[indx]);   .     CliStat = InitCli(PERSONA_CLD, "PERSONA");'     if(!CliStat & 1) lib$stop(CliStat);   >         /* if user typed /HELP then show help text and exit */       strcpy(CliStr,"HELP");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();   @         /* if user typed /VERSION then show versinfo and exit */       strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); *     if(CliStat == CLI$_PRESENT) version();  >         /* if user typed /IGNOREID then set the ignore flag */       strcpy(CliStr, "IGNOREID"); )     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); .     if(CliStat == CLI$_PRESENT) Ignore = TRUE;  8         /* get the desired username from command line */  ,     strcpy(DscCli.dsc$a_pointer,"USERNAME");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); :     CliStat = cli$get_value(&DscCli, &DscUserT, &UserLen);.     status = str$upcase(&DscUserT, &DscUserT);     if(CliStat == SS$_NORMAL) { #         NewUserTmp[UserLen] = '\0';      } :     else {  /* if no username, display message and exit */A         printf("\n%%%s-E-NOUSERID,  Usage Syntax: %s Username\n",              CmdVerb,  CmdVerb); 1         printf("\t(type %s /HELP)\n\n", CmdVerb);          exit(1);     } )     sprintf(NewUser,"%-12s", NewUserTmp); ,     DscUserN.dsc$w_length = strlen(NewUser);  9         /* Verify pseudoterm is installed, exit if not */        strcpy(PtdName, "FTA0:"); *     DviItem[0].buf_size = strlen(PtdName);'     DviItem[0].item_code = DVI$_DEVNAM; #     DviItem[0].buf_addr = &PtdName; "     DviItem[0].buf_len = &NameLen;     DviItem[1].buf_size = 0;     DviItem[1].item_code = 0;   E     status = sys$getdviw(0, 0, &DscPtd, &DviItem, &DviIosb, 0, 0, 0);      if(!(status & 1)) { J         printf("\n%%%s-E-NOSUCHDEV, device FTA0: not found\n\n", CmdVerb);         exit(1);     } @         /* check if the username really exists on this system */  +     UaiItem[0].buf_size = sizeof(UaiFlags); &     UaiItem[0].item_code = UAI$_FLAGS;$     UaiItem[0].buf_addr = &UaiFlags;     UaiItem[0].buf_len  = 0;*     UaiItem[1].buf_size = sizeof(UicBufN);$     UaiItem[1].item_code = UAI$_UIC;#     UaiItem[1].buf_addr = &UicBufN; "     UaiItem[1].buf_len  = &UicLen;     UaiItem[2].buf_size = 0;     UaiItem[2].item_code = 0;   /     DscUserT.dsc$w_length = strlen(NewUserTmp); <     status = sys$getuai(0, 0, &DscUserT, &UaiItem, 0, 0, 0);9     if (status == RMS$_RNF || status == SS$_NOSUCHUSER) { <         printf("\n%%%s-E-NOSUCHUSER, User %s not found\n\n",%                 CmdVerb, NewUserTmp);          exit(1);     }      if (status == SS$_NORMAL) { '         if (UaiFlags & UAI$M_DISACNT) { J             printf("\n%%%s-E-DISUSER, The account for %s is disabled\n\n",)                     CmdVerb, NewUserTmp);              exit(1);	         }      }      else lib$stop(status);  /         /* get some info about invoking user */   *     JpiUser[0].buf_size = sizeof(UicBufO);$     JpiUser[0].item_code = JPI$_UIC;#     JpiUser[0].buf_addr = &UicBufO;      JpiUser[0].buf_len  = 0;*     JpiUser[1].buf_size = sizeof(OldUser);)     JpiUser[1].item_code = JPI$_USERNAME; #     JpiUser[1].buf_addr = &OldUser;      JpiUser[1].buf_len  = 0;)     JpiUser[2].buf_size = sizeof(PrvBuf); (     JpiUser[2].item_code = JPI$_CURPRIV;"     JpiUser[2].buf_addr = &PrvBuf;     JpiUser[2].buf_len  = 0;)     JpiUser[3].buf_size = sizeof(OldPid); $     JpiUser[3].item_code = JPI$_PID;"     JpiUser[3].buf_addr = &OldPid;     JpiUser[3].buf_len  = 0;+     JpiUser[4].buf_size = sizeof(OldProcN); '     JpiUser[4].item_code = JPI$_PRCNAM; $     JpiUser[4].buf_addr = &OldProcN;#     JpiUser[4].buf_len  = &NameLen;      JpiUser[5].buf_size = 0;     JpiUser[5].item_code = 0;   <     status = sys$getjpiw(0, 0, 0, &JpiUser, &JpiIosb, 0, 0);'     if(!(status & 1)) lib$stop(status);     D         /* Verify invoking user is authorized to become target user.C            If not, display error message and exit Should the IGNORE C            flage be set, have user enter system manager password */        if(Ignore) {         status = PwdChk();         if(!(status & 1)) { R             printf("%%%s-E-INVPWD, Invalid password entered for SYSTEM account\n",                     CmdVerb);              exit(1);	         }      } 
     else {         status = CheckIdent();$         if(status == SS$_NOSUCHID) {(             ptr1 = strchr(OldUser, ' ');             *ptr1 = '\0'; M             sprintf(MsgBuff, "\n\n%%%s-E-NOAUTH, User %s not authorized to ", &                     CmdVerb, OldUser);H             sprintf(MsgBuff+strlen(MsgBuff), "assume persona of %s\n\n",                      NewUserTmp);"             printf("%s", MsgBuff);             exit(1);	         }      }   >         /* Assign a channel to the original terminal device */  0     status = sys$assign(&DscTt, &TtdChan, 0, 0);'     if(!(status & 1)) lib$stop(status);   9         /* Get device name of original terminal device */    *     DviItem[0].buf_size = sizeof(TtdName);'     DviItem[0].item_code = DVI$_DEVNAM; #     DviItem[0].buf_addr = &TtdName; "     DviItem[0].buf_len = &NameLen;     DviItem[1].buf_size = 0;     DviItem[1].item_code = 0;   E     status = sys$getdviw(0, TtdChan, 0, &DviItem, &DviIosb, 0, 0, 0); '     if(!(status & 1)) lib$stop(status);   C         /* get the device protections of original terminal and save D            for restore on exit. Then set orig term to full access */  *     status = GetDevProt(&TtdName, OLDDEV);'     if(!(status & 1)) lib$stop(status); *     status = SetDevProt(&TtdName, NEWDEV);'     if(!(status & 1)) lib$stop(status);   3         /* get original terminal characteristics */   L     status = sys$qiow(0, TtdChan, IO$_SENSEMODE, &TtdIosb, 0, 0, &OldTTChar,5                       sizeof(OldTTChar), 0, 0, 0, 0); '     if(!(status & 1)) lib$stop(status);   E         /* copy old term characteristics to new term characteristics, E            then make changes to new characteristics buffer (there are >            prettier ways to do this, but this method works! */        NewTTChar[0] = OldTTChar[0];      NewTTChar[1] = OldTTChar[1];      NewTTChar[2] = OldTTChar[2];        NewTTChar[1] |= TT$M_NOECHO;     NewTTChar[1] &= ~TT$M_WRAP; "     NewTTChar[2] |= TT2$M_PASTHRU;  C         /* save new characteristics back to originating terminal */   I     status = sys$qio(0, TtdChan, IO$_SETMODE, &TtdIosb, 0, 0, &NewTTChar, 5                       sizeof(NewTTChar), 0, 0, 0, 0); '     if(!(status & 1)) lib$stop(status);   D         /* Define an exit handler to restore callers original env */  $     status = sys$dclexh(&ExitBlock);'     if(!(status & 1)) lib$stop(status);   @         /* Perform persona create and assume for new username */  <     ImpFlags = IMP$M_ASSUME_DEFPRIV | IMP$M_ASSUME_DEFCLASS;A     status = sys$persona_create(&ImpHandle, &DscUserN, ImpFlags); '     if(!(status & 1)) lib$stop(status);   =     ImpFlags = IMP$M_ASSUME_ACCOUNT | IMP$M_ASSUME_JOB_WIDE | %                IMP$M_ASSUME_SECURITY; 6     status = sys$persona_assume(&ImpHandle, ImpFlags);'     if(!(status & 1)) lib$stop(status);   B         /* Create FTA device, using the default characteristics */       inAdr[0] = &IoBuff; )     inAdr[1] = inAdr[0] + sizeof(IoBuff);  #ifdef MYPTDC     status = ptd$create(&PtdChan, 0, &OldTTChar, sizeof(OldTTChar), )                         0, 0, 0, &inAdr);  #else <     status = ptd$create(&PtdChan, 0, 0, 0, 0, 0, 0, &inAdr); #endif'     if(!(status & 1)) lib$stop(status);   =         /* Initialize itemlist to get the device name of the  9            pseudoterminal. Save this string in PtdName */   *     DviItem[0].buf_size = sizeof(PtdName);'     DviItem[0].item_code = DVI$_DEVNAM;*#     DviItem[0].buf_addr = &PtdName; "     DviItem[0].buf_len = &NameLen;     DviItem[1].buf_size = 0;     DviItem[1].item_code = 0;_  E     status = sys$getdviw(0, PtdChan, 0, &DviItem, &DviIosb, 0, 0, 0); '     if(!(status & 1)) lib$stop(status);R     PtdName[NameLen] = 0;   7         /* set pseudoterm protections to full access */   *     status = SetDevProt(&PtdName, NEWDEV);'     if(!(status & 1)) lib$stop(status);   9         /* Write the terminal name and new user to TT: */   C     sprintf(EscStr, "\033[2J\033[H"); /* clr screen, home cursor */ @     sprintf(MsgBuff, "%s\n\n%%%s-I-SESINIT, session initiated.",             EscStr, CmdVerb); G     sprintf(MsgBuff+strlen(MsgBuff), " PsuedoTerm: %s, Userid: %s\n\n",              PtdName, NewUser);@     status = sys$qiow(0, TtdChan, IO$_WRITEVBLK, &TtdIosb, 0, 0,<                       MsgBuff, strlen(MsgBuff), 0, 0, 0, 0);'     if(!(status & 1)) lib$stop(status);s  ?         /* create a termination mailbox, get mbx unit value andi=            set up an ast routine to be called when the mbx isg5            written to (at detached process logout) */i  F     status = sys$crembx(0, &MbxChan, ACC$K_TERMLEN, 0, 0, 0, 0, 0, 0);'     if(!(status & 1)) lib$stop(status);R  *     MbxItem[0].buf_size = sizeof(MbxUnit);%     MbxItem[0].item_code = DVI$_UNIT;e#     MbxItem[0].buf_addr = &MbxUnit; "     MbxItem[0].buf_len = &NameLen;     MbxItem[1].buf_size = 0;     MbxItem[1].item_code = 0;   E     status = sys$getdviw(0, MbxChan, 0, &MbxItem, &DviIosb, 0, 0, 0);p'     if(!(status & 1)) lib$stop(status);t  <         /* Don't use $QIOW here, we will block forever... */   D     status = sys$qio(0, MbxChan, IO$_READVBLK, &MbxIosb, &MbxAst, 0,:                       MbxBuff, ACC$K_TERMLEN, 0, 0, 0, 0);'     if(!(status & 1)) lib$stop(status);n  
 #ifdef ARF=         /* Set event notification when the FTA device changede?            characteristics. e.g when doing SET TERM/PERM/... */   @     status = ptd$set_event_notification(PtdChan, CharChangedAst,*                 0, 0, PTD$C_CHAR_CHANGED);'     if(!(status & 1)) lib$stop(status);, #endif  D         /* Create the interactive process using the psuedo terminal.@            The created process will be INTERactive and DETACHed.>            The NOPASSWORD flag will cause the process to login7            without the Userid: and Password: prompts */   ;     StsFlg = PRC$M_DETACH | PRC$M_INTER | PRC$M_NOPASSWORD; <     status = sys$creprc(&NewPid,        /* new process id */E                         &DscImg,        /* descriptor for loginout */eD                         &DscPtd,        /* input - pseudoterminal */E                         &DscPtd,        /* output - pseudoterminal */ D                         0,              /* error (same as output) */=                         0,              /* mask_privileges */s=                         0,              /* new proc quotas */tD                         0,              /* proc name is orig user */;                         0,              /* base priority */ =                         UicBufN,        /* uic of new user */ I                         MbxUnit,        /* termination mbx unit number */fF                         StsFlg,         /* process creation options */J                         0);             /* itmlst - reserved by Digital */'     if(!(status & 1)) lib$stop(status);   C         /* set our detached process name to be PERS_xxxxxxxxx where A            xxxxxxxxx is the process id of the detached process */   *     sprintf(PrcName, "PERS_%08X", NewPid);*     DscPrn.dsc$w_length = strlen(PrcName);!     status = sys$setprn(&DscPrn);e'     if(!(status & 1)) lib$stop(status);J    @         /* Delete assumed persona, return to orig environment */       ImpFlags = 1; 1     status = sys$persona_assume(&ImpFlags, 0, 0);i'     if(!(status & 1)) lib$stop(status);a,     status = sys$persona_delete(&ImpHandle);'     if(!(status & 1)) lib$stop(status);   >         /* Post a read to the local terminal -- with an AST */  G     status = sys$qio(0, TtdChan, IO$_READVBLK, &TtdIosb, TtdReadAst, 0,u;                      &IoBuff.PtdWrtBuf.dat, 1, 0, 0, 0, 0);T'     if(!(status & 1)) lib$stop(status);   n>         /* Post PTD read with an AST. Any consecutive PTD read:            will be accomplished within the AST routine. */  J     status = ptd$read(0, PtdChan, PtdReadAst, 0, &IoBuff.PtdReadBuf, 508);'     if(!(status & 1)) lib$stop(status);r  E         /* HIBERnate here forever -- all the rest is done by ASTs. */        status = sys$hiber(); '     if(!(status & 1)) lib$stop(status);      exit(1); }n  