   N (* Definitions for RTL Screen Management Facility                           *)N (*                                                                          *)   N (*                                                                          *)N (* Define the out-of-band information table used when an out-of-band        *)N (* AST routine is called as it's own record.                                *)N (*                                                                          *)   / TYPE	OUT_OF_BAND_TABLE = RECORD CASE INTEGER OF G 	1: (SMG$L_PBD_ID : UNSIGNED;    (* Pasteboard ID                    *) G 	    SMG$L_USER_ARG : UNSIGNED;  (* User's AST argument              *) / 	    SMG$R_CHAR_OVERLAY : [BYTE(4)] RECORD END;  	    ); G 	2: (SMG$B_CHAR : [POS(64)] $UBYTE; (* The character typed           *)  	    ); G 	3: (SMG$L_CHAR : [POS(64)] UNSIGNED; (* The character and 3 spaces  *)  	    ) 	END;    N (*                                                                          *)N (* Define the subprocess information table used when a subprocess           *)N (* AST routine is called as it's own record.                                *)N (*                                                                          *)   # TYPE	SUBPROCESS_INFO_TABLE = RECORD G 	    SMG$L_DISP_ID : UNSIGNED;   (* Display ID                       *) G 	    SMG$L_USR_ARG : UNSIGNED;   (* User's AST argument              *) G 	    SMG$L_STATUS : UNSIGNED;    (* Status of executed command       *)  	END;    N (*                                                                          *)N (* Define an information table that can be used by both                     *)N (* SMG$GET_PASTEBOARD_ATTRIBUTES and SMG$GET_KEYBOARD_ATTRIBUTES            *)N (* as it's own record.                                                      *)N (*                                                                          *)   2 TYPE	ATTRIBUTE_INFO_BLOCK = RECORD CASE INTEGER OFG 	1: (SMG$L_DEV_CHAR : UNSIGNED;  (* Device characteristics           *) G 	    SMG$L_DEV_DEPEND : UNSIGNED; (* Specific characteristics (1)    *) G 	    SMG$L_DEV_DEPEND2 : UNSIGNED; (* Specific characteristics (2)   *) G 	    SMG$B_DEV_CLASS : $UBYTE;   (* Device class (e.g. DC$_TERM)     *) . 	    SMG$R_DEV_OVERLAY : [BYTE(1)] RECORD END;L 	    SMG$B_DEV_TYPE : $UBYTE;    (* Physical device type (e.g. DT$_VT100) *). 	    SMG$R_ROW_OVERLAY : [BYTE(1)] RECORD END;G 	    SMG$W_NUM_COLUMNS : $UWORD; (* Terminal width                   *) 0 	    SMG$R_COUNT_OVERLAY : [BYTE(2)] RECORD END;G 	    SMG$W_DEV_SPEED : $UWORD;   (* Terminal Speed (+)               *) G 	    SMG$W_DEV_FILL : $UWORD;    (* Fill characteristics (+)         *) G 	    SMG$W_PHYS_CURSOR_ROW : $UWORD; (* Row where physical cursor is *) G 	    SMG$W_PHYS_CURSOR_COL : $UWORD; (* Col where physical cursor is *) G 	    SMG$L_DISPLAY_ID : UNSIGNED; (* Display containing phy cursor   *)  	    ); G 	2: (SMG$B_PBD_TYPE : [POS(104)] $UBYTE; (* Internal SMG device type *) G 	    SMG$B_NUM_ROWS : [POS(120)] $UBYTE; (* Number of rows on device *) Y 	    SMG$W_TYPEAHD_CNT : [POS(144)] $UWORD; (* Number of chars in typeahead buffer (+) *)  	    ); J 	3: (SMG$B_RECALL_NUM : [POS(104)] $UBYTE; (* Size of recall buffer (+) *)U 	    SMG$B_TYPEAHD_CHAR : [POS(120)] $UBYTE; (* First char in typeahead buffer (+) *) 9 	    SMG$R_COUNT_STRUCT : [POS(144), BYTE(2)] RECORD END;  	    ); G 	4: (SMG$B_PBD_COLOR : [POS(144)] $UBYTE; (* PBD background color    *) G 	    SMG$B_DEV_PARITY : [POS(152)] $UBYTE; (* Parity attributes (+)  *)  	    ) 	END;    