 #ifndef PACKASM_VMSDEF #define PACKASM_VMSDEF 1 /*E ** Copyright  1993, 1994 by Eric M. LaFranchi.  All Rights Reserved.  **J ** This software is Copyright 1993, 1994 by Eric M. LaFranchi.  PermissionJ ** to use, copy, and freely redistributed this software in its entirety isC ** hereby granted provided that the above copyright notice and this L ** permission notice are retained.  This software may not be sold for profitF ** or incorporated in commercial software products without the writtenK ** permission of the author.  This software is provided "as is", the author L ** nor his employer make any representation of warranty, express or implied,J ** with respect to any code or other information herein.  In addition, theI ** author disclaim's any liability whatsoever for any use of such code or  ** other information.  **   **+-+  **
 ** Module: **	vmsdef.h  ** ** Abstract:< **	This module contains all the VMS specific definitions andE **	is only included in the VMS specific files of the PACKASM utility.  **
 ** Author:( **	EML000		Eric M. LaFranchi	01-MAY-1993 ** **-- */     /*=     ** include files to avoid compiler informational messages B     ** Note that msg.h is included here, so the defines for GLOBAL@     ** and extern don't conflict with file work with the message     ** definitions     */> #include <descrip.h>			/* VMS string descriptor definitions */< #include <chfdef.h>			/* VMS condition handling code	     */. #include <rms.h>			/* RMS definitions		     */: #include "msgdef.h"			/* Local message definitions	     */  8     /* macros to allocate and initialize VMS descriptors      */ 4 #define $DESCALLOC( name ) struct dsc$descriptor_s \1 	(name) = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, NULL}   7 #define $DESCALLOC_DD( name ) struct dsc$descriptor_s \ 1 	(name) = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, NULL}   # #define $DESCINIT( name, string ) \ 2 	((void)((name).dsc$a_pointer = (char *)(string),\' 	(name).dsc$w_length = strlen(string)))   ' #define $DESCFILL(name, size, string) \ + 	((void)((name).dsc$a_pointer = (string), \ ' 	        (name).dsc$w_length = (size)))    #ifdef __ALPHA #pragma member_alignment __save  #pragma nomember_alignment #endif  /* __ALPHA */   5     /* Item list structure and macro to initialize it       */  typedef struct item_descriptor {      unsigned short int	buflen;     unsigned short int	item;     void 		*bufadr;      size_t		*retlen;	 } ITMLST;   "     /* I/O status block definition      */  typedef struct io_status_block {      unsigned short	status;     unsigned short	bytcnt;     unsigned int	devspec;  } IOSB;    #ifdef __ALPHA" #pragma member_alignment __restore #endif  ( #if defined(__DECC) || defined(__DECCXX) #define GLOBAL #else /* VAXC */ #define GLOBAL globaldef #define extern globalref #endif /* __DECC || __DECCXX */   K     /* Macros that generate in line VAX instructions for string operations.       */  #ifdef VAXC  #pragma builtins6 #define strlen(cs)		(0xFFFF - _LOCC('\0', 0xFFFF, cs))9 #define strcpy(s, ct)		(_MOVC3(strlen(ct) + 1, ct, s), s) [ #define strncpy(s, ct, n)	(_MOVC5(MIN(n, (n - _LOCC('\0', n, ct)) + 1), ct, '\0', n, s), s) _ #define strchr(cs, c)		(_LOCC(c, strlen(cs), (char *)cs) ? (char *)_READ_GPR(1) : (char *)NULL)   E #define strcat(s, ct)		(_MOVC3(strlen(ct) + 1, ct, s + strlen(s)), s) O #define strncat(s, ct, n)	(_MOVC5(MIN(n, (n - _LOCC('\0', n, ct))), ct, '\0', \ > 				(MIN(n, (n - _LOCC('\0', n, ct))) + 1), s + strlen(s)), s)  > #define memcpy(s, ct, n)	(_MOVC3(n, (char *)ct, (char *)s), s)? #define memmove(s, ct, n)	(_MOVC3(n, (char *)ct, (char *)s), s) N #define memset(s, c, n)		(_MOVC5(0, (char *)_READ_GPR(14), c, n,(char *)s), s)P #define memchr(cs, c, n)	(_LOCC(c, n, (char *)cs) ? (void *)_READ_GPR(1) : NULL) #endif /* VAXC */   7     /* External function definitions for local services       */ 6 size_t	handler( struct chf$signal_array *signal_array,' 		 struct chf$mech_array *mech_array );   7 size_t	get_input( struct dsc$descriptor_s *const input, 1 		   const struct dsc$descriptor_s *const prompt, $ 		   unsigned short *const retlen );  + size_t	present( const char *const entity );   + size_t	get_value( const char *const entity,  		   char *const retbuf, 		   const size_t buflen );   5     /* External function definitions for VMS services       */  size_t	CLI$DISPATCH( void );< size_t	CLI$DCL_PARSE( const struct dsc$descriptor_s * const,- 		       void *, size_t (*)(), size_t (*)(),  1 		       const struct dsc$descriptor_s * const ); < size_t	CLI$PRESENT( const struct dsc$descriptor_s * const );< size_t	CLI$GET_VALUE( const struct dsc$descriptor_s * const,) 		       struct dsc$descriptor_s * const, " 		       unsigned short * const );                                 , size_t	LIB$ADDX( const unsigned int * const, 		  const unsigned int * const,   		  unsigned int * const, ... );  , size_t	LIB$EMUL( const unsigned int * const, 		  const int * const, 		  const unsigned int * const,  		  unsigned int * const );   L void	LIB$ESTABLISH( const size_t (*)( struct chf$signal_array *signal_array,, 					 struct chf$mech_array *mech_array ) );  6 size_t	LIB$GET_INPUT( struct dsc$descriptor_s * const,/ 		       const struct dsc$descriptor_s * const, " 		       unsigned short * const );  8 size_t	LIB$GET_FOREIGN( struct dsc$descriptor_s * const,* 			 const struct dsc$descriptor_s * const, 			 unsigned short * const,  			 unsigned long * const );  = size_t	LIB$SIG_TO_RET( struct chf$signal_array *signal_array, ' 			struct chf$mech_array *mech_array );   ? size_t	LIB$PUT_OUTPUT( const struct dsc$descriptor_s * const );   = size_t	SMG$CREATE_KEY_TABLE( void *const key_table_id, ... );   C size_t	SMG$CREATE_VIRTUAL_KEYBOARD( void *const keyboard_id, ... );   7 size_t	SMG$READ_COMPOSED_LINE( void *const keyboard_id,  				void *const key_table_id, $ 				struct dsc$descriptor_s * const,* 				const struct dsc$descriptor_s * const,! 				unsigned short *const, ... );   3 size_t	STR$CONCAT( struct dsc$descriptor_s * const, , 		    const struct dsc$descriptor_s * const,3 		    const struct dsc$descriptor_s * const, ... );   7 size_t	STR$FREE1_DX( struct dsc$descriptor_s * const );   = size_t	STR$MATCH_WILD( const struct dsc$descriptor_s * const, + 			const struct dsc$descriptor_s * const );   - size_t	SYS$ASCTIM( unsigned short int *const, & 		    struct dsc$descriptor_s * const,! 		    const unsigned int * const,  		    const unsigned int );   9 size_t	SYS$ASSIGN( const struct dsc$descriptor_s * const,  		    unsigned short * const, , 		    const struct dsc$descriptor_s * const,. 		    const struct dsc$descriptor_s * const );  9 size_t	SYS$BINTIM( const struct dsc$descriptor_s * const,  		    unsigned int * const );   & size_t	SYS$CLOSE( struct FAB *, ... );  ( size_t	SYS$CONNECT( struct RAB *, ... );  $ size_t	SYS$DASSGN( unsigned short );   void	SYS$EXIT( const size_t );  & size_t	SYS$FLUSH( struct RAB *, ... );  $ size_t	SYS$GET( struct RAB *, ... );  D size_t	SYS$GETJPIW( const unsigned int, unsigned int * const, ... );  0 size_t	SYS$GETTIM( const unsigned int * const );  % size_t	SYS$OPEN( struct FAB *, ... );   & size_t	SYS$PARSE( struct FAB *, ... );  $ size_t	SYS$PUT( struct RAB *, ... );   size_t	SYS$QIOW( unsigned int, 		  unsigned short,  		  unsigned int,  		  IOSB *,  		  void (*)(),  		  void *, 
 		  ... );  " size_t	SYS$SEARCH( struct FAB * ); #endif