$	sql$output_file = "sys$scratch:omisql$_output._tmp$"
$	gosub 'p1'$
$	exit $status
$!
$!******************************************************************************
$!*                                                                            *
$!*  FILENAME:                                                                 *
$!*  =========                                                                 *
$!*     Omi$SqlTools.Com                                                       *
$!*                                                                            *
$!*  DESCRIPTION:                                                              *
$!*  ============                                                              *
$!*      This is an additional toolbox for OMI, which defines several OMI      *
$!*      commands that can be used with SQL.                                   *
$!*                                                                            *
$!*      Before any of these action will work, the command OMI$SQL_INIT        *
$!*      has to be called (e.g. from an ON_INIT OMI-module) with the para-     *
$!*      meters ENVIRONMENT and DATABASE, where ENVIRONMENT is the database    *
$!*      type (version 1.0 only supports RdB), and DATABASE is the name of     *
$!*      the database to work with.                                            *
$!*                                                                            *
$!*      These settings should be removed by calling the command               *
$!*      OMI$SQL_CLEANUP (e.g. using an ON_EXIT OMI module).                   *
$!*      * NOTE: OMI$SQL_CLEANUP also restores a previous environment that     *
$!*              is removed by OMI$SQL_INIT!!                                  *
$!*                                                                            *
$!*  HISTORY:                                                                  *
$!*  ========                                                                  *
$!*     Version:  Date:       Author:                                          *
$!*     --------  -----       -------                                          *
$!*     1.0       11-09-1997  Oscar van Eijk, OVEAS                            *
$!*         Initial version with the commands OMI$SQL_INIT,                    *
$!*                                           OMI$SQL_CLEANUP,                 *
$!*                                           OMI$SQL_SSELECT,                 *
$!*                                           OMI$SQL_SUPDATE                  *
$!*                                                                            *
$!******************************************************************************

$!******************************************************************************
$!
$!==>	This command initializes the environment for using the OMISQL tools.
$!	It overwrites logicals that might have been set by the user, like
$!	SQLINI and SQL$DATABASE. Those will be restored by OMI$SQL_CLEANUP.
$!	This command has to be called as the first OMISQL command during an
$!	OMI session. It can be called as many times as required to overwrite
$!	the current environment.
$!	The following parameters are required:
$!	   P1  Name of the database to use.
$!	   P2  Database product (currently only RdB is supported)
$!	       This parameter is not required if OMI$SQL_INIT has already
$!             been called during the current OMI session.
$!	   
$!	The logicals that are defined will be used by all OMISQL commands.
$!	They can be deassigned at the end of the OMI session by calling
$!	OMI$SQL_CLEANUP
$!
$ sql_init$:
$!
$	supported_products = ",RDB,"
$	if p2 .eqs. ""
$	   then
$		omi$signal omisql nodb
$		return omi$_error
$	endif
$!
$	if p3 .eqs. "" .and. f$trnlnm("omisql$product") .eqs. ""
$	   then
$		omi$signal omisql noprod
$		p3 = "RDB"   ! Use this as the default since no other
$!                             product is currently supported anyway.
$	endif
$!
$	p3 = f$edit(p3,"upcase")
$	if f$locate(",''p3',",supported_products) .eq. f$length(supported_products)
$	   then
$		omi$signal omisql unsup,p3
$		return omi$_error
$	endif
$!
$	gosub init$'p3'_specific
$	if $status .ge. omi$_warning then $ return $status
$!
$	define /nolog omisql$product  p3
$	define /nolog omisql$database p2
$!
$	_logical = "sqlini"
$	gosub init$remove_logical
$	_logical = "sql$database"
$	gosub init$remove_logical
$!
$	return omi$_ok
$!
$ init$remove_logical:
$!
$	if f$trnlnm(_logical) .eqs. "" then $ return omi$_ok
$!
$! Save the old logical...
$!
$	define /nolog omisql$restore_'_logical' -
	   "Define/table=''f$trnlnm(_logical,,,,,"table_name")'/''f$trnlnm(_logical,,,,,"access_mode")' ''_logical' ''f$trnlnm(_logical)'"
$!
$! ... and remove it.
$!
$	deassign /table='f$trnlnm(_logical,,,,,"table_name")' -
	   /'f$trnlnm(_logical,,,,,"access_mode")' '_logical'
$!
$	return omi$_ok
$!
$ init$rdb_specific:
$!
$! Some RDB specific checks and settings.
$!
$	if f$trnlnm(p2) .eqs. ""
$	   then
$		omi$signal omisql dbnf,p2
$		return omi$_error
$	endif
$!
$	if f$type(sql) .eqs. "" then $ sql :== "$sql$"
$	omisql$_attach         :== "attach 'filename ''P2'';"
$	omisql$_reroute_output :== "set output ''sql$output_file';"
$	omisql$_read_only      :== "declare transaction read only nowait;"
$	omisql$_shared_write   :== "set transaction read write reserving -tables- for shared write;"
$	omisql$_long_lines     :== "set line length 32767;"
$	return omi$_ok
$!
$!******************************************************************************

$!******************************************************************************
$!
$!==>	This command cleanups up the OMISQL symbols and logicals, and
$!	restores the user environment.
$!
$ sql_cleanup$:
$!
$	if f$trnlnm("omisql$produc"t)  .nes. "" then $ deassign omisql$product
$	if f$trnlnm("omisql$database") .nes. "" then $ deassign omisql$database
$!
$	_logical = "sqlini"
$	gosub cleanup$restore_logical
$	_logical = "sql$database"
$	gosub cleanup$restore_logical
$!
$	assign sys$scratch:omisql$cleanup._tmp$ sys$error
$	assign sys$scratch:omisql$cleanup._tmp$ sys$output
$	show symbol /global omisql$*
$	deassign sys$error
$	deassign sys$output
$	open /read glsymbols sys$scratch:omisql$cleanup._tmp$
$!
$ cleanup$_gl_symbols:
$!
$	read /end_of_file=cleanup$end_gl_symbols glsymbols _symbol
$	if f$extract(0,13,_symbol) .eqs. "%DCL-W-UNDSYM" then - 
	   $ goto cleanup$end_gl_symbols ! $severity is still 1 after this warning
$	_symbol = f$edit(f$element(0,"=",_symbol),"collapse")
$	deletee /symbol /global '_symbol'
$	goto cleanup$_gl_symbols
$!
$ cleanup$end_gl_symbols:
$!
$	close glsymbols
$	delete /nolog /noconfirm sys$scratch:omisql$cleanup._tmp$;
$!
$ cleanup$restore_logical:
$!
$	if f$trnlnm("omisql$restore_''_logical'") .nes. ""
$	   then
$		r_cmd = f$trnlnm("omisql$restore_''_logical'")
$		'r_cmd
$		deassign omisql$restore_'_logical'
$	endif
$!
$	return omi$_ok
$!
$!******************************************************************************

$!******************************************************************************
$!
$!==>	Select one or more values from a single table in the database.
$!	Parameters:
$!	   P1             Fields to select.
$!	   P2             Table from which to select
$!	   P3             List of select statements
$!	   P4 (optional)  Name of a file to write the values to
$!
$!	If P4 is omitted, the values will be returned in the global symbols
$!	OMISQL$<field-name>, where <field-name> is the name of the selected
$!	field.
$!	This command returns OMI$_ERROR on all errors and warnings, and
$!	OMI$_WARNING when no rows were selected.
$!
$ sql_sselect$:
$!
$	if f$trnlnm("omisql$database") .eqs. ""
$	   then
$		omi$signal omisql noenv
$		return omi$_error
$	endif
$!
$	if p2 .eqs. "" then $ p2 = "*"
$	if p3 .eqs. "" .or. p4 .eqs. ""
$	   then
$		omi$signal omi insarg,omi$sql_sselect
$		return omi$_error
$	endif
$!
$	if p5 .nes. ""
$	   then
$		open /write /error=sselect$output_file_err dumpfile 'p5
$		_dump_to_file = 1
$	   else $ _dump_to_file = 0
$	endif
$!
$	open /write sqlscript sys$scratch:omisql$commands._sql$
$	write sqlscript "$ sql"
$	write sqlscript "''omisql$_attach'"
$	write sqlscript "''omisql$_read_only'"
$	write sqlscript "''omisql$_long_lines'"
$	write sqlscript "''omisql$_reroute_output'"
$	write sqlscript "select ''p2' from ''p3' where ''p4';"
$	write sqlscript "$ exit $status"
$	close sqlscript
$!
$	on error then $ goto omisql$error
$	on severe_error then $ goto omisql$error
$  	assign sys$scratch:omisql$output_msg._tmp$ sys$error
$	set message 'omi$_message
$  	assign sys$scratch:omisql$output_msg._tmp$ sys$output
$	@sys$scratch:omisql$commands._sql$
$  	deassign sys$error
$  	deassign sys$output
$	set message /nofacility /noseverity /noidentification /notext
$	deletee /nolog /noconfirm sys$scratch:omisql$commands._sql$;
$  	search /output=nla0: sys$scratch:omisql$output_msg._tmp$ "-F-","-E-","-W-"
$	if $status .ne. omi$_nomatch
$	   then
$		omi$signal omisql sqlerr,unknown
$		omi$call type_file sys$scratch:omisql$output_msg._tmp$
$		delete /nolog /noconfirm  sys$scratch:omisql$output_msg._tmp$;
$		return omi$_error
$	endif
$!
$	open /read sqlout 'sql$output_file
$	read sqlout _dummy	! Select statement
$	read sqlout _fields	! Field names
$	read sqlout _values	! Field values
$	close sqlout
$	delete /nolog /noconfirm 'sql$output_file';
$!
$	if _fields .eqs. "0 rows selected"
$	   then
$		if _dump_to_file
$		   then
$			close dumpfile
$			delete /nolog /noconfirm 'f$search("''p5'")'
$		endif
$		return omi$_warning
$	endif
$!
$	_field_list = f$edit(_fields,"trim,compress")
$	_field_counter = 0
$!
$ sselect$_get_fields:
$!
$	_field = f$element(_field_counter, " ", _field_list)
$	if _field .eqs. " "
$	   then
$		if _dump_to_file then $ close dumpfile
$		return omi$_ok
$	endif
$!
$	_next  = f$element(_field_counter + 1, " ", _field_list)
$	_start = f$locate(_field,_fields)
$	if _next .eqs. " "
$	   then $ _end = f$length(_values)
$	   else $ _end = f$locate(_next, _fields)
$	endif
$!
$	_end = _end - _start
$!
$	_field = f$edit(f$extract(_start, _end, _fields),"collapse")
$	_value = f$edit(f$extract(_start, _end, _values),"trim")
$!
$	if _dump_to_file
$	   then $ write dumpfile "''_field' = ''_value'"
$	   else $ omisql$'_field' == "''_value'"
$	endif
$	_field_counter = _field_counter + 1
$!
$	goto sselect$_get_fields
$!
$ sselect$output_file_err:
$!
$	omi$signal omisql fopenerr,p5
$	return omi$_error
$!
$!******************************************************************************

$!******************************************************************************
$!
$!==>	Update one or more values from a single table in the database.
$!	Parameters:
$!	   P1             Fields to update
$!	   P2             Table in which to update
$!	   P3             List of select statements
$!
$!	This command returns OMI$_ERROR on all errors and warnings, and
$!	OMI$_WARNING when no rows were selected.
$!
$ sql_supdate$:
$!
$	if f$trnlnm("omisql$database") .eqs. ""
$	   then
$		omi$signal omisql noenv
$		return omi$_error
$	endif
$!
$	if p2 .eqs. "" .or. p3 .eqs. "" .or. p4 .eqs. ""
$	   then
$		omi$signal omi insarg,omi$sql_sselect
$		return omi$_error
$	endif
$!
$	omi$substitute "-tables-" 'p3 "''omisql$_shared_write'"
$	_shared_write = omi$substituted
$	deletee /symbol /global omi$substituted
$!
$	open /write sqlscript sys$scratch:omisql$commands._sql$
$	write sqlscript "$ on warning then $ exit $status"
$	write sqlscript "$ sql"
$	write sqlscript "''omisql$_attach'"
$	write sqlscript "''_shared_write'"
$	write sqlscript "update ''p3' set ''p2' where ''p4';"
$	write sqlscript "commit;"
$	write sqlscript "$ exit $status"
$	close sqlscript
$!
$	on error then $ goto omisql$error
$	on severe_error then $ goto omisql$error
$	set message /facility /severity /identification /text
$  	assign sys$scratch:omisql$output_msg._tmp$ sys$error
$	set message 'omi$_message
$  	assign sys$scratch:omisql$output_msg._tmp$ sys$output
$	@sys$scratch:omisql$commands._sql$
$  	deassign sys$error
$  	deassign sys$output
$	set message /nofacility /noseverity /noidentification /notext
$	deletee /nolog /noconfirm sys$scratch:omisql$commands._sql$;
$  	search /output=nla0: sys$scratch:omisql$output_msg._tmp$ "-F-","-E-","-W-"
$	if $status .ne. omi$_nomatch
$	   then
$		omi$signal omisql sqlerr,unknown
$		omi$call type_file sys$scratch:omisql$output_msg._tmp$
$		delete /nolog /noconfirm  sys$scratch:omisql$output_msg._tmp$;
$		return omi$_error
$	endif
$!
$	omi$msgline_clear
$	omi$signal omisql updated
$	return omi$_ok
$!
$!******************************************************************************

$!******************************************************************************
$!
$!==>	Signal a SQL error
$!
$ omisql$error:
$!
$	omi$signal omisql sqlerr,'$status
$  	deassign sys$error
$	deassign sys$output
$	set message /nofacility /noseverity /noidentification /notext
$	deletee /nolog /noconfirm sys$scratch:omisql$commands._sql$;
$	delete /nolog /noconfirm  sys$scratch:omisql$output_msg._tmp$;
$	return omi$_error
$!
$!******************************************************************************
