 #define MODULE_NAME     NBS  #define MODULE_IDENT    "V3.2" /*K  *  NBS - Set system time to National Bureau of Standards Clock - Version 3   *  *  September 26, 1995  *    *  Author: Marc L. Kozam !  *          MLK Software Services   *          13245 Glenhill Road )  *          Silver Spring, MD  20904-3260   *          201-567-9204%  *          UUCP: mimsy!mlksoft!kozam A  *          Internet: kozam@mlksoft.com OR kozam@eisner.decus.org   *    *  Modified by:  *&  *	V3.2		Hunter Goatley		March 6, 20149  *		About time. (Ha!) Modified to allow a comma-separated 7  *		list of time servers to be specified by the logical 5  *		NBS_TIME_SERVER. Also, "-n" (network mode) is the :  *		default, as I don't know anyone who still uses modems.,  *		"-m" can be specified for modem support.  *#  *	February 27, 2002	Hunter Goatley :  *		Don't use a hardcoded IP address.  Use a name instead.  *"  *	January 8, 1999		Hunter Goatley=  *		Apply Y2K fixes by Tim Shoppa <SHOPPA@trailing-edge.com>.   *  */ ' #pragma module MODULE_NAME MODULE_IDENT    #include <stdio.h> #include <ssdef.h> #include <libdef.h>  #include <iodef.h> #include <descrip.h> #include <starlet.h> #include <lib$routines.h>  #include <string.h>  #include <stdlib.h>  #include <ctype.h>! #include "NETLIB_DIR:NETLIBDEF.H"    #define TRUE	1 #define	FALSE	0    #define	SUCCESS	1  #define	FAILURE	0   @ 	/* The length of the line sent back to us from the time server.> 	They both happen to be 51, but it would probably be unwise to, 	suggest that they are necessarily equal. */ #define	MODEM_TIME_SIZE		51  #define NETWORK_TIME_SIZE	51  ? 	/* The internet address for the time server.  It is hardcoded, < 	which may be a flaw if other time servers come into use. */ #if defined(Y2KTEST)J char	time_server[] = "132.163.135.136";	/* y2ktest.timefreq.bldrdoc.gov */ #else * //char    time_server[] = "time.nist.gov";/ char    time_server[] = "nist1-lnk.binary.net";  //nist1-atl.ustiming.org"; #endif  ) 	/* Port 13 provides the time service. */  #define	SERVER_PORT		13   & int readwrite_modem(char *, int, int);     short	chan;   8 	/* These variables are set by command line options.  */  < 	/* Set to TRUE if we are to take daylight savings time into 	account. */ short	set_dst = 0, 	set_precise = 0, 
 	set_toy = 0,  	check_only = 0,         set_network = 1;   typedef	long	QUAD[2];   B 	/* Set to contain the offset required between UTC and local time.0 	when daylight savings time is NOT in effect. */ QUAD	offsetbintime,         	newbintime;  	  struct 	{
 	long	header;  	long	terms; 	} mask;   typedef struct	{
 	long	mjd; 	short	year, 		month, 		day, 		hour, 	 		minute, 	 		second,  		dst,
 	     	ls; 	float	dut1, 		msadv;
 	char	src[9];  	} TIME_BLOCK;   typedef struct	{ 	short	year, 		month, 		day, 		hour, 	 		minute, 	 		second,  	  	hundreths;   	} NUMTIME_BLOCK;   : 	/* We expect the first argument to be a deltatime used to< 	convert between nbs time and local time.  This is typically& 	a difference in a number of hours. */ parse_delta(ascii_delta) char	ascii_delta[];  {  static char	asctime[24];# $DESCRIPTOR(asctime_desc, asctime);   / 	/* Initialize the descriptor to all spaces. */ , memset(asctime, ' ', sizeof(asctime));        ? 	/* Copy the offset into asctime so that it is in a descriptor, C 	being careful not to overflow it or to copy the NULL.  VMS doesn't  	want to see a null. */  if (strlen(ascii_delta) > 24) 3    	strncpy(asctime, ascii_delta, sizeof(asctime));  else7    	strncpy(asctime, ascii_delta, strlen(ascii_delta));   2 	/* Convert from ascii time format into binary. */; if (sys$bintim(&asctime_desc, offsetbintime) != SS$_NORMAL)  	{; 	fprintf(stderr, "Invalid offset time: %s\n", ascii_delta);  	return(FAILURE);  	}-                                                return(SUCCESS); }   " 	/* Parse command line options. */ parse_option(option) char	option[]; {  if (strlen(option) != 2) 	{1 	fprintf(stderr, "Invalid option: %s\n", option);  	return(FAILURE);  	}   tolower(option[1]);    switch(option[1])  	{A 		/* Set if we are to take daylight savings time into account. */ 
 	case 'd': 		set_dst = TRUE;  		break;  ; 		/* Set if we are not actually going to set the time, only ; 		set it - useful to see how well your clock is working and > 		for non-privileged users to see if the system is on time. */
 	case 'c': 		check_only = TRUE; 		break;  ; 		/* Set if we insist on only setting the time if we can be ; 		very precise, i.e. we have gotten the OTM mark that takes & 		the transmission delay into account.  > 		For networks, only set the time if the server is healthy. */
 	case 'p': 		set_precise = TRUE;  		break;  9 		/* Set if we first want to reset the system time to the 8 		hardware TOY (time of year) clock inside the VAX.  The: 		internal clock is proported to be more accurate than the 		system clock.  */ 
 	case 't': 		set_toy = TRUE;  		break;  9 		/* Set if we are to use the internet time server rather  		than the modem line. */ 
 	case 'n': 		set_network = TRUE;  		break;  
 	case 'm': 		set_network = FALSE; 		break;  	 	default: 2 		fprintf(stderr, "Invalid option: %s\n", option); 		return(FAILURE); 		break; 	}  ! return(SUCCESS);                   }    parse_usage(argc, argv) 	 int	argc; 
 char	*argv[];  {  short	i;   for(i = 1; i < argc; i++)  	if (argv[i][0] == '-')  		{      		if (!parse_option(argv[i]))  		 	return(FAILURE); 		}  	else : 		{                                                        		if (!parse_delta(argv[i])) 		     	return(FAILURE); 		}    return(SUCCESS); }    open_modem() {   $DESCRIPTOR(terminal, "MODEM:");  , if (sys$assign(&terminal, &chan, 0, 0) != 1) 	{> 	fprintf(stderr, "Couldn't assign a channel to the modem.\n");
 	exit(-1); 	}   mask.header = 0L;  mask.terms = 0L;   return(SUCCESS); }   
 clear_modem()  { 	 char	otm;   = 	/* Returns 0 if it timed out while trying to clear the line, < 	otherwise, keep reading characters until a '*' (the OTM) is 	received.  */  < 	/* First do a read with purge in order to clear the line of< 	any noise or header characters that may be in the typeahead 	buffer. */ 1 if (readwrite_modem(&otm, sizeof(otm), -10) != 1)      	return(FAILURE);    while(1) 	{0 	if (readwrite_modem(&otm, sizeof(otm), 2) != 1) 	    	return(FAILURE);   	if (otm == '*') 		return(SUCCESS); 	} }   E 	/* Readwrite_modem reads characters from the modem, then immediately > 	echos them back out.  The argument "timeout" is the number ofD 	seconds to wait for a character.  If "timeout" is a negative value,> 	the line input buffer is purged before reading characters. */& readwrite_modem(buffer, size, timeout)
 char	*buffer; 	 int	size, 	 	timeout;  {  int	status; 
 char	iosb[8]; 
 int	received; 
 int	count; short	purge; int	read_flags;   ? 	/* Read characters from the modem line, reading one at a time. @ 	If the line input buffer is to be purged, do so only before the> 	first character.  Doing so before each character is likely to 	cause characters to be lost.   D 	Keep track of the number of characters read by incrementing "count" 	for each character. */   1 	/* Set up the options for reading the modem.  */ 7 read_flags = IO$_READVBLK|IO$M_NOFILTR|IO$M_NOECHO;       ? 	/* Include the IO$M_TIMED option if we are using a timeout. */  if (timeout) 	read_flags |= IO$M_TIMED;  A 	/* If timeout is negative, then we must first purge the line, so B 	set the purge to 1.  Also, we must negate timeout because the QIO) 	expects a positive number of seconds. */  if (timeout < 0) 	{ 	purge = 1;  	timeout = -timeout; 	} else 	purge = 0;   % for(count = 0; count < size; count++)  	{A 	/* If the count is 0 (no characters read) and we are supposed to < 	purge the line, then also include the IO$M_PURGE option. */   	status = sys$qiow(0, chan, 4 		read_flags | ((purge && !count) ? IO$M_PURGE : 0),7 		iosb, 0, 0, buffer + count, 1, timeout, &mask, 0, 0);   + 	/* If we got an error, get out of here. */  	if (status != SS$_NORMAL) 		break;  < 	received = *((short *)(iosb + 2)) + *((short *)(iosb + 6));  E 	/* Even if we got return status SS$_NORMAL, we may not have received B 	any characters - SS$_TIMOUT only seems to be returned if at least  	one character has been read. */ 	if (!received)  		break;  B 	/* Write the character back out to the line.  Don't wait for this? 	to complete - we need to overlap reading and writing if we are 7 	to get everything done in < 1 second at 1200 baud.  */ 7 	status = sys$qio(0, chan, IO$_WRITEVBLK|IO$M_NOFORMAT, &  		0, 0, 0, buffer, 1, 0, 0, 0, 0, 0);   	if (status != SS$_NORMAL) 		break; 	}  2 if (status != SS$_NORMAL && status != SS$_TIMEOUT) 	{B 	fprintf(stderr, "Couldn't get a character from the terminal.\n");
 	exit(-1); 	}  
 if (count) 	return(count);  else 	return(-1); }   G 	/* Neither the read_modem nor the write_modem code is used any longer. : 	It is included because it may be useful in the future. */  
 #ifdef UNUSED   ! read_modem(buffer, size, timeout) 
 char	*buffer; 	 int	size, 	 	timeout;  {  int	status; 
 char	iosb[8]; 
 int	received;   7 	/* Gets all characters except ^C,^Q,^S,^Y,^O,^T which, + 	as far as I am concerned, VMS can keep! */    if (timeout > 0) 	status = sys$qiow(0, chan, : 	       	IO$_READVBLK|IO$M_NOFILTR|IO$M_NOECHO|IO$M_TIMED,8 	      	iosb, 0, 0, buffer, size, timeout, &mask, 0, 0); else if (timeout < 0)  	status = sys$qiow(0, chan, > 		IO$_READVBLK|IO$M_NOFILTR|IO$M_NOECHO|IO$M_TIMED|IO$M_PURGE,8 	      	iosb, 0, 0, buffer, size, timeout, &mask, 0, 0); else 	{A 	status = sys$qio(0, chan, IO$_READVBLK|IO$M_NOFILTR|IO$M_NOECHO, , 		iosb, 0, 0, buffer, size, 0, &mask, 0, 0);   	if (status != SS$_NORMAL). 		fprintf(stderr, "QIO failed: %d\n", status); 	}  2 if (status != SS$_NORMAL && status != SS$_TIMEOUT) 	{B 	fprintf(stderr, "Couldn't get a character from the terminal.\n");
 	exit(-1); 	}  ; received = *((short *)(iosb + 2)) + *((short *)(iosb + 6));   
 if (received)  	return(received); else 	return(-1); }    write_modem(buffer, size) 
 char	*buffer; 	 int	size;  {  int	status;   7 status = sys$qiow(0, chan, IO$_WRITEVBLK|IO$M_NOFORMAT, ) 	 	0, 0, 0, buffer, size, 0, 0, 0, 0, 0);  }    #endif /* UNUSED */      parse_time(raw, parsed)  char		*raw;  TIME_BLOCK	*parsed;  {  short	count;  > 	/* Attempt to parse the entire string, even though we discard> 	large portions of it.  This is done to ensure that everything 	was received accurately. */O if (sscanf(raw, "%5ld %2hd-%2hd-%2hd %2hd:%2hd:%2hd %2hd %1hd %*c%2f %5f %8s ",  	&(parsed->mjd),4 	&(parsed->year), &(parsed->month),  &(parsed->day),7 	&(parsed->hour), &(parsed->minute), &(parsed->second),   	&(parsed->dst),  &(parsed->ls),; 	&(parsed->dut1), &(parsed->msadv),  &(parsed->src)) != 12)  	return(FAILURE);   H /* Use windowing to determine which century the two-digit year falls in.I    The cutoff of 70 used below works for the 100-year era 1970 to 2069 */    if (parsed->year < 70) {  	parsed->year=parsed->year+2000; } else {  	parsed->year=parsed->year+1900; }   . return(SUCCESS);                               }   ; char	*months[] = {"JAN", "FEB", "MAR", "APR", "MAY", "JUN", : 		     "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};           " show_delta(oldbintime, newbintime) QUAD		oldbintime, 
 		newbintime;  {  QUAD		deltabintime;    static char   		asctime[24]; NUMTIME_BLOCK	numtime;  # $DESCRIPTOR(asctime_desc, asctime);    int	ascii_length;    	/* Display the old time. */J if (sys$asctim(&ascii_length, &asctime_desc, oldbintime, 0) != SS$_NORMAL) 	{9 	fprintf(stderr, "Unable to convert binary to ascii.\n");  	return(FAILURE);  	}   printf("%0.23s ", asctime);    	/* Display the new time. */J if (sys$asctim(&ascii_length, &asctime_desc, newbintime, 0) != SS$_NORMAL) 	{9 	fprintf(stderr, "Unable to convert binary to ascii.\n");  	return(FAILURE);  	}   printf("to %0.23s, ", asctime);   % 	/* Calculate the time difference. */ G if (lib$sub_times(oldbintime, newbintime, deltabintime) != LIB$_NORMAL) H 	if (lib$sub_times(newbintime, oldbintime, deltabintime) != LIB$_NORMAL) 		{ 8 		fprintf(stderr, "Unable to calculate time change.\n"); 		exit(SS$_NORMAL);  		}   " 	/* Display the change in time. */) if (!deltabintime[0] && !deltabintime[1]) % 	strcpy(asctime, "   0 00:00:00.00"); B else if (sys$asctim(&ascii_length, &asctime_desc, deltabintime, 0) 	!= SS$_NORMAL)  	{9 	fprintf(stderr, "Unable to convert binary to ascii.\n");  	return(FAILURE);  	}  # printf("delta %0.16s.\n", asctime);   K return(SUCCESS);                                                             }    setup_time(parsed) TIME_BLOCK	*parsed;  {  QUAD  		oldbintime,     		onehourbintime; static char   		asctime[24]; NUMTIME_BLOCK	numtime;  # $DESCRIPTOR(asctime_desc, asctime);   8 	/* Parse into VAX format the time received from NBS. */2 sprintf(asctime, "%02d-%s-%04d %02d:%02d:%02d.00",6 	parsed->day, months[parsed->month - 1], parsed->year,/ 	parsed->hour, parsed->minute, parsed->second);                              2 	/* Convert from ascii time format into binary. */8 if (sys$bintim(&asctime_desc, newbintime) != SS$_NORMAL) 	{9 	fprintf(stderr, "Unable to convert ascii to binary.\n");  	return(FAILURE);  	}  @ 	/* Subtract the time offset on the command line from newbintime@ 	in order to convert it into local time.  Since the deltatime isA 	actually a negative number, it is added to the absolute time. */ ) if (offsetbintime[0] || offsetbintime[1]) I 	if (lib$sub_times(newbintime, offsetbintime, newbintime) != LIB$_NORMAL)  		{ = 		fprintf(stderr, "Unable to convert to local time zone.\n");  		exit(SS$_NORMAL);; 		}   3 if (sys$numtim(&numtime, newbintime) != SS$_NORMAL)  	{; 	fprintf(stderr, "Unable to convert binary to numeric.\n");  	return(FAILURE);  	}  B 	/* If the daylight savings time switch is ON and daylight savingsA 	time is currently in effect in the United States, then take this @ 	into account in making adjustments.  Daylight savings time ADDS 	one hour to the time.  A 	We must first check if the user wants us to bother with daylight > 	savings time in the first place.  Next, we check to see if we> 	are in DST, and if so, we do the fixup.  Finally, if we're on> 	one of those strange and wonderful days when the time changes> 	from ST to DST, we must determine if it is before 2AM and the> 	change has not yet gone into effect (so we still need to makeA 	the correction).  Note that when it is 2AM DST (when we all move = 	our clocks back one hour), it is 1AM ST.  If it is after 1AM D 	ST (as told to us by the NBS and modified by our local time offset,! 	then we are no longer on DST. */                   if (set_dst &&G 	((parsed->dst >= 2 && parsed->dst <= 50) ||        /* No change day */ ? 		(parsed->dst ==  1 && numtime.hour < 1) || /* ST after 2AM */ A 		(parsed->dst == 51 && numtime.hour >= 2))) /* DST after 2AM */   		{ 2 			/* Set asctime to a value equal to one hour. */= 		strncpy(asctime, "0 01:00:00.00        ", sizeof(asctime));   4 			/* Convert from ascii time format into binary. */> 		if (sys$bintim(&asctime_desc, onehourbintime) != SS$_NORMAL) 			{; 			fprintf(stderr, "Unable to convert ascii to binary.\n");  			return(FAILURE);  			}  / 		if (lib$add_times(newbintime, onehourbintime,  			newbintime) != LIB$_NORMAL) 			{2 			fprintf(stderr, "Unable to use DST offset.\n"); 			exit(SS$_NORMAL);;    			} 		}    return(SUCCESS); }   
 set_time() {  QUAD  		oldbintime;   C 	/* Get the current system time, just so we know where we stand. */ ) if (sys$gettim(oldbintime) != SS$_NORMAL)  	{9 	fprintf(stderr, "Unable to get current system time.\n");  	return(FAILURE);  	}  = 	/* Actually set the system time clock (but only if we're not  	just checking things out. */  if (!check_only)* 	if (sys$setime(newbintime) != SS$_NORMAL) 		{ 6 		fprintf(stderr, "Unable to set new system time.\n"); 		return(FAILURE); 		}     	/* Now show how well we did. */( if (!show_delta(oldbintime, newbintime)) 	{4 	fprintf(stderr, "Unable to display delta time.\n"); 	return(FAILURE);  	}   return(SUCCESS); }   	 use_toy()  {  QUAD  		oldbintime, 
 		newbintime;   C 	/* Get the current system time, just so we know where we stand. */ ) if (sys$gettim(oldbintime) != SS$_NORMAL)  	{9 	fprintf(stderr, "Unable to get current system time.\n");  	return(FAILURE);  	}  A 	/* Reset the system time according to the time-of-year clock. */   if (sys$setime(0) != SS$_NORMAL) 	{E 	fprintf(stderr, "Unable to set new system time using TOY clock.\n");  	return(FAILURE);  	}  2 	/* Get the new system time, so we can compare. */) if (sys$gettim(newbintime) != SS$_NORMAL)  	{5 	fprintf(stderr, "Unable to get new system time.\n");  	return(FAILURE);  	}    	/* Now show how well we did. */( if (!show_delta(oldbintime, newbintime)) 	{4 	fprintf(stderr, "Unable to display delta time.\n"); 	return(FAILURE);  	}  K return(SUCCESS);                                                             }    use_modem()  { 
 short		retry; 
 char		otm;% char		time_line[MODEM_TIME_SIZE + 1];  TIME_BLOCK	time_block;  " time_line[MODEM_TIME_SIZE] = '\0';  . 	/* Attempt to open a channel to the modem. */ if (!open_modem()) 	{  < 	fprintf(stderr, "Unable to open modem (device MODEM:).\n");
 	exit(-1); 	}  ; 	/* We start by clearing the modem, in any garbage has been = 	received during the connection process and to get rid of the  	initial greeting from NBS.   = 	We then read the line of information sent to us (making sure ; 	that it is of the length we expect), then parse it (making < 	sure the it parsed properly, including fields we don't even< 	look at), then we set up everything so that the actual time= 	setting happens as soon after the OTM mark is received as is 
 	possible.  > 	Finally, we wait for the OTM mark to arrive and once verified8 	that it is correct, we zip off and set the system time. 	*/   ? 	/* Give us 10 tries to get the time.  If we can't get it in 10 ? 	tries, we probably won't ever get it.  The only time this will A 	fail is when we are receiving the time through a packet network, ? 	in which case both the time line and the OTM may arrive in the ? 	same packet.  In such cases, we can probably set the time, but 1 	only roughly (still within a second, though). */  retry = 10;    while(1) 	{ 	if (!(retry--)) 		{  		fprintf(stderr, 4 			"Unable to read time from NBS and set clock.\n"); 		exit(-1);  		}    	if (!clear_modem()) 		{ ; 		fprintf(stderr, "Unable to clear communication line.\n");  		exit(-1);  		}   	 	while(1)  		{ = 		if (readwrite_modem(time_line, sizeof(time_line) - 1, 2) !=  			MODEM_TIME_SIZE)  			{ 	 		fprintf(stderr, 2 				"Timed out while attempting to read time.\n");	 			break;  			}  % 		parse_time(time_line, &time_block);    		setup_time(&time_block);  @ 	/* Read with purge - we want to make sure we get the OTM fresh,< 	not something that has been sitting in the typeahead buffer 	for a while. */2 		if (readwrite_modem(&otm, sizeof(otm), -2) != 1)
 			{      A 	 		fprintf(stderr, "Timed out while attempting to read OTM.\n"); 	 			break;  			}  % 		if (otm != '*' && otm != '#')        			{5 			fprintf(stderr, "Invalid OTM mark received: %d\n", 	 				otm); 	 			break;  			}  < 	/* If the user did not specify to set precisely, we set the@ 	time no matter what.  If the user has requested precise settingD 	only, we set time ONLY if we receive the precise time mark, '#'. */! 		if (!set_precise || otm == '#') $ 		       	if (set_time() == SUCCESS) 				exit(SS$_NORMAL);;
 		}            	}                 }   
 use_network()  {  int	status,  	socket;
 short	length;  short	port;  short	iosb[4];% char		time_line[MODEM_TIME_SIZE + 1];  TIME_BLOCK	time_block; char *time_server_ptr; char *time_servers;   " $DESCRIPTOR(time_server_desc, ""); $DESCRIPTOR(buf_desc, "");    < 	/* Set up structures to connect to the time server host. */  8 	if ((time_servers = getenv("NBS_TIME_SERVER")) == NULL) 	    {  	    time_servers = time_server; 	    }  . 	time_server_ptr = strtok (time_servers, ",");   	port = SERVER_PORT;    	while (time_server_ptr != NULL) 	    {  @ 	    /* Set up structures to connect to the time server host. */= 	    time_server_desc.dsc$w_length = strlen(time_server_ptr); 6 	    time_server_desc.dsc$a_pointer = time_server_ptr;  1 	    /* Attempt to connect to the time server. */    	    /* Create a socket. */ A 	    if ((status = netlib_socket((void *)&socket)) != SS$_NORMAL)  		{ 0 		fprintf(stderr, "Unable to create socket.\n"); 		exit(SS$_NORMAL);; 		}   w 	    if ((status = netlib_connect_by_name((void *)&socket, &time_server_desc, (unsigned short *) &port)) != SS$_NORMAL)  		{ $ 		/* We're done with the network. */  		netlib_close((void *)&socket);Q 		fprintf(stderr, "Unable to connect to time server host %s\n", time_server_ptr); - 		time_server_ptr = (char*)strtok(NULL, ",");  		} 	 	    else  		time_server_ptr = NULL;  	    }  - 	/* Attempt to connect to the time server. */  	if (status != SS$_NORMAL) 	    {Y 	    fprintf(stderr, "Unable to connect to any time server (%X), exiting....\n", status);  	    exit(SS$_NORMAL); 	    }  $ 	/* Set up the buffer descriptor. */* buf_desc.dsc$w_length = NETWORK_TIME_SIZE;# buf_desc.dsc$a_pointer = time_line;   % 	/* Read the time from the server. */ K if ((status = netlib_read((void *)&socket, &buf_desc, 0, 0, 0, 0, iosb)) !=  	SS$_NORMAL) {6 	fprintf(stderr, "Unable to connect to read time.\n"); 	exit(SS$_NORMAL);;  	}   time_line[iosb[1]] = '\0';  # 	/* We're done with the network. */  netlib_close((void *)&socket);   	/* Parse the time. */# parse_time(time_line, &time_block);   # if (time_block.dut1 && set_precise)  	{0 	fprintf(stderr, "Time server wasn't healthy."); 	exit(SS$_NORMAL);;  	}   	/* Set things up. */  setup_time(&time_block);   	/* Actually set the clock. */ set_time();  }    main(argc, argv)	 int	argc; 
 char	*argv[]; A {                                                                  if (!parse_usage(argc, argv)) 0 	{                                              < 	fprintf(stderr, "Usage: NBS <deltatime> -d -c -t -p -m\n");
 	exit(-1); 	}   if (set_toy) 	if (use_toy() == SUCCESS) 		exit(SS$_NORMAL);  	else  		exit(-1);   = 	/* Decide if we're going to use the modem or the network. */  if (set_network) 	use_network();  else
 	use_modem();  } 