 /*  *  address_rewriter.c  *$  *  ADDRESS_REWRITER callout for MX.  *=  *  Copyright  2001, MadGoat Software.  All Rights Reserved.   *  */  #include "address_rewriter.h"    /*    * Forward declarations   */ %     vms_status_t INIT(void **ctxptr); R     vms_status_t REWRITE_HEADER(void **ctxptr, const struct dsc$descriptor *inadr,G     	    	    	    	struct dsc$descriptor *outadr, mx_hdr_code_t code); T     vms_status_t REWRITE_ENVELOPE(void **ctxptr, const struct dsc$descriptor *inadr,3     	    	    	    	struct dsc$descriptor *outadr); Z     int	    	 REWRITE_VIRTUAL_DOMAIN(void **ctxptr, const struct dsc$descriptor *domname);(     vms_status_t CLEANUP(void **ctxptr);   /*  *  Local static storage  */      static config_t 	 cfg;%     static int	    	 initialized = 0; "     static int	    	 dummy = 1234;(     static $DESCRIPTOR(ctrstr, "<!AD>");   /*  *  External references   */ K     vms_status_t PARSE821(const struct dsc$descriptor *inadr, void *rteque, J     	    	    	 struct dsc$descriptor *usrd, struct dsc$descriptor *domd);?     vms_status_t PARSE_MBOX(const struct dsc$descriptor *inadr, [                             struct dsc$descriptor *usrd, struct dsc$descriptor *domd, ...);    /*  *  ROUTINE:	INIT   *  *  DESCRIPTION:=  *  	Initializes for address rewriting.  Checks to see if the ;  *  	configuration has changed; if so, it re-reads whatever 2  *  	parts of the configuration have been updated.  *  *  PARAMETERS: =  *  	ctxptr:	    address of context, write only, by reference   *   *  RETURNS:	VMS condition value  */ # vms_status_t INIT (void **ctxptr) {        vms_status_t status;       if (!initialized) { %         memset(&cfg, 0, sizeof(cfg));      	mem_init(&cfg);     	initialized = 1;      }   &     status = load_configuration(&cfg);     if (!OK(status)) {         mem_destroy_all(&cfg);         initialized = 0;     	return status;      }        *ctxptr = &dummy;        return SS$_NORMAL;   } /* INIT */   /*    *  ROUTINE:	REWRITE_HEADER   *  *  DESCRIPTION:6  *  	Called to rewrite an address in a message header.  *  *  PARAMETERS: 6  *  	ctxptr:	    context pointer, modify, by reference5  *  	inadr:	    char_string, read only, by descriptor 7  *  	outadr:	    char_string, write only, by descriptor 1  *  	code:	    word_unsigned, read only, by value   *  *  RETURNS:  VMS status code   */ O vms_status_t REWRITE_HEADER (void **ctxptr, const struct dsc$descriptor *inadr, H     	    	    	     struct dsc$descriptor *outadr, mx_hdr_code_t code) {  #     struct dsc$descriptor usr, dom; !     vms_status_t          status;      mailbox_t             cand;      node_t               *node; $     char                  buf[1024];  9     if (code != MX_K_HDR_FROM && code != MX_K_HDR_R_FROM)          return 0;        INIT_DYNDESC(&usr);      INIT_DYNDESC(&dom); +     status = PARSE_MBOX(inadr, &usr, &dom);      if (OK(status)) { ?         u_int32_t totlen = usr.dsc$w_length + dom.dsc$w_length; "         if (totlen >= sizeof(buf))             status = 0;      }        if (OK(status)) { 9         memcpy(buf, usr.dsc$a_pointer, usr.dsc$w_length); $         buf[usr.dsc$w_length] = '@';N         memcpy(buf+(usr.dsc$w_length+1), dom.dsc$a_pointer, dom.dsc$w_length);B         cand.mbx_actlen = usr.dsc$w_length + dom.dsc$w_length + 1;         cand.mbx_actual = buf;  2         status = LIB$LOOKUP_TREE(&cfg.cfg_hdrtree,;                                  (librtl_symbol_t *) &cand, ?                                  (librtl_cmprtn_t) hdr_compare, (                                  &node);     }        if (OK(status)) <         status = LIB$SCOPY_R_DX(&node->node_mbx->mbx_deslen,<                                 node->node_mbx->mbx_desired,(                                 outadr);       STR$FREE1_DX(&usr);      STR$FREE1_DX(&dom);        return status;   } /* REWRITE_HEADER */   /*    *  ROUTINE:	REWRITE_ENVELOPE   *  *  DESCRIPTION:9  *  	Maps recipient "virtual" addresses into their "real"   *  	counterparts.  *  *  PARAMETERS: 6  *  	ctxptr:	    context pointer, modify, by reference5  *  	inadr:	    char_string, read only, by descriptor 7  *  	outadr:	    char_string, write only, by descriptor   *  *  RETURNS:  VMS status code   */ Q vms_status_t REWRITE_ENVELOPE (void **ctxptr, const struct dsc$descriptor *inadr, 6     	    	    	       struct dsc$descriptor *outadr) {  #     struct dsc$descriptor usr, dom; !     vms_status_t          status;      mailbox_t             cand;      node_t               *node; $     char                  buf[1024];       INIT_DYNDESC(&usr);      INIT_DYNDESC(&dom);   ,     status = PARSE821(inadr, 0, &usr, &dom);     if (OK(status)) { ?         u_int32_t totlen = usr.dsc$w_length + dom.dsc$w_length; "         if (totlen >= sizeof(buf))             status = 0;      }        if (OK(status)) { 9         memcpy(buf, usr.dsc$a_pointer, usr.dsc$w_length); $         buf[usr.dsc$w_length] = '@';N         memcpy(buf+(usr.dsc$w_length+1), dom.dsc$a_pointer, dom.dsc$w_length);B         cand.mbx_deslen = usr.dsc$w_length + dom.dsc$w_length + 1;         cand.mbx_desired = buf;   2         status = LIB$LOOKUP_TREE(&cfg.cfg_envtree,;                                  (librtl_symbol_t *) &cand, ?                                  (librtl_cmprtn_t) env_compare, (                                  &node);     }        if (OK(status)) 0         status = LIB$SYS_FAO(&ctrstr, 0, outadr,8                              node->node_mbx->mbx_actlen,9                              node->node_mbx->mbx_actual);        STR$FREE1_DX(&usr);      STR$FREE1_DX(&dom);        return status;   } /* REWRITE_ENVELOPE */   /*  #  *  ROUTINE:	REWRITE_VIRTUAL_DOMAIN   *  *  DESCRIPTION::  *      Always returns zero.  This module does not support   *      virtual-domain mappings.  *  *  PARAMETERS: 6  *  	ctxptr:	    context pointer, modify, by reference6  *  	domname:    char_string, read only, by descriptor  *  *  RETURNS:  int (1=yes, 0=no)   */ O int REWRITE_VIRTUAL_DOMAIN (void **ctxptr, const struct dsc$descriptor *domp) {   
     return 0;    } /* REWRITE_VIRTUAL_DOMAIN */   /*  *  ROUTINE:	CLEANUP  *  *  DESCRIPTION:2  *  	Cleans up after a rewrite sequence.  For this4  *  	module, there is no per-lookup context, so this  *  	routine does nothing.  *  *  PARAMETERS: =  *  	ctxptr:	    address of context, write only, by reference   *   *  RETURNS:	VMS condition value  */ & vms_status_t CLEANUP (void **ctxptr) {       *ctxptr = 0;       return SS$_NORMAL;   } /* CLEANUP */    /*  *  ROUTINE:	hdr_compare  *  *  DESCRIPTION:>  *  	Tree node comparison routine for the header-rewrite tree.*  *      Compares against actual addresses.  *  *  PARAMETERS: =  *  	ctxptr:	    address of context, write only, by reference   *   *  RETURNS:	VMS condition value  */ H int hdr_compare (void *symbol, void *comparison_node, void *user_data) {  *     mailbox_t               *mbx = symbol;4     node_t                  *node = comparison_node;(     struct dsc$descriptor    dsc1, dsc2;  8     INIT_SDESC(&dsc1, mbx->mbx_actlen, mbx->mbx_actual);N     INIT_SDESC(&dsc2, node->node_mbx->mbx_actlen, node->node_mbx->mbx_actual);0     return STR$CASE_BLIND_COMPARE(&dsc1, &dsc2);   } /* hdr_compare */    /*  *  ROUTINE:	env_compare  *  *  DESCRIPTION:@  *  	Tree node comparison routine for the envelope-rewrite tree.+  *      Compares against desired addresses.   *  *  PARAMETERS: =  *  	ctxptr:	    address of context, write only, by reference   *   *  RETURNS:	VMS condition value  */ H int env_compare (void *symbol, void *comparison_node, void *user_data) {  "     mailbox_t       *mbx = symbol;,     node_t          *node = comparison_node;(     struct dsc$descriptor    dsc1, dsc2;  9     INIT_SDESC(&dsc1, mbx->mbx_deslen, mbx->mbx_desired); O     INIT_SDESC(&dsc2, node->node_mbx->mbx_deslen, node->node_mbx->mbx_desired); 0     return STR$CASE_BLIND_COMPARE(&dsc1, &dsc2);   } /* env_compare */ 