 #ifndef NETLIB_H_LOADED  #define NETLIB_H_LOADED  /* ** NETLIB.H  **" **  Main #include file for NETLIB. ** **) **   Copyright (c) 2008, Matthew Madison.  **     **   All rights reserved.  **    G **   Redistribution and use in source and binary forms, with or without G **   modification, are permitted provided that the following conditions 
 **   are met:  **    ? **       * Redistributions of source code must retain the above F **         copyright notice, this list of conditions and the following **         disclaimer.B **       * Redistributions in binary form must reproduce the aboveF **         copyright notice, this list of conditions and the followingJ **         disclaimer in the documentation and/or other materials provided! **         with the distribution. G **       * Neither the name of the copyright owner nor the names of any H **         other contributors may be used to endorse or promote productsD **         derived from this software without specific prior written **         permission. **    H **   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSF **   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTJ **   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORI **   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT J **   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,E **   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT J **   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,J **   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYH **   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTJ **   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEI **   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ** **  MODIFICATION HISTORY:  **0 **  29-Sep-1993	    Madison 	Initial commenting.. **  31-May-1997	    Madison 	Fix queue access.- **  07-Nov-2004     Madison     IA64 support.  */ #include <stdio.h> #include <stddef.h>  #include <stdlib.h>  #include <string.h>  #include <ctype.h> #include <varargs.h> #include <socket.h>  #include <in.h>  #include <netdb.h> #include <descrip.h> #include <stsdef.h>  #include <ssdef.h> #include <lib$routines.h>  #include <str$routines.h>  #include <starlet.h>
 #ifdef __DECC  #include <builtins.h>  #else  #pragma builtins #endif #ifndef __NETLIB_BUILD__ #define __NETLIB_BUILD__ #endif #include "netlibdef.h"  ) #if defined(__ALPHA) || defined(__ia64__)  #pragma member_alignment save  #pragma nomember_alignment #endif, typedef struct { void *head, *tail; } QUEUE;3 typedef struct { unsigned int long1, long2; } TIME; & typedef struct dsc$descriptor DESCRIP;P typedef struct { unsigned short bufsiz, itmcod; void *bufadr, *retlen; } ITMLST;) #if defined(__ALPHA) || defined(__ia64__)   #pragma member_alignment restore #endif   /* ** Handy macros  */$ #define OK(s) $VMS_STATUS_SUCCESS(s)U #define INIT_DYNDSCPTR(str) {str->dsc$w_length = 0; str->dsc$a_pointer = (void *) 0;\ M     	    str->dsc$b_class = DSC$K_CLASS_D; str->dsc$b_dtype = DSC$K_DTYPE_T;} Q #define INIT_DYNDESC(str) {str.dsc$w_length = 0; str.dsc$a_pointer = (void *) 0;\ K     	    str.dsc$b_class = DSC$K_CLASS_D; str.dsc$b_dtype = DSC$K_DTYPE_T;} Y #define INIT_SDESC(str,len,ptr) {str.dsc$w_length=(len);str.dsc$a_pointer=(void *)(ptr);\ G     	    str.dsc$b_class=DSC$K_CLASS_S; str.dsc$b_dtype=DSC$K_DTYPE_T;} B #define ITMLST_INIT(itm,c,s,a,r) {itm.bufsiz=(s); itm.itmcod=(c);\)     	    itm.bufadr=(a); itm.retlen=(r);} 5 #define INIT_QUEUE(que) {que.head = que.tail = &que;} " #define SETARGCOUNT(x) va_count(x)D #define VERIFY_CTX(x,c) {if ((x) == 0) return SS$_BADPARAM; c = *x;}H #define GET_IOR(x, _ctx, _iosb, _astadr, _astprm) {unsigned int status;\*     	    status = netlib___alloc_ior(&x);\<     	    if (!OK(status)) return status; (x)->ctx = (_ctx);\K     	    (x)->iosbp=(_iosb); (x)->astadr=(_astadr); (x)->astprm=(_astprm);} ) #define FREE_IOR(x) netlib___free_ior(x); K #define GET_DNSREQ(x, _ctx, _iosb, _astadr, _astprm) {unsigned int status;\ -     	    status = netlib___alloc_dnsreq(&x);\ )     	    if (!OK(status)) return status;\ 3     	    status = netlib___alloc_ior(&((x)->ior));\ D     	    if (!OK(status)) {netlib___free_dnsreq(x); return status;}\!     	    (x)->ior->ctx = (_ctx);\ >     	    (x)->ior->iosbp=(_iosb); (x)->ior->astadr=(_astadr);\%     	    (x)->ior->astprm=(_astprm);} O #define FREE_DNSREQ(x) {netlib___free_ior(((x)->ior));netlib___free_dnsreq(x);}   ) #if defined(__ALPHA) || defined(__ia64__) L #define queue_insert(item,pred) __PAL_INSQUEL((void *)(pred),(void *)(item))U #define queue_remove(entry,addr) (__PAL_REMQUEL((void *)(entry),(void *)(addr)) >= 0)  #else 2 #define queue_insert(item,pred) _INSQUE(item,pred); #define queue_remove(entry,addr) (_REMQUE(entry,addr) != 2)  #endif   /* **  Generic context structure  */   #ifndef __SPECCTX  #define __SPECCTX void #endif       struct NAMESERVER { &     	struct NAMESERVER *flink, *blink;     	struct INADDRDEF addr;      };       struct DOMAIN { "     	struct DOMAIN *flink, *blink;     	int length;     	char name[1];     };       struct DNSCTX {      	QUEUE nsq;      	QUEUE domq;     	TIME  timeout;      	int   retry_count;      	unsigned int flags;     	unsigned short queryid;     };   #define CTX_S_LINEBUF	32768        struct CTX {     	struct CTX *flink, *blink;        	TIME exptime;       	unsigned int flags;* #define CTX_M_USER_SET_REUSEADDR    (1<<0)' #define CTX_M_LINE_FOUND_CR 	    (1<<1) $ #define CTX_M_NO_DNS	    	    (1<<2)     	unsigned short chan;      	__SPECCTX *specctx;     	unsigned int specctx_size;   4     	unsigned char *linebuf, *linebufp, *lineanchor;%     	struct dsc$descriptor *line_dsc; !     	unsigned short *line_retlen;      	unsigned int line_flags;      	int line_remain;      	TIME *line_tmo;       	unsigned char *wlinebuf;      	int wlinesize;        	struct DNSCTX *dnsctx;        };   #define SPECIOR_SPACE 64 #ifndef __SPECIOR  #define __SPECIOR void * #endif   #pragma nostandard     struct IOR {     	struct IOR *flink, *blink;      	struct NETLIBIOSBDEF iosb;      	TIME   timeout;     	struct CTX *ctx; !     	struct NETLIBIOSBDEF *iosbp;      	unsigned int iorflags; ' #define IOR_M_IO_COMPLETED  	    (1<<0) & #define IOR_M_IO_TIMED	    	    (1<<1)' #define IOR_M_IO_TIMEOUT    	    (1<<2)      	void (*astadr)();     	void *astprm;     	union {     	    void *address;      	    unsigned int longword;      	    unsigned short word;      	} arg[8];     	variant_union {4     	    unsigned char specior_space[SPECIOR_SPACE];     	    __SPECIOR specior;      	} specior_overlay;      }; #pragma standard       struct DNSREQ { "     	struct DNSREQ *flink, *blink;     	struct IOR *ior;      	struct CTX *ctx;      	struct NAMESERVER *curns;     	struct DOMAIN *curdom;      	char *query_name;!     	unsigned short query_namlen;      	unsigned int query_flags;     	unsigned char *query_rbuf; !     	unsigned int query_rbufsize;      	unsigned int query_class;     	unsigned int query_type; #     	unsigned int buflen, replylen;      	int retries;      	struct SINDEF sin;      	struct SINDEF rsin;     	unsigned char buf[1024];      };   #ifndef __NETLIB_MODULE_MEM__  #pragma nostandard,     globalref unsigned int netlib_synch_efn;-     globalref unsigned int netlib_asynch_efn;  #pragma standardA     unsigned int netlib___alloc_ctx(struct CTX **, unsigned int); 1     unsigned int netlib___free_ctx(struct CTX *); 3     unsigned int netlib___alloc_ior(struct IOR **); 1     unsigned int netlib___free_ior(struct IOR *); 9     unsigned int netlib___alloc_dnsreq(struct DNSREQ **); 7     unsigned int netlib___free_dnsreq(struct DNSREQ *);  #endif   #endif /* NETLIB_H_LOADED */