 /* **++ **  FACILITY:	NETLIB **? **  ABSTRACT:	DNS resolver routines - support for doing our own 2 **  	    	DNS gethostbyname/gethostbyaddr support. ** **  MODULE DESCRIPTION:  ** **  	tbs ** **  AUTHOR: 	    M. Madison  **) **   Copyright (c) 2008, Matthew Madison.  **     **   All rights reserved.  **    G **   Redistribution and use in source and binary forms, with or without G **   modification, are permitted provided that the following conditions 
 **   are met:  **    ? **       * Redistributions of source code must retain the above F **         copyright notice, this list of conditions and the following **         disclaimer.B **       * Redistributions in binary form must reproduce the aboveF **         copyright notice, this list of conditions and the followingJ **         disclaimer in the documentation and/or other materials provided! **         with the distribution. G **       * Neither the name of the copyright owner nor the names of any H **         other contributors may be used to endorse or promote productsD **         derived from this software without specific prior written **         permission. **    H **   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSF **   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTJ **   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORI **   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT J **   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,E **   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT J **   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,J **   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYH **   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTJ **   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEI **   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ** **  CREATION DATE:  22-OCT-1994  ** **  MODIFICATION HISTORY:  **1 **  	22-OCT-1994 V1.0    Madison 	Initial coding. F **  	17-NOV-1994 V1.1    Madison 	Fixed handling of DNS lookup errors.; **  	18-JAN-2001 V1.1-1  Madison 	Tighten up DNS RC checks.  **-- */ #include "netlib.h"  /* **  Forward declarations */;     unsigned int netlib___dns_name_to_addr(struct CTX *ctx, H     	    	    struct dsc$descriptor *namdsc, struct INADDRDEF *addrlist,9     	    	    unsigned int listsize, unsigned int *count, J     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm);G     static unsigned int name_to_addr_completion(struct DNSREQ *dnsreq); ;     unsigned int netlib___dns_addr_to_name(struct CTX *ctx, @     	    	    struct INADDRDEF *addrlist, unsigned int addrsize,D     	    	    struct dsc$descriptor *namdsc, unsigned short *retlen,J     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm);G     static unsigned int addr_to_name_completion(struct DNSREQ *dnsreq);    /* **  External references  */S     unsigned int netlib_dns_query(struct CTX **xctx, struct dsc$descriptor *namdsc, 6     	    	    unsigned int *class, unsigned int *type,:     	    	    unsigned char *buf, unsigned short *bufsize,>     	    	    unsigned int *flags, struct NETLIBIOSBDEF *iosb,.     	    	    void (*astadr)(), void *astprm);I     int netlib_dns_skipname(unsigned char *bufp, unsigned short *buflen); R     unsigned int netlib_dns_expandname(unsigned char *buf, unsigned short *buflen,A     	    	    unsigned char *bufp, struct dsc$descriptor *namdsc, ?     	    	    unsigned short *retlen, unsigned short *bufchrs); 4     unsigned int netlib___dns_init(struct CTX *ctx);        /* **++& **  ROUTINE:	netlib___dns_name_to_addr ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */8 unsigned int netlib___dns_name_to_addr (struct CTX *ctx,H     	    	    struct dsc$descriptor *namdsc, struct INADDRDEF *addrlist,9     	    	    unsigned int listsize, unsigned int *count, K     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm) {        unsigned short bufsize;      unsigned int status;     struct DNSREQ *dnsreq;     struct IOR *ior;  6     static unsigned int class = NETLIB_K_DNS_CLASS_IN;4     static unsigned int type  = NETLIB_K_DNS_TYPE_A;<     static unsigned int queryflags = NETLIB_M_DOMAIN_SEARCH;  :     if (ctx->flags & CTX_M_NO_DNS) return SS$_UNSUPPORTED;       if (ctx->dnsctx == 0) { %     	status = netlib___dns_init(ctx); -     	if (!OK(status)) return SS$_UNSUPPORTED;      }   2     GET_DNSREQ(dnsreq, ctx, iosb, astadr, astprm);     ior = dnsreq->ior;#     ior->arg[0].address = addrlist; $     ior->arg[1].longword = listsize;      ior->arg[2].address = count;"     bufsize = sizeof(dnsreq->buf);:     status = netlib_dns_query(&ctx, namdsc, &class, &type,%     	    	    	dnsreq->buf, &bufsize,      	    	    	&queryflags,      	    	    	&ior->iosb,!     	    	    	(astadr == 0) ? 0  C     	    	    	    : (void (*)()) name_to_addr_completion, dnsreq); #     if (astadr != 0) return status;   +     return name_to_addr_completion(dnsreq);   ! } /* netlib___dns_name_to_addr */    /* **++$ **  ROUTINE:	name_to_addr_completion ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */E static unsigned int name_to_addr_completion (struct DNSREQ *dnsreq) {   "     struct IOR *ior = dnsreq->ior;     struct CTX *ctx = ior->ctx; 2     struct INADDRDEF *alist = ior->arg[0].address;.     unsigned int *count = ior->arg[2].address;     struct dsc$descriptor dsc;"     struct NETLIB_DNS_HEADER *hdr;     unsigned char *cp;     char name[256]; 0     unsigned short retlen, remain, buflen, skip;,     int i, n, ancount, qdcount, type, class;  '     if (!OK(ior->iosb.iosb_w_status)) {      	unsigned int status;        	if (ior->iosbp != 0) { =     	    ior->iosbp->iosb_w_status = ior->iosb.iosb_w_status; '     	    ior->iosbp->iosb_w_count  = 0; '     	    ior->iosbp->iosb_l_unused = 0;      	}      	if (count != 0) *count = 0;7     	if (ior->astadr != 0) (*ior->astadr)(ior->astprm); &     	status = ior->iosb.iosb_w_status;     	FREE_DNSREQ(dnsreq);      	return status;      }   3     hdr = (struct NETLIB_DNS_HEADER *) dnsreq->buf; 3     ancount = netlib_word_swap(hdr->dns_w_ancount); 3     qdcount = netlib_word_swap(hdr->dns_w_qdcount);   ;     if (hdr->dns_v_reply_code != NETLIB_K_DNS_RC_SUCCESS) {      	unsigned int status; B     	status = ((hdr->dns_v_reply_code == NETLIB_K_DNS_RC_NAMERR &&D     	    	   hdr->dns_v_authoritative) ? SS$_ENDOFFILE : SS$_ABORT);     	if (ior->iosbp != 0) { ,     	    ior->iosbp->iosb_w_status = status;&     	    ior->iosbp->iosb_w_count = 0;'     	    ior->iosbp->iosb_l_unused = 0;      	}      	if (count != 0) *count = 0;7     	if (ior->astadr != 0) (*ior->astadr)(ior->astprm);      	FREE_DNSREQ(dnsreq);      	return status;      }   $     buflen = ior->iosb.iosb_w_count;$     remain =  buflen - sizeof(*hdr);$     cp = dnsreq->buf + sizeof(*hdr);     while (qdcount-- > 0) { .     	i = netlib_dns_skipname(cp, &remain) + 4;
     	cp += i;      	remain -= i;      }   (     INIT_SDESC(dsc, sizeof(name), name);
     n = 0;  E     while (ancount-- > 0 && remain > 0 && n < ior->arg[1].longword) { [     	if (!OK(netlib_dns_expandname(dnsreq->buf, &buflen, cp, &dsc, &retlen, &skip))) break;      	cp += skip;     	remain -= skip;4     	type = netlib_word_swap(*(unsigned short *)cp);     	cp += 2; remain -= 2;5     	class = netlib_word_swap(*(unsigned short *)cp); 3     	cp += 6; remain -= 6; /* skip over TTL, too */ 1     	i = netlib_word_swap(*(unsigned short *)cp);      	cp += 2; remain -= 2;'     	if (type == NETLIB_K_DNS_TYPE_A) { 9     	    alist[n++].inaddr_l_addr = *(unsigned long *)cp;      	}
     	cp += i;      	remain -= i;      }           if (count != 0) *count = n;      if (ior->iosbp != 0) {,     	ior->iosbp->iosb_w_status = SS$_NORMAL;#     	ior->iosbp->iosb_w_count  = n; #     	ior->iosbp->iosb_l_unused = 0;      } 1     if (ior->astadr) (*ior->astadr)(ior->astprm);      FREE_DNSREQ(dnsreq);     return SS$_NORMAL;   } /* name_to_addr_completion */    /* **++& **  ROUTINE:	netlib___dns_addr_to_name ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */8 unsigned int netlib___dns_addr_to_name (struct CTX *ctx,=     	    	    struct INADDRDEF *xaddr, unsigned int addrsize, D     	    	    struct dsc$descriptor *namdsc, unsigned short *retlen,K     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm) {        struct dsc$descriptor dsc;     struct IOR *ior;     struct DNSREQ *dnsreq;     char tmp[256];     unsigned short bufsize;      unsigned int status;     unsigned char *addr;  6     static unsigned int class = NETLIB_K_DNS_CLASS_IN;6     static unsigned int type  = NETLIB_K_DNS_TYPE_PTR;<     static unsigned int queryflags = NETLIB_M_DOMAIN_SEARCH;  :     if (ctx->flags & CTX_M_NO_DNS) return SS$_UNSUPPORTED;       if (ctx->dnsctx == 0) { %     	status = netlib___dns_init(ctx); -     	if (!OK(status)) return SS$_UNSUPPORTED;      }   2     GET_DNSREQ(dnsreq, ctx, iosb, astadr, astprm);     ior = dnsreq->ior;!     ior->arg[0].address = namdsc; !     ior->arg[1].address = retlen; #     addr = (unsigned char *) xaddr; =     INIT_SDESC(dsc, sprintf(tmp, "%d.%d.%d.%d.in-addr.arpa.", 9     	    	    	addr[3], addr[2], addr[1], addr[0]), tmp); "     bufsize = sizeof(dnsreq->buf);8     status = netlib_dns_query(&ctx, &dsc, &class, &type,%     	    	    	dnsreq->buf, &bufsize,I     	    	    	&queryflags,	     	    	    	&ior->iosb,!     	    	    	(astadr == 0) ? 0 NC     	    	    	    : (void (*)()) addr_to_name_completion, dnsreq); #     if (astadr != 0) return status;   +     return addr_to_name_completion(dnsreq);M  ! } /* netlib___dns_addr_to_name */e d /* **++$ **  ROUTINE:	addr_to_name_completion ** **  FUNCTIONAL DESCRIPTION:u **) **  	tbs                                 h **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.s ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */E static unsigned int addr_to_name_completion (struct DNSREQ *dnsreq) {t  "     struct IOR *ior = dnsreq->ior;     struct CTX *ctx = ior->ctx;a8     struct dsc$descriptor *namdsc = ior->arg[0].address;2     unsigned short *retlenp = ior->arg[1].address;     struct dsc$descriptor dsc;"     struct NETLIB_DNS_HEADER *hdr;     unsigned char *cp;3     unsigned short retlen, remain, buflen, n, skip;w     char name[256];p)     int i, ancount, qdcount, type, class;      unsigned int status;  '     if (!OK(ior->iosb.iosb_w_status)) {U     	if (ior->iosbp != 0) {P=     	    ior->iosbp->iosb_w_status = ior->iosb.iosb_w_status;,'     	    ior->iosbp->iosb_w_count  = 0;Y'     	    ior->iosbp->iosb_l_unused = 0;S     	}$     	if (retlenp != 0) *retlenp = 0;7     	if (ior->astadr != 0) (*ior->astadr)(ior->astprm);,&     	status = ior->iosb.iosb_w_status;     	FREE_DNSREQ(dnsreq);A     	return status;      }*  3     hdr = (struct NETLIB_DNS_HEADER *) dnsreq->buf;C3     ancount = netlib_word_swap(hdr->dns_w_ancount);I3     qdcount = netlib_word_swap(hdr->dns_w_qdcount);F  ;     if (hdr->dns_v_reply_code != NETLIB_K_DNS_RC_SUCCESS) {      	unsigned int status;TB     	status = ((hdr->dns_v_reply_code == NETLIB_K_DNS_RC_NAMERR &&D     	    	   hdr->dns_v_authoritative) ? SS$_ENDOFFILE : SS$_ABORT);     	if (ior->iosbp != 0) {O3     	    ior->iosbp->iosb_w_status = SS$_ENDOFFILE;d&     	    ior->iosbp->iosb_w_count = 0;'     	    ior->iosbp->iosb_l_unused = 0;o     	}$     	if (retlenp != 0) *retlenp = 0;7     	if (ior->astadr != 0) (*ior->astadr)(ior->astprm);h     	FREE_DNSREQ(dnsreq);t     	return status;d     }t  $     buflen = ior->iosb.iosb_w_count;$     remain =  buflen - sizeof(*hdr);$     cp = dnsreq->buf + sizeof(*hdr);     while (qdcount-- > 0) {s.     	i = netlib_dns_skipname(cp, &remain) + 4;
     	cp += i;F     	remain -= i;d     }o  (     INIT_SDESC(dsc, sizeof(name), name);     status = SS$_NORMAL;  )     while (ancount-- > 0 && remain > 0) {n[     	if (!OK(netlib_dns_expandname(dnsreq->buf, &buflen, cp, &dsc, &retlen, &skip))) break;s     	cp += skip;     	remain -= skip;4     	type = netlib_word_swap(*(unsigned short *)cp);     	cp += 2; remain -= 2;5     	class = netlib_word_swap(*(unsigned short *)cp);d3     	cp += 6; remain -= 6; /* skip over TTL, too */ 1     	i = netlib_word_swap(*(unsigned short *)cp);i     	cp += 2; remain -= 2;)     	if (type == NETLIB_K_DNS_TYPE_PTR) { Q     	    status = netlib_dns_expandname(dnsreq->buf, &buflen, cp, namdsc, &n, 0);n     	    break;s     	}
     	cp += i;i     	remain -= i;r     }L     1     if (OK(status) && retlenp != 0) *retlenp = n;s     if (ior->iosbp != 0) {(     	ior->iosbp->iosb_w_status = status;3     	ior->iosbp->iosb_w_count  = OK(status) ? n: 0;u#     	ior->iosbp->iosb_l_unused = 0;f     } 1     if (ior->astadr) (*ior->astadr)(ior->astprm);t     FREE_DNSREQ(dnsreq);     return status;   } /* addr_to_name_completion */ 