 /* **++ **  FACILITY:	NETLIB **1 **  ABSTRACT:	Line-mode send and receive routines  ** **  MODULE DESCRIPTION:  **< **  	This module contains routines for sending and receivingD **  "lines" of ASCII data, with CR/LF terminators at the end of eachC **  line.  It is layered on top of the raw NETLIB_READ/NETLIB_WRITE C **  routines, and contains no code dependent on a particular TCP/IP C **  implementation.  They do assume, however, that the TCP protocol # **  is being used, rather than UDP.  ** ** **  AUTHOR: 	    M. Madison  **) **   Copyright (c) 2008, Matthew Madison.  **     **   All rights reserved.  **    G **   Redistribution and use in source and binary forms, with or without G **   modification, are permitted provided that the following conditions 
 **   are met:  **    ? **       * Redistributions of source code must retain the above F **         copyright notice, this list of conditions and the following **         disclaimer.B **       * Redistributions in binary form must reproduce the aboveF **         copyright notice, this list of conditions and the followingJ **         disclaimer in the documentation and/or other materials provided! **         with the distribution. G **       * Neither the name of the copyright owner nor the names of any H **         other contributors may be used to endorse or promote productsD **         derived from this software without specific prior written **         permission. **    H **   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSF **   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTJ **   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORI **   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT J **   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,E **   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT J **   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,J **   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYH **   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTJ **   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEI **   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ** **  CREATION DATE:  22-OCT-1994  ** **  MODIFICATION HISTORY:  **1 **  	22-OCT-1994 V1.0    Madison 	Initial coding. 9 **  	09-JAN-1995 V1.0-1  Madison 	Read data in 1K chunks. D **  	11-JAN-1995 V1.0-2  Madison 	Fix timeout reference in readline.M **  	13-JAN-1995 V1.0-3  Madison 	Fix split CR/LF handling in parse_out_line. 4 **  	25-JAN-1995 V1.0-4  Madison 	Fix for CR w/o LF.H **  	31-AUG-1995 V1.0-5  Madison 	Change writeline to write entire line,< **  	    	    	    	    	including terminator, in one write.: **  	    	    	    	    	Works around cc:Mail gateway bug.N **  	19-JAN-1997 V1.0-6  Madison 	Async read should return NETLIB_READ status.R **  	01-JUN-1997 V1.0-7  Madison 	Catch NETLIB_READ status in readline_continue().O **  	27-NOV-1997 V1.1    Madison 	Add NETLIB_M_FLUSH flag to netlib_readline(). 1 **  	14-DEC-1997 V1.1-1  Madison 	Fix flush code. K **  	02-JAN-1998 V1.1-2  Madison 	Make relaxed line mode even more relaxed. _ **      03-MAR-2001 V1.1-3  Madison     retlen should reflect actualy number of bytes returned. 9 **      07-NOV-2004 V1.2    Madison     ALLOW_CR support.  **-- */ #include "netlib.h"  /* **  Forward declarations */O     unsigned int netlib_readline(struct CTX **xctx, struct dsc$descriptor *dsc, @     	    	    	    	unsigned short *retlen, unsigned int *flagp,>     	    	    	    	TIME *timeout, struct NETLIBIOSBDEF *iosb,4     	    	    	    	void (*astadr)(), void *astprm);3     static void readline_continue(struct IOR *ior); J     static int parse_out_line(struct CTX *ctx, struct dsc$descriptor *dsc,,     	    	    	    	unsigned short *retlen);\     static unsigned short compute_retlen(struct dsc$descriptor *dsc, unsigned short actlen);P     unsigned int netlib_writeline(struct CTX **xctx, struct dsc$descriptor *dsc,1     	    	    	    	  struct NETLIBIOSBDEF *iosb, 6     	    	    	    	  void (*astadr)(), void *astprm);2     static void writeline_finish(struct IOR *ior); /* **  OWN storage  */%     static $DESCRIPTOR(crlf, "\r\n");  /* **  External references  */=     unsigned int netlib_read(struct CTX **xctx, void *, ...); >     unsigned int netlib_write(struct CTX **xctx, void *, ...);   /* **++ **  ROUTINE:	netlib_readline ** **  FUNCTIONAL DESCRIPTION:  **A **  	Reads in a line.  The terminating CR/LF pair is not included C **  in the data returned to the caller.  The caller may specify the E **  NETLIB_M_ALLOW_LF flag to permit interoperation with senders that B **  may erroneously terminate lines with just linefeeds instead of= **  CR/LF pairs; likewise for NETLIB_M_ALLOW_CR and bare CRs.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **C **  	NETLIB_READLINE  ctx, dsc [,retlen] [,flag] [,timeout] [,iosb] ) **  	    	    	    	  [,astadr] [,astprm]  **M **  ctx:    NETLIB session context, longword (unsigned), modify, by reference D **  dsc:    char_string, character string, write only, by descriptorD **  retlen: word_unsigned, word (unsigned), write only, by referenceG **  flag:   mask_longword, longword (unsigned), read only, by reference C **  timeout: delta_time, quadword (signed), read only, by reference ? **  iosb:   IO_status_block, quadword, write only, by reference D **  astadr: ast_procedure, procedure entry mask, CALL , by reference> **  astprm: user_arg, longword (unsigned), read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */L unsigned int netlib_readline (struct CTX **xctx, struct dsc$descriptor *dsc,@     	    	    	    	unsigned short *retlen, unsigned int *flagp,>     	    	    	    	TIME *timeout, struct NETLIBIOSBDEF *iosb,5     	    	    	    	void (*astadr)(), void *astprm) {        struct CTX *ctx;      struct NETLIBIOSBDEF myiosb;     struct dsc$descriptor sdsc;      unsigned int status;     unsigned short len; 
     int argc;        VERIFY_CTX(xctx, ctx)      SETARGCOUNT(argc);%     if (argc < 2) return SS$_INSFARG;   D     if (argc < 4 || flagp == 0) ctx->line_flags = NETLIB_M_ALLOW_LF;"     else ctx->line_flags = *flagp;       if (ctx->linebuf == 0) {.     	static unsigned int size = CTX_S_LINEBUF;/     	status = lib$get_vm(&size, &ctx->linebuf); $     	if (!OK(status)) return status;     	ctx->line_remain = 0;4     	ctx->linebufp = ctx->lineanchor = ctx->linebuf;     }        len = 0;     while (1) {   *     	if (parse_out_line(ctx, dsc, &len)) {     	    status = SS$_NORMAL;      	    break;      	}  A     	INIT_SDESC(sdsc, CTX_S_LINEBUF-(ctx->linebufp-ctx->linebuf), "     	    	    	    ctx->linebufp);<     	if (sdsc.dsc$w_length > 1024) sdsc.dsc$w_length = 1024;  #     	if (argc > 6 && astadr != 0) {      	    struct IOR *ior; B     	    GET_IOR(ior, ctx, iosb, astadr, (argc > 7) ? astprm : 0);#     	    ctx->line_retlen = retlen;       	    ctx->line_dsc    = dsc;$     	    ctx->line_tmo    = timeout;F     	    return netlib_read(xctx, &sdsc, 0, 0, 0, timeout, &ior->iosb,,     	    	    	    	readline_continue, ior);     	}  S     	status = netlib_read(xctx, &sdsc, 0, 0, 0, (argc > 4) ? timeout : 0, &myiosb);      	if (!OK(status)) break;,     	ctx->line_remain = myiosb.iosb_w_count;       } /* while */   /     if (argc > 2 && retlen != 0) *retlen = len;         if (argc > 5 && iosb != 0) {"     	iosb->iosb_w_status = status;     	iosb->iosb_w_count = len;     }   "     if (argc > 6 && astadr != 0) {4     	sys$dclast(astadr, (argc > 7) ? astprm : 0, 0);     	return SS$_NORMAL;      }        return status;   } /* netlib_readline */    /* **++ **  ROUTINE:	readline_continue ** **  FUNCTIONAL DESCRIPTION:  **D **  	Internal routine for coninuation of a line-mode read operation.N **  Continues reading data until the line termination sequence is encountered.J **  Completes the operation by returning the line (without terminators) to **  the caller.  ** **  RETURNS:	void  ** **  PROTOTYPE: ** **  	READLINE_CONTINUE ior **L **  ior:    struct IOR, internal I/O request structure, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */1 static void readline_continue (struct IOR *ior) {        struct CTX *ctx = ior->ctx;      struct dsc$descriptor sdsc;      unsigned int status;     unsigned short len;   '     if (!OK(ior->iosb.iosb_w_status)) {      	if (ior->iosbp != 0) { $     	    ior->iosbp->iosb_w_status ="     	    	ior->iosb.iosb_w_status;&     	    ior->iosbp->iosb_w_count = 0;     	}8     	if (ctx->line_retlen != 0) *(ctx->line_retlen) = 0;7     	if (ior->astadr != 0) (*ior->astadr)(ior->astprm);      	FREE_IOR(ior);      	return;     }   .     ctx->line_remain = ior->iosb.iosb_w_count;  3     if (parse_out_line(ctx, ctx->line_dsc, &len)) {      	if (ior->iosbp != 0) { 0     	    ior->iosbp->iosb_w_status = SS$_NORMAL;(     	    ior->iosbp->iosb_w_count = len;     	}:     	if (ctx->line_retlen != 0) *(ctx->line_retlen) = len;7     	if (ior->astadr != 0) (*ior->astadr)(ior->astprm);      	FREE_IOR(ior);      	return;     }      	 P     INIT_SDESC(sdsc, CTX_S_LINEBUF-(ctx->linebufp-ctx->linebuf), ctx->linebufp);;     if (sdsc.dsc$w_length > 1024) sdsc.dsc$w_length = 1024; I     status = netlib_read(&ctx, &sdsc, 0, 0, 0, ctx->line_tmo, &ior->iosb, ,     	    	    	    	readline_continue, ior);     if (!OK(status)) {=     	if (ior->iosbp != 0) ior->iosbp->iosb_w_status = status; 7     	if (ior->astadr != 0) (*ior->astadr)(ior->astprm);      	FREE_IOR(ior);      }        return;    } /* readline_continue */    /* **++ **  ROUTINE:	parse_out_line  ** **  FUNCTIONAL DESCRIPTION:  **@ **  	Utility routine for parsing a line out of a buffer of data. ** **  RETURNS:	int (boolean) ** **  PROTOTYPE: **% **  	PARSE_OUT_LINE  ctx, dsc, retlen  **F **  ctx:    struct CTX, NETLIB context structure, modify, by referenceD **  dsc:    char_string, character string, write only, by descriptorD **  retlen: word_unsigned, word (unsigned), write only, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:e+ **  	    1:	line termination sequence found + **  	    0:  termination sequence not foundr ** **  SIDE EFFECTS:   	None. ** **-- */G static int parse_out_line (struct CTX *ctx, struct dsc$descriptor *dsc,*-     	    	    	    	unsigned short *retlen) {p       unsigned short len;d     unsigned char *cp;  +     if (ctx->line_flags & NETLIB_M_FLUSH) {      	len = ctx->line_remain;     	if (len != 0) {+             len = compute_retlen(dsc, len);h0     	    str$copy_r(dsc, &len, ctx->lineanchor);	         }      	*retlen = len;      	ctx->line_remain = 0;4     	ctx->linebufp = ctx->lineanchor = ctx->linebuf;     	return 1;     }g  "     while (ctx->line_remain > 0) {  ,     	if (ctx->flags & CTX_M_LINE_FOUND_CR) {,     	    ctx->flags &= ~CTX_M_LINE_FOUND_CR;&     	    if (*ctx->linebufp == '\n') {A                 if ((ctx->line_flags & NETLIB_M_ALLOW_CR) == 0) {dO     	    	    len = compute_retlen(dsc, (ctx->linebufp - ctx->lineanchor) - 1);t5     	    	    str$copy_r(dsc, &len, ctx->lineanchor);t     	    	    *retlen = len;                 }*      	    	ctx->line_remain -= 1;     	    	ctx->linebufp += 1;n*     	    	ctx->lineanchor = ctx->linebufp;?                 if ((ctx->line_flags & NETLIB_M_ALLOW_CR) == 0)*     	    	    return 1;S
     	    }     	}  8     	cp = memchr(ctx->linebufp, '\r', ctx->line_remain);     	/*R7     	**  If we're in relaxed line mode, check to see ifR8     	**  a linefeed precedes the carriage return we just8     	**  found.  If so, treat it as though we didn't get     	**  the carriage return.,     	*/Q     	if (cp != 0 &&U]             (ctx->line_flags & (NETLIB_M_ALLOW_LF|NETLIB_M_ALLOW_CR)) == NETLIB_M_ALLOW_LF && D     	    memchr(ctx->linebufp, '\n', cp-ctx->linebufp) != 0) cp = 0;     	if (cp == 0) {I3     	    if (ctx->line_flags & NETLIB_M_ALLOW_LF) { =     	    	cp = memchr(ctx->linebufp, '\n', ctx->line_remain);      	    	if (cp != 0) {>     	    	    len = compute_retlen(dsc, cp - ctx->lineanchor);5     	    	    str$copy_r(dsc, &len, ctx->lineanchor);N     	    	    *retlen = len;)     	    	    len = cp - ctx->lineanchor;05     	    	    len -= (ctx->linebufp-ctx->lineanchor);**     	    	    ctx->line_remain -= len + 1;'     	    	    ctx->linebufp += len + 1;V.     	    	    ctx->lineanchor = ctx->linebufp;     	    	    return 1;-     	    	}M
     	    }+     	    ctx->linebufp += ctx->line_remain;s     	    ctx->line_remain = 0;
     	} else { <     	    if ((cp - ctx->linebufp) == (ctx->line_remain-1)) {,     	    	ctx->flags |= CTX_M_LINE_FOUND_CR;:                 if (ctx->line_flags & NETLIB_M_ALLOW_CR) {>     	    	    len = compute_retlen(dsc, cp - ctx->lineanchor);5     	    	    str$copy_r(dsc, &len, ctx->lineanchor);2     	    	    *retlen = len;&     	            ctx->line_remain = 0;@     	            ctx->linebufp = ctx->lineanchor = ctx->linebuf;     	            return 1;                 }e-      	    	ctx->linebufp += ctx->line_remain;3     	    	ctx->line_remain = 0;c     	    } else { K     	    	if (*(cp + 1) == '\n' || (ctx->line_flags & NETLIB_M_ALLOW_CR)) { <                     int delta = (*(cp + 1) == '\n' ? 2 : 1);>     	    	    len = compute_retlen(dsc, cp - ctx->lineanchor);5     	    	    str$copy_r(dsc, &len, ctx->lineanchor);t     	    	    *retlen = len;)     	    	    len = cp - ctx->lineanchor; 5     	    	    len -= (ctx->linebufp-ctx->lineanchor);).     	    	    ctx->line_remain -= len + delta;+     	    	    ctx->linebufp += len + delta;e.     	    	    ctx->lineanchor = ctx->linebufp;     	    	    return 1;      	    	} else {;     	    	    ctx->line_remain -= (cp - ctx->linebufp) + 1;e%     	    	    ctx->linebufp = cp + 1;      	    	}i
     	    }     	}     }C  =     if (ctx->linebufp - ctx->lineanchor >= CTX_S_LINEBUF-2) {u@     	len = compute_retlen(dsc, ctx->linebufp - ctx->lineanchor);,     	str$copy_r(dsc, &len, ctx->lineanchor);     	ctx->line_remain = 0;4     	ctx->lineanchor = ctx->linebufp = ctx->linebuf;     	*retlen = len;l     	return 1;     }n       if (ctx->line_remain > 0 ||*L     	    (ctx->linebufp - ctx->linebuf == CTX_S_LINEBUF-ctx->line_remain)) {<     	len = ctx->line_remain + ctx->linebufp-ctx->lineanchor;1     	memmove(ctx->linebuf, ctx->lineanchor, len);T(     	ctx->linebufp = ctx->linebuf + len;$     	ctx->lineanchor = ctx->linebuf;     	ctx->line_remain = 0;     }*
     return 0;W   } /* parse_out_line */ t /* **++ **  ROUTINE:	compute_retlenu ** **  FUNCTIONAL DESCRIPTION:e **= **  	Computes actual returned length for readline operations.n ** **  RETURNS:	unsigned shortn ** **  PROTOTYPE: **  **  	COMPUTE_RETLEN  dsc, actlen **D **  dsc:    char_string, character string, write only, by descriptor? **  actlen: word_unsigned, word (unsigned), read only, by value  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.e ** **  COMPLETION CODES:   None.c ** **  SIDE EFFECTS:   	None. ** **-- */Z static unsigned short compute_retlen (struct dsc$descriptor *dsc, unsigned short actlen) {  H     if (dsc->dsc$b_class == DSC$K_CLASS_D || dsc->dsc$w_length > actlen)         return actlen;       return dsc->dsc$w_length;O   } /* compute_retlen */ e /* **++ **  ROUTINE:	netlib_writelinec ** **  FUNCTIONAL DESCRIPTION:  **> **  	Writes a line of data to the network, adding a CR/LF pair **  as a line terminator.T **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **; **  	NETLIB_WRITELINE  ctx, dsc [,iosb] [,astadr] [,astprm]d **M **  ctx:    NETLIB session context, longword (unsigned), modify, by referencesC **  dsc:    char_string, character string, read only, by descriptor,? **  iosb:   IO_status_block, quadword, write only, by reference)D **  astadr: ast_procedure, procedure entry mask, CALL , by reference> **  astprm: user_arg, longword (unsigned), read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.t ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */M unsigned int netlib_writeline (struct CTX **xctx, struct dsc$descriptor *dsc,e1     	    	    	    	  struct NETLIBIOSBDEF *iosb, 7     	    	    	    	  void (*astadr)(), void *astprm) {        struct CTX *ctx;     struct IOR *ior;      struct NETLIBIOSBDEF myiosb;     struct dsc$descriptor sdsc;>     char *line, *bufptr;     unsigned short len, buflen;e     unsigned int status, count;i
     int argc;n       VERIFY_CTX(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 2) return SS$_INSFARG;S&     if (dsc == 0) return SS$_BADPARAM;6     status = lib$analyze_sdesc(dsc, &buflen, &bufptr);#     if (!OK(status)) return status;$ /*8 **  Make sure our write buffer is large enough to handle0 **  the entire string plus the terminating CRLF. */$     if (buflen+2 > ctx->wlinesize) {     	if (ctx->wlinebuf != 0) {6     	    lib$free_vm(&ctx->wlinesize, &ctx->wlinebuf);     	    ctx->wlinebuf = 0;      	    ctx->wlinesize = 0;     	}<     	ctx->wlinesize = ((buflen < 2046) ? 2046 : buflen) + 2;:     	status = lib$get_vm(&ctx->wlinesize, &ctx->wlinebuf);     	if (!OK(status)) {o     	    ctx->wlinesize = 0;     	    ctx->wlinebuf = 0;>     	    return status;_     	}     }    /*< **  Now copy the user's data into our buffer and tack on the **  terminating CRLF.o **> **  We do this because some applications are broken and assume@ **  that one entire line can be read in in a single read, rather> **  than actually parsing the stream of data coming in for the% **  line termination sequence.  Sigh.  */*     memcpy(ctx->wlinebuf, bufptr, buflen);#     ctx->wlinebuf[buflen++] = '\r';I#     ctx->wlinebuf[buflen++] = '\n';   ,     INIT_SDESC(sdsc, buflen, ctx->wlinebuf);  "     if (argc > 3 && astadr != 0) {>     	GET_IOR(ior, ctx, iosb, astadr, (argc > 4) ? astprm : 0);7     	return netlib_write(xctx, &sdsc, 0, 0, &ior->iosb, %     	    	    writeline_finish, ior);v     }*  6     status = netlib_write(xctx, &sdsc, 0, 0, &myiosb);      if (argc > 2 && iosb != 0) {0     	iosb->iosb_w_status = myiosb.iosb_w_status;.     	iosb->iosb_w_count = myiosb.iosb_w_count;     	iosb->iosb_l_unused = 0;S     }        return status;   } /* netlib_writeline */ c /* **++ **  ROUTINE:	writeline_finish  ** **  FUNCTIONAL DESCRIPTION:c **D **  	Completes an asynchronous NETLIB_WRITELINE operation by fillingE **  in the user's IOSB and calling the user's AST completion routine.i ** **  RETURNS:	void  ** **  PROTOTYPE: **5 **  	WRITELINE_FINISH   ior     ! called at AST leveli **L **  ior:    struct IOR, internal I/O request structure, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.r ** **  COMPLETION CODES:	None.r ** **  SIDE EFFECTS:   	None. ** **-- */0 static void writeline_finish (struct IOR *ior) {       if (ior->iosbp != 0) {9     	ior->iosbp->iosb_w_status = ior->iosb.iosb_w_status;s8     	ior->iosbp->iosb_w_count  = ior->iosb.iosb_w_count;     }   6     if (ior->astadr != 0) (*ior->astadr)(ior->astprm);       FREE_IOR(ior);   } /* writeline_finish */