 /* **++ **  FACILITY:	NETLIB **, **  ABSTRACT:	Pre-V2 compatibility routines. ** **  MODULE DESCRIPTION:  **G **  	This module contains wrapper routines for NETLIB V2 that implement O **  the V1 programming interface, for compatibility with V1-based applications.  **J **  N.B.: This compatibility may be removed in a future release of NETLIB.F **  	  Existing applications should migrate to the V2 API, and all new/ **  	  applications should use only the V2 API.  ** **  AUTHOR: 	    M. Madison  **) **   Copyright (c) 2008, Matthew Madison.  **     **   All rights reserved.  **    G **   Redistribution and use in source and binary forms, with or without G **   modification, are permitted provided that the following conditions 
 **   are met:  **    ? **       * Redistributions of source code must retain the above F **         copyright notice, this list of conditions and the following **         disclaimer.B **       * Redistributions in binary form must reproduce the aboveF **         copyright notice, this list of conditions and the followingJ **         disclaimer in the documentation and/or other materials provided! **         with the distribution. G **       * Neither the name of the copyright owner nor the names of any H **         other contributors may be used to endorse or promote productsD **         derived from this software without specific prior written **         permission. **    H **   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORSF **   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOTJ **   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FORI **   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT J **   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,E **   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT J **   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,J **   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANYH **   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORTJ **   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEI **   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ** **  CREATION DATE:  25-OCT-1994  ** **  MODIFICATION HISTORY:  **1 **  	25-OCT-1994 V1.0    Madison 	Initial coding. F **  	13-NOV-1994 V1.1    Madison 	Another V1 compatibility hack -- for% **  	    	    	    	    	udp_receive. @ **  	17-NOV-1994 V1.1-1  Madison 	A shutdown call on disconnect.B **  	11-JAN-1995 V1.1-2  Madison 	Fix shutdown call on disconnect;0 **  	    	    	    	    	   add default timeout.F **  	11-JAN-1995 V1.1-3  Madison 	Fixed invocation of default timeout.D **  	17-FEB-1995 V1.1-4  Madison 	Allow SS$_LINKDISCON as success on, **  	    	    	    	    	    tcp_disconnect.5 **      07-NOV-2004 V1.1-5  Madison     IA64 support.  **-- */ #include "netlibdef.h" #include <ssdef.h> #include <descrip.h> #include <stsdef.h>  #include <varargs.h> #include <string.h>  #include <lib$routines.h>  #include <starlet.h>   /*0 **  A few handy macros and structure definitions */$ #define OK(x) $VMS_STATUS_SUCCESS(x)F #define VERIFY_CONTEXT(p,c) {if (p == 0) return SS$_BADPARAM; c = *p;}" #define SETARGCOUNT(x) va_count(x)  ) #if defined(__ALPHA) || defined(__ia64__)  #pragma member_alignment save  #pragma nomember_alignment #endif2     typedef struct {unsigned int low, high;} TIME;) #if defined(__ALPHA) || defined(__ia64__)   #pragma member_alignment restore #endif   /*: **  These constants are from the V1 programming interface. */ #define NET_K_TCP   1  #define NET_K_UDP   2  #define NET_M_PUSH  1  #define NET_M_NOTRM 2    /*: **  Context structure for tracking a V1-style "connection" */     struct COMPATCTX {     	struct NETLIBIOSBDEF iosb;      	void *ctx;      	unsigned int proto;     	unsigned int rcvsinlen;     	void (*astadr)();     	void *astprm;     	unsigned short *retlenp;      	struct INADDRDEF *retaddr;      	unsigned short *retport; %     	struct NETLIBIOSBDEF *user_iosb;      	struct SINDEF rcvsin;     }; /* **  Forward declarations */5     unsigned int net_assign(struct COMPATCTX **xctx); F     unsigned int net_bind(struct COMPATCTX **xctx, unsigned int proto,8     	    	    unsigned short port, unsigned int threads,$     	    	    unsigned int notpass);9     unsigned int net_get_address(struct COMPATCTX **xctx, ?     	    	    struct dsc$descriptor *host, unsigned int alsize, >     	    	    struct INADDRDEF *alist, unsigned int *alcount);:     unsigned int net_addr_to_name(struct COMPATCTX **xctx,B     	    	    struct INADDRDEF addr, struct dsc$descriptor *name);7     unsigned int net_deassign(struct COMPATCTX **xctx); 6     unsigned int net_get_info(struct COMPATCTX **xctx,>     	    	    struct INADDRDEF *remadr, unsigned int *remport,?     	    	    struct INADDRDEF *lcladr, unsigned int *lclport); R     unsigned int net_get_hostname(struct dsc$descriptor *name, unsigned int *len);5     unsigned int tcp_connect(struct COMPATCTX **xctx, >     	    	    struct dsc$descriptor *node, unsigned int port);:     unsigned int tcp_connect_addr(struct COMPATCTX **xctx,9     	    	    struct INADDRDEF *addr, unsigned int port); 4     unsigned int tcp_accept(struct COMPATCTX **xctx,D     	    	    struct COMPATCTX **newctx, struct NETLIBIOSBDEF *iosb,.     	    	    void (*astadr)(), void *astprm);9     unsigned int tcp_disconnect(struct COMPATCTX **xctx); N     unsigned int tcp_send(struct COMPATCTX **xctx, struct dsc$descriptor *str,=     	    	    unsigned int flags, struct NETLIBIOSBDEF *iosb, .     	    	    void (*astadr)(), void *astprm);Q     unsigned int tcp_receive(struct COMPATCTX **xctx, struct dsc$descriptor *str, I     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm,      	    	    TIME *timeout); R     unsigned int tcp_get_line(struct COMPATCTX **xctx, struct dsc$descriptor *str,I     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm,      	    	    TIME *timeout); I     unsigned int udp_send(struct COMPATCTX **xctx, struct INADDRDEF addr, E     	    	    unsigned short port, void *buf, unsigned short buflen); C     unsigned int udp_receive(struct COMPATCTX **xctx, void *bufptr, =     	    	    unsigned short bufsize, unsigned short *buflen, ?     	    	    struct INADDRDEF *srcaddr, unsigned int *srcport, 8     	    	    TIME *timeout, struct NETLIBIOSBDEF *iosb,.     	    	    void (*astadr)(), void *astprm);;     static void udp_read_completion(struct COMPATCTX *ctx); B     unsigned int net_set_trace_routine(unsigned int (*routine)());L     unsigned int dns_mxlook(struct dsc$descriptor *name, unsigned int *size,?     	    	    	    	unsigned int *count, struct MXRRDEF *mxrr);  /* **  OWN storage  */;     static unsigned int ctxsize = sizeof(struct COMPATCTX); 8     static unsigned int sinsize = sizeof(struct SINDEF);;     static unsigned int inasize = sizeof(struct INADDRDEF); U     static unsigned int which[2] = {NETLIB_K_LOOKUP_DNS, NETLIB_K_LOOKUP_HOST_TABLE}; N     static unsigned int type[2] = {NETLIB_K_TYPE_STREAM, NETLIB_K_TYPE_DGRAM};   /* **++ **  ROUTINE:	net_assign  ** **  FUNCTIONAL DESCRIPTION:  **> **  	Creates a V1 API network context.  Under V1, this routineB **  would also assign a channel to the network device.  While this; **  no longer happens, applications should not be affected.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	NET_ASSIGN  ctxptr  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  **9 **  COMPLETION CODES:	SS$_NORMAL, or any from LIB$GET_VM.  ** **  SIDE EFFECTS:   	None. ** **-- */3 unsigned int net_assign (struct COMPATCTX **xctx) {        unsigned int status;     struct COMPATCTX *ctx;  (     status = lib$get_vm(&ctxsize, &ctx);#     if (!OK(status)) return status;      memset(ctx, 0, ctxsize);     *xctx = ctx;       return SS$_NORMAL;   } /* net_assign */   /* **++ **  ROUTINE:	net_bind  ** **  FUNCTIONAL DESCRIPTION:  **? **  	Binds a network context to a particular port.  For passive < **  connections, also establishes the context as a listener. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **C **  	NETLIB_BIND  ctxptr, protocol [,port] [,backlog] [,notpassive]  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */C unsigned int net_bind (struct COMPATCTX **xctx, unsigned int proto, 8     	    	    unsigned short port, unsigned int threads,%     	    	    unsigned int notpass) {        struct COMPATCTX *ctx;     struct SINDEF sin;     struct NETLIBIOSBDEF iosb;     unsigned int status;     int argc, passive;   /*% **  Make sure we have a valid context  */     VERIFY_CONTEXT(xctx, ctx); /*& **  Make sure we have enough arguments */     SETARGCOUNT(argc);%     if (argc < 2) return SS$_INSFARG;    /*1 **  Use TCP if they specified an invalid protocol  */*     if (proto < 1 || proto > 2) proto = 1;   /* **  Create a V2 socket */6     status = netlib_socket(&ctx->ctx, &type[proto-1]);#     if (!OK(status)) return status;  /* **  Passive mode?  */H     passive = (argc > 4) ? !notpass : ((argc > 2 && port != 0) ? 1 : 0);   /* **  Bind the V2 socket */!     memset(&sin, 0, sizeof(sin)); (     sin.sin_w_family = NETLIB_K_AF_INET;=     sin.sin_w_port = (argc > 2) ? netlib_word_swap(port) : 0;   ;     status = netlib_bind(&ctx->ctx, &sin, &sinsize, &iosb); 0     if (OK(status)) status = iosb.iosb_w_status;     if (!OK(status)) {     	netlib_close(&ctx->ctx);      	ctx->ctx = 0;     	return status;      }    /*2 **  For a passive open, establish the listener now */     if (passive) {I     	status = netlib_listen(&ctx->ctx, (argc > 3) ? &threads : 0, &iosb); 1     	if (OK(status)) status = iosb.iosb_w_status;      	if (!OK(status)) { !     	    netlib_close(&ctx->ctx);      	    ctx->ctx = 0;     	}     }        return status;    } /* net_bind */   /* **++ **  ROUTINE:	net_get_address ** **  FUNCTIONAL DESCRIPTION:I **3 **  	Looks up a host name, returning an IP address.i **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **A **  	NET_GET_ADDRESS  ctxptr, hostname, listsize, alist [,acount]t ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.m ** **  COMPLETION CODES:	See code.N ** **  SIDE EFFECTS:   	None. ** **-- */6 unsigned int net_get_address (struct COMPATCTX **xctx,?     	    	    struct dsc$descriptor *host, unsigned int alsize, ?     	    	    struct INADDRDEF *alist, unsigned int *alcount) {t       struct COMPATCTX *ctx;     unsigned int status;     int argc, i, temp;       VERIFY_CONTEXT(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 4) return SS$_INSFARG;m5     if (host == 0 || alist == 0) return SS$_BADPARAM;        if (ctx->ctx == 0) {'     	status = netlib_socket(&ctx->ctx);d$     	if (!OK(status)) return status;     	temp = 1;     } else temp = 0;       for (i = 0; i < 2; i++) {e:     	status = netlib_name_to_address(&ctx->ctx, &which[i],?     	    	    	host, alist, &alsize, (argc > 4) ? alcount : 0);d     	if (OK(status)) break;      }        if (temp) {u     	netlib_close(&ctx->ctx);n     	ctx->ctx = 0;     }n       return status;   } /* net_get_address */r a /* **++ **  ROUTINE:	net_addr_to_name  ** **  FUNCTIONAL DESCRIPTION:w **3 **  	Looks up an IP address, returning a host name.. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **3 **  	NET_ADDR_TO_NAME  ctxptr, ip-address, hostnameT ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.A ** **  COMPLETION CODES:	See code.P ** **  SIDE EFFECTS:   	None. ** **-- */7 unsigned int net_addr_to_name (struct COMPATCTX **xctx,CC     	    	    struct INADDRDEF addr, struct dsc$descriptor *name) {A     struct COMPATCTX *ctx;     unsigned int status;     int argc, i, temp;       VERIFY_CONTEXT(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 3) return SS$_INSFARG;Y'     if (name == 0) return SS$_BADPARAM;N       if (ctx->ctx == 0) {'     	status = netlib_socket(&ctx->ctx);W$     	if (!OK(status)) return status;     	temp = 1;     } else temp = 0;       for (i = 0; i < 2; i++) {AK     	status = netlib_address_to_name(&ctx->ctx, &which[i], &addr, &inasize,*%     	    	    	    	    	    	 name);t     	if (OK(status)) break;4     }        if (temp) {1     	netlib_close(&ctx->ctx);      	ctx->ctx = 0;     }c       return status;   } /* net_addr_to_name */ c /* **++ **  ROUTINE:	net_deassignV ** **  FUNCTIONAL DESCRIPTION:  **& **  	Closes down a V1 network context. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	NET_DEASSIGN  ctxptrs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  **1 **  COMPLETION CODES:	SS$_NORMAL always returned.  ** **  SIDE EFFECTS:   	None. ** **-- */5 unsigned int net_deassign (struct COMPATCTX **xctx) {u       struct COMPATCTX *ctx;       VERIFY_CONTEXT(xctx, ctx);       if (ctx->ctx != 0) {     	netlib_close(&ctx->ctx);e     	ctx->ctx = 0;     }e        lib$free_vm(&ctxsize, &ctx);       *xctx = 0;       return SS$_NORMAL;   } /* net_deassign */ _ /* **++ **  ROUTINE:	net_get_infoN ** **  FUNCTIONAL DESCRIPTION:_ **G **  	Gets the local and/or remote socket information (address and port)r **  for a connection.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **C **  	NET_GET_INFO  ctxptr, [remadr] [,remport] [,lcladr] [,lclport]r ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.f ** **  COMPLETION CODES:	See code.H ** **  SIDE EFFECTS:   	None. ** **-- */3 unsigned int net_get_info (struct COMPATCTX **xctx, >     	    	    struct INADDRDEF *remadr, unsigned int *remport,@     	    	    struct INADDRDEF *lcladr, unsigned int *lclport) {       struct COMPATCTX *ctx;     struct SINDEF sin;     unsigned int status;     unsigned int retlen;
     int argc;g       VERIFY_CONTEXT(xctx, ctx);     SETARGCOUNT(argc);%     if (argc < 2) return SS$_INSFARG; *     if (ctx->ctx == 0) return SS$_NOLINKS;   /*4 **  Get the remote information, if they asked for it */4     if (remadr != 0 || (argc > 2 && remport != 0)) {E     	status = netlib_getpeername(&ctx->ctx, &sin, &sinsize, &retlen); $     	if (!OK(status)) return status;=     	if (argc > 2 && remport != 0) *remport = sin.sin_w_port;u/     	if (remadr != 0) *remadr = sin.sin_x_addr;      }	   /*7 **  Now get the local information, if they asked for itn */     if (argc > 3) {tE     	status = netlib_getsockname(&ctx->ctx, &sin, &sinsize, &retlen);$     	if (OK(status)) {3     	    if (lcladr != 0) *lcladr = sin.sin_x_addr; A     	    if (argc > 4 && lclport != 0) *lclport = sin.sin_w_port;      	}     }D       return status;   } /* net_get_info */   /* **++ **  ROUTINE:	net_get_hostnamec ** **  FUNCTIONAL DESCRIPTION:t **$ **  	Returns the local IP host name. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **) **  	NET_GET_HOSTNAME  hostname [,retlen]  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.d ** **  SIDE EFFECTS:   	None. ** **-- */P unsigned int net_get_hostname (struct dsc$descriptor *name, unsigned int *len) {       unsigned int status;     unsigned short retlen;
     int argc;i       SETARGCOUNT(argc);0     status = netlib_get_hostname(name, &retlen);:     if (OK(status) && argc > 1 && len != 0) *len = retlen;       return status;   } /* net_get_hostname */   /* **++ **  ROUTINE:	tcp_connect ** **  FUNCTIONAL DESCRIPTION:r **= **  	Performs an active open to establish a TCP connection to  **  a remote system (by name). **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **( **  	TCP_CONNECT  ctxptr, hostname, port ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.a ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */2 unsigned int tcp_connect (struct COMPATCTX **xctx,?     	    	    struct dsc$descriptor *node, unsigned int port) {)       struct COMPATCTX *ctx;     unsigned short p;c     unsigned int status;       VERIFY_CONTEXT(xctx, ctx);       if (ctx->ctx == 0) {<     	status = netlib_socket(&ctx->ctx, &type[ctx->proto-1]);$     	if (!OK(status)) return status;     }B
     p = port; 7     return netlib_connect_by_name(&ctx->ctx, node, &p);i   } /* tcp_connect */t t /* **++ **  ROUTINE:	tcp_connect_addrs ** **  FUNCTIONAL DESCRIPTION:o **9 **  	Performs an active open to establish a connection ton **  a remote system by address.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **, **  	TCP_CONNECT_ADDR  ctxptr, addrptr, port ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.s ** **  SIDE EFFECTS:   	None. ** **-- */7 unsigned int tcp_connect_addr (struct COMPATCTX **xctx,}:     	    	    struct INADDRDEF *addr, unsigned int port) {       struct COMPATCTX *ctx;     struct SINDEF sin;     unsigned int status;       VERIFY_CONTEXT(xctx, ctx);       if (ctx->ctx == 0) {<     	status = netlib_socket(&ctx->ctx, &type[ctx->proto-1]);$     	if (!OK(status)) return status;     }a  !     memset(&sin, 0, sizeof(sin));e(     sin.sin_w_family = NETLIB_K_AF_INET;,     sin.sin_w_port = netlib_word_swap(port);     sin.sin_x_addr = *addr;G5     return netlib_connect(&ctx->ctx, &sin, &sinsize);L   } /* tcp_connect */* * /* **++ **  ROUTINE:	tcp_accepta ** **  FUNCTIONAL DESCRIPTION:E **B **  	Accepts an incoming TCP connection (passive open completion). **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **> **  	TCP_ACCEPT  ctxptr, newctxptr [,iosb] [,astadr] [,astprm] ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.; ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */1 unsigned int tcp_accept (struct COMPATCTX **xctx,aB     	    	    struct COMPATCTX **xnew, struct NETLIBIOSBDEF *iosb,/     	    	    void (*astadr)(), void *astprm) {u        struct COMPATCTX *ctx, *new;
     int argc;*       SETARGCOUNT(argc);%     if (argc < 2) return SS$_INSFARG;c       VERIFY_CONTEXT(xctx, ctx);     VERIFY_CONTEXT(xnew, new);  7     return netlib_accept(&ctx->ctx, &new->ctx, 0, 0, 0, 9     	    	(argc > 2) ? iosb : 0, (argc > 3) ? astadr : 0,n#     	    	(argc > 4) ? astprm : 0);i   } /* tcp_accept */   /* **++ **  ROUTINE:	tcp_disconnect  ** **  FUNCTIONAL DESCRIPTION:i **" **  	Closes down a TCP connection. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	TCP_DISCONNECT  ctxptre ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.; ** **  COMPLETION CODES:	See code.g ** **  SIDE EFFECTS:   	None. ** **-- */7 unsigned int tcp_disconnect (struct COMPATCTX **xctx) {p       struct COMPATCTX *ctx;     unsigned int status;<     static unsigned int shuttype = NETLIB_K_SHUTDOWN_SENDER;       VERIFY_CONTEXT(xctx, ctx);)     if (ctx->ctx == 0) return SS$_NORMAL;   3     status = netlib_shutdown(&ctx->ctx, &shuttype);g?     if (!OK(status) && status != SS$_LINKDISCON) return status;   %     status = netlib_close(&ctx->ctx);0!     if (OK(status)) ctx->ctx = 0;i       return status;   } /* tcp_disconnect */ > /* **++ **  ROUTINE:	tcp_send  ** **  FUNCTIONAL DESCRIPTION:- **9 **  	Sends data on a TCP connection, possibly followed bys **  a CR/LF sequence.f **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **B **  	TCP_SEND  ctxptr, strdsc [,flags] [,iosb] [,astadr] [,astprm] ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.3 ** **  COMPLETION CODES:	See code.O ** **  SIDE EFFECTS:   	None. ** **-- */K unsigned int tcp_send (struct COMPATCTX **xctx, struct dsc$descriptor *str, >     	    	    	unsigned int flags, struct NETLIBIOSBDEF *iosb,0     	    	    	void (*astadr)(), void *astprm) {       struct COMPATCTX *ctx;     unsigned int f;t
     int argc;g       VERIFY_CONTEXT(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 2) return SS$_INSFARG;R&     if (str == 0) return SS$_BADPARAM;*     if (ctx->ctx == 0) return SS$_NOLINKS;       f = (argc > 2) ? flags : 0;*       if (f & NET_M_NOTRM) {E     	return netlib_write(&ctx->ctx, str, 0, 0, (argc > 3) ? iosb : 0, @     	    	    (argc > 4) ? astadr : 0, (argc > 5) ? astprm : 0);     } else {C     	return netlib_writeline(&ctx->ctx, str, (argc > 3) ? iosb : 0,u@     	    	    (argc > 4) ? astadr : 0, (argc > 5) ? astprm : 0);     }t   } /* tcp_send */ a /* **++ **  ROUTINE:	tcp_receive ** **  FUNCTIONAL DESCRIPTION:E **% **  	Reads data off a TCP connection.n **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **G **  	TCP_RECEIVE  ctxptr, bufdsc [,iosb] [,astadr] [,astprm] [,timeout]n ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.n ** **  SIDE EFFECTS:   	None. ** **-- */N unsigned int tcp_receive (struct COMPATCTX **xctx, struct dsc$descriptor *str,I     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm,x     	    	    TIME *timeout) {       struct COMPATCTX *ctx;     struct dsc$descriptor dsc;     unsigned int status;
     int argc;D       VERIFY_CONTEXT(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 2) return SS$_INSFARG;,&     if (str == 0) return SS$_BADPARAM;*     if (ctx->ctx == 0) return SS$_NOLINKS;   /*J **  HACK to support broken MGFTP code, which passes us a static descriptor, **  which is set up as a dynamic descriptor! */K     status = lib$analyze_sdesc(str, &dsc.dsc$w_length, &dsc.dsc$a_pointer);_$     dsc.dsc$b_dtype = DSC$K_DTYPE_T;$     dsc.dsc$b_class = DSC$K_CLASS_S;  J     return netlib_read(&ctx->ctx, &dsc, 0, 0, 0, (argc > 5) ? timeout : 0,>     	    	    	(argc > 2) ? iosb : 0, (argc > 3) ? astadr : 0,(     	    	    	(argc > 4) ? astprm : 0);   } /* tcp_receive */    /* **++ **  ROUTINE:	tcp_get_line  ** **  FUNCTIONAL DESCRIPTION:s **G **  	Reads a "line" of data (a string of characters which is terminated 3 **  with a CR/LF sequence) from the TCP connection.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **I **  	TCP_GET_LINE  ctxptr, bufdsc [,iosb] [,astadr] [,astprm], [,timeout]  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */O unsigned int tcp_get_line (struct COMPATCTX **xctx, struct dsc$descriptor *str,eI     	    	    struct NETLIBIOSBDEF *iosb, void (*astadr)(), void *astprm,y     	    	    TIME *timeout) {     struct COMPATCTX *ctx;2     static unsigned int flags = NETLIB_M_ALLOW_LF;(     static TIME default_timeout = {1,0};     static int did_timeout = 0;*<     static $DESCRIPTOR(default_timeoutdsc, "0 00:10:00.00");
     int argc;        VERIFY_CONTEXT(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 2) return SS$_INSFARG;-&     if (str == 0) return SS$_BADPARAM;*     if (ctx->ctx == 0) return SS$_NOLINKS;  Z     if (!did_timeout) did_timeout = OK(sys$bintim(&default_timeoutdsc, &default_timeout));  5     return netlib_readline(&ctx->ctx, str, 0, &flags,NG     	    	    	(argc > 5 && timeout != 0) ? timeout : &default_timeout,n>     	    	    	(argc > 2) ? iosb : 0, (argc > 3) ? astadr : 0,(     	    	    	(argc > 4) ? astprm : 0);   } /* tcp_get_line */ P /* **++ **  ROUTINE:	udp_send, ** **  FUNCTIONAL DESCRIPTION:l ** **  	Sends a UDP datagram. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **4 **  	UDP_SEND  ctxptr, address, port, bufptr, buflen ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.e ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */F unsigned int udp_send (struct COMPATCTX **xctx, struct INADDRDEF addr,B     	    	unsigned short port, void *buf, unsigned short buflen) {       struct COMPATCTX *ctx;     struct SINDEF sin;     struct dsc$descriptor dsc;       VERIFY_CONTEXT(xctx, ctx);*     if (ctx->ctx == 0) return SS$_NOLINKS;  $     dsc.dsc$b_dtype = DSC$K_DTYPE_T;$     dsc.dsc$b_class = DSC$K_CLASS_S;     dsc.dsc$w_length = buflen;     dsc.dsc$a_pointer = buf;!     memset(&sin, 0, sizeof(sin));s(     sin.sin_w_family = NETLIB_K_AF_INET;     sin.sin_x_addr = addr;,     sin.sin_w_port = netlib_word_swap(port);  9     return netlib_write(&ctx->ctx, &dsc, &sin, &sinsize);o   } /* udp_send */ f /* **++ **  ROUTINE:	udp_receive ** **  FUNCTIONAL DESCRIPTION:t ** **  	Receives a UDP datagram.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **> **  	UDP_RECEIVE  ctxptr, bufptr, bufsize [,retlen] [,srcaddr]@ **  	    	     [,srcport] [,timeout] [,iosb] [,astadr] [,astprm] **D **  N.B.:  for synchronous calls, srcport should be the address of aC **  	   longword.  For asynchronous calls, it should be the addressu **  	   of a word. ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.m ** **  COMPLETION CODES:	See code.: ** **  SIDE EFFECTS:   	None. ** **-- */@ unsigned int udp_receive (struct COMPATCTX **xctx, void *bufptr,=     	    	    unsigned short bufsize, unsigned short *buflen,t?     	    	    struct INADDRDEF *srcaddr, unsigned int *srcport,n8     	    	    TIME *timeout, struct NETLIBIOSBDEF *iosb,/     	    	    void (*astadr)(), void *astprm) {l       struct COMPATCTX *ctx;     struct SINDEF sin;     struct dsc$descriptor dsc;     unsigned int status;
     int argc;+       VERIFY_CONTEXT(xctx, ctx);     SETARGCOUNT(argc);  %     if (argc < 3) return SS$_INSFARG;s)     if (bufptr == 0) return SS$_BADPARAM;s*     if (ctx->ctx == 0) return SS$_NOLINKS;  $     dsc.dsc$b_dtype = DSC$K_DTYPE_T;$     dsc.dsc$b_class = DSC$K_CLASS_S;     dsc.dsc$a_pointer = bufptr;      dsc.dsc$w_length = bufsize;*  "     if (argc > 8 && astadr != 0) {"     	ctx->retaddr = srcaddr;      /     	ctx->retport = (unsigned short *) srcport;d     	ctx->retlenp = buflen;A     	ctx->user_iosb = iosb;t     	ctx->astadr = astadr;+     	ctx->astprm = (argc > 9) ? astprm : 0;*  @     	return netlib_read(&ctx->ctx, &dsc, &ctx->rcvsin, &sinsize,8     	    	    	    &ctx->rcvsinlen, timeout, &ctx->iosb,-     	    	    	    udp_read_completion, ctx);-     }   A     status = netlib_read(&ctx->ctx, &dsc, &ctx->rcvsin, &sinsize,nA     	    	&ctx->rcvsinlen, (argc > 6) ? timeout : 0, &ctx->iosb);*       if (OK(status)) {TC     	if (argc > 3 && buflen != 0) *buflen = ctx->iosb.iosb_w_count;rE     	if (argc > 4 && srcaddr != 0) *srcaddr = ctx->rcvsin.sin_x_addr; "     	if (argc > 5 && srcport != 0)=     	    *srcport = netlib_word_swap(ctx->rcvsin.sin_w_port);T     }*K     if (argc > 7 && iosb != 0) memcpy(iosb, &ctx->iosb, sizeof(ctx->iosb));.       return status;   } /* udp_receive */O E /* **++  **  ROUTINE:	udp_read_completion ** **  FUNCTIONAL DESCRIPTION:d **G **  	AST completion routine for asynchronous UDP_READ calls.  Does someD< **  pre-processing before invoking the caller's AST routine. ** **  RETURNS:	void  ** **  PROTOTYPE: ** **  	UDP_READ_COMPLETION  ctxx ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.> ** **  COMPLETION CODES:	None.i ** **  SIDE EFFECTS:   	None. ** **-- */9 static void udp_read_completion (struct COMPATCTX *ctx) {I   /*E **  Stash the originating address and port, if the caller wanted themr */&     if (OK(ctx->iosb.iosb_w_status)) {E     	if (ctx->retaddr != 0) *(ctx->retaddr) = ctx->rcvsin.sin_x_addr;N     	if (ctx->retport != 0)ID     	    *(ctx->retport) = netlib_word_swap(ctx->rcvsin.sin_w_port);E     	if (ctx->retlenp != 0) *(ctx->retlenp) = ctx->iosb.iosb_w_count;      }n   /*$ **  Stash the IOSB, if it was wanted */S     if (ctx->user_iosb != 0) memcpy(ctx->user_iosb, &ctx->iosb, sizeof(ctx->iosb));    /*# **  Invoke the caller's AST routineO */      (*ctx->astadr)(ctx->astprm);   } /* udp_read_completion */    /* **++" **  ROUTINE:	net_set_trace_routine ** **  FUNCTIONAL DESCRIPTION:C **C **  	This routine was used in the V1 interface for tracing activityo; **  of the MX lookup routine.  It no longer has any effect.r **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **" **  	NET_SET_TRACE_ROUTINE  rtnptr ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  **1 **  COMPLETION CODES:	SS$_NORMAL always returned.0 ** **  SIDE EFFECTS:   	None. ** **-- */@ unsigned int net_set_trace_routine (unsigned int (*routine)()) {       return SS$_NORMAL;   } /* net_set_trace_routine */n t /* **++ **  ROUTINE:	dns_mxlookl ** **  FUNCTIONAL DESCRIPTION:y **A **  	Looks up MX RR's in the DNS for a domain name.  Returns themME **  in an array of special structures (the same structure is used forI' **  the V2 equivalent of this routine).S **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **5 **  	DNS_MXLOOK  name, mxrrsize [,mxrrcount], mxrrptru ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.N ** **  COMPLETION CODES:	See code.  ** **  SIDE EFFECTS:   	None. ** **-- */H unsigned int dns_mxlook(struct dsc$descriptor *name, unsigned int *size,?     	    	    	    unsigned int *count, struct MXRRDEF *mxrr) {0       void *ctx;     unsigned int status;  !     status = netlib_socket(&ctx); #     if (!OK(status)) return status;nA     status = netlib_dns_mx_lookup(&ctx, name, mxrr, size, count);c     netlib_close(&ctx);w       return status;   } /* dns_mxlook */