 /*
  *  virtdom.c   *@  *  ADDRESS_REWRITER callout for implementing "virtual" domains.  *A  *  Copyright  2000,2001 MadGoat Software.  All Rights Reserved.   *  */  #include "virtdom.h" #include <lib$routines.h>  #include <str$routines.h>    /*    * Forward declarations   */ %     vms_status_t INIT(void **ctxptr); R     vms_status_t REWRITE_HEADER(void **ctxptr, const struct dsc$descriptor *inadr,C     	    	    	    	struct dsc$descriptor *outadr, u_int16_t code); T     vms_status_t REWRITE_ENVELOPE(void **ctxptr, const struct dsc$descriptor *inadr,3     	    	    	    	struct dsc$descriptor *outadr); Z     int	    	 REWRITE_VIRTUAL_DOMAIN(void **ctxptr, const struct dsc$descriptor *domname);(     vms_status_t CLEANUP(void **ctxptr);   /*  *  Local static storage  */      static config_t 	 cfg;%     static int	    	 initialized = 0; "     static int	    	 dummy = 1234;   /*  *  External references   */ K     vms_status_t PARSE821(const struct dsc$descriptor *inadr, void *rteque, J     	    	    	 struct dsc$descriptor *usrd, struct dsc$descriptor *domd);   /*  *  ROUTINE:	INIT   *  *  DESCRIPTION:=  *  	Initializes for address rewriting.  Checks to see if the ;  *  	configuration has changed; if so, it re-reads whatever 2  *  	parts of the configuration have been updated.  *  *  PARAMETERS: =  *  	ctxptr:	    address of context, write only, by reference   *   *  RETURNS:	VMS condition value  */ # vms_status_t INIT (void **ctxptr) {        vms_status_t status;       if (!initialized) {      	mem_init();'     	status = load_configuration(&cfg);      	if (!OK(status))      	    return status;      	initialized = 1;      }   (     status = reload_configuration(&cfg);     if (!OK(status)) {      	unload_configuration(&cfg);     	initialized = 0;      	return status;      }        *ctxptr = &dummy;        return SS$_NORMAL;   } /* INIT */   /*    *  ROUTINE:	REWRITE_HEADER   *  *  DESCRIPTION:=  *  	Currently does nothing.  Could be updated to do backward E  *  	mapping between "real" and "virtual" addresses in From: headers.   *  *  PARAMETERS: 6  *  	ctxptr:	    context pointer, modify, by reference5  *  	inadr:	    char_string, read only, by descriptor 7  *  	outadr:	    char_string, write only, by descriptor 1  *  	code:	    word_unsigned, read only, by value   *  *  RETURNS:  VMS status code   */ O vms_status_t REWRITE_HEADER (void **ctxptr, const struct dsc$descriptor *inadr, D     	    	    	     struct dsc$descriptor *outadr, u_int16_t code) {  '     return 0;  /* no header rewrites */    } /* REWRITE_HEADER */   /*    *  ROUTINE:	REWRITE_ENVELOPE   *  *  DESCRIPTION:9  *  	Maps recipient "virtual" addresses into their "real"   *  	counterparts.  *  *  PARAMETERS: 6  *  	ctxptr:	    context pointer, modify, by reference5  *  	inadr:	    char_string, read only, by descriptor 7  *  	outadr:	    char_string, write only, by descriptor   *  *  RETURNS:  VMS status code   */ Q vms_status_t REWRITE_ENVELOPE (void **ctxptr, const struct dsc$descriptor *inadr, 6     	    	    	       struct dsc$descriptor *outadr) {  '     struct dsc$descriptor   usrd, domd;      domain_t	    	    *dom;      mailbox_t	    	    *mbx;      vms_status_t    	    status;     int	    	    	    i, j; (     static $DESCRIPTOR(ctrstr, "<!AD>");       INIT_DYNDESC(&usrd);     INIT_DYNDESC(&domd);  .     status = PARSE821(inadr, 0, &usrd, &domd);     if (!OK(status))     	return status;   =     i = dom_name_hash(domd.dsc$a_pointer, domd.dsc$w_length); C     for (dom = cfg.cfg_domhash[i]; dom != 0; dom = dom->dom_next) { 1     	if (dom->dom_namelen == domd.dsc$w_length && Q     	    	strncasecmp(dom->dom_name, domd.dsc$a_pointer, domd.dsc$w_length) == 0)      	    break;      }        if (dom == 0) {      	STR$FREE1_DX(&usrd);      	STR$FREE1_DX(&domd);      	return 0;     }   =     j = mbx_name_hash(usrd.dsc$a_pointer, usrd.dsc$w_length); D     for (mbx = dom->dom_mbxhash[j]; mbx != 0; mbx = mbx->mbx_next) {1     	if (mbx->mbx_namelen == usrd.dsc$w_length && Q     	    	strncasecmp(mbx->mbx_name, usrd.dsc$a_pointer, usrd.dsc$w_length) == 0)      	    break;      }        if (mbx == 0) {      	if (dom->dom_defrw == 0)      	    return 0;     	mbx = dom->dom_defrw;     }        STR$FREE1_DX(&usrd);     STR$FREE1_DX(&domd);  P     return LIB$SYS_FAO(&ctrstr, 0, outadr, mbx->mbx_rwaddrlen, mbx->mbx_rwaddr);   } /* REWRITE_ENVELOPE */   /*  #  *  ROUTINE:	REWRITE_VIRTUAL_DOMAIN   *  *  DESCRIPTION:   *  	Identifies virtual domains.  *  *  PARAMETERS: 6  *  	ctxptr:	    context pointer, modify, by reference6  *  	domname:    char_string, read only, by descriptor  *  *  RETURNS:  int (1=yes, 0=no)   */ O int REWRITE_VIRTUAL_DOMAIN (void **ctxptr, const struct dsc$descriptor *domp) {        domain_t	*dom;     int	    	 i;        if (domp->dsc$w_length == 0)         return 0;   ?     i = dom_name_hash(domp->dsc$a_pointer, domp->dsc$w_length); C     for (dom = cfg.cfg_domhash[i]; dom != 0; dom = dom->dom_next) { 2     	if (dom->dom_namelen == domp->dsc$w_length &&S     	    	strncasecmp(dom->dom_name, domp->dsc$a_pointer, domp->dsc$w_length) == 0)      	    break;      }        return (dom == 0 ? 0 : 1);   } /* REWRITE_VIRTUAL_DOMAIN */   /*  *  ROUTINE:	CLEANUP  *  *  DESCRIPTION:2  *  	Cleans up after a rewrite sequence.  For this4  *  	module, there is no per-lookup context, so this  *  	routine does nothing.  *  *  PARAMETERS: =  *  	ctxptr:	    address of context, write only, by reference   *   *  RETURNS:	VMS condition value  */ & vms_status_t CLEANUP (void **ctxptr) {       *ctxptr = 0;       return SS$_NORMAL;   } /* CLEANUP */ 