 /*	  *  mem.c   *K  *  Memory management routines for virtual domain ADDRESS_REWRITER callout.   *=  *  Copyright  2000, MadGoat Software.  All Rights Reserved.   */  #include "virtdom.h" #include <lib$routines.h>  #include <libvmdef.h>    /*  *  Forward declarations  */      void    	 mem_init(void); E     domain_t 	*mem_domain_alloc(const char *name, u_int16_t namelen); -     void    	 mem_domain_free(domain_t *dom); l     mailbox_t 	*mem_mailbox_alloc(const char *name, u_int16_t namelen, const char *addr, u_int16_t addrlen);/     void    	 mem_mailbox_free(mailbox_t *mbx);    /*  *  Local static storage  */ /     static u_int32_t	domain_zone, mailbox_zone;    /*  *  ROUTINE:	mem_init   *  *  DESCRIPTION:>  *  	Initializes the memory zones for use with these routines.  *  *  PARAMETERS:	none  *  *  RETURNS:	void   */  void mem_init (void) {       vms_status_t    status; 0     u_int32_t	    alg	    = LIB$K_VM_FREQ_SIZES;     u_int32_t	    param   = 8;F     u_int32_t	    flags   = LIB$M_VM_GET_FILL0 | LIB$M_VM_EXTEND_AREA;  D     status = LIB$CREATE_VM_ZONE(&domain_zone, &alg, &param, &flags);     if (!OK(status))     	domain_zone = 0;   E     status = LIB$CREATE_VM_ZONE(&mailbox_zone, &alg, &param, &flags);      if (!OK(status))     	mailbox_zone = 0;   } /* mem_init */       /*  *  ROUTINE:	mem_domain_alloc   *  *  DESCRIPTION:F  *  	Allocates a domain structure from the domain zone, filling in the
  *  	name.  *  *  PARAMETERS: 3  *  	name:	    char_string, read only, by reference 3  *  	namelen:    word_unsigned, read only, by value   *  *  RETURNS:	domain_t pointer   *  	0:  	error occurred  *  	non-0:	valid pointer   */ B domain_t *mem_domain_alloc (const char *name, u_int16_t namelen) {  2     int32_t 	    len = sizeof(domain_t) + namelen;     domain_t	    *dom;     vms_status_t    status;      2     status = LIB$GET_VM(&len, &dom, &domain_zone);     if (!OK(status))     	return 0;       dom->dom_namelen = namelen; )     memcpy(dom->dom_name, name, namelen); S     dom->dom_name[namelen] = '\0';  	/* should already be null, but just in case */        return dom;    } /* mem_domain_alloc */   /*  *  ROUTINE:	mem_domain_free  *  *  DESCRIPTION:=  *  	Frees a domain structure, including any attached mailbox "  *  	structures in its hash table.  *  *  PARAMETERS: ,  *  	dom:	    domain_t, modify, by reference  *  *  RETURNS:	void   */ & void mem_domain_free (domain_t *dom) {       mailbox_t	*mbx, *mbxnext; 7     int32_t 	len = sizeof(domain_t) + dom->dom_namelen;      int     	i;   (     for (i = 0; i < MBX_K_HTSIZE; i++) {?     	for (mbx = dom->dom_mbxhash[i]; mbx != 0; mbx = mbxnext) { !     	    mbxnext = mbx->mbx_next;      	    mem_mailbox_free(mbx);      	}     }        if (dom->dom_defrw != 0)&     	mem_mailbox_free(dom->dom_defrw);  *     LIB$FREE_VM(&len, &dom, &domain_zone);   } /* mem_domain_free */    /*  *  ROUTINE:	mem_mailbox_alloc  *  *  DESCRIPTION:H  *  	Allocates a mailbox structure from the mailbox zone, filling in the  *  	name and rewrite address.  *  *  PARAMETERS: 3  *  	name:	    char_string, read only, by reference 3  *  	namelen:    word_unsigned, read only, by value 3  *  	addr:	    char_string, read only, by reference 3  *  	addrlen:    word_unsigned, read only, by value   *  *  RETURNS:	mailbox_t pointer  *  	0:  	error occurred  *  	non-0:	valid pointer   */ i mailbox_t *mem_mailbox_alloc (const char *name, u_int16_t namelen, const char *addr, u_int16_t addrlen) {   2     int32_t 	    len = sizeof(domain_t) + addrlen;     mailbox_t	    *mbx;      vms_status_t    status;      3     status = LIB$GET_VM(&len, &mbx, &mailbox_zone);      if (!OK(status))     	return 0;       mbx->mbx_namelen = namelen; )     memcpy(mbx->mbx_name, name, namelen); S     mbx->mbx_name[namelen] = '\0';  	/* should already be null, but just in case */ !     mbx->mbx_rwaddrlen = addrlen; +     memcpy(mbx->mbx_rwaddr, addr, addrlen); S     mbx->mbx_rwaddr[addrlen] = '\0';	/* should already by null, but just in case */        return mbx;    } /* mem_mailbox_alloc */    /*  *  ROUTINE:	mem_mailbox_free   *  *  DESCRIPTION:  *  	Frees a mailbox structure.   *  *  PARAMETERS: -  *  	mbx:	    mailbox_t, modify, by reference   *  *  RETURNS:	void   */ ( void mem_mailbox_free (mailbox_t *mbx) {  :     int32_t 	len = sizeof(mailbox_t) + mbx->mbx_rwaddrlen;  +     LIB$FREE_VM(&len, &mbx, &mailbox_zone);    } /* mem_mailbox_free */