 /*
  *  virtdom.h   *:  *  Header file for the "virtual domain" address rewriter.  *=  *  COPYRIGHT  2000, MadGoat Software.  All Rights Reserved.   */  #ifndef virtdom_h__  #define virtdom_h__    #define  __NEW_STARLET #include <bitypes.h> #include <descrip.h> #include <stsdef.h>  #include <ssdef.h> #include <string.h>  #include <strings.h>  2 #define OK(status__) $VMS_STATUS_SUCCESS(status__)  2     static inline void INIT_DYNDESC (void *Xdsc) {+     	    struct dsc$descriptor *dsc = Xdsc; *     	    dsc->dsc$b_class = DSC$K_CLASS_D;*     	    dsc->dsc$b_dtype = DSC$K_DTYPE_T;     	    dsc->dsc$w_length = 0;       	    dsc->dsc$a_pointer = 0;     } O     static inline void INIT_SDESC (void *Xdsc, unsigned short len, void *ptr) { +     	    struct dsc$descriptor *dsc = Xdsc; *     	    dsc->dsc$b_class = DSC$K_CLASS_S;*     	    dsc->dsc$b_dtype = DSC$K_DTYPE_T;!     	    dsc->dsc$w_length = len; "     	    dsc->dsc$a_pointer = ptr;     }    #define MBX_S_NAME  	64  #define MBX_K_HTSIZE	256 #define DOM_K_HTSIZE	256 #define MAX_FN_LEN  	256        typedef int64_t 	vms_time_t;#     typedef u_int32_t	vms_status_t;        typedef struct mailbox_ { #     	struct mailbox_	    *mbx_next;      	int 	    	     mbx_valid;      	u_int16_t	     mbx_namelen;"     	u_int16_t	     mbx_rwaddrlen;)     	char	    	     mbx_name[MBX_S_NAME]; "     	char	    	     mbx_rwaddr[1];     } mailbox_t;       typedef struct domain_ {"     	struct domain_	    *dom_next;1     	mailbox_t   	    *dom_mbxhash[MBX_K_HTSIZE]; !     	mailbox_t   	    *dom_defrw; !     	vms_time_t  	     dom_moddt;      	int 	    	     dom_valid;     	int 	    	     dom_loaded;      	u_int16_t	     dom_fnlen;      	u_int16_t	     dom_namelen;*     	char	    	     dom_fname[MAX_FN_LEN];      	char	    	     dom_name[1];     } domain_t;        typedef struct {1     	domain_t    	    *cfg_domhash[DOM_K_HTSIZE]; !     	vms_time_t  	     cfg_moddt; !     	u_int16_t   	     cfg_fnlen; *     	char	    	     cfg_fname[MAX_FN_LEN];     } config_t;        /*J      *	N.B.: The following hash functions are case-insensitive.  Make sureU      *	      that if you change them, any new hash function is also case-insensitive.       *Q      *	Mailbox name hash function uses first and last characters in mailbox name. J      *	Domain name hash function uses first two characters in domain name.      */ E     static inline int mbx_name_hash (char *name, u_int16_t namelen) { Q     	return (MBX_K_HTSIZE-1) & ((name[0] & 0xf) << 4) | (name [namelen-1] & 0xf);      }   E     static inline int dom_name_hash (char *name, u_int16_t namelen) { g     	return (DOM_K_HTSIZE-1) & ((name[0] & 0xf) << 4) | (namelen < 2 ? (' ' & 0xf) : (name [1] & 0xf));      }   %     vms_status_t INIT(void **ctxptr); R     vms_status_t REWRITE_HEADER(void **ctxptr, const struct dsc$descriptor *inadr,C     	    	    	    	struct dsc$descriptor *outadr, u_int16_t code); T     vms_status_t REWRITE_ENVELOPE(void **ctxptr, const struct dsc$descriptor *inadr,3     	    	    	    	struct dsc$descriptor *outadr); Z     int	    	 REWRITE_VIRTUAL_DOMAIN(void **ctxptr, const struct dsc$descriptor *domname);(     vms_status_t CLEANUP(void **ctxptr);       void    	 mem_init(void); E     domain_t 	*mem_domain_alloc(const char *name, u_int16_t namelen); -     void    	 mem_domain_free(domain_t *dom); l     mailbox_t 	*mem_mailbox_alloc(const char *name, u_int16_t namelen, const char *addr, u_int16_t addrlen);/     void    	 mem_mailbox_free(mailbox_t *mbx); 3     vms_status_t load_configuration(config_t *cfg); 5     vms_status_t reload_configuration(config_t *cfg); 2     void    	 unload_configuration(config_t *cfg);      #endif /* virtdom_h__ */