 /*  *  config.c  *G  *  Configuration routines for virtual domain ADDRESS_REWRITER callout.   *B  *  Copyright  2000,2001  MadGoat Software.  All Rights Reserved.  */  #include "virtdom.h" #include <starlet.h> #include <lib$routines.h>  #include <rms.h> #include <stdarg.h>  #include <stdio.h>   /*  *  Forward declarations  */ ;     	    vms_status_t    load_configuration(config_t *cfg); =     	    vms_status_t    reload_configuration(config_t *cfg); :     	    void    	    unload_configuration(config_t *cfg);D     static  vms_status_t    do_config(config_t *cfg, int reloading);6     static  vms_status_t    do_domains(config_t *cfg);n     static  int	    	    validate_file(const char *fname, u_int16_t fnlen, const char *dname, u_int16_t dnlen,H     	    	    	    	    	  char *rspec, u_int16_t rss, vms_time_t *rdt);e     static  int	    	    get_next_line(RABDEF *rab, char **linepp, u_int16_t *countp, int *linenump); j     static  int	    	    get_next_word(char **linepp, u_int16_t *remainp, char **wordpp, u_int16_t *lenp);U     static  void    	    unquote_word(const char *srcp, u_int16_t srclen, char *dstp, A     	    	    	    	    	 u_int16_t dstsize, u_int16_t *dstlenp); 9     static  void    	    log_error(const char *fmt, ...);         /*  *  ROUTINE:	load_configuration   *  *  DESCRIPTION:7  *  	Loads the configuration file and the domain files; -  *  	assumes no configuration already loaded.   *  *  PARAMETERS: ,  *  	cfg:	    config_t, modify, by reference  *   *  RETURNS:	VMS condition value  */ 1 vms_status_t load_configuration (config_t *cfg) {        vms_status_t    status;        status = do_config(cfg, 0);      if (!OK(status))     	return status;        return do_domains(cfg);    } /* load_configuration */   /*!  *  ROUTINE:	reload_configuration   *  *  DESCRIPTION:5  *  	Reloads the configuration file and domain files, /  *  	updating the live configuration as needed.   *  *  PARAMETERS: ,  *  	cfg:	    config_t, modify, by reference  *   *  RETURNS:	VMS condition value  */ 3 vms_status_t reload_configuration (config_t *cfg) {        vms_status_t    status;        status = do_config(cfg, 1);      if (!OK(status))     	return status;        return do_domains(cfg);    } /* reload_configuration */   /*!  *  ROUTINE:	unload_configuration   *  *  DESCRIPTION:4  *  	Resets the configuration, freeing up all of the  *  	mailboxes and domains.   *  *  PARAMETERS: ,  *  	cfg:	    config_t, modify, by reference  *  *  RETURNS:	void   */ + void unload_configuration (config_t *cfg) {        domain_t	*dom, *domnext;     int     	i;   (     for (i = 0; i < DOM_K_HTSIZE; i++) {?     	for (dom = cfg->cfg_domhash[i]; dom != 0; dom = domnext) { !     	    domnext = dom->dom_next;      	    mem_domain_free(dom);     	}     	cfg->cfg_domhash[i] = 0;      }        cfg->cfg_fnlen = 0;      cfg->cfg_moddt = 0;    } /* unload_configuration */   /*  *  ROUTINE:	do_config  *  *  DESCRIPTION:-  *  	Reads and parses the configuration file.   *  *  PARAMETERS: ,  *  	cfg:	    config_t, modify, by reference)  *  	reloading:  int, read only, by value   *   *  RETURNS:	VMS condition value  */ > static vms_status_t do_config (config_t *cfg, int reloading) {       FABDEF  	    fab;      RABDEF  	    rab;      NAMDEF  	    nam;      XABRDTDEF	    xabrdt;      vms_status_t    status; D     char    	    *linep, *wordp, *fnamep, *dirnamep, *dnamep, *msgp;A     u_int16_t	    count, wordlen, fnamelen, dirnamelen, dnamelen;       domain_t	    *dom, *domnext;     vms_time_t	    moddt;      int	    	    linenum, i;8     char    	    line_buffer[2048], dirname[MAX_FN_LEN];K     char    	    espec[MAX_FN_LEN], rspec [MAX_FN_LEN], fnbuf [MAX_FN_LEN];        fab = cc$rms_fab;      nam = cc$rms_nam;      xabrdt = cc$rms_xabrdt;        fab.fab$b_fac = FAB$M_GET;!     fab.fab$b_shr = FAB$M_SHRGET; (     fab.fab$l_fna = "MX_VIRTDOM_CONFIG";*     fab.fab$b_fns = strlen(fab.fab$l_fna);"     fab.fab$l_dna = "MX_DIR:.DAT";*     fab.fab$b_dns = strlen(fab.fab$l_dna);     fab.fab$l_xab = &xabrdt;     fab.fab$l_nam = &nam;      nam.nam$l_esa = espec;!     nam.nam$b_ess = MAX_FN_LEN-1;      nam.nam$l_rsa = rspec;!     nam.nam$b_rss = MAX_FN_LEN-1;        status = SYS$OPEN(&fab);     if (!OK(status))     	return status;        rab = cc$rms_rab;      rab.rab$l_fab = &fab;      rab.rab$v_rah = 1;     status = SYS$CONNECT(&rab);      if (!OK(status)) {     	SYS$CLOSE(&fab);      	nam.nam$v_synchk = 1;     	SYS$PARSE(&fab);      	return status;      }        /*;      *	If no change to configuration file, don't re-read it       */      if (reloading) {+     	if (nam.nam$b_rsl == cfg->cfg_fnlen && L     	    	strncasecmp(nam.nam$l_rsa, cfg->cfg_fname, cfg->cfg_fnlen) == 0 &&/     	    	xabrdt.xab$q_rdt == cfg->cfg_moddt) {      	    SYS$CLOSE(&fab);      	    nam.nam$v_synchk = 1;     	    SYS$PARSE(&fab);      	    return SS$_NORMAL;      	}       	/* >     	 *  Invalidate all of the domains in the table, so we canF     	 *  delete them if they aren't in the updated configuration file.     	 */'     	for (i = 0; i < DOM_K_HTSIZE; i++) G     	    for (dom = cfg->cfg_domhash[i]; dom != 0; dom = dom->dom_next) /     	    	dom->dom_valid = dom->dom_loaded = 0;      } /* if reloading */        rab.rab$l_ubf = line_buffer;(     rab.rab$w_usz = sizeof(line_buffer);       linenum = 0;     dirnamep = "MX_DIR:"; "     dirnamelen = strlen(dirnamep);  &     msgp = "configuration file empty";     status = 0;   ;     while (get_next_line(&rab, &linep, &count, &linenum)) {        	status = 0;  4     	msgp = "expecting \"domain\" or \"directory\"";;     	if (!get_next_word(&linep, &count, &wordp, &wordlen))       	    break;   C     	if (wordlen == 9 && strncasecmp(wordp, "directory", 9) == 0) { +     	    msgp = "expecting directory name"; >     	    if (!get_next_word(&linep, &count, &wordp, &wordlen))     	    	break;P             unquote_word(wordp, wordlen, dirname, sizeof(dirname), &dirnamelen);     	    dirnamep = dirname;     	    continue;     	}  >     	if (wordlen != 6 || strncasecmp(wordp, "domain", 6) != 0)     	    break;   $     	msgp = "expecting domain name";<     	if (!get_next_word(&linep, &count, &dnamep, &dnamelen))     	    break;   "     	msgp = "invalid domain name";     	if (dnamelen < 2)     	    break;   !     	msgp = "expecting \"file\""; :     	if (!get_next_word(&linep, &count, &wordp, &wordlen))     	    break; <     	if (wordlen != 4 || strncasecmp(wordp, "file", 4) != 0)     	    break;   "     	msgp = "expecting file name";<     	if (!get_next_word(&linep, &count, &fnamep, &fnamelen))     	    break;   E     	unquote_word(fnamep, fnamelen, fnbuf, sizeof(fnbuf), &fnamelen);      	fnamep = fnbuf;  $     	msgp = "domain file not found";^     	if (!validate_file(fnamep, fnamelen, dirnamep, dirnamelen, espec, sizeof(espec), &moddt))     	    break;      	fnamep = espec;     	fnamelen = strlen(espec);  )     	i = dom_name_hash(dnamep, dnamelen);      	if (reloading) { G     	    for (dom = cfg->cfg_domhash[i]; dom != 0; dom = dom->dom_next) -     	    	if (dom->dom_namelen == dnamelen && A     	    	    	strncasecmp(dom->dom_name, dnamep, dnamelen) == 0)      	    	    break;     	    if (dom != 0) {+     	    	if (fnamelen == dom->dom_fnlen && D     	    	    	strncasecmp(fnamep, dom->dom_fname, fnamelen) == 0 &&'     	    	    	dom->dom_moddt == moddt) "     	    	    dom->dom_loaded = 1;
     	    }     	} else      	    dom = 0;        	if (dom == 0) {2     	    dom = mem_domain_alloc(dnamep, dnamelen);-     	    dom->dom_next = cfg->cfg_domhash[i]; #     	    cfg->cfg_domhash[i] = dom; #     	    dom->dom_fnlen = fnamelen; 2     	    memcpy(dom->dom_fname, fnamep, fnamelen);      	    dom->dom_moddt = moddt;     	    dom->dom_loaded = 0;      	}       	dom->dom_valid = 1;       	status = SS$_NORMAL;        } /* while get_next_line */        if (!OK(status))A     	log_error("Error in configuration file %.*s, line %d: %s\n", <     	    	    	nam.nam$b_rsl, nam.nam$l_rsa, linenum, msgp);
     else {$     	cfg->cfg_fnlen = nam.nam$b_rsl;3     	memcpy(cfg->cfg_fname, rspec, cfg->cfg_fnlen); '     	cfg->cfg_moddt = xabrdt.xab$q_rdt;      }        SYS$CLOSE(&fab);     nam.nam$v_synchk = 1;      SYS$PARSE(&fab);     return status;   } /* do_config */    /*  *  ROUTINE:	do_domains   *  *  DESCRIPTION:.  *  	Reads and parses domain definition files.  *  *  PARAMETERS: ,  *  	cfg:	    config_t, modify, by reference  *   *  RETURNS:	VMS condition value  */ 0 static vms_status_t do_domains (config_t *cfg) {       FABDEF  	    fab;      RABDEF  	    rab;      NAMDEF  	    nam;      XABRDTDEF	    xabrdt; *     domain_t	    *dom, *domnext, *domprev;(     mailbox_t	    *mbx, *prev, *mbxnext;     vms_status_t    status; 0     char    	    *linep, *mnamep, *addrp, *msgp;2     u_int16_t	    fnlen, count, mnamelen, addrlen;     int	    	    i, j, linenum; #     char    	    line_buffer[2048]; L     char    	    espec[MAX_FN_LEN], rspec [MAX_FN_LEN], addrbuf[MAX_FN_LEN];    (     for (i = 0; i < DOM_K_HTSIZE; i++) {  "     	if (cfg->cfg_domhash[i] == 0)     	    continue;       	domprev = 0;   ?     	for (dom = cfg->cfg_domhash[i]; dom != 0; dom = domnext) {   !     	    domnext = dom->dom_next;        	    if (!dom->dom_valid) {      	    	mem_domain_free(dom);      	    	if (domprev == 0) ,     	    	    cfg->cfg_domhash[i] = domnext;     	    	else*     	    	    domprev->dom_next = domnext;     	    	continue; 
     	    }       	    fab = cc$rms_fab;     	    nam = cc$rms_nam;      	    xabrdt = cc$rms_xabrdt;  #     	    fab.fab$b_fac = FAB$M_GET; &     	    fab.fab$b_shr = FAB$M_SHRGET;(     	    fab.fab$l_fna = dom->dom_fname;\     	    for (fnlen = dom->dom_fnlen; fnlen > 1 && dom->dom_fname[fnlen-1] != ';'; fnlen--);?     	    fab.fab$b_fns = (fnlen == 0 ? dom->dom_fnlen : fnlen); (     	    fab.fab$l_dna = "MX_DIR:.DAT;";/     	    fab.fab$b_dns = strlen(fab.fab$l_dna); !     	    fab.fab$l_xab = &xabrdt;      	    fab.fab$l_nam = &nam;     	    nam.nam$l_esa = espec; &     	    nam.nam$b_ess = MAX_FN_LEN-1;     	    nam.nam$l_rsa = rspec; &     	    nam.nam$b_rss = MAX_FN_LEN-1;  !     	    status = SYS$OPEN(&fab);      	    if (!OK(status)) { E     	    	log_error("Error (0x%X) opening file %.*s for domain %.*s", \     	    	    	    status, dom->dom_fnlen, dom->dom_fname, dom->dom_namelen, dom->dom_name);     	    	mem_domain_free(dom);      	    	continue; 
     	    }       	    rab = cc$rms_rab;     	    rab.rab$l_fab = &fab;     	    rab.rab$v_rah = 1; $     	    status = SYS$CONNECT(&rab);     	    if (!OK(status)) {      	    	SYS$CLOSE(&fab);     	    	nam.nam$v_synchk = 1;      	    	SYS$PARSE(&fab);E     	    	log_error("Error (0x%X) opening file %.*s for domain %.*s", \     	    	    	    status, dom->dom_fnlen, dom->dom_fname, dom->dom_namelen, dom->dom_name);     	    	mem_domain_free(dom);      	    	continue; 
     	    }       	    /* I     	     *	If already loaded and no change to file, no need to reload it      	     */     	    if (dom->dom_loaded && 0     	    	    nam.nam$b_rsl == dom->dom_fnlen &&P     	    	    strncasecmp(nam.nam$l_rsa, dom->dom_fname, dom->dom_fnlen) == 0 &&3     	    	    xabrdt.xab$q_rdt == dom->dom_moddt) {      	    	SYS$CLOSE(&fab);     	    	nam.nam$v_synchk = 1;      	    	SYS$PARSE(&fab);     	        domprev = dom;      	    	continue; 
     	    }       	    /* I     	     *  Invalidate all of the mailboxes in the hash table, so we can C     	     *  delete them if they aren't in the updated domain file.      	     */+     	    for (j = 0; j < MBX_K_HTSIZE; j++) H     	    	for (mbx = dom->dom_mbxhash[j]; mbx != 0; mbx = mbx->mbx_next)!     	    	    mbx->mbx_valid = 0;   !     	    if (dom->dom_defrw != 0) (     	    	dom->dom_defrw->mbx_valid = 0;  %     	    rab.rab$l_ubf = line_buffer; -     	    rab.rab$w_usz = sizeof(line_buffer);        	    linenum = 0;   $     	    msgp = "domain file empty";     	    status = 0;  @     	    while (get_next_line(&rab, &linep, &count, &linenum)) {       	    	status = 0;   3     	    	msgp = "expecting mailbox name or \"*\""; B     	    	if (!get_next_word(&linep, &count, &mnamep, &mnamelen))      	    	    break;)     	    	msgp = "mailbox name too long"; $     	    	if (mnamelen > MBX_S_NAME)     	    	    break;  2     	    	msgp = "expecting valid e-mail address";?     	    	if (!get_next_word(&linep, &count, &addrp, &addrlen))      	    	    break;K     	    	unquote_word(addrp, addrlen, addrbuf, sizeof(addrbuf), &addrlen);      	    	addrp = addrbuf;       	    	/*C     	    	 *  Special case for default mailbox rewrite (name = "*") 
     	    	 */ 0     	    	if (mnamelen == 1 && *mnamep == '*') {;     	    	    if (dom->dom_loaded && dom->dom_defrw != 0) { $     	    	    	mbx = dom->dom_defrw;3     	    	    	if (mbx->mbx_rwaddrlen == addrlen && H     	    	    	    	strncasecmp(mbx->mbx_rwaddr, addrp, addrlen) == 0) {'     	    	    	    status = SS$_NORMAL; &     	    	    	    mbx->mbx_valid = 1;     	    	    	    continue;     	    	    	}0     	    	    	mem_mailbox_free(dom->dom_defrw);"     	    	    	dom->dom_defrw = 0;     	    	    } S     	    	    dom->dom_defrw = mem_mailbox_alloc(mnamep, mnamelen, addrp, addrlen); ,     	    	    dom->dom_defrw->mbx_valid = 1;"     	    	    status = SS$_NORMAL;     	    	    continue;      	    	}        	    	prev = 0; .     	    	j = mbx_name_hash(mnamep, mnamelen);        	    	if (dom->dom_loaded) {N     	    	    for (mbx = dom->dom_mbxhash[j]; mbx != 0; mbx = mbx->mbx_next) {2     	    	    	if (mbx->mbx_namelen == mnamelen &&F     	    	    	    	strncasecmp(mnamep, mbx->mbx_name, mnamelen) == 0)     	    	    	    break;      	    	    	prev = mbx;     	    	    }      	    	    /*P     	    	     *	If no change from already-loaded rewrite, leave it and move on.O     	    	     *	Otherwise, delete the current one so a new one can be entered.      	    	     */      	    	    if (mbx != 0) { 3     	    	    	if (mbx->mbx_rwaddrlen == addrlen && H     	    	    	    	strncasecmp(mbx->mbx_rwaddr, addrp, addrlen) == 0) {'     	    	    	    status = SS$_NORMAL; &     	    	    	    mbx->mbx_valid = 1;     	    	    	    continue;     	    	    	}     	    	    	if (prev == 0) 7     	    	    	    dom->dom_mbxhash[j] = mbx->mbx_next;      	    	    	else 2     	    	    	    prev->mbx_next = mbx->mbx_next;  %     	    	    	mem_mailbox_free(mbx);      	    	    	mbx = 0;      	    	    }      	    	}        	    	/*J     	    	 *  If we're here, either the mailbox name wasn't already in theP     	    	 *  table or it was but we had to delete it due to a rewrite mismatch.
     	    	 */ D     	    	mbx = mem_mailbox_alloc(mnamep, mnamelen, addrp, addrlen);     	    	mbx->mbx_valid = 1;      	    	if (prev == 0) {2     	    	    mbx->mbx_next = dom->dom_mbxhash[j];(     	    	    dom->dom_mbxhash[j] = mbx;     	    	} else {-     	    	    mbx->mbx_next = prev->mbx_next; #     	    	    prev->mbx_next = mbx;      	    	}        	    	status = SS$_NORMAL;  $     	    } /* while get_next_line */       	    if (!OK(status)) { D     	    	log_error("Error in domain %.*s file %.*s, line %d: %s\n",3     	    	    	    dom->dom_namelen, dom->dom_name, @     	    	    	    nam.nam$b_rsl, nam.nam$l_rsa, linenum, msgp);     	    	mem_domain_free(dom);      	    } else { ,     	    	dom->dom_moddt = xabrdt.xab$q_rdt;)     	    	dom->dom_fnlen = nam.nam$b_rsl; @     	    	memcpy(dom->dom_fname, nam.nam$l_rsa, dom->dom_fnlen);
     	    }       	    SYS$CLOSE(&fab);      	    nam.nam$v_synchk = 1;     	    SYS$PARSE(&fab);              domprev = dom;  1     	} /* for dom -- traversing collision list */   1     } /* for i -- traversing domain hash table */        /*P      *	Now, one more pass over the domains to remove any invalid mailbox entries      */   (     for (i = 0; i < DOM_K_HTSIZE; i++) {E     	for (dom = cfg->cfg_domhash[i]; dom != 0; dom = dom->dom_next) {      	    /* !     	     *	Check default rewrite      	     */#     	    if (dom->dom_defrw != 0) { +     	    	if (!dom->dom_defrw->mbx_valid) { /     	    	    mem_mailbox_free(dom->dom_defrw);*!     	    	    dom->dom_defrw = 0;l     	    	}S
     	    }     	    /* -     	     *	Now run through all the mailboxesl     	     */-     	    for (j = 0; j < MBX_K_HTSIZE; j++) {r     	    	prev = 0;$D     	    	for (mbx = dom->dom_mbxhash[j]; mbx != 0; mbx = mbxnext) {&     	    	    mbxnext = mbx->mbx_next;!     	    	    if (mbx->mbx_valid)f     	    	    	prev = mbx;     	    	    else {%     	    	    	mem_mailbox_free(mbx);      	    	    	if (prev == 0)c1     	    	    	    dom->dom_mbxhash[j] = mbxnext;s     	    	    	elseg,     	    	    	    prev->mbx_next = mbxnext;     	    	    }s       	    	} /* for mbx */        	    } /* for j */       	} /* for dom */       } /* for i */a         return status;   } /* do_config */    /*  *  ROUTINE:	validate_file  *  *  DESCRIPTION:A  *  	Checks to see if a file can be opened; if so, it returns theuL  *  	resultant file specification and revision date/time stamp for the file.  *  *  PARAMETERS: 4  *  	fname:	    char_string, read only, by reference3  *   	fnlen:	    word_unsigned, read only, by value_4  *  	dname:	    char_string, read only, by reference2  *  	dnlen:	    word_unsigned, read only, by value5  *  	rspec:	    char_string, write only, by reference*0  *  	rss:	    word_unsigned, read only, by value0  *  	rdt:	    vms_time, write only, by reference  *  *  RETURNS:	int  *  	1 = success  *  	0 = failure  */ a static int validate_file (const char *fname, u_int16_t fnlen, const char *dname, u_int16_t dnlen,v?     	    	    	  char *rspec, u_int16_t rss, vms_time_t *rdt) {        FABDEF  	    fab;s     NAMDEF  	    nam;o     XABRDTDEF	    xabrdt;(     vms_status_t    status; #     char    	    espec[MAX_FN_LEN];        fab = cc$rms_fab;      nam = cc$rms_nam;a     xabrdt = cc$rms_xabrdt;C       fab.fab$b_fac = FAB$M_GET;!     fab.fab$b_shr = FAB$M_SHRGET; #     fab.fab$l_fna = (char *) fname;e     fab.fab$b_fns = fnlen;#     fab.fab$l_dna = (char *) dname;r     fab.fab$b_dns = dnlen;     fab.fab$l_xab = &xabrdt;     fab.fab$l_nam = &nam;o     nam.nam$l_esa = espec;!     nam.nam$b_ess = MAX_FN_LEN-1;t     nam.nam$l_rsa = rspec;     nam.nam$b_rss = rss-1;       status = SYS$OPEN(&fab);     if (OK(status)) {l!     	rspec[nam.nam$b_rsl] = '\0';T     	*rdt = xabrdt.xab$q_rdt;      	SYS$CLOSE(&fab);R     	nam.nam$v_synchk = 1;     	SYS$PARSE(&fab);      }x       return OK(status);   } /* validate_file */    /*  *  ROUTINE:	get_next_line  *  *  DESCRIPTION:E  *  	Gets the next non-comment line from a file, trimming off leadingo  *  	whitespace.  *D  *  	Comments begin with an exclamation point (!) or pound sign (#).  *  *  PARAMETERS:d*  *  	rab:	    RABDEF, modify, by reference5  *  	linepp:	    string pointer, modify, by reference 4  *  	countp:	    word_unsigned, modify, by reference*  *  	linenump:   int, modify, by reference  *  *  RETURNS:	int  *  	1 = success  *  	0 = failure  */*Y static int get_next_line (RABDEF *rab, char **linepp, u_int16_t *countp, int *linenump) {*       char    	    *linep;     u_int16_t	    count;       while (OK(SYS$GET(rab))) {       	*linenump += 1;       	linep = rab->rab$l_rbf;     	count = rab->rab$w_rsz;  =     	while (count > 0 && (*linep == ' ' || *linep == '\t')) {r     	    linep += 1;     	    count -= 1;     	}  6     	if (count == 0 || *linep == '!' || *linep == '#')     	    continue;       	*linepp = linep;;     	*countp = count;n       	return 1;       }m  
     return 0;    } /* get_next_line */o   /*  *  ROUTINE:	get_next_word  *  *  DESCRIPTION:H  *  	Gets the next "word" (string of non-whitespace characters or quotedM  *  	string) from a line.  Stops if it hits end of line or comment delimiter.aH  *  	Increments position in line past next batch of whitespace after the  *  	discovered word.$  *D  *  	Comments begin with an exclamation point (!) or pound sign (#).  *  *  PARAMETERS:a5  *  	linepp:	    string pointer, modify, by referenceM4  *  	remainp:    word_unsigned, modify, by reference5  *  	wordpp:	    string pointer, modify, by referencen2  *  	lenp:	    word_unsigned, modify, by reference  *  *  RETURNS:	int  *  	1 = success  *  	0 = failure  */ ^ static int get_next_word (char **linepp, u_int16_t *remainp, char **wordpp, u_int16_t *lenp) {  "     char    	    *linep = *linepp;$     u_int16_t	    remain = *remainp;     char    	    *wordp;       if (remain == 0)     	return 0;  '     if (*linep == '!' || *linep == '#')      	return 0;       wordp = linep;     linep += 1;      remain -= 1;     if (*wordp == '"') {     	while (remain > 0) { ,     	    if (*linep == '\\' && remain > 1) {     	    	linep += 2;n     	    	remain -= 2;     	    	continue;g
     	    }     	    linep += 1;     	    remain -= 1;b     	    if (*(linep-1) == '"')      	    	break;     	}     } else {     	while (remain > 0) {S-     	    if (*linep == ' ' || *linep == '\t')      	    	break;     	    linep += 1;     	    remain -= 1;      	}     }n       *wordpp = wordp;     *lenp = linep - wordp;  =     while (remain > 0 && (*linep == ' ' || *linep == '\t')) {;     	linep += 1;     	remain -= 1;d     }i
     	    	     *linepp = linep;     *remainp = remain;  
     return 1;d   } /* get_next_word */o   /*  *  ROUTINE:	unquote_wordi  *  *  DESCRIPTION:C  *  	Strips quotation marks from around a quoted word, and resolvesXK  *  	any escaped character sequences (backslash followed by any character).eJ  *  	The unquoted string is copied into the output buffer, rather than the"  *  	unquoting happening in-place.  *J  *  	If the word does not begin with a quotation mark, it is simply copied  *  	verbatim.  *  *  PARAMETERS: 3  *  	srcp:	    char_string, read only, by referencec3  *  	srclen:	    word_unsigned, read only, by valuee4  *  	dstp:	    char_string, write only, by reference3  *  	dstsize:    word_unsigned, read only, by value;8  *  	dstlenp:    word_unsigned, write only, by reference  *  *  RETURNS:	void;  */ I static void unquote_word (const char *srcp, u_int16_t srclen, char *dstp, 9     	    	    	  u_int16_t dstsize, u_int16_t *dstlenp) {        u_int16_t	dstlen;g       if (*srcp != '"') {e     	if (srclen > dstsize)     	    *dstlenp = dstsize;	     	else      	    *dstlenp = srclen;a"     	memcpy(dstp, srcp, *dstlenp);     	return;     }g       dstlen = 0;lV     for (srcp += 1, srclen -= 1; srclen > 0 && *srcp != '"'; srcp += 1, srclen -= 1) {  '     	if (*srcp == '\\' && srclen > 1) {f     	    srcp += 1;      	    srclen -= 1;      	}       	if (dstlen == dstsize)_     	    break;        	*dstp++ = *srcp;n     	dstlen += 1;      }        *dstlenp = dstlen;   } /* unquote_word */   /*  *  ROUTINE:	log_error  *  *  DESCRIPTION:.  *  	Logs an error message to standard output.  *  *  PARAMETERS: 2  *  	fmt:	    char_string, read only, by reference$  *  	... 	    variable argument list  *  *  RETURNS:	voidl  */p. static void log_error (const char *fmt, ...) {        struct dsc$descriptor   dsc;      char    	    	    buf[2048];     va_list  	    	    ap;  '     INIT_SDESC(&dsc, sizeof(buf), buf);l     va_start(ap, fmt);.     dsc.dsc$w_length = vsprintf(buf, fmt, ap);     va_end(ap);        LIB$PUT_OUTPUT(&dsc);)   } /* log_error */m