 /*  *  access_check.c  *9  *  Configurable client SMTP access check callout for MX.   *$ Copyright (c) 2008, Matthew Madison.   All rights reserved.  B Redistribution and use in source and binary forms, with or withoutB modification, are permitted provided that the following conditions are met:  :     * Redistributions of source code must retain the aboveA       copyright notice, this list of conditions and the following        disclaimer. =     * Redistributions in binary form must reproduce the above A       copyright notice, this list of conditions and the following E       disclaimer in the documentation and/or other materials provided        with the distribution.B     * Neither the name of the copyright owner nor the names of anyC       other contributors may be used to endorse or promote products ?       derived from this software without specific prior written        permission.   C THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS A "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT E LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR D A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHTE OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, @ SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOTE LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, E DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY C THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT E (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE D OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  *  *  MODULE DESCRIPTION:   *G  *  	This module contains routines that implement an access check based (  *  on a connecting client's IP address.  *  *  Installing the callout: R  *      $ DEFINE/SYSTEM/EXEC MX_SITE_CLIENT_ACCESS_CHECK dev:[dir]ACCESS_CHECK.EXE  *  	$ MCP SHUTDOWN SMTP_SERVER -  *      $ @SYS$STARTUP:MX_STARTUP SMTP_SERVER   */  #define __NEW_STARLET  #include <descrip.h> #include <socket.h>  #include <in.h>  #include <str$routines.h>  #include <lib$routines.h>  #include <starlet.h> #include <stsdef.h>  #include <ssdef.h> #include <string.h>  #include <ctype.h>! #include "netlib_dir:netlibdef.h"   0 #define OK(status_) $VMS_STATUS_SUCCESS(status_)g #define MAKE_HELLO_STATUS(a_, b_, c_) ((((a_) & 0xFF) << 24) | (((b_) & 0xFF) << 16) | ((c_) & 0xFFFF))  #define DNSBUFSIZE      1024  &     typedef unsigned int vms_status_t;       /*7      *	Context structure used to track a single session       */ 0     typedef void (*ast_routine_t)(void *astprm);  "     typedef struct acc_context__ {#         struct acc_context__ *next;       	ast_routine_t	      astadr;     	void	    	     *astprm;"     	unsigned int	     *accstatus;8         unsigned int          inv_lookup_ok         : 1;8         unsigned int          inside                : 1;8         unsigned int          check_inverse_lookup  : 1;8         unsigned int          reject_on_inv_fail    : 1;8         unsigned int          reject_on_helo_fail   : 1;8         unsigned int          excluded              : 1;$         void                 *nlctx;     	unsigned int	      clilen; "     	struct sockaddr       client;"         struct dsc$descriptor dsc;#         struct NETLIBIOSBDEF  iosb; %         unsigned short        invlen; '         char                  inv[256]; *         char                  nambuf[256];1         unsigned char         dnsbuf[DNSBUFSIZE];      } acc_context_t;  4     static int context_size = sizeof(acc_context_t);2     static unsigned short dnsbufsize = DNSBUFSIZE;  *     static acc_context_t *freelist = NULL;       static struct {          unsigned int prefix;         unsigned int netmask; 3     } private_net[] = { { 0x0000000A, 0x000000FF }, 3                         { 0x000010AC, 0x0000F0FF }, 5                         { 0x0000A8C0, 0x0000FFFF }} ; N     static int private_net_count = sizeof(private_net)/sizeof(private_net[0]);       static struct {          unsigned int prefix;         unsigned int netmask; 2     } exclusions[] = { { 0x00C08742, 0x00E0FFFF },4                        { 0x00000440, 0x00C0FFFF } };J     static int exclusion_count = sizeof(exclusions)/sizeof(exclusions[0]);  9     static unsigned int class_in = NETLIB_K_DNS_CLASS_IN;        /*      *	Forward declarations       */ (     static int lnm_exists(char *lognam);%     unsigned int INIT(void **ctxptr); U     unsigned int CHECK(void **ctxptr, const struct sockaddr *cliaddr, int cliaddrlen, N     	    	       unsigned int *accstatus, ast_routine_t astadr, void *astprm);/     static void addr_to_name_ast(void *astprm); Y     unsigned int CHECK_HELLO(void **ctxptr, struct dsc$descriptor *domain, int is_inside, S     	    	            unsigned int *accstatus, ast_routine_t astadr, void *astprm); 3     static void name_to_addr_ast(void *astprm);     (     unsigned int CLEANUP(void **ctxptr);     /*  *  get_word  *O  *  Fetch a network-order 16-bit value from a buffer, converting to host order.   */  static unsigned short   get_word (unsigned char **cpp) {     unsigned char *cp = *cpp; #     *cpp += sizeof(unsigned short); "     return (*cp << 8) | *(cp + 1); }   
 static int8 skipname (unsigned char *bufp, unsigned short *buflen) {       unsigned char *cp, *eom;       cp = bufp;     eom = cp + *buflen; "     while (cp < eom && *cp != 0) {     	if (*cp >= 64) {              cp += 2;             return cp - bufp;          } else             cp += *cp + 1;     }      return (cp - bufp) + 1;    }    /*  *  lnm_exists  *B  *  Checks for the existence of a logical name in the LNM$FILE_DEV  *  logical name table(s).  */ 
 static int lnm_exists (char *lognam)  { !     struct dsc$descriptor lnmdsc; 5     static $DESCRIPTOR(lnm_file_dev, "LNM$FILE_DEV");   '     lnmdsc.dsc$b_dtype = DSC$K_DTYPE_T; '     lnmdsc.dsc$b_class = DSC$K_CLASS_S; )     lnmdsc.dsc$w_length = strlen(lognam); "     lnmdsc.dsc$a_pointer = lognam;  ;     return OK(sys$trnlnm(0, &lnm_file_dev, &lnmdsc, 0, 0));    } /* lnm_exists */   /*  *  INIT  *9  *  Initialization for this callout.  Allocates a context 3  *  block and sets up a socket for the DNS queries.   */  vms_status_t INIT (void **ctxptr) {      acc_context_t  *ctx;     vms_status_t    status; 0     unsigned int    dgram = NETLIB_K_TYPE_DGRAM;       if (NULL == freelist) { 1         status = lib$get_vm(&context_size, &ctx);      } else {         ctx = freelist;          freelist = ctx->next;          ctx->next = NULL;          status = SS$_NORMAL;     }        if (OK(status)) { "     	memset(ctx, 0, sizeof(*ctx));4         status = netlib_socket(&ctx->nlctx, &dgram);         if (!OK(status)) {!             ctx->next = freelist;              freelist = ctx; 	         }      }        if (OK(status)) { J         ctx->check_inverse_lookup = lnm_exists("CLIENT_ACCESS_CHECK_PTR");S         ctx->reject_on_inv_fail   = lnm_exists("CLIENT_ACCESS_REJECT_ON_PTR_FAIL"); T         ctx->reject_on_helo_fail  = lnm_exists("CLIENT_ACCESS_REJECT_ON_HELO_FAIL");     	*ctxptr = ctx;      }        return status;   } /* INIT */   /*	  *  CHECK   *R  *  Called when the SMTP server accepts an incoming connection.  If configured forT  *  checking the address->name translation of the client's IP address, it will startU  *  that lookup.  Otherwise, it simply stashes the client's IP address in the context '  *  block for later use in CHECK_HELLO.   */  vms_status_tE CHECK (void **ctxptr, const struct sockaddr *cliaddr, int cliaddrlen, C        unsigned int *accstatus, ast_routine_t astadr, void *astprm)  { *     acc_context_t       *ctx    = *ctxptr;      vms_status_t         status;C     struct sockaddr_in  *sin = (struct sockaddr_in *) &ctx->client; =     unsigned int         inaddrsize = sizeof(struct in_addr);      int                  i; ?     static $DESCRIPTOR(invctr, "!UB.!UB.!UB.!UB.IN-ADDR.ARPA"); 9     static unsigned int ptr_type = NETLIB_K_DNS_TYPE_PTR;        ctx->accstatus = accstatus;      ctx->astadr	   = astadr;     ctx->astprm	   = astprm;      ctx->clilen    = cliaddrlen;*     if (ctx->clilen > sizeof(ctx->client))'     	ctx->clilen = sizeof(ctx->client); /     memcpy(&ctx->client, cliaddr, ctx->clilen);     +     if (ctx->client.sa_family != AF_INET) { $             *accstatus = SS$_NORMAL;             return SS$_SYNCH;      }        *accstatus = SS$_NORMAL;  +     for (i = 0; i < exclusion_count; i++) { U         if ((sin->sin_addr.s_addr & exclusions[i].netmask) == exclusions[i].prefix) {              ctx->excluded = 1;             break;	         }      }          6     if (ctx->check_inverse_lookup && !ctx->excluded) {.         unsigned int a = sin->sin_addr.s_addr;-         ctx->dsc.dsc$b_dtype = DSC$K_DTYPE_T; -         ctx->dsc.dsc$b_class = DSC$K_CLASS_S; 4         ctx->dsc.dsc$w_length = sizeof(ctx->nambuf);-         ctx->dsc.dsc$a_pointer = ctx->nambuf; D         status = sys$fao(&invctr, &ctx->dsc.dsc$w_length, &ctx->dsc,<                          (a >> 24) & 0xFF, (a >> 16) & 0xFF,5                          (a >> 8)  & 0xFF, a & 0xFF);          if (OK(status)) S             status = netlib_dns_query(&ctx->nlctx, &ctx->dsc, &class_in, &ptr_type, N                                       ctx->dnsbuf, &dnsbufsize, 0, &ctx->iosb,=                                       addr_to_name_ast, ctx);      } else {         ctx->inv_lookup_ok = 1;          status = SS$_SYNCH;      }      return status;  
 } /* CHECK */    /*  *  addr_to_name_ast  *C  *  AST completion routine for the address->name lookup.  Only sets F  *  inv_lookup_ok to FALSE if we get a definitive "name error" answer.  */  static void ! addr_to_name_ast (void *astprm) {         acc_context_t *ctx	= astprm;M     struct NETLIB_DNS_HEADER *hdr = (struct NETLIB_DNS_HEADER *) ctx->dnsbuf;      struct dsc$descriptor dsc;1     unsigned short ancount, qdcount, type, class; %     unsigned short buflen, i, remain;      unsigned char *cp;       ctx->invlen = 0;     ctx->inv_lookup_ok = 1; !     *ctx->accstatus = SS$_NORMAL; '     if (!OK(ctx->iosb.iosb_w_status)) { $         (*ctx->astadr)(ctx->astprm);         return;      } ;     if (hdr->dns_v_reply_code != NETLIB_K_DNS_RC_SUCCESS) { M         ctx->inv_lookup_ok = hdr->dns_v_reply_code != NETLIB_K_DNS_RC_NAMERR; $         (*ctx->astadr)(ctx->astprm);         return;      } /     cp = (unsigned char *) &hdr->dns_w_ancount;      ancount = get_word(&cp);/     cp = (unsigned char *) &hdr->dns_w_qdcount;      qdcount = get_word(&cp);$     buflen = ctx->iosb.iosb_w_count;#     remain = buflen - sizeof(*hdr); $     cp = ctx->dnsbuf + sizeof(*hdr);     while (qdcount-- > 0) { &         i = skipname(cp, &remain) + 4;         cp += i;         remain -= i;     } $     dsc.dsc$b_dtype = DSC$K_DTYPE_T;$     dsc.dsc$b_class = DSC$K_CLASS_S;(     dsc.dsc$w_length = sizeof(ctx->inv);!     dsc.dsc$a_pointer = ctx->inv; )     while (ancount-- > 0 && remain > 0) { "         i = skipname(cp, &remain);         cp += i; remain -= i;          type = get_word(&cp);          remain -= 2;         class = get_word(&cp);=         cp += 4; remain -= 6; /* skip over 4-byte TTL also */          i = get_word(&cp);         remain -= 2;N         if (type != NETLIB_K_DNS_TYPE_PTR || class != NETLIB_K_DNS_CLASS_IN) {!             cp += i; remain -= i;              continue; 	         } T         if (OK(netlib_dns_expandname(ctx->dnsbuf, &buflen, cp, &dsc, &ctx->invlen)))             break;         cp += i; remain -= i;      }   !     *ctx->accstatus = SS$_NORMAL;       (*ctx->astadr)(ctx->astprm);   } /* addr_to_name_ast */   /*  *  CHECK_HELLO   *E  *  Called by the SMTP server to validate the domain name provided by (  *  the client on the HELO/EHLO command.  *'  *  1. Checks the address->name lookup. C  *  2. Starts a name->address lookup on the domain name supplied by   *     the client.  *F  *  The low-order 16 bits of the "accstatus" argument should be set toF  *  one of the following values to tell the SMTP server what action to	  *  take: $  *   0: reject the HELO/EHLO command$  *   1: accept the HELO/EHLO command6  *   2: accept HELO/EHLO, but reject any sent messages=  *   3: domain should be flagged as a fake, but accept anyway T  *   4: accept HELO/EHLO, but reject any sent messages *unless* client authenticatesI  *   5: accept, but insert the value in the upper 16 bits of accstatus in K  *      a field in the Received: header so that REJMAN rules can be used to R  *      reject or redirect messages (looking for "warning type XXXX", where "XXXX"=  *      is a 4-hex-digit representation of the 16-bit value). ,  *   any other value: treated the same as 1.  */  vms_status_tI CHECK_HELLO (void **ctxptr, struct dsc$descriptor *domain, int is_inside, I              unsigned int *accstatus, ast_routine_t astadr, void *astprm)  {   #     acc_context_t   *ctx = *ctxptr;      vms_status_t     status;     unsigned short   len; )     int              dotcount, alldigits;      char            *ptr, *cp;5     static unsigned int a_type = NETLIB_K_DNS_TYPE_A;        ctx->accstatus = accstatus;      ctx->astadr    = astadr;     ctx->astprm    = astprm;     ctx->inside    = is_inside;        if (ctx->excluded) {         *accstatus = 1;          return SS$_SYNCH;      }   ,     if (!ctx->inv_lookup_ok && !is_inside) {P         *accstatus = (ctx->reject_on_inv_fail ? 4 : MAKE_HELLO_STATUS(0, 1, 5));         return SS$_SYNCH;      }        /*      *  This shouldn't fail.      */ <     status = lib$analyze_sdesc((void *) domain, &len, &ptr);"     if (!OK(status) || len == 0) {B         *accstatus = MAKE_HELLO_STATUS((is_inside ? 1 : 0), 2, 5);         return SS$_SYNCH;      }        /*=      *  Check for numeric addresses and unadorned host names.       */ 7     if (len >= 2 && *ptr == '[' && ptr[len-1] == ']') { c         *accstatus = (ctx->reject_on_helo_fail ? 4 : MAKE_HELLO_STATUS((is_inside ? 1 : 0), 3, 5));          return SS$_SYNCH;      }      dotcount = 0;      alldigits = 1;*     for (cp = ptr; cp < ptr + len; cp++) {         if (*cp == '.')              dotcount += 1;         else if (!isdigit(*cp))              alldigits = 0;     } 5     if (alldigits || (dotcount == 0 && !is_inside)) { c         *accstatus = (ctx->reject_on_helo_fail ? 4 : MAKE_HELLO_STATUS((is_inside ? 1 : 0), 4, 5));          return SS$_SYNCH;      }        /*L      *  A failure here shouldn't count as a real failure, since it indicatesH      *  some kind of internal problem.  So don't reject if it does fail.      */ S     status = netlib_dns_query(&ctx->nlctx, domain, &class_in, &a_type, ctx->dnsbuf, Q                               &dnsbufsize, 0, &ctx->iosb, name_to_addr_ast, ctx);      if (!OK(status)) {B         *accstatus = MAKE_HELLO_STATUS((is_inside ? 1 : 0), 5, 5);         return SS$_SYNCH;      }        return SS$_NORMAL; }    /*  *  name_to_addr_ast  *G  *  Checks the returned addresses against the actual client IP address. B  *  Only flags a failure if we get an actual "name error" responseB  *  from the DNS query, or if none of the returned addresses match!  *  the actual client IP address.   */  static void  name_to_addr_ast (void *astprm)  { &     acc_context_t       *ctx	= astprm;C     struct sockaddr_in  *sin = (struct sockaddr_in *) &ctx->client; M     struct NETLIB_DNS_HEADER *hdr = (struct NETLIB_DNS_HEADER *) ctx->dnsbuf;      unsigned long addr; 1     unsigned short ancount, qdcount, type, class; %     unsigned short buflen, i, remain;      int acount, found, j;      unsigned char *cp;  '     if (!OK(ctx->iosb.iosb_w_status)) { %         *ctx->accstatus = SS$_NORMAL; $         (*ctx->astadr)(ctx->astprm);         return;      } ;     if (hdr->dns_v_reply_code != NETLIB_K_DNS_RC_SUCCESS) { <         if (hdr->dns_v_reply_code == NETLIB_K_DNS_RC_NAMERR)7             *ctx->accstatus = (ctx->reject_on_helo_fail #                                 ? 4 R                                 : MAKE_HELLO_STATUS((ctx->inside ? 1 : 0), 6, 5));         else)             *ctx->accstatus = SS$_NORMAL; $         (*ctx->astadr)(ctx->astprm);         return;      } /     cp = (unsigned char *) &hdr->dns_w_ancount;      ancount = get_word(&cp);       if (ancount == 0) { 3         *ctx->accstatus = (ctx->reject_on_helo_fail                              ? 4 N                             : MAKE_HELLO_STATUS((ctx->inside ? 1 : 0), 7, 5));$         (*ctx->astadr)(ctx->astprm);         return;      }   /     cp = (unsigned char *) &hdr->dns_w_qdcount;      qdcount = get_word(&cp);$     buflen = ctx->iosb.iosb_w_count;#     remain = buflen - sizeof(*hdr); $     cp = ctx->dnsbuf + sizeof(*hdr);     while (qdcount-- > 0) { &         i = skipname(cp, &remain) + 4;         cp += i;         remain -= i;     }        acount = 0;      found = 0;3     while (ancount-- > 0 && remain > 0 && !found) { "         i = skipname(cp, &remain);         cp += i; remain -= i;          type = get_word(&cp);          remain -= 2;         class = get_word(&cp);=         cp += 4; remain -= 6; /* skip over 4-byte TTL also */          i = get_word(&cp);         remain -= 2;V         if (type != NETLIB_K_DNS_TYPE_A || class != NETLIB_K_DNS_CLASS_IN || i != 4) {!             cp += i; remain -= i;              continue; 	         } `         addr = (*(cp+3) << 24) | ((*(cp+2) << 16) & 0xFF0000) | ((*(cp+1) << 8) & 0xFF00) | *cp;         remain -= 4;1         for (j = 0; j < private_net_count; j++) { I             if ((addr & private_net[j].netmask) != private_net[j].prefix)                  break;	         } #         if (j >= private_net_count)              continue;          acount += 1;-         found = addr == sin->sin_addr.s_addr;      }        if (acount == 0 || found)          *ctx->accstatus = 1;     else3         *ctx->accstatus = (ctx->reject_on_helo_fail                              ? 4 N                             : MAKE_HELLO_STATUS((ctx->inside ? 1 : 0), 7, 5));        (*ctx->astadr)(ctx->astprm);   } /* name_to_addr_ast */      /*  *  CLEANUP   *  *  Free up the context.  */  vms_status_t CLEANUP (void **ctxptr)  { !     acc_context_t *ctx = *ctxptr;      vms_status_t   status;       if (ctx->nlctx != 0)"         netlib_close(&ctx->nlctx);       ctx->next = freelist;      freelist = ctx;   9     *ctxptr = 0;  /* not required, but just to be safe */        return SS$_NORMAL;   } /* CLEANUP */ 