 C	CHARACTER STRING SUBROUTINES C  C	T. WORLTON 4/1/83  C    N C  Subroutine CSOUT outputs a Character String at the current cursor position. C  Valid calls would be:# C		CALL CSOUT('String to be typed')  C		CALL CSOUT(STRING) E C  where in the latter example "STRING" would be a previously defined  C  Character String. C A C  Other entry points are PROMPT, CSNEW, and ESCOUT.  PROMPT will @ C  output the string at the beginning of the next line and leaveG C  the cursor at the end of that string.  CSNEW is similar to a FORTRAN B C  type statement.  It does a carriage return and Line Feed before, C  outputing the string.  ESCOUT will outputA C  an escape before sending the Character String from the calling F C  Routine.  Thus you can send the escape sequence to erase the screen C  with the call:  C		Call ESCOUT('[2J')  C  	SUBROUTINE CSOUT(STRING)  	CHARACTER STRING*(*),MODE*15 % 	BYTE NULL, BLANK, DOLLAR, ESC, BRING ; 	DATA ESC, NULL, BLANK, DOLLAR, BRING/"33, 0, ' ', '$', "7/ 
 	DATA INIT/0/    	WRITE (6,100) NULL,STRING 100	FORMAT(A1,A) 	RETURN     	ENTRY PROMPT(STRING)  	WRITE(6,100) DOLLAR, STRING 	RETURN     	ENTRY CSNEW(STRING) 	WRITE(6,100) BLANK,STRING 	RETURN    	ENTRY CRLF  	WRITE(6,100) BLANK  	RETURN    	ENTRY ESCOUT(STRING)  	IF(INIT .EQ. 0) THEN  	    CALL GTMODE(MODE,MLEN) 
 	    INIT = 1  	END IF # 	IF(MODE(1:MLEN) .NE. 'BATCH') THEN ! 	    WRITE(6,200) NULL,ESC,STRING  	END IF  200	FORMAT(2A1,A)  	RETURN     	ENTRY RING(N)
 	DO 300 I=1,N  300	WRITE(6,200) NULL, BRING 	RETURN  	END   1 C  Subroutines to set Character attributes.  Note 6 C  that the effects are cumulative. All attributes are C  reset by calling ATTOFF> C  These routines use the same calls as used by Kenyon College+ C  (See The DEC Professional January, 1984)  C  C  Calls and effects are: ! C   (AVO = Advanced Video Option) & C		CALL ANSI	Set to ANSI (VT100) mode.2 C		CALL BOLD	Turn on Bold attribute (Requires AVO)! C		CALL UNDSCR	Turn on underscore 1 C  		CALL BLINK	Turn on blink mode (Requires AVO) . C		CALL REVIMG	Turn reverse image attribute on/ C		CALL ATTOFF	Turn all graphics attributes off  C     	SUBROUTINE ANSI 	CALL ESCOUT('<')  	RETURN     	ENTRY BOLD  	CALL ESCOUT('[1m')  	RETURN    
 	ENTRY UNDSCR  	CALL ESCOUT('[4m')  	RETURN     	ENTRY BLINK 	CALL ESCOUT('[5m')  	RETURN    
 	ENTRY REVIMG  	CALL ESCOUT('[7m')  	RETURN    
 	ENTRY ATTOFF  	CALL ESCOUT('[0m')  	RETURN  	END   I C  These Subroutines clear the screen or cursor line or portions thereof. = C  The names were chosen to match the calls at Kenyon College * C  (See the DEC Professional January 1984)
 C  Calls are: ( C		CALL CLRHOM	Clear screen; Home cursor( C		CALL CLRTOC	Erase from home to cursor1 C		CALL CLREOS	Erase from cursor to end of screen  C		CALL CLRALL	Clear screen + C		CALL CURHOM	Move cursor to home position   C		CALL CLRLIN	Clear cursor line# C		CALL CLRBOL	Clear line to cursor % C		CALL CLREOL	Clear line from cursor  C  C     	SUBROUTINE CLRHOM 	CALL ESCOUT('[2J')  	RETURN    
 	ENTRY CLRTOC  	CALL ESCOUT('[1J')  	RETURN    
 	ENTRY CLREOS  	CALL ESCOUT('[0J')  	RETURN    
 	ENTRY CLRALL  	CALL CWHERE(IL,IC)  	CALL ESCOUT('[2J')  	CALL curpos(IL,IC)  	RETURN    
 	ENTRY CLRLIN  	CALL ESCOUT('[2K')  	RETURN    
 	ENTRY CLRBOL  	CALL ESCOUT('[1K')  	RETURN    
 	ENTRY CLREOL  	CALL ESCOUT('[0K')  	RETURN     	END   > C  Subroutine CSBIG writes a Character String in double height@ C  and width type at a specified location (IL,IC) on the screen.? C  Since the lines are double-height they will also affect text 8 C  on line IL+1.  Any other text on these two lines will= C  subsequently be interpreted as the top or bottom half of a  C  double-height line.? C  Entry point CSWIDE is similar to CSBIG except the characters ? C  are only double-width so it does not affect any lines except  C  line no. IL. ? C  Entry point CSPOS writes a normal size Character String at a , C  specified position (IL,IC) on the screen. C < C  The cursor is left at the end of the string in each case.9 C  If the column number is given as zero, the string will 2 C  be centered on the line for all three routines. C  C  A valid call would be:  C		CALL CSBIG(1,0,'Big Title'); C  This would center the words "Big Title" on the first two  C  lines of the screen.  C  	SUBROUTINE CSBIG(IL,IC,STRING)  	CHARACTER STRING*(*),CT*1 	INTEGER*4 PAGE,SCREEN,FORM 	 	CT = '3'  	MIDDLE = 20 	GOTO 2     	ENTRY CSWIDE(IL,IC,STRING) 	 	CT = '6'  	MIDDLE = 20 	GOTO 2     	ENTRY CSPOS(IL,IC,STRING)	 	CT = '5'  	CALL GTERM(PAGE,SCREEN,FORM) 8 D	WRITE(1,*) 'CSPOS: PAGE,SCREEN,FORM=',PAGE,SCREEN,FORM 	IF(SCREEN .GT. 80) THEN 	    MIDDLE = 66 	ELSE  	    MIDDLE = 40 	END IF  	GOTO 2     C	CENTER STRING IF IC = 0    8 2	JC = IC	!RENAME SO WE CAN CHANGE IF INPUT NOT VARIABLE 	JL = IL 	IF(JL .LE.0) JL = 13 	IF(JC .EQ. 0) THEN	!CALCULATE COLUMN FOR CENTERING  		JC = MIDDLE - LEN(STRING)/2  		IF(JC .LT. 1) JC = 1 	END IF $ D	WRITE(1,*) ' MIDDLE,JC=',MIDDLE,JC    	CALL CURPOS(JL,JC)  	CALL ESCOUT('#'//CT)  	CALL CSOUT(STRING)  	IF(CT .NE. '3') RETURN     	CALL curpos(JL+1,JC)  	CALL ESCOUT('#4') 	CALL CSOUT(STRING)  	RETURN  	END   , C	SUBROUTINES TO SET SCREEN BACKGROUND, ETC.    	SUBROUTINE BLONWH 	CALL ESCOUT('[?5h') 	RETURN    
 	ENTRY WHONBL  	CALL ESCOUT('?5l')  	RETURN     	ENTRY JUMP  	CALL ESCOUT('[?4l') 	RETURN    
 	ENTRY SMOOTH  	CALL ESCOUT('[?4h') 	RETURN    
 	ENTRY KEYAPP  	CALL ESCOUT('=')  	RETURN    
 	ENTRY KEYNUM  	CALL ESCOUT('>')  	RETURN     	END     C	SUBROUTINES TO POSITION CURSOR    	SUBROUTINE CURPOS(IL,IC) " 	CHARACTER CL*2,CC*3,CLB*2,MODE*20 	IF(INIT .EQ. 0) THEN  	    CALL GTMODE(MODE,MLEN) 
 	    INIT = 1  	END IF ) 	IF(MODE(1:MLEN) .EQ. 'INTERACTIVE') THEN  	    CALL LIB$SET_CURSOR(IL,IC)  	END IF  	RETURN     	ENTRY SCREGN(LT,LB) 	ENTRY SCROLL(LT,LB) 	WRITE(CL,110) LT  	WRITE(CLB,110) LB$ 	CALL ESCOUT('['//CL//';'//CLB//'r') 	RETURN     	ENTRY CURBCK(NCOL) 
 D	CALL PORTON  D	CALL VTOFF D	TYPE *,'CURBCK NCOL=',NCOL D	CALL VTON  D	CALL PORTOFF 	IF(NCOL .LE. 0) RETURN  	WRITE(CC,100) NCOL  100	FORMAT(I3.3) 	CALL ESCOUT('['//CC//'D') 	RETURN     	ENTRY CURFWD(NCOL)  	WRITE(CC,100) NCOL  	CALL ESCOUT('['//CC//'C') 	RETURN     	ENTRY CURDWN(NROW)  	WRITE(CL,110) NROW  110	FORMAT(I2.2) 	CALL ESCOUT('['//CL//'B') 	RETURN     	ENTRY CURUP(NROW) 	WRITE(CL,110) NROW  	CALL ESCOUT('['//CL//'A') 	RETURN  	END   + C	CURSOR ROUTINES WITH NO CALLING PARAMETER     	SUBROUTINE SAVCUR 	CALL ESCOUT('7')  	RETURN    
 	ENTRY RESCUR  	CALL ESCOUT('8')  	RETURN    
 	ENTRY ORGOFF  	CALL ESCOUT('[?6l') 	RETURN     	ENTRY ORGON 	CALL ESCOUT('[?6h') 	RETURN    
 	ENTRY CURHOM  	ENTRY HOME  	CALL ESCOUT('[H') 	RETURN     	ENTRY INDEX 	CALL ESCOUT('D')  	RETURN    
 	ENTRY REVIND  	CALL ESCOUT('M')  	RETURN    
 	ENTRY NXTLIN  	CALL ESCOUT('E')  	RETURN     	END   & C	SUBROUTINES TO SELECT CHARACTER SETS    	SUBROUTINE G1ASC  	CALL ESCOUT(')B') 	RETURN    
 	ENTRY G1GRAF  	CALL ESCOUT(')0') 	RETURN    
 	ENTRY GRFOFF  	CALL ESCOUT('(B') 	RETURN     	ENTRY GRFON 	CALL ESCOUT('(0') 	RETURN     	END   @ C	THE FOLLOWING ROUTINES ARE GENERAL ANSI VIDEO CONTROL ROUTINES C 3 C Subroutine CWHERE returns current cursor position  C	Valid Call is: C		CALL CWHERE(IL,IC)  C  	SUBROUTINE CWHERE(IL,IC)  	PARAMETER NBUFF=12   	COMMON /CPRINT/PWIDTH,IFPR,IFLA 	CHARACTER CBUFF*12,MODE*15  	byte B1,BUFF(NBUFF)0 	IF(IFPR .EQ. 2) RETURN	!CAN'T READ IF VT IS OFF 	IF(INIT .EQ. 0) THEN  	    CALL GTMODE(MODE,MLEN)  	    INIT=1  	END IF ) 	IF(MODE(1:MLEN) .NE. 'INTERACTIVE') THEN  	    IL = 1  	    IC = 1  	    RETURN  	END IF  	CALL ESCOUT('[6n') 
 	nchar = 0. C  look for escape sequence back from terminal+ 	do while (B1 .ne. "33 .and. nchar .lt. 80) - 		call inchar(B1,.FALSE.,.TRUE.,.FALSE.,IERR)  		nchar = nchar + 1  	END DO 
 	nchar = 0. 	DO WHILE (B1 .NE. 'R' .AND. NCHAR .LE. NBUFF)- 		CALL INCHAR(B1,.FALSE.,.TRUE.,.FALSE.,IERR)  		IF(IERR .EQ. 0) THEN 			NCHAR = NCHAR + 1 			BUFF(NCHAR) = B1  			CBUFF(NCHAR:) = CHAR(B1)  		END IF 	END DO  	I1=INDEX(CBUFF,'[') + 1 	I2=INDEX(CBUFF,';') - 1 	NDIGIT = I2 -I1 + 1 D	TYPE *,'IL=',CBUFF(I1:I2)  	IF (NDIGIT .EQ. 1) THEN 		READ(CBUFF(I1:),100) IL  	ELSE IF(NDIGIT .EQ. 2) THEN 		READ(CBUFF(I1:),200) IL  	END IF  	I1 = I2 + 2 	I2 = NCHAR - 1  	NDIGIT = I2 - I1 + 1  D	TYPE *,'IC=',CBUFF(I1:I2)  	IF      (NDIGIT .EQ. 1) THEN  		READ (CBUFF(I1:),100) IC 	ELSE IF (NDIGIT .EQ. 2) THEN  		READ (CBUFF(I1:),200) IC 	ELSE IF (NDIGIT .EQ. 3) THEN  		READ (CBUFF(I1:),300) IC 	END IF  100	FORMAT(I1) 200	FORMAT(I2) 300	FORMAT(I3) 	RETURN  	END	    5 C  Subroutine CPSAVE saves a list of cursor positions  C  Calling sequence is:  C		call cpsave(ISIN)* C  where ISIN is the index into the stack.5 C  To initialize, set ISIN = 1 before the first call. $ C  ICP is the current stack pointer.$ C  NCP is the highest stack pointer.( C  CPSAVE and CPPUSH always use NCP, but0 C  CPBUMP can use ICP to step through previously C  saved positions.  C  	Subroutine cpsave(isin) 	parameter max=30   	integer*2 line(max),column(max) 	data ncp/0/ 	ncp = isin - 1  	if(ncp .lt. 0) ncp = 0    
 	entry cppush  	if(ncp .ge. max) then 		type *, 'cursor stack full'  	else  		call cwhere(il,ic) 		ncp = ncp + 1  		line(ncp)   = il 		column(ncp) = ic 		icp = ncp  	end if  	return    A C  Entry point OLDPOSIT returns the line and column number of the - C  previous cursor position pointed to by IS.  C  	entry oldposit(is,ilin,icin) % 	if(is .ge. 1 .and. is .le. ncp) then  		ilin = line(is)  		icin = column(is)  	else 4 		call csout(23,1,'oldposit pointer outside limits') 	end if  	return    K c  Entry points CPPOP and CPBUMP return the cursor to a position previously D c  saved by CPPUSH or CPSAVE.  CPPOP/CPBUMP will decrement/incrementC c  the stack pointer before restoring the previous cursor position. C C  CPPOP will remove the position from the stack.  CPBUMP will not.     	entry cppop 	if(ncp .gt. 1) then 		ncp = ncp - 1  		icp = ncp 	 		goto 30  	else  		type *, 'cursor stack empty' 	end if  	return    
 	entry cpbump ) 	if(icp .lt. max .and. icp .lt. ncp) then  		icp = icp + 1 	 		goto 30  	else - 		type *, 'no more cursor positions on stack'  	end if  	return    A C  Entry REPOSIT moves the cursor to a previously saved position. C C  The calling parameter is the stack pointer which indicates which   C  previous position is desired.? C  This routine is called after subroutine cpsave or cppush has ( C  saved the desired cursor coordinates.? C  Calls to cpbump can be used to step forward through the list 6 C  of saved positions after reposit(1) has been called C  	entry reposit(isin) 	icp = isin  	if      (icp .lt. 1  ) then	 		icp = 1  	else if (icp .gt. ncp) then 		icp = ncp  	end if     30	il = line(icp)  	ic = column(icp)  	call curpos(il,ic)     	return  	end  