	Subroutine PRSCOM
*
*	Parse global qualifiers for the Search command, setting
*	values in common blocks.
*
*** V3.0 - Edited 7 July 1991 by Kevin
***		Support ACTION=COPY, selection on To: field
***		Exit on CLI warnings
***		Handle parse of CONFIRM=FOLDER properly.
***		Support /SIZE
*** V3.0 - Edited 14 July 1991 by Kevin
***		Support /MESSAGE_MATCH
*** V3.1 - Edited 27-OCT-1997 by Hunter Goatley
***		Fix Init_Cli1 so that entire Dyndes buffer is cleared.
***		Add LIB$GET_INPUT to CLI$DCL_PARSE to prompt for params.
***		Don't call WSrv on CLI$GET_VALUE for REVIEW.
*
	Implicit None
	Integer Status,Cli$Get_Value,Cli$Present,Lib$Get_Lun
	Integer Lib$Find_Image_Symbol
	Integer Init_Cli
	External CLI$_NEGATED,CLI$_LOCNEG,CLI$_PRESENT
	Character*128 Temp
	Integer Tlen
	Include 'QUALCOM.INC'
	Include 'WINDOW.INC'       !To get value of MAXWIN
	Integer Log_level
	Common/LOGCOM/Log_level
	Logical Hilite_Used,Avo,Ansi

	External Mlsearch_Cmd
*   Message codes
	External MLSEARCH_WINPARONE,MLSEARCH_WINPARBAD,MLSEARCH_TOOMNYEXC
	External MLSEARCH_INVNUMFMT,MLSEARCH_WDW_MAXPRM,MLSEARCH_INVALEDIT
	External MLSEARCH_SIZMINMAX,MLSEARCH_SIZNEG,MLSEARCH_SIZ_MAXPRM
*
*   Fake up CLI tables if necessary
*
	Log_level = 0

	Call Wsrv(Init_Cli(Mlsearch_Cmd,'MLSEARCH'))
*
*   Handle simple yes/no qualifiers first.
*
	Remaining = .False.
	If(Cli$Present('REMAINING')) Remaining = .True.

	Exact = .False.
	If(Cli$Present('EXACT')) Exact = .True.

	Statistics = .False.
	If(Cli$Present('STATISTICS')) Statistics = .True.

	Heading = .False.
	If(Cli$Present('HEADING')) Heading = .True.

	Numbers = .False.
	If(Cli$Present('NUMBERS')) Numbers = .True.

	Log = .False.
	If(Cli$Present('LOG')) Log = .True.

	MMatch = .False.
	If(Cli$Present('MESSAGE_MATCH')) Mmatch = .True.
*
*  Then yes/no qualifiers where we need to track explicit use.
*
	Usel_Marked = .False.
	Status = Cli$Present('MARKED')
	If(Status .eq. %Loc(Cli$_Present)) Then
		Usel_Marked = .True.
		Marked = .True.
	Else If(Status .eq. %Loc(Cli$_Negated)) Then
		Usel_Marked = .True.
		Marked = .False.
	Endif

	Usel_Replied = .False.
	Status = Cli$Present('REPLIED')
	If(Status .eq. %Loc(Cli$_Present)) Then
		Usel_Replied = .True.
		Replied = .True.
	Else If(Status .eq. %Loc(Cli$_Negated)) Then
		Usel_Replied = .True.
		Replied = .False.
	Endif
*
*  Now some simple values
*
	Confirm = .False.
	Confirm_Folder = .False.
	If(Cli$Present('CONFIRM')) Then
	    Confirm = .True.
	    If(Cli$Present('CONFIRM.FOLDER')) Confirm_Folder = .True.
	Endif

	If(Cli$Present('DEBUG')) Then
	  Call WSrv(Cli$Get_Value('DEBUG',Temp,Tlen))
	  Read(Temp(1:Tlen),'(I<Tlen>)',Err=900) Log_level
	Endif
*
*  Now some string values
*
	Usel_CC = .False.
	If(Cli$Present('CC')) Then
	  Call DynIni(Sel_CC)
	  Call WSrv(Cli$Get_Value('CC',Sel_CC,Tlen))
	Endif

	Usel_From = .False.
	If(Cli$Present('FROM')) Then
	  Call DynIni(Sel_From)
	  Call WSrv(Cli$Get_Value('From',Sel_From,Tlen))
	Endif

	Usel_Subject = .False.
	If(Cli$Present('SUBJECT')) Then
	  Call DynIni(Sel_Subject)
	  Call WSrv(Cli$Get_Value('Subject',Sel_Subject,Tlen))
	Endif

	Usel_To = .False.
	If(Cli$Present('TO')) Then
	  Call DynIni(Sel_To)
	  Call WSrv(Cli$Get_Value('To',Sel_To,Tlen))
	Endif
*
*  Now the ones that take values - enumerated ones first.
*
	Match = Match_Or
	If(Cli$Present('MATCH')) Then
		Status = Cli$Get_Value('MATCH',Temp,Tlen)
		Call Stchek(Status)
		Match = (Index(MatchNams,Temp(1:Tlen)) - 1)/4
	Endif

	Format = FmtTxt

	If(Cli$Present('FORMAT')) Then
		Status = Cli$Get_Value('FORMAT',Temp,Tlen)
		Call Stchek(Status)
		Format = Index('TPDN',Temp(1:1)) - 1
		If(Temp(1:Tlen) .eq. 'NOFF') Format = Fmtnoff
	Endif
*
*  Before/since - mail messages only have one date we can get at,
*  so we don't bother with /created and all that stuff.
*

	UBefore = .False.
	If(Cli$Present('BEFORE')) Then
		Ubefore = .true.
		Call Dynini(Btime)
		Status = Cli$Get_Value('BEFORE',Btime,Tlen)
		Call Stchek(Status)
	Endif

	USince = .False.
	If(Cli$Present('SINCE')) Then
		USince = .True.
		Call Dynini(Stime)
		Status = Cli$Get_Value('SINCE',Stime,Tlen)
		Call Stchek(Status)
	Endif
*
*  Highlight is slightly different - we treat as a single enumerated
*  type.
*
	If(Cli$Present('HIGHLIGHT')) Then
		Status = Cli$Get_Value('HIGHLIGHT',Temp,Tlen)
		Call Stchek(Status)
		If(Temp(1:Tlen) .eq. 'HARDCOPY' .or. 
     $                    CLI$present('HARDCOPY')) Then
		  Status = Cli$Get_Value('HARDCOPY',Temp,Tlen)
		  Call Stchek(Status)
		  Hilite = Index('UO',Temp(1:1)) + 4
		Else
		  Hilite = (Index('BOBLREUN',Temp(1:2)) + 1)/2
		Endif

		Hilite_used = .True.
	Else If(Cli$Present('HIGHLIGHT') .eq. %loc(Cli$_Negated)) Then
		HiLite = 0
		Hilite_used = .True.
	Else
		HiLite = 0
		Hilite_used = .False.
	Endif
*
* SEARCH=bits of message. This can take a list of values, which add
* or remove individual bits. In the way of these things, we first
* set up the default mask, then loop gettings values, and checking
* for the keyword being negated.
*
	Sparts = S_text + S_From + S_CC + S_Subject

	If(Cli$Present('SEARCH')) Then
		Sparts = 0
		Do While (Cli$Get_Value('SEARCH',Temp,Tlen))
		  Call Prscom_List(Temp(1:Tlen),'ALL',-1,Sparts)
		  Call Prscom_List(Temp(1:Tlen),'TO',S_To,Sparts)
		  Call Prscom_List(Temp(1:Tlen),'FROM',S_From,Sparts)
		  Call Prscom_List(Temp(1:Tlen),'CC',S_CC,Sparts)
		  Call Prscom_List(Temp(1:Tlen),'TEXT',S_Text,Sparts)
		  Call Prscom_List(Temp(1:Tlen),'SUBJECT',S_Subject,Sparts)
		Enddo
	Endif
*
* Window - if not present, no lines before or after, but target line
* itself. If present, but no value, then /WINDOW=5 is assumed.
* If present with two values, set before and after to values. If one
* value, then subtract one, round up to multiple of two, and set before
* and after.
* Window=0 implies no windows at all - just file lines. To indicate this,
* we set WINDOW false.
*
	Window = .True.
	WinBefore = 0
	WinAfter = 0
	If(Cli$Present('WINDOW')) Then
		WinBefore = 2
		WinAfter = 2

		If(Cli$Get_Value('WINDOW',Temp,Tlen)) Then
		  Read(Temp(1:Tlen),'(I<Tlen>)',Err=900) WinBefore

		  If(Cli$Get_Value('WINDOW',Temp,Tlen)) Then
		    Read(Temp(1:Tlen),'(I<Tlen>)',Err=900) WinAfter

		    If(Winbefore .gt. Maxwin - 1) Then
			Call Lib$Signal(MLSEARCH_WINPARONE,
     $                     %val(1),%val(Maxwin-1))
		    Endif

		    If(Cli$Get_Value('WINDOW',Temp,Tlen)) Then
		        Call Lib$Signal(MLSEARCH_WDW_MAXPRM) !Too many windows
		    Endif

		  Else
*
* Split /WINDOW=n between before and after
* Check for special case of Window=0
*
		  If(Winbefore .gt. (Maxwin-1)*2+1) Then
			Call Lib$Signal(MLSEARCH_WINPARBAD,
     $                     %val(1),%val(Maxwin*2))
		   Endif

		   If(Winbefore .eq. 0) Then
		     Window = .False.
		     Winbefore = 0
		     Winafter = 0
		     Remaining = .False.    !this is what SEARCH does....
		   Else
		     Winbefore = Winbefore - 1
*
*    Change re pat rankin's suggestions to match SEARCH more closely.
*	after = before + 0 or 1
*
		    WinAfter = Winbefore - Winbefore/2
		    Winbefore = Winbefore/2
		   Endif	!/WINDOW=0 specified
		  Endif		!2 VALUES FOR Window
		Endif		! Any values present
	Endif			!/Window present
*
* Size qualifier - accepts one or two parameters.
* One means minimum size in records, two is min and max.
*
	U_Size = .False.
	If(Cli$Present('SIZE')) Then
		U_Size = .True.
		If(Cli$Get_Value('SIZE',Temp,Tlen)) Then
		  Read(Temp(1:Tlen),'(I<Tlen>)',Err=900) Min_Size
		  If(Cli$Get_Value('SIZE',Temp,Tlen)) Then
		    Read(Temp(1:Tlen),'(I<Tlen>)',Err=900) Max_Size

		    If(Max_Size .lt. Min_Size) Then
			Call Lib$Signal(MLSEARCH_SIZMINMAX)
		    Endif

		    If(Max_Size .lt. 0 .or. Min_Size .lt. 0) Then
			Call Lib$Signal(MLSEARCH_SIZNEG)
		    Endif

		    If(Cli$Get_Value('SIZE',Temp,Tlen)) Then
		        Call Lib$Signal(MLSEARCH_SIZ_MAXPRM) !Too many sizes
		    Endif

		  Else
		   Max_Size = -1
		  Endif		!Maxsize specified.
		Endif		!Any size specified
	Endif
*
* REVIEW qualifier - value is either an editor name (from known
* list) or "@filename", for subprocess stuff. If no value given, we find
* the default editor and validate the whole business here.
*
	If(Cli$Present('REVIEW')) Then
		Review = .True.
		Tlen = 0
		Call Cli$get_Value('REVIEW',Temp,Tlen)
		If(Tlen .le. 0) Then		!Get default mail editor
		    Call GetMailEdit(Temp,Tlen)
		Endif
		If(Temp(1:1) .eq. '@') Then
		    Reviewer = Temp(2:Tlen)
		    LReviewer = Tlen - 1
  		    ReviewCall = .False.
		Else 
	            Reviewer = Temp(1:Tlen)
		    Lreviewer = Tlen
  		    ReviewCall = .true.
  	            Status = Lib$Find_image_Symbol(
     $               Reviewer(1:Lreviewer)//'SHR',
     $               Reviewer(1:Lreviewer)//'$'//'EDIT',
*E     $               Reviewer(1:Lreviewer)//'$'//Reviewer(1:Lreviewer),
     $               Entry)
		    If(.Not. Status) Then
			Review = .False.
		        Call Lib$Signal(MLSEARCH_INVALEDIT,%Val(1),
     $                      Temp(1:Tlen),%Val(Status))
		    Endif
		Endif
	Else
		Review = .false.
	Endif
*
* ACTION qualifier - either delete, copy or move the messages to another folder
*
	Action_Del = .False.
	Action_Move = .False.
	Action_Copy = .False.
	If(Cli$Present('ACTION')) Then
	   If(Cli$Present('ACTION.MOVE')) Then
		Call WSrv(Cli$Get_Value('ACTION.MOVE',Temp,Tlen))
		Action_Val = Temp
		LAction_Val = Tlen
		Action_Move = .True.
	   Else If(Cli$Present('ACTION.COPY')) Then
		Call WSrv(Cli$Get_Value('ACTION.COPY',Temp,Tlen))
		Action_Val = Temp
		LAction_Val = Tlen
		Action_Copy = .True.
	   Else If(Cli$Present('ACTION.DELETE')) Then
		Action_Del = .True.
	   Endif
	Endif
*
* OUTPUT qualifier - get output and open it now.
*
	IF(.Not. Cli$Get_Value('OUTPUT',Temp,Tlen)) Then
		Temp = 'NL:'
		Tlen = 3
	Endif
	Status = Lib$Get_Lun(Outlun)
	Call StChek(Status)
*
*	If highlight was not specified, default it based on the characteristics
*	of the output device.
*
	If(.Not. Hilite_Used) Then
		Call GetTermCap(Temp(1:Tlen),Ansi,Avo)
		If(Ansi .and. Avo) Then
			Hilite = Hilite_Bold
		Else If(Ansi) Then
			Hilite = Hilite_Rev
		Endif
	Endif

	Open(Unit=Outlun,Status='New',Name=Temp(1:Tlen),
     $      CarriageControl='LIST',Recl=2048,
     $      DefaultFile='.LIS')

	If(Statistics) Call Stat_ini
	Call Win_ini(Winbefore,Winafter,Window)   !Init window buffers
	Return
*
*	Errors with numbers come here.
*
900	Call Lib$Signal(MLSEARCH_INVNUMFMT,%val(1),Temp(1:Tlen))
	End

	Subroutine Prscom_List(Inp,Qual,Flag,Flags)
	Implicit None
	Character*(*) Inp,Qual
	Integer Flag,Flags
*
*	Check INP to see if it is an abbreviation of QUAL, or NOQUAL.
*	Set or clear bit Flag in flags appropriately
*
	Logical Abbrev
	Logical Sense
	Integer I

	If(Inp(1:2) .eq. 'NO') Then
               	Sense = .False.
		I = 3
	Else
		Sense = .True.
		I = 1
	Endif

	If(Abbrev(Inp(I:),Qual)) Then
            If(Sense) Then
		Flags = IOR(Flags,Flag)
	    Else
		Flags = Iand(Flags,NOT(Flag))
	    Endif
	Endif

	Return
	End

	Integer Function Init_Cli(Table,Verb)
*
*	This function is called by a program which wishes to use the CLI
*	routines, but doesn't know if the user has done a SET COMMAND to
*	invoke the program. The routine fakes the CLI tables if necessary.
*	Translated by Kevin Ashley from Joe Meadows' original C routine.
*
	Implicit None
	Integer Table
	Character*(*) Verb
	Include '($DSCDEF)'
	Record/DSCDEF1/ Dyndes
	Integer Cli$Get_Value,Cli$Dcl_Parse,Str$Compare
	External LIB$GET_INPUT
	Integer Status,L
 
	Dyndes.Dsc$B_DType = Dsc$K_Dtype_T
	Dyndes.Dsc$B_Class = Dsc$K_Class_D
 
	Status = Cli$Get_Value('$VERB',Dyndes)
 
	If(.Not.Status) Then
		Init_Cli = Status
		Return
	Endif
 
	L = Min(Len(Verb),Dyndes.Dsc$W_Maxstrlen)
	If(Str$Compare(Verb(1:L),Dyndes) .eq. 0) Then
		Init_Cli = 1		!SET COMMAND used OK
	Else
		Status = Cli$Get_Value('$LINE',Dyndes)
		If(.Not. Status) Then
		   Init_Cli = Status
		   Return
		Endif
*
*	We now replace the foreign image specification with the verb name...
*
		Call Init_Cli1(Dyndes,Verb)
		Status = Cli$Dcl_Parse(Dyndes,Table,LIB$GET_INPUT,LIB$GET_INPUT)
		If(.not. status) call Exit
		Init_Cli = Status
	Endif
 
	Return
	End
 
	Subroutine Init_Cli1(Command,Verb)
*
*	replace foreign image specification in  command with verb
*
	Implicit None
	Character*(*) Command,Verb
	Integer I
 
	I = 1
	Do While (I .le. Len(Command) .and.
     $             Command(I:I) .ne. ' ' .and.
     $             Command(I:I) .ne. '/')
		If(I .le. Len(Verb)) Then
		  Command(I:I) = Verb(I:I)
		Else
		  Command(I:I) = ' '
		Endif
		I = I + 1
	Enddo
	Return
	End

	Subroutine GetTermCap(Name,Ansi,Avo)
*
*	Get terminal capabilities
*	Any errors from LIB$GETDVI are assumed to indicate that the name
*	is not a device name, so they are ignored.
*
	Implicit None
	Character*(*) Name
	Logical Ansi,Avo
	Include '($DVIDEF)'
	Integer Lib$Getdvi

	If(.not. (Lib$GetDvi(Dvi$_TT_ANSICRT,,Name,Ansi))) Ansi = .False.
	If(.not. (Lib$GetDvi(Dvi$_TT_AVO,,Name,Avo))) Avo = .False.
	Return
	End
